/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.impl;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.Fund;
import org.egov.egf.commons.EgovCommon;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.services.PersistenceService;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.BudgetFolioDetail;
import org.egov.works.abstractestimate.entity.DepositWorksUsage;
import org.egov.works.abstractestimate.entity.FinancialDetail;
import org.egov.works.services.ContractorBillService;
import org.egov.works.services.DepositWorksUsageService;
import org.egov.works.services.impl.BaseServiceImpl;

public class DepositWorksUsageServiceImpl
extends BaseServiceImpl<DepositWorksUsage, Long>
implements DepositWorksUsageService {
    private static final Logger LOGGER = Logger.getLogger(DepositWorksUsageServiceImpl.class);
    private EgovCommon egovCommon;
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy", Locale.US);
    public static final String dateFormat = "dd-MMM-yyyy";
    private ContractorBillService contractorBillService;

    public DepositWorksUsageServiceImpl(PersistenceService<DepositWorksUsage, Long> persistenceService) {
        super(persistenceService);
    }

    @Override
    public BigDecimal getTotalDepositWorksAmount(Fund fund, CChartOfAccounts coa, Accountdetailtype accountdetailtype, Long depositCode, Date appropriationDate) {
        return this.egovCommon.getDepositAmountForDepositCode(appropriationDate, coa.getGlcode(), fund.getCode(), accountdetailtype.getId(), Integer.valueOf(depositCode.intValue()));
    }

    @Override
    public Map<String, List> getDepositFolioDetails(AbstractEstimate abstractEstimate, Fund fund, CChartOfAccounts coa, Accountdetailtype accountdetailtype, Long depositCode, Date appropriationDate) {
        ArrayList<BudgetFolioDetail> approvedBudgetFolioResultList = new ArrayList<BudgetFolioDetail>();
        ArrayList<Comparable<Date>> paramList = new ArrayList<Comparable<Date>>();
        paramList.add(appropriationDate);
        paramList.add(fund.getId());
        paramList.add(depositCode);
        paramList.add(coa.getId());
        Object[] params = new Object[paramList.size()];
        params = paramList.toArray(params);
        List depositWorksUsageList = this.persistenceService.findAllBy("from DepositWorksUsage dwu where trunc(dwu.appropriationDate)<=trunc(?) and  dwu.depositCode.fund.id=?  and  dwu.depositCode.id=?  and  dwu.coa.id=?   order by dwu.id asc", params);
        if (depositWorksUsageList != null && !depositWorksUsageList.isEmpty()) {
            return this.addApprovedEstimateResultList(approvedBudgetFolioResultList, depositWorksUsageList, appropriationDate);
        }
        return new HashMap<String, List>();
    }

    public Map<String, List> addApprovedEstimateResultList(List<BudgetFolioDetail> depositFolioResultList, List<DepositWorksUsage> depositWorksUsageList, Date appropriationDate) {
        int srlNo = 1;
        Double cumulativeTotal = 0.0;
        BigDecimal totalDeposit = BigDecimal.ZERO;
        double cumulativeExpensesIncurred = 0.0;
        HashMap<String, List> budgetFolioMap = new HashMap<String, List>();
        for (DepositWorksUsage depositWorksUsage : depositWorksUsageList) {
            BudgetFolioDetail budgetFolioDetail = new BudgetFolioDetail();
            budgetFolioDetail.setSrlNo(srlNo++);
            if (depositWorksUsage.getAbstractEstimate() != null) {
                budgetFolioDetail.setEstimateNo(depositWorksUsage.getAbstractEstimate().getEstimateNumber());
                budgetFolioDetail.setNameOfWork(depositWorksUsage.getAbstractEstimate().getName());
                budgetFolioDetail.setEstimateDate(this.sdf.format(depositWorksUsage.getAbstractEstimate().getEstimateDate()));
                if (!this.isAppropriationRejected(depositWorksUsage.getAppropriationNumber())) {
                    budgetFolioDetail.setExpensesIncurred(this.contractorBillService.getTotalActualExpenseForProject(depositWorksUsage.getAbstractEstimate(), appropriationDate));
                    budgetFolioDetail.setCumulativeExpensesIncurred(cumulativeExpensesIncurred);
                    budgetFolioDetail.setActualBalanceAvailable(depositWorksUsage.getTotalDepositAmount().doubleValue() - cumulativeExpensesIncurred);
                    cumulativeExpensesIncurred += budgetFolioDetail.getExpensesIncurred().doubleValue();
                } else {
                    budgetFolioDetail.setExpensesIncurred(0.0);
                    budgetFolioDetail.setCumulativeExpensesIncurred(cumulativeExpensesIncurred);
                    budgetFolioDetail.setActualBalanceAvailable(depositWorksUsage.getTotalDepositAmount().doubleValue() - cumulativeExpensesIncurred);
                    cumulativeExpensesIncurred += budgetFolioDetail.getExpensesIncurred().doubleValue();
                }
            }
            budgetFolioDetail.setBudgetApprNo(depositWorksUsage.getAppropriationNumber());
            budgetFolioDetail.setCumulativeTotal(cumulativeTotal);
            budgetFolioDetail.setAppDate(this.sdf.format(depositWorksUsage.getAppropriationDate()));
            if (depositWorksUsage.getReleasedAmount().compareTo(BigDecimal.ZERO) > 0) {
                cumulativeTotal = cumulativeTotal - depositWorksUsage.getReleasedAmount().doubleValue();
                budgetFolioDetail.setWorkValue(depositWorksUsage.getAbstractEstimate().getTotalAmount().getValue() * -1.0);
                budgetFolioDetail.setAppropriatedValue(BigDecimal.ZERO.subtract(depositWorksUsage.getReleasedAmount()).doubleValue());
            } else {
                cumulativeTotal = cumulativeTotal + depositWorksUsage.getConsumedAmount().doubleValue();
                budgetFolioDetail.setWorkValue(depositWorksUsage.getAbstractEstimate().getTotalAmount().getValue());
                budgetFolioDetail.setAppropriatedValue(depositWorksUsage.getConsumedAmount().doubleValue());
            }
            totalDeposit = depositWorksUsage.getTotalDepositAmount();
            budgetFolioDetail.setBalanceAvailable(totalDeposit);
            depositFolioResultList.add(budgetFolioDetail);
        }
        ArrayList<Double> calculatedValuesList = new ArrayList<Double>();
        calculatedValuesList.add(cumulativeTotal);
        budgetFolioMap.put("depositFolioList", depositFolioResultList);
        budgetFolioMap.put("calculatedValues", calculatedValuesList);
        budgetFolioMap.put("totalCumulativeExpensesIncurred", Arrays.asList(cumulativeExpensesIncurred));
        return budgetFolioMap;
    }

    @Override
    public BigDecimal getTotalUtilizedAmountForDepositWorks(FinancialDetail financialDetail) {
        return (BigDecimal)this.genericService.findByNamedQuery("getDepositWorksUsageAmount", new Object[]{financialDetail.getAbstractEstimate().getDepositCode().getId(), financialDetail.getFund().getId(), financialDetail.getCoa().getId()});
    }

    @Override
    public BigDecimal getTotalUtilizedAmountForDepositWorks(FinancialDetail financialDetail, Date appDate) {
        BigDecimal totalUtilizedAmount = BigDecimal.ZERO;
        BigDecimal utilizedAmountForRunningProject = (BigDecimal)this.genericService.find("select sum(dwu.consumedAmount-dwu.releasedAmount) from DepositWorksUsage dwu where dwu.createdDate<=? and EXISTS (select 'true' from FinancialDetail fd where fd.abstractEstimate.id=dwu.abstractEstimate.id and fd.fund.id=? and fd.abstractEstimate.depositCode.id=? and fd.coa.id=?) and (dwu.abstractEstimate.projectCode.id is null or dwu.abstractEstimate.projectCode.id not in (select proj.id from ProjectCode proj where proj.egwStatus.code='CLOSED'))", new Object[]{appDate, financialDetail.getFund().getId(), financialDetail.getAbstractEstimate().getDepositCode().getId(), financialDetail.getCoa().getId()});
        if (utilizedAmountForRunningProject == null) {
            utilizedAmountForRunningProject = BigDecimal.ZERO;
        }
        LOGGER.debug((Object)("Total Utilized amount for deposit works (Running projects) >>>>Depositcodeid=" + financialDetail.getAbstractEstimate().getDepositCode().getId() + "|| till date=" + appDate + "||utilizedAmount=" + utilizedAmountForRunningProject));
        Double utilizedAmountForClosedProject = (Double)this.genericService.find("select sum(fd.abstractEstimate.projectCode.projectValue) from FinancialDetail fd where trunc(fd.abstractEstimate.projectCode.completionDate)<=trunc(?) and fd.fund.id=? and fd.abstractEstimate.depositCode.id=? and fd.coa.id=? and fd.abstractEstimate.projectCode.egwStatus.code='CLOSED'", new Object[]{appDate, financialDetail.getFund().getId(), financialDetail.getAbstractEstimate().getDepositCode().getId(), financialDetail.getCoa().getId()});
        if (utilizedAmountForClosedProject == null) {
            utilizedAmountForClosedProject = 0.0;
        }
        totalUtilizedAmount = utilizedAmountForRunningProject.add(new BigDecimal(utilizedAmountForClosedProject));
        LOGGER.debug((Object)("Total Utilized amount for deposit works (Closed projects) >>>>Depositcodeid=" + financialDetail.getAbstractEstimate().getDepositCode().getId() + "|| till date=" + appDate + "||utilizedAmount=" + utilizedAmountForClosedProject));
        LOGGER.debug((Object)("Total Utilized amount for deposit works (including Closed and running projects) >>>>Depositcodeid=" + financialDetail.getAbstractEstimate().getDepositCode().getId() + "|| till date=" + appDate + "||totalutilizedAmount=" + totalUtilizedAmount));
        return totalUtilizedAmount;
    }

    public void setEgovCommon(EgovCommon egovCommon) {
        this.egovCommon = egovCommon;
    }

    @Override
    public DepositWorksUsage getDepositWorksUsage(AbstractEstimate estimate, String appropriationNumber) {
        DepositWorksUsage depositWorksUsage = (DepositWorksUsage)((Object)this.persistenceService.find("from DepositWorksUsage dwu where dwu.abstractEstimate=? and dwu.appropriationNumber=?", new Object[]{estimate, appropriationNumber}));
        return depositWorksUsage;
    }

    public void setContractorBillService(ContractorBillService contractorBillService) {
        this.contractorBillService = contractorBillService;
    }

    private boolean isAppropriationRejected(String apprNumber) {
        if (apprNumber == null) {
            throw new ApplicationRuntimeException("Invalid parameter passed to isAppropriationRejected() ||apprNumber=" + apprNumber);
        }
        String[] str = apprNumber.split("/");
        if (str.length > 0 && "BC".equalsIgnoreCase(str[0])) {
            return true;
        }
        String rejectedApprNumber = "BC/" + apprNumber;
        DepositWorksUsage depositWorksUsage = (DepositWorksUsage)((Object)this.persistenceService.find("from DepositWorksUsage dwu where dwu.appropriationNumber=?", new Object[]{rejectedApprNumber}));
        return depositWorksUsage != null;
    }
}

