/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.dao.bills.EgBilldetailsHibernateDAO;
import org.egov.egf.commons.EgovCommon;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.infstr.models.EgChecklists;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.bills.EgBilldetails;
import org.egov.model.bills.EgBillregister;
import org.egov.utils.FinancialConstants;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.autonumber.ContractorBillNumberGenerator;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.mb.entity.MBDetails;
import org.egov.works.mb.entity.MBForCancelledBill;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.models.contractorBill.AssetForBill;
import org.egov.works.models.contractorBill.DeductionTypeForBill;
import org.egov.works.models.contractorBill.StatutoryDeductionsForBill;
import org.egov.works.models.contractorBill.WorkCompletionDetailInfo;
import org.egov.works.models.contractorBill.WorkCompletionInfo;
import org.egov.works.models.tender.OfflineStatus;
import org.egov.works.models.tender.TenderResponse;
import org.egov.works.services.ContractorBillService;
import org.egov.works.services.TenderResponseService;
import org.egov.works.services.WorksService;
import org.egov.works.services.contractoradvance.ContractorAdvanceService;
import org.egov.works.services.impl.BaseServiceImpl;
import org.egov.works.utils.DateConversionUtil;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderActivity;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;

public class ContractorBillServiceImpl
extends BaseServiceImpl<ContractorBillRegister, Long>
implements ContractorBillService {
    private static final Logger logger = Logger.getLogger(ContractorBillServiceImpl.class);
    private WorksService worksService;
    @Autowired
    private PersistenceService<EgChecklists, Long> checklistService;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;
    @Autowired
    private EgovCommon egovCommon;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    private static final String WORKS_NETPAYABLE_CODE = "WORKS_NETPAYABLE_CODE";
    private static final String RETENTION_MONEY_PURPOSE = "RETENTION_MONEY_PURPOSE";
    public static final String WORKORDER_NO = "WORKORDER_NO";
    public static final String CONTRACTOR_ID = "CONTRACTOR_ID";
    public static final String BILLSTATUS = "BILLSTATUS";
    public static final String BILLNO = "BILLNO";
    public static final String FROM_DATE = "FROM_DATE";
    public static final String TO_DATE = "TO_DATE";
    public static final String FROMDATE = "fromDate";
    public static final String TODATE = "toDate";
    public static final String PARAM = "param_";
    private TenderResponseService tenderResponseService;
    public static final String PROJECT_STATUS_CLOSED = "CLOSED";
    public static final String BILL_DEPT_ID = "BILL_DEPT_ID";
    public static final String EXEC_DEPT_ID = "EXEC_DEPT_ID";
    public static final String EST_NO = "EST_NO";
    private ContractorAdvanceService contractorAdvanceService;
    @Autowired
    private EgBilldetailsHibernateDAO egBilldetailsHibernateDAO;

    public ContractorBillServiceImpl(PersistenceService<ContractorBillRegister, Long> persistenceService) {
        super(persistenceService);
    }

    @Override
    public List getBillType() {
        String configVal = this.worksService.getWorksConfigValue("BILLTYPE");
        LinkedList<String> billTypeList = new LinkedList<String>();
        if (StringUtils.isNotBlank((String)configVal)) {
            String[] configVals;
            for (String configVal2 : configVals = configVal.split(",")) {
                billTypeList.add(configVal2);
            }
        }
        return billTypeList;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    @Override
    public boolean contractorBillNumberChangeRequired(EgBillregister bill, WorkOrder workOrder, CFinancialYear financialYear) {
        return true;
    }

    @Override
    public String generateContractorBillNumber(ContractorBillRegister ContractorBillRegister2) {
        ContractorBillNumberGenerator c = (ContractorBillNumberGenerator)this.beanResolver.getAutoNumberServiceFor(ContractorBillNumberGenerator.class);
        String contractorBillNumber = c.getNextNumber(ContractorBillRegister2);
        return contractorBillNumber;
    }

    @Override
    public BigDecimal calculateTotalPendingAdvance(BigDecimal totalAdvancePaid, Date billDate, WorkOrderEstimate workOrderEstimate, Long billId) {
        CChartOfAccounts advanceCOA = this.contractorAdvanceService.getContractorAdvanceAccountcodeForWOE(workOrderEstimate.getId());
        BigDecimal totalPendingBalance = BigDecimal.ZERO;
        BigDecimal totalAdvanceAdjusted = BigDecimal.ZERO;
        if (advanceCOA != null && totalAdvancePaid != null && totalAdvancePaid.compareTo(BigDecimal.ZERO) > 0) {
            totalAdvanceAdjusted = this.getTotalAdvanceAdjustedForWOE(billDate, workOrderEstimate.getId(), advanceCOA.getId(), billId);
            totalPendingBalance = totalAdvanceAdjusted != null && totalAdvanceAdjusted.compareTo(BigDecimal.ZERO) > 0 && totalAdvanceAdjusted.compareTo(BigDecimal.ZERO) > 0 ? totalAdvanceAdjusted.subtract(totalAdvanceAdjusted) : totalAdvancePaid;
        }
        return totalPendingBalance;
    }

    public BigDecimal getTotalAdvanceAdjustedForWOE(Date billDate, Long workOrderEstimateId, Long advanceGlCodeId, Long billId) {
        BigDecimal advanceAdjustment = BigDecimal.ZERO;
        List<Long> billIdList = this.getBillIdListUptoBillDate(billDate, workOrderEstimateId, billId);
        if (billIdList == null || billIdList.isEmpty()) {
            billIdList.add(null);
        }
        List egBilldetailsList = this.genericService.findAllByNamedQuery("getAdvanceAjustementTotAmt", new Object[]{new BigDecimal(advanceGlCodeId), billIdList});
        for (EgBilldetails egBilldetails : egBilldetailsList) {
            if (egBilldetails.getCreditamount() == null) continue;
            advanceAdjustment = advanceAdjustment.add(egBilldetails.getCreditamount());
        }
        return advanceAdjustment;
    }

    public List<Long> getBillIdListUptoBillDate(Date billDate, Long workOrderEstimateId, Long billId) {
        ArrayList<Long> billIdList = new ArrayList<Long>();
        ArrayList<Comparable<Long>> params = new ArrayList<Comparable<Long>>();
        String whereClause = "";
        params.add(workOrderEstimateId);
        params.add(billDate);
        if (billId != null) {
            EgBillregister egbr = (EgBillregister)this.genericService.find("from EgBillregister egbr where egbr.id = ? ", new Object[]{billId});
            if (egbr.getBillstatus().equalsIgnoreCase("CANCELLED")) {
                whereClause = " mbh.egBillregister.billdate <= ? and  mbh.egBillregister.id<? )";
                params.add(billId);
            } else {
                whereClause = " mbh.egBillregister.billdate <= ? and mbh.egBillregister.billstatus!='CANCELLED' and mbh.egBillregister.id<? )";
                params.add(billId);
            }
        } else {
            whereClause = " mbh.egBillregister.billdate <= ? and mbh.egBillregister.billstatus!='CANCELLED')";
        }
        List egBillregisterList = this.genericService.findAllBy("select distinct mbh.egBillregister from MBHeader mbh where mbh.workOrderEstimate.id = ?  and " + whereClause, params.toArray());
        if (!egBillregisterList.isEmpty()) {
            for (EgBillregister egBillregister : egBillregisterList) {
                billIdList.add(egBillregister.getId());
            }
        }
        return billIdList;
    }

    @Override
    public BigDecimal getUtlizedAmountForUnArrovedBill(Long workOrderId, Date asOnDate) {
        BigDecimal result = BigDecimal.ZERO;
        Object[] params = new Object[]{"CANCELLED", workOrderId, asOnDate};
        BigDecimal queryVal = (BigDecimal)this.genericService.findByNamedQuery("getUtlizedAmountForUnArrovedBill", params);
        if (queryVal != null) {
            result = result.add(queryVal);
        }
        return result;
    }

    public BigDecimal getApprovedMBAmountOld(Long workOrderId, Long workOrderEstimateId, Date asOnDate) {
        BigDecimal result = BigDecimal.ZERO;
        Object[] params = new Object[]{"APPROVED", workOrderId, workOrderEstimateId, asOnDate};
        Double queryVal = (Double)this.genericService.findByNamedQuery("totalApprovedMBAmount", params);
        params = new Object[]{"APPROVED", workOrderId, workOrderEstimateId, asOnDate, "CANCELLED"};
        Double queryVal2 = (Double)this.genericService.findByNamedQuery("totalApprovedMBAmountForCancelledBill", params);
        if (queryVal != null) {
            result = result.add(BigDecimal.valueOf(queryVal));
        }
        if (queryVal2 != null) {
            result = result.add(BigDecimal.valueOf(queryVal2));
        }
        return result;
    }

    @Override
    public BigDecimal getApprovedMBAmount(Long workOrderId, Long workOrderEstimateId, Date asOnDate) {
        BigDecimal result = BigDecimal.ZERO;
        Object[] params = new Object[]{"APPROVED", workOrderId, workOrderEstimateId, asOnDate};
        List approvedMBsList = this.genericService.findAllByNamedQuery("gettotalApprovedMBs", params);
        params = new Object[]{"APPROVED", workOrderId, workOrderEstimateId, asOnDate, "CANCELLED"};
        List approvedMBsForCancelledBillList = this.genericService.findAllByNamedQuery("gettotalApprovedMBsForCancelledBill", params);
        Double amount = 0.0;
        ArrayList<Long> woaIdsListForApprovedMBs = new ArrayList<Long>();
        for (Object[] obj : approvedMBsList) {
            woaIdsListForApprovedMBs.add((Long)obj[0]);
        }
        if (!woaIdsListForApprovedMBs.isEmpty()) {
            List<WorkOrderActivity> woaListForApprovedMBs = this.getWorkOrderActivityListForIds(woaIdsListForApprovedMBs);
            block1: for (Object[] obj : approvedMBsList) {
                Long woaId = (Long)obj[0];
                double mbQuantity = (Double)obj[1];
                for (WorkOrderActivity woa : woaListForApprovedMBs) {
                    if (!woaId.equals(woa.getId())) continue;
                    amount = woa.getActivity().getNonSor() == null ? Double.valueOf(woa.getApprovedRate() * mbQuantity * woa.getConversionFactor()) : Double.valueOf(woa.getApprovedRate() * mbQuantity);
                    result = result.add(BigDecimal.valueOf(amount));
                    continue block1;
                }
            }
        }
        ArrayList<Long> woaIdsListForCancelledBills = new ArrayList<Long>();
        for (Object[] obj : approvedMBsForCancelledBillList) {
            woaIdsListForCancelledBills.add((Long)obj[0]);
        }
        if (!woaIdsListForCancelledBills.isEmpty()) {
            List<WorkOrderActivity> woaListForCancelledBills = this.getWorkOrderActivityListForIds(woaIdsListForCancelledBills);
            block4: for (Object[] obj : approvedMBsForCancelledBillList) {
                Long woaId = (Long)obj[0];
                double mbQuantity = (Double)obj[1];
                for (WorkOrderActivity woa : woaListForCancelledBills) {
                    if (!woaId.equals(woa.getId())) continue;
                    amount = woa.getActivity().getNonSor() == null ? Double.valueOf(woa.getApprovedRate() * mbQuantity * woa.getConversionFactor()) : Double.valueOf(woa.getApprovedRate() * mbQuantity);
                    result = result.add(BigDecimal.valueOf(amount));
                    continue block4;
                }
            }
        }
        return result;
    }

    @Override
    public BigDecimal getApprovedMBAmountOfTenderedItems(Long workOrderId, Long workOrderEstimateId, Date asOnDate) {
        BigDecimal result = BigDecimal.ZERO;
        Object[] params = new Object[]{"APPROVED", workOrderId, workOrderEstimateId, asOnDate};
        List approvedMBsList = this.genericService.findAllByNamedQuery("gettotalApprovedMBs", params);
        params = new Object[]{"APPROVED", workOrderId, workOrderEstimateId, asOnDate, "CANCELLED"};
        List approvedMBsForCancelledBillList = this.genericService.findAllByNamedQuery("gettotalApprovedMBsForCancelledBill", params);
        Double amount = 0.0;
        ArrayList<Long> woaIdsListForApprovedMBs = new ArrayList<Long>();
        for (Object[] obj : approvedMBsList) {
            woaIdsListForApprovedMBs.add((Long)obj[0]);
        }
        if (!woaIdsListForApprovedMBs.isEmpty()) {
            List<WorkOrderActivity> woaListForApprovedMBs = this.getWorkOrderActivityListForIds(woaIdsListForApprovedMBs);
            block1: for (Object[] obj : approvedMBsList) {
                Long woaId = (Long)obj[0];
                double mbQuantity = (Double)obj[1];
                for (WorkOrderActivity woa : woaListForApprovedMBs) {
                    if (!woaId.equals(woa.getId())) continue;
                    amount = woa.getActivity().getNonSor() == null ? Double.valueOf(woa.getApprovedRate() * mbQuantity * woa.getConversionFactor()) : Double.valueOf(woa.getApprovedRate() * mbQuantity);
                    if (woa.getActivity().getRevisionType() != null) continue;
                    result = result.add(BigDecimal.valueOf(amount));
                    continue block1;
                }
            }
        }
        ArrayList<Long> woaIdsListForCancelledBills = new ArrayList<Long>();
        for (Object[] obj : approvedMBsForCancelledBillList) {
            woaIdsListForCancelledBills.add((Long)obj[0]);
        }
        if (!woaIdsListForCancelledBills.isEmpty()) {
            List<WorkOrderActivity> woaListForCancelledBills = this.getWorkOrderActivityListForIds(woaIdsListForCancelledBills);
            block4: for (Object[] obj : approvedMBsForCancelledBillList) {
                Long woaId = (Long)obj[0];
                double mbQuantity = (Double)obj[1];
                for (WorkOrderActivity woa : woaListForCancelledBills) {
                    if (!woaId.equals(woa.getId())) continue;
                    amount = woa.getActivity().getNonSor() == null ? Double.valueOf(woa.getApprovedRate() * mbQuantity * woa.getConversionFactor()) : Double.valueOf(woa.getApprovedRate() * mbQuantity);
                    if (woa.getActivity().getRevisionType() != null) continue;
                    result = result.add(BigDecimal.valueOf(amount));
                    continue block4;
                }
            }
        }
        return result;
    }

    @Override
    public Map<String, String[]> getStandardDeductionsFromConfig() {
        String[] splitedMainArr;
        String strDec = this.worksService.getWorksConfigValue("STANDARD_DEDUCTION");
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (String element : splitedMainArr = strDec.split("\\|")) {
            String[] splitedSubArr = element.split(":");
            String[] splitedACCodesArr = splitedSubArr[1].split(",");
            map.put(splitedSubArr[0], splitedACCodesArr);
        }
        return map;
    }

    @Override
    public BigDecimal getTotalValueWoForUptoBillDate(Date billDate, Long workOrderId, Long workOrderEstimateId) {
        BigDecimal totalWorkValue = BigDecimal.ZERO;
        List egBillregisterList = this.genericService.findAllBy("select distinct mbh.egBillregister from MBHeader mbh where mbh.egBillregister.id in (select egBillRegister.id from org.egov.model.bills.EgBillregister egBillRegister  where egBillRegister.billdate <= ? and egBillRegister.billstatus <>'CANCELLED') and mbh.workOrder.id = ? and mbh.workOrderEstimate.id=?", new Object[]{billDate, workOrderId, workOrderEstimateId});
        if (!egBillregisterList.isEmpty()) {
            for (EgBillregister egBillregister : egBillregisterList) {
                totalWorkValue = totalWorkValue.add(egBillregister.getBillamount());
            }
        }
        return totalWorkValue;
    }

    @Override
    public List<String> getSortedDeductionsFromConfig(String Key) {
        String[] splitedMainArr;
        String strDec = this.worksService.getWorksConfigValue(Key);
        ArrayList<String> sortedDedcutionList = new ArrayList<String>();
        for (String element : splitedMainArr = strDec.split("\\|")) {
            sortedDedcutionList.add(element);
        }
        return sortedDedcutionList;
    }

    @Override
    public List<StatutoryDeductionsForBill> getStatutoryDeductionSortedOrder(List<String> requiredOrder, List<StatutoryDeductionsForBill> givenEgBillPayeedetails) {
        ArrayList<StatutoryDeductionsForBill> orderedResults = new ArrayList<StatutoryDeductionsForBill>();
        for (String caseStatus : requiredOrder) {
            for (StatutoryDeductionsForBill statDeductionDetails : givenEgBillPayeedetails) {
                if (!caseStatus.equals(statDeductionDetails.getEgBillPayeeDtls().getRecovery().getType())) continue;
                orderedResults.add(statDeductionDetails);
            }
        }
        return orderedResults;
    }

    @Override
    public List<DeductionTypeForBill> getStandardDeductionSortedOrder(List<String> requiredOrder, List<DeductionTypeForBill> givenStandardList) {
        ArrayList<DeductionTypeForBill> orderedResults = new ArrayList<DeductionTypeForBill>();
        for (String caseStatus : requiredOrder) {
            for (DeductionTypeForBill deductionTypeForBill : givenStandardList) {
                if (!caseStatus.equals(deductionTypeForBill.getDeductionType())) continue;
                orderedResults.add(deductionTypeForBill);
            }
        }
        return orderedResults;
    }

    @Override
    public List<StatutoryDeductionsForBill> getStatutoryListForBill(Long billId) {
        return this.genericService.findAllBy("from StatutoryDeductionsForBill epd where epd.egBillPayeeDtls.egBilldetailsId.egBillregister.id=? and epd.egBillPayeeDtls.recovery.id is not null", new Object[]{billId});
    }

    @Override
    public List<DeductionTypeForBill> getStandardDeductionForBill(Long billId) {
        return this.genericService.findAllBy("from DeductionTypeForBill dtb where dtb.egbill.id=?", new Object[]{billId});
    }

    @Override
    public List<AssetForBill> getAssetForBill(Long billId) {
        return this.genericService.findAllBy("from AssetForBill assetForBill where assetForBill.egbill.id=?", new Object[]{billId});
    }

    @Override
    public BigDecimal getAdvanceAdjustmentAmountForBill(Long billId, Long workOrderEstimateId) {
        EgBilldetails egBilldetails;
        BigDecimal advanceAdjustment = BigDecimal.ZERO;
        CChartOfAccounts advanceCOA = this.contractorAdvanceService.getContractorAdvanceAccountcodeForWOE(workOrderEstimateId);
        if (advanceCOA != null && (egBilldetails = (EgBilldetails)this.genericService.find("from EgBilldetails ebd where ebd.glcodeid=? and ebd.egBillregister.id=?", new Object[]{new BigDecimal(advanceCOA.getId()), billId})) != null && egBilldetails.getCreditamount() != null) {
            advanceAdjustment = egBilldetails.getCreditamount();
        }
        return advanceAdjustment;
    }

    @Override
    public List<EgBilldetails> getCustomDeductionListforglcodes(List<BigDecimal> glcodeIdList, Long billId) {
        return this.genericService.findAllByNamedQuery("CustomDeductionList", new Object[]{billId, glcodeIdList});
    }

    public List<EgBilldetails> getRetentionMoneyListforglcodes(List<BigDecimal> glcodeIdList, Long billId) {
        return this.genericService.findAllByNamedQuery("RetentionMoneyDeductionList", new Object[]{billId, glcodeIdList});
    }

    public List<EgBilldetails> getAccountDetailsList(List<BigDecimal> glcodeIdList, Long billId) {
        return this.genericService.findAllByNamedQuery("AccountDetailsList", new Object[]{billId, glcodeIdList});
    }

    @Override
    public BigDecimal getNetPayableAmountForGlCodeId(Long billId) throws NumberFormatException, ApplicationException {
        BigDecimal netPayableAmount = BigDecimal.ZERO;
        List coaPayableList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurpose(Integer.valueOf(this.worksService.getWorksConfigValue(WORKS_NETPAYABLE_CODE)));
        for (CChartOfAccounts coa : coaPayableList) {
            List egBillDetails = this.genericService.findAllBy("from EgBilldetails ebd where ebd.glcodeid=? and ebd.egBillregister.id=?", new Object[]{new BigDecimal(coa.getId()), billId});
            if (egBillDetails.isEmpty()) continue;
            netPayableAmount = ((EgBilldetails)egBillDetails.get(0)).getCreditamount();
        }
        return netPayableAmount;
    }

    @Override
    public BigDecimal getTotAmtForAdvanceAdjustment(Date billDate, Long workOrderId, Long workOrderEstimateId) {
        BigDecimal totDeductionAmt = BigDecimal.ZERO;
        CChartOfAccounts advanceCOA = this.contractorAdvanceService.getContractorAdvanceAccountcodeForWOE(workOrderEstimateId);
        if (advanceCOA != null) {
            totDeductionAmt = this.getAdvanceAdjustmentDeductionTotAmount(billDate, workOrderId, advanceCOA.getId(), workOrderEstimateId);
        }
        return totDeductionAmt;
    }

    public BigDecimal getAdvanceAdjustmentDeductionTotAmount(Date billDate, Long workOrderId, Long advanceCOAId, Long workOrderEstimateId) {
        BigDecimal advanceAdjustment = BigDecimal.ZERO;
        List<Long> billIdList = this.getBillIdListForWoUptoBillDate(billDate, workOrderId, workOrderEstimateId);
        if (billIdList == null || billIdList.isEmpty()) {
            billIdList.add(null);
        }
        List egBilldetailsList = this.genericService.findAllByNamedQuery("getAdvanceAjustementTotAmt", new Object[]{new BigDecimal(advanceCOAId), billIdList});
        for (EgBilldetails egBilldetails : egBilldetailsList) {
            if (egBilldetails.getCreditamount() == null) continue;
            advanceAdjustment = advanceAdjustment.add(egBilldetails.getCreditamount());
        }
        return advanceAdjustment;
    }

    @Override
    public BigDecimal getTotAmtForStatutory(Date billDate, Long workOrderId, StatutoryDeductionsForBill statDeductionBilldetail, Long workOrderEstimateId) {
        BigDecimal totalStatutoryAmount = BigDecimal.ZERO;
        List<Long> billIdList = this.getBillIdListForWoUptoBillDate(billDate, workOrderId, workOrderEstimateId);
        List egBillPayeedetailsList = new ArrayList();
        if (billIdList != null && !billIdList.isEmpty()) {
            egBillPayeedetailsList = this.genericService.findAllByNamedQuery("getStatutoryTotAmt", new Object[]{statDeductionBilldetail.getEgBillPayeeDtls().getRecovery().getChartofaccounts().getId(), billIdList});
        }
        for (StatutoryDeductionsForBill egBillPayeedetails : egBillPayeedetailsList) {
            if (egBillPayeedetails.getEgBillPayeeDtls().getCreditAmount() == null) continue;
            totalStatutoryAmount = totalStatutoryAmount.add(egBillPayeedetails.getEgBillPayeeDtls().getCreditAmount());
        }
        return totalStatutoryAmount;
    }

    @Override
    public BigDecimal getTotAmtForStandard(Date billDate, Long workOrderId, DeductionTypeForBill deductionTypeForBill1, Long workOrderEstimateId) {
        BigDecimal totalStandarDeductionAmount = BigDecimal.ZERO;
        List<Long> billIdList = this.getBillIdListForWoUptoBillDate(billDate, workOrderId, workOrderEstimateId);
        List standardDeductionList = new ArrayList();
        if (billIdList != null && !billIdList.isEmpty()) {
            standardDeductionList = this.genericService.findAllByNamedQuery("getStandardTotAmt", new Object[]{deductionTypeForBill1.getCoa().getId(), billIdList});
        }
        for (DeductionTypeForBill deductionTypeForBill : standardDeductionList) {
            if (deductionTypeForBill.getCreditamount() == null) continue;
            totalStandarDeductionAmount = totalStandarDeductionAmount.add(deductionTypeForBill.getCreditamount());
        }
        return totalStandarDeductionAmount;
    }

    @Override
    public BigDecimal getTotAmtForCustom(Date billDate, Long workOrderId, EgBilldetails egBilldetails1, Long workOrderEstimateId) {
        BigDecimal totalCustomDeductionAmount = BigDecimal.ZERO;
        List<Long> billIdList = this.getBillIdListForWoUptoBillDate(billDate, workOrderId, workOrderEstimateId);
        List customDeductionList = new ArrayList();
        if (billIdList != null && !billIdList.isEmpty()) {
            customDeductionList = this.genericService.findAllByNamedQuery("getCustomDeductionTotAmt", new Object[]{egBilldetails1.getGlcodeid(), billIdList});
        }
        for (EgBilldetails egBilldetails : customDeductionList) {
            if (egBilldetails.getCreditamount() == null) continue;
            totalCustomDeductionAmount = totalCustomDeductionAmount.add(egBilldetails.getCreditamount());
        }
        return totalCustomDeductionAmount;
    }

    public List<Long> getBillIdListForWoUptoBillDate(Date billDate, Long workOrderId, Long workOrderEstimateId) {
        ArrayList<Long> billIdList = new ArrayList<Long>();
        logger.debug((Object)"---inside getBillIdListForWoUptoBillDate----");
        List egBillregisterList = this.genericService.findAllBy("select distinct mbh.egBillregister from MBHeader mbh where mbh.egBillregister.billdate <=? and mbh.egBillregister.billstatus<>'CANCELLED' and mbh.workOrder.id=? and mbh.workOrderEstimate.id=?", new Object[]{billDate, workOrderId, workOrderEstimateId});
        if (!egBillregisterList.isEmpty()) {
            for (EgBillregister egBillregister : egBillregisterList) {
                billIdList.add(egBillregister.getId());
            }
        }
        logger.debug((Object)"---atend getBillIdListForWoUptoBillDate ");
        return billIdList;
    }

    @Override
    public List<String> searchContractorBill(Map<String, Object> paramsMap, List<Object> paramList) {
        ArrayList<String> QueryObj = new ArrayList<String>();
        StringBuffer commonQry = new StringBuffer();
        String countQry = "select count(distinct cbr) from ContractorBillRegister cbr where cbr.id != null and cbr.billstatus != ? ";
        String dynQuery = "select distinct cbr from ContractorBillRegister cbr where cbr.id != null and cbr.billstatus != ? ";
        paramList.add("NEW");
        if (paramsMap.get(WORKORDER_NO) != null) {
            commonQry = commonQry.append("  and cbr.workordernumber like ?");
            paramList.add("%" + paramsMap.get(WORKORDER_NO) + "%");
        }
        if (paramsMap.get(CONTRACTOR_ID) != null && !"-1".equals(paramsMap.get(CONTRACTOR_ID))) {
            commonQry = commonQry.append(" and (cbr.id in (select mbh.egBillregister.id from MBHeader mbh where mbh.egBillregister.id=cbr.id and mbh.workOrder.contractor.id = ?) OR cbr.id in (select mbcb.contractorBillRegister.id from MBForCancelledBill mbcb where mbcb.contractorBillRegister.id=cbr.id and mbcb.mbHeader.workOrder.contractor.id = ?))");
            paramList.add(paramsMap.get(CONTRACTOR_ID));
            paramList.add(paramsMap.get(CONTRACTOR_ID));
        }
        if (paramsMap.get(FROM_DATE) != null && paramsMap.get(TO_DATE) == null) {
            commonQry = commonQry.append(" and cbr.billdate >= ? ");
            paramList.add(paramsMap.get(FROM_DATE));
        } else if (paramsMap.get(TO_DATE) != null && paramsMap.get(FROM_DATE) == null) {
            commonQry = commonQry.append(" and cbr.billdate <= ? ");
            paramList.add(paramsMap.get(TO_DATE));
        } else if (paramsMap.get(FROM_DATE) != null && paramsMap.get(TO_DATE) != null) {
            commonQry = commonQry.append(" and cbr.billdate between ? and ? ");
            paramList.add(paramsMap.get(FROM_DATE));
            paramList.add(paramsMap.get(TO_DATE));
        }
        if (paramsMap.get(BILLSTATUS) != null && !paramsMap.get(BILLSTATUS).equals("-1")) {
            commonQry = commonQry.append(" and cbr.billstatus=?");
            paramList.add(paramsMap.get(BILLSTATUS));
        }
        if (paramsMap.get(BILLNO) != null) {
            commonQry = commonQry.append(" and cbr.billnumber like ?");
            paramList.add("%" + paramsMap.get(BILLNO) + "%");
        }
        if (paramsMap.get(BILL_DEPT_ID) != null && !"-1".equals(paramsMap.get(BILL_DEPT_ID))) {
            commonQry = commonQry.append(" and cbr.egBillregistermis.egDepartment.id = ? ");
            paramList.add(paramsMap.get(BILL_DEPT_ID));
        }
        if (paramsMap.get(EXEC_DEPT_ID) != null && !"-1".equals(paramsMap.get(EXEC_DEPT_ID))) {
            commonQry = commonQry.append(" and (cbr.id in (select mbh.egBillregister.id from MBHeader mbh where mbh.egBillregister.id=cbr.id and mbh.workOrderEstimate.estimate.executingDepartment.id = ?) OR cbr.id in (select mbcb.contractorBillRegister.id from MBForCancelledBill mbcb where mbcb.contractorBillRegister.id=cbr.id and mbcb.mbHeader.workOrderEstimate.estimate.executingDepartment.id = ?))");
            paramList.add(paramsMap.get(EXEC_DEPT_ID));
            paramList.add(paramsMap.get(EXEC_DEPT_ID));
        }
        if (paramsMap.get(EST_NO) != null) {
            commonQry = commonQry.append(" and (EXISTS (select mbh.egBillregister.id from MBHeader mbh where mbh.egBillregister.id=cbr.id and mbh.workOrderEstimate.estimate.estimateNumber like ? ) OR EXISTS (select mbcb.contractorBillRegister.id from MBForCancelledBill mbcb where mbcb.contractorBillRegister.id=cbr.id and mbcb.mbHeader.workOrderEstimate.estimate.estimateNumber like ? ))");
            paramList.add("%" + paramsMap.get(EST_NO) + "%");
            paramList.add("%" + paramsMap.get(EST_NO) + "%");
        }
        commonQry = commonQry.append(" order by cbr.billdate");
        QueryObj.add("select distinct cbr from ContractorBillRegister cbr where cbr.id != null and cbr.billstatus != ? " + commonQry);
        QueryObj.add("select count(distinct cbr) from ContractorBillRegister cbr where cbr.id != null and cbr.billstatus != ? " + commonQry);
        return QueryObj;
    }

    @Override
    public List<EgBilldetails> getCustomDeductionList(Long billId, Long workOrderEstimateId, List<StatutoryDeductionsForBill> statutoryList, List<DeductionTypeForBill> standardDeductionList, List<EgBilldetails> retentionMoneyDeductionList) throws NumberFormatException, ApplicationException {
        ArrayList<BigDecimal> glcodeIdList = new ArrayList<BigDecimal>();
        this.addStatutoryDeductionGlcode(glcodeIdList, statutoryList);
        this.addStandardDeductionGlcode(glcodeIdList, standardDeductionList);
        String advanceAdjstglCodeId = "";
        CChartOfAccounts advanceCOA = this.contractorAdvanceService.getContractorAdvanceAccountcodeForWOE(workOrderEstimateId);
        if (advanceCOA != null) {
            advanceAdjstglCodeId = advanceCOA.getId().toString();
        }
        this.addRetentionMoneyDeductionGlcode(glcodeIdList, retentionMoneyDeductionList);
        this.addGlCodeForNetPayable(glcodeIdList);
        if (StringUtils.isNotBlank((String)advanceAdjstglCodeId)) {
            glcodeIdList.add(new BigDecimal(advanceAdjstglCodeId));
        }
        return this.getCustomDeductionListforglcodes(glcodeIdList, billId);
    }

    @Override
    public List<EgBilldetails> getRetentionMoneyDeductionList(Long billId, List<StatutoryDeductionsForBill> statutoryList, List<DeductionTypeForBill> standardDeductionList) throws NumberFormatException, ApplicationException {
        ArrayList<BigDecimal> retentionGlcodeIdList = new ArrayList<BigDecimal>();
        this.getAllRetentionMoneyGlcodeList(retentionGlcodeIdList);
        return this.getRetentionMoneyListforglcodes(retentionGlcodeIdList, billId);
    }

    @Override
    public List<EgBilldetails> getAccountDetailsList(Long billId, Long workOrderEstimateId, List<StatutoryDeductionsForBill> statutoryList, List<DeductionTypeForBill> standardDeductionList, List<EgBilldetails> customDeductionList, List<EgBilldetails> retentionMoneyDeductionList) throws NumberFormatException, ApplicationException {
        ArrayList<BigDecimal> glcodeIdList = new ArrayList<BigDecimal>();
        this.addStatutoryDeductionGlcode(glcodeIdList, statutoryList);
        this.addStandardDeductionGlcode(glcodeIdList, standardDeductionList);
        String advanceAdjstglCodeId = "";
        CChartOfAccounts advanceCOA = this.contractorAdvanceService.getContractorAdvanceAccountcodeForWOE(workOrderEstimateId);
        if (advanceCOA != null) {
            advanceAdjstglCodeId = advanceCOA.getId().toString();
        }
        this.addRetentionMoneyDeductionGlcode(glcodeIdList, retentionMoneyDeductionList);
        this.addCustomDeductionGlcode(glcodeIdList, customDeductionList);
        this.addGlCodeForNetPayable(glcodeIdList);
        if (StringUtils.isNotBlank((String)advanceAdjstglCodeId)) {
            glcodeIdList.add(new BigDecimal(advanceAdjstglCodeId));
        }
        return this.getAccountDetailsList(glcodeIdList, billId);
    }

    public void addStatutoryDeductionGlcode(List<BigDecimal> glcodeIdList, List<StatutoryDeductionsForBill> sortedStatutorySortedList) {
        if (!sortedStatutorySortedList.isEmpty()) {
            for (StatutoryDeductionsForBill bpd : sortedStatutorySortedList) {
                if (bpd == null || bpd.getEgBillPayeeDtls().getRecovery() == null || bpd.getEgBillPayeeDtls().getRecovery().getId() == null || bpd.getEgBillPayeeDtls().getRecovery().getChartofaccounts() == null || bpd.getEgBillPayeeDtls().getRecovery().getChartofaccounts().getId() == null) continue;
                glcodeIdList.add(new BigDecimal(bpd.getEgBillPayeeDtls().getRecovery().getChartofaccounts().getId()));
            }
        }
    }

    public void addStandardDeductionGlcode(List<BigDecimal> glcodeIdList, List<DeductionTypeForBill> sortedStandardDeductionList) {
        if (!sortedStandardDeductionList.isEmpty()) {
            for (DeductionTypeForBill deductionTypeForBill : sortedStandardDeductionList) {
                if (deductionTypeForBill.getCoa() == null || deductionTypeForBill.getCoa().getId() == null) continue;
                glcodeIdList.add(new BigDecimal(deductionTypeForBill.getCoa().getId()));
            }
        }
    }

    public void addRetentionMoneyDeductionGlcode(List<BigDecimal> glcodeIdList, List<EgBilldetails> retentionMoneyDeductionList) {
        if (!retentionMoneyDeductionList.isEmpty()) {
            for (EgBilldetails deductionTypeForBill : retentionMoneyDeductionList) {
                if (deductionTypeForBill.getGlcodeid() == null || deductionTypeForBill.getGlcodeid() == null) continue;
                glcodeIdList.add(deductionTypeForBill.getGlcodeid());
            }
        }
    }

    private void getAllRetentionMoneyGlcodeList(List<BigDecimal> retentionGlcodeIdList) throws ApplicationException {
        if (StringUtils.isNotBlank((String)this.worksService.getWorksConfigValue(RETENTION_MONEY_PURPOSE))) {
            List tempAllRetAccList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurpose(Integer.valueOf(this.worksService.getWorksConfigValue(RETENTION_MONEY_PURPOSE)));
            for (CChartOfAccounts acc : tempAllRetAccList) {
                retentionGlcodeIdList.add(new BigDecimal(acc.getId()));
            }
        }
    }

    public void addCustomDeductionGlcode(List<BigDecimal> glcodeIdList, List<EgBilldetails> customDeductionList) {
        if (!customDeductionList.isEmpty()) {
            for (EgBilldetails deductionTypeForBill : customDeductionList) {
                if (deductionTypeForBill.getGlcodeid() == null || deductionTypeForBill.getGlcodeid() == null) continue;
                glcodeIdList.add(deductionTypeForBill.getGlcodeid());
            }
        }
    }

    public void addGlCodeForNetPayable(List<BigDecimal> glcodeIdList) throws NumberFormatException, ApplicationException {
        List coaPayableList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurpose(Integer.valueOf(this.worksService.getWorksConfigValue(WORKS_NETPAYABLE_CODE)));
        if (coaPayableList != null) {
            for (CChartOfAccounts coa : coaPayableList) {
                if (coa.getId() == null) continue;
                glcodeIdList.add(new BigDecimal(coa.getId()));
            }
        }
    }

    @Override
    public BigDecimal getNetPaybleCode(Long billId) throws Exception {
        ArrayList<BigDecimal> glcodeIdList = new ArrayList<BigDecimal>();
        BigDecimal netpaybleCode = BigDecimal.ZERO;
        List coaPayableList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurpose(Integer.valueOf(this.worksService.getWorksConfigValue(WORKS_NETPAYABLE_CODE)));
        if (coaPayableList != null) {
            for (CChartOfAccounts coa : coaPayableList) {
                if (coa.getId() == null) continue;
                glcodeIdList.add(new BigDecimal(coa.getId()));
            }
        }
        EgBilldetails egbillDetails = this.egBilldetailsHibernateDAO.getBillDetails(billId, glcodeIdList);
        netpaybleCode = egbillDetails.getGlcodeid();
        return netpaybleCode;
    }

    @Override
    public List<MBHeader> getMbListForBillAndWorkordrId(Long workOrderId, Long billId) {
        return this.genericService.findAllBy("from MBHeader mbHeader where mbHeader.workOrder.id=? and mbHeader.egBillregister.id=?", new Object[]{workOrderId, billId});
    }

    @Override
    public List<MBForCancelledBill> getMbListForCancelBill(Long billId) {
        List list = this.genericService.findAllBy("from MBForCancelledBill mbcb where  mbcb.contractorBillRegister.id=?", new Object[]{billId});
        return list;
    }

    @Override
    public void setAllViewLists(Long id, Long workOrderId, Long workOrderEstimateId, List<StatutoryDeductionsForBill> actionStatutorydetails, List<DeductionTypeForBill> standardDeductions, List<EgBilldetails> customDeductions, List<EgBilldetails> retentionMoneyDeductions, List<AssetForBill> accountDetailsForBill) throws NumberFormatException, ApplicationException {
        actionStatutorydetails.clear();
        actionStatutorydetails.addAll(this.getStatutoryListForBill(id));
        standardDeductions.clear();
        accountDetailsForBill.clear();
        for (DeductionTypeForBill deductionTypeForBill : this.getStandardDeductionForBill(id)) {
            deductionTypeForBill.setGlcodeid(BigDecimal.valueOf(deductionTypeForBill.getCoa().getId()));
            standardDeductions.add(deductionTypeForBill);
        }
        retentionMoneyDeductions.clear();
        retentionMoneyDeductions.addAll(this.getRetentionMoneyDeductionList(id, actionStatutorydetails, standardDeductions));
        customDeductions.clear();
        customDeductions.addAll(this.getCustomDeductionList(id, workOrderEstimateId, actionStatutorydetails, standardDeductions, retentionMoneyDeductions));
        List<EgBilldetails> accountDetailsForassetandbill = this.getAccountDetailsList(id, workOrderEstimateId, actionStatutorydetails, standardDeductions, customDeductions, retentionMoneyDeductions);
        accountDetailsForBill.addAll(this.getAssetForBill(id));
        if (accountDetailsForBill.isEmpty()) {
            for (EgBilldetails egBilldetails : accountDetailsForassetandbill) {
                CChartOfAccounts coa = this.chartOfAccountsHibernateDAO.findById((Number)egBilldetails.getGlcodeid().longValue(), false);
                if (coa == null) continue;
                coa.setId(Long.valueOf(egBilldetails.getGlcodeid().longValue()));
                AssetForBill assetforBill = new AssetForBill();
                assetforBill.setCoa(coa);
                assetforBill.setDescription(coa.getName());
                assetforBill.setAmount(egBilldetails.getDebitamount());
                if (accountDetailsForBill.contains((Object)assetforBill)) continue;
                accountDetailsForBill.add(assetforBill);
            }
        }
    }

    @Override
    public List<EgChecklists> getEgcheckList(Long billId) throws NumberFormatException, ApplicationException {
        return this.checklistService.findAllBy("from EgChecklists egChecklists  where egChecklists.objectid=?", new Object[]{billId});
    }

    @Override
    public WorkCompletionInfo setWorkCompletionInfoFromBill(ContractorBillRegister contractorBillRegister, WorkOrderEstimate workOrderEstimate) {
        WorkCompletionInfo workCompletionInfo = null;
        String mbNumbers = "";
        List mbNumberList = this.genericService.findAllByNamedQuery("getAllMBNosbyWorkEstimate", new Object[]{"APPROVED", workOrderEstimate.getId()});
        for (String mbNumber : mbNumberList) {
            mbNumbers = mbNumbers.concat(mbNumber).concat(",");
        }
        int strLen = mbNumbers.length();
        if (strLen > 0) {
            mbNumbers = mbNumbers.substring(0, strLen - 1);
        }
        String workCommenced = "";
        List<AppConfigValues> appConfigValuesList = this.worksService.getAppConfigValue("Works", "WorkOrder.laststatus");
        if (appConfigValuesList != null && !appConfigValuesList.isEmpty() && appConfigValuesList.get(0).getValue() != null) {
            workCommenced = appConfigValuesList.get(0).getValue();
        }
        Date workCommencedDate = null;
        OfflineStatus woStatus = (OfflineStatus)((Object)this.genericService.findByNamedQuery("getStatusDateByObjectId_Type_Desc", new Object[]{workOrderEstimate.getWorkOrder().getId(), WorkOrder.class.getSimpleName(), workCommenced}));
        if (woStatus != null) {
            workCommencedDate = woStatus.getStatusDate();
        }
        List history = null;
        if (contractorBillRegister != null && contractorBillRegister.getCurrentState() != null && contractorBillRegister.getCurrentState().getHistory() != null) {
            history = contractorBillRegister.getStateHistory();
        }
        workCompletionInfo = new WorkCompletionInfo(workOrderEstimate, mbNumbers);
        workCompletionInfo.setWorkCommencedOn(workCommencedDate);
        workCompletionInfo.setWorkflowHistory(history);
        return workCompletionInfo;
    }

    @Override
    public List<WorkCompletionDetailInfo> setWorkCompletionDetailInfoList(WorkOrderEstimate workOrderEstimate) {
        WorkCompletionDetailInfo workCompletionDetailInfo;
        ArrayList<WorkCompletionDetailInfo> workCompletionDetailInfoList = new ArrayList<WorkCompletionDetailInfo>();
        TenderResponse tenderResponse = (TenderResponse)((Object)this.tenderResponseService.find("from TenderResponse tr where tr.negotiationNumber=?", new Object[]{workOrderEstimate.getWorkOrder().getNegotiationNumber()}));
        String rebatePremLevel = this.worksService.getWorksConfigValue("REBATE_PREMIUM_LEVEL");
        List workOrderActivityIdList = this.genericService.findAllByNamedQuery("getallWorkOrderActivityWithMB", new Object[]{workOrderEstimate.getId(), "APPROVED"});
        for (Object[] object : workOrderActivityIdList) {
            WorkOrderActivity woa = (WorkOrderActivity)((Object)this.genericService.find("from WorkOrderActivity woa where woa.id=?", new Object[]{Long.parseLong(object[0].toString())}));
            workCompletionDetailInfo = new WorkCompletionDetailInfo(woa, Double.parseDouble(object[1].toString()));
            double executionRate = 0.0;
            List<String> tenderTypeList = this.worksService.getTendertypeList();
            if (tenderTypeList != null && !tenderTypeList.isEmpty() && tenderResponse.getTenderEstimate().getTenderType().equals(tenderTypeList.get(0)) && rebatePremLevel.equalsIgnoreCase("BILL")) {
                double rebpremRate = woa.getApprovedRate() * (Math.abs(tenderResponse.getPercNegotiatedAmountRate()) / 100.0);
                executionRate = tenderResponse.getPercNegotiatedAmountRate() > 0.0 ? woa.getApprovedRate() + rebpremRate : woa.getApprovedRate() - rebpremRate;
            } else {
                executionRate = woa.getApprovedRate();
            }
            workCompletionDetailInfo.setExecutionRate(executionRate);
            if (woa.getActivity().getSchedule() == null) {
                workCompletionDetailInfo.setTenderAmount(woa.getActivity().getQuantity() * woa.getActivity().getRate());
                workCompletionDetailInfo.setExecutionAmount(executionRate * Double.parseDouble(object[1].toString()));
            } else {
                Map<String, Integer> exceptionaSorMap = this.getSpecialUoms();
                double result = 1.0;
                if (exceptionaSorMap.containsKey(woa.getActivity().getUom().getUom())) {
                    result = exceptionaSorMap.get(woa.getActivity().getUom().getUom()).intValue();
                }
                workCompletionDetailInfo.setTenderAmount(woa.getActivity().getQuantity() * woa.getScheduleOfRate() / result);
                workCompletionDetailInfo.setExecutionAmount(executionRate * Double.parseDouble(object[1].toString()) / result);
            }
            workCompletionDetailInfoList.add(workCompletionDetailInfo);
        }
        List workOrderActivityWithoutMBList = this.genericService.findAllByNamedQuery("getallWorkOrderActivityWithoutMB", new Object[]{workOrderEstimate.getId(), "CANCELLED", workOrderEstimate.getId(), "APPROVED"});
        for (WorkOrderActivity woa : workOrderActivityWithoutMBList) {
            workCompletionDetailInfo = new WorkCompletionDetailInfo(woa, Double.parseDouble("0"));
            workCompletionDetailInfo.setTenderAmount(woa.getApprovedRate() * woa.getApprovedQuantity());
            workCompletionDetailInfo.setExecutionAmount(Double.parseDouble("0"));
            workCompletionDetailInfoList.add(workCompletionDetailInfo);
        }
        return workCompletionDetailInfoList;
    }

    @Override
    public BigDecimal getApprovedMBAmountforBill(ContractorBillRegister contractorBillRegister) {
        BigDecimal result = BigDecimal.ZERO;
        Object[] params = new Object[]{"APPROVED", contractorBillRegister.getId()};
        List approvedMBsForCancelledBillList = new ArrayList();
        List approvedMBsList = new ArrayList();
        approvedMBsList = this.genericService.findAllByNamedQuery("getMBAmountForBill", params);
        params = new Object[]{contractorBillRegister.getId(), "CANCELLED"};
        approvedMBsForCancelledBillList = this.genericService.findAllByNamedQuery("getMBListForCancelledBill", params);
        if (approvedMBsForCancelledBillList.isEmpty()) {
            Double amount = 0.0;
            ArrayList<Long> woaIdsListForApprovedMBs = new ArrayList<Long>();
            for (Object[] objectArray : approvedMBsList) {
                woaIdsListForApprovedMBs.add((Long)objectArray[0]);
            }
            List<WorkOrderActivity> list = this.getWorkOrderActivityListForIds(woaIdsListForApprovedMBs);
            block1: for (Object[] obj : approvedMBsList) {
                Long woaId = (Long)obj[0];
                double mbQuantity = (Double)obj[1];
                for (WorkOrderActivity woa : list) {
                    if (!woaId.equals(woa.getId())) continue;
                    amount = woa.getActivity().getNonSor() == null ? Double.valueOf(woa.getApprovedRate() * mbQuantity * woa.getConversionFactor()) : Double.valueOf(woa.getApprovedRate() * mbQuantity);
                    result = result.add(BigDecimal.valueOf(amount));
                    continue block1;
                }
            }
        } else {
            for (MBHeader mbh : approvedMBsForCancelledBillList) {
                List<Object> mbdetails = new ArrayList();
                mbdetails = mbh.getMbDetails();
                for (MBDetails mBDetails : mbdetails) {
                    Double amount = 0.0;
                    amount = mBDetails.getWorkOrderActivity().getActivity().getNonSor() == null ? Double.valueOf(mBDetails.getWorkOrderActivity().getApprovedRate() * mBDetails.getQuantity() * mBDetails.getWorkOrderActivity().getConversionFactor()) : Double.valueOf(mBDetails.getWorkOrderActivity().getApprovedRate() * mBDetails.getQuantity());
                    result = result.add(BigDecimal.valueOf(amount));
                }
            }
        }
        return result;
    }

    @Override
    public BigDecimal getApprovedMBAmountOfTenderedItemsForBill(ContractorBillRegister contractorBillRegister) {
        BigDecimal result = BigDecimal.ZERO;
        Object[] params = new Object[]{"APPROVED", contractorBillRegister.getId()};
        List approvedMBsForCancelledBillList = new ArrayList();
        List approvedMBsList = new ArrayList();
        approvedMBsList = this.genericService.findAllByNamedQuery("getMBAmountForBill", params);
        params = new Object[]{contractorBillRegister.getId(), "CANCELLED"};
        approvedMBsForCancelledBillList = this.genericService.findAllByNamedQuery("getMBListForCancelledBill", params);
        Double amount = 0.0;
        if (approvedMBsForCancelledBillList.isEmpty()) {
            ArrayList<Long> woaIdsListForApprovedMBs = new ArrayList<Long>();
            for (Object[] obj : approvedMBsList) {
                woaIdsListForApprovedMBs.add((Long)obj[0]);
            }
            List<WorkOrderActivity> woaListForApprovedMBs = this.getWorkOrderActivityListForIds(woaIdsListForApprovedMBs);
            block1: for (Object[] objectArray : approvedMBsList) {
                Long woaId = (Long)objectArray[0];
                double mbQuantity = (Double)objectArray[1];
                for (WorkOrderActivity woa : woaListForApprovedMBs) {
                    if (!woaId.equals(woa.getId())) continue;
                    amount = woa.getActivity().getNonSor() == null ? Double.valueOf(woa.getApprovedRate() * mbQuantity * woa.getConversionFactor()) : Double.valueOf(woa.getApprovedRate() * mbQuantity);
                    if (woa.getActivity().getRevisionType() != null) continue;
                    result = result.add(BigDecimal.valueOf(amount));
                    continue block1;
                }
            }
        } else {
            for (MBHeader mbh : approvedMBsForCancelledBillList) {
                List<Object> mbdetails = new ArrayList();
                mbdetails = mbh.getMbDetails();
                for (MBDetails mBDetails : mbdetails) {
                    amount = mBDetails.getWorkOrderActivity().getActivity().getNonSor() == null ? Double.valueOf(mBDetails.getWorkOrderActivity().getApprovedRate() * mBDetails.getQuantity() * mBDetails.getWorkOrderActivity().getConversionFactor()) : Double.valueOf(mBDetails.getWorkOrderActivity().getApprovedRate() * mBDetails.getQuantity());
                    if (mBDetails.getWorkOrderActivity().getActivity().getRevisionType() != null) continue;
                    result = result.add(BigDecimal.valueOf(amount));
                }
            }
        }
        return result;
    }

    private Map<String, Integer> getSpecialUoms() {
        return this.worksService.getExceptionSOR();
    }

    public void setEgovCommon(EgovCommon egovCommon) {
        this.egovCommon = egovCommon;
    }

    public void setChecklistService(PersistenceService<EgChecklists, Long> checklistService) {
        this.checklistService = checklistService;
    }

    public String getFinalBillTypeConfigValue() {
        return this.worksService.getWorksConfigValue("FinalBillType");
    }

    public void setTenderResponseService(TenderResponseService tenderResponseService) {
        this.tenderResponseService = tenderResponseService;
    }

    @Override
    public Double getTotalActualExpenseForProject(AbstractEstimate estimate, Date asonDate) {
        Double totalExpense = 0.0;
        if (estimate == null || asonDate == null) {
            throw new ApplicationRuntimeException("Invalid Arguments passed to getTotalActualExpenseForProject()");
        }
        logger.debug((Object)("Start of getTotalActualExpenseForProject() ||estimate=" + estimate.getEstimateNumber() + "||asonDate=||" + asonDate));
        if (estimate.getProjectCode() != null && estimate.getProjectCode().getEgwStatus() != null && PROJECT_STATUS_CLOSED.equalsIgnoreCase(estimate.getProjectCode().getEgwStatus().getCode()) && !DateConversionUtil.isBeforeByDate(asonDate, estimate.getProjectCode().getCompletionDate())) {
            logger.debug((Object)("Project code <<" + estimate.getProjectCode().getCode() + ">> is closed"));
            totalExpense = estimate.getProjectCode().getProjectValue();
        } else {
            if (estimate.getProjectCode() != null) {
                logger.debug((Object)("Project having project code <<" + estimate.getProjectCode().getCode() + ">> is running"));
            } else {
                logger.debug((Object)("Project having estimate number <<" + estimate.getEstimateNumber() + ">> is in the workflow"));
            }
            for (EgBillregister egbr : this.getListOfApprovedBillforEstimate(estimate, asonDate)) {
                totalExpense = totalExpense + egbr.getBillamount().doubleValue();
            }
        }
        if (estimate.getProjectCode() != null) {
            logger.debug((Object)("Actual Expense for the project " + estimate.getProjectCode().getCode() + "||expense amount " + totalExpense));
        }
        logger.debug((Object)"End of getTotalActualExpenseForProject() ");
        return totalExpense == null ? 0.0 : totalExpense;
    }

    @Override
    public List<EgBillregister> getListOfApprovedBillforEstimate(AbstractEstimate estimate, Date date) {
        List egBillRegisterList = null;
        Query query = null;
        if (estimate == null || date == null) {
            throw new ApplicationRuntimeException("Invalid Arguments passed to getApprovedBillAmountforEstimate()");
        }
        logger.debug((Object)("Arguments passed to getListOfApprovedBillforEstimate() ||estimate " + estimate.getEstimateNumber() + "||date=" + date));
        if (estimate.getDepositCode() != null) {
            logger.debug((Object)("Estimate is of DEPOSIT WORKS|| estimate Number " + estimate.getEstimateNumber()));
            query = this.persistenceService.getSession().createQuery("select distinct egbr from MBHeader as mbh left outer join mbh.egBillregister egbr left outer join egbr.egBillregistermis egbrmis where mbh.workOrderEstimate.estimate.id=:estimateId and egbr.status.code=:code and trunc(egbr.billdate)<=trunc(:date) ");
            query.setLong("estimateId", estimate.getId().longValue());
            query.setDate("date", date);
            query.setString("code", "APPROVED");
            egBillRegisterList = query.list();
        } else {
            logger.debug((Object)("Estimate is of CAPITAL WORKS|| estimate Number " + estimate.getEstimateNumber()));
            query = this.persistenceService.getSession().createQuery("select distinct egbr from MBHeader as mbh left outer join mbh.egBillregister egbr where mbh.workOrderEstimate.estimate.id=:estimateId and egbr.status.code=:code and trunc(egbr.billdate)<=trunc(:date) ");
            query.setLong("estimateId", estimate.getId().longValue());
            query.setDate("date", date);
            query.setString("code", "APPROVED");
            egBillRegisterList = query.list();
        }
        if (egBillRegisterList == null) {
            egBillRegisterList = Collections.EMPTY_LIST;
        }
        logger.debug((Object)("Number of Approved bills for ||estimate " + estimate.getEstimateNumber() + "||date=" + date + "||is " + egBillRegisterList.size()));
        logger.debug((Object)">>>>>>End of getListOfApprovedBillforEstimate()>>>>>>");
        return egBillRegisterList;
    }

    @Override
    public BigDecimal getBilledAmountForDate(AbstractEstimate estimate, Date asOnDate) {
        logger.debug((Object)"<<<<<<<<<<<<<<< Start of getBilledAmountForDate(AbstractEstimate estimate,Date asOnDate >>>>>>>>>>>>>");
        if (estimate == null || asOnDate == null) {
            throw new ApplicationRuntimeException("Invalid Arguments passed to getApprovedBillAmountforEstimate()");
        }
        logger.debug((Object)("Arguments passed to getBilledAmountForDate(AbstractEstimate estimate,Date asOnDate) ||estimate " + (Object)((Object)estimate) + "||asOnDate=" + asOnDate));
        List voucherDetails = this.egovCommon.getExpenditureDetailsforProject(estimate.getProjectCode().getId(), asOnDate);
        logger.debug((Object)("total voucher created for project code  <<" + estimate.getProjectCode().getCode() + ">> is " + voucherDetails));
        ArrayList voucherNumbers = new ArrayList();
        BigDecimal totalVoucherAmount = BigDecimal.ZERO;
        if (voucherDetails != null && voucherDetails.size() > 0) {
            for (Map voucher : voucherDetails) {
                voucherNumbers.add(voucher.get("VoucherNumber"));
                totalVoucherAmount = totalVoucherAmount.add(new BigDecimal(Double.parseDouble((String)voucher.get("Amount"))));
            }
        }
        logger.debug((Object)("Total amount of vouchers(Contractor bills including overheads) | " + totalVoucherAmount));
        String queryString = "select sum(egbr.billamount) from MBHeader as mbh left outer join mbh.egBillregister egbr left outer join egbr.egBillregistermis egbrmis where mbh.workOrderEstimate.estimate.id=:estimateId and trunc(egbr.billdate)<=trunc(:date) and egbr.status.code=:code";
        if (voucherNumbers.size() > 0) {
            queryString = queryString + " and egbrmis.voucherHeader.voucherNumber not in (:voucherNumbers)";
        }
        queryString = queryString + " group by mbh.workOrderEstimate.estimate.id";
        Query query = this.persistenceService.getSession().createQuery(queryString);
        query.setLong("estimateId", estimate.getId().longValue());
        query.setDate("date", new Date());
        query.setString("code", "APPROVED");
        if (voucherNumbers.size() > 0) {
            query.setParameterList("voucherNumbers", voucherNumbers);
        }
        BigDecimal totalBillAmount = (BigDecimal)query.uniqueResult();
        logger.debug((Object)("Total amount of contractor bills (Vouchers amount not included in this contractor bill amount) | " + totalBillAmount));
        if (totalBillAmount == null) {
            totalBillAmount = BigDecimal.ZERO;
        }
        logger.debug((Object)("End of getBilledAmountForDate(AbstractEstimate estimate,Date asOnDate) ||returned value is (including voucher amount and contractor bill)" + totalBillAmount.add(totalVoucherAmount)));
        return totalBillAmount.add(totalVoucherAmount);
    }

    @Override
    public BigDecimal getBilledAmount(AbstractEstimate estimate) {
        if (estimate == null) {
            throw new ApplicationRuntimeException("Invalid Arguments passed to getApprovedBillAmountforEstimate()");
        }
        logger.debug((Object)("Arguments passed to getBilledAmount(AbstractEstimate estimate) ||estimate " + estimate.getEstimateNumber() + "||today date=" + new Date()));
        List voucherDetails = this.egovCommon.getExpenditureDetailsforProjectforFinYear(estimate.getProjectCode().getId(), new Date());
        logger.debug((Object)("total voucher created for project code  <<" + estimate.getProjectCode().getCode() + ">> is " + voucherDetails));
        ArrayList voucherNumbers = new ArrayList();
        BigDecimal totalVoucherAmount = BigDecimal.ZERO;
        if (voucherDetails != null && voucherDetails.size() > 0) {
            for (Map voucher : voucherDetails) {
                voucherNumbers.add(voucher.get("VoucherNumber"));
                totalVoucherAmount = totalVoucherAmount.add(new BigDecimal(Double.parseDouble((String)voucher.get("Amount"))));
            }
        }
        logger.debug((Object)("Total amount of vouchers(Contractor bills including overheads) | " + totalVoucherAmount));
        String queryString = "select sum(egbr.billamount) from MBHeader as mbh left outer join mbh.egBillregister egbr left outer join egbr.egBillregistermis egbrmis where mbh.workOrderEstimate.estimate.id=:estimateId and EXISTS (select 'true' from CFinancialYear cfinancialyear where trunc(cfinancialyear.startingDate)<=trunc(:date) and trunc(cfinancialyear.endingDate)>=trunc(:date) and cfinancialyear.id=egbrmis.financialyear.id) and egbr.status.code=:code";
        if (voucherNumbers.size() > 0) {
            queryString = queryString + " and egbrmis.voucherHeader.voucherNumber not in (:voucherNumbers)";
        }
        queryString = queryString + " group by mbh.workOrderEstimate.estimate.id";
        Query query = this.persistenceService.getSession().createQuery(queryString);
        query.setLong("estimateId", estimate.getId().longValue());
        query.setDate("date", new Date());
        query.setString("code", "APPROVED");
        if (voucherNumbers.size() > 0) {
            query.setParameterList("voucherNumbers", voucherNumbers);
        }
        BigDecimal totalBillAmount = (BigDecimal)query.uniqueResult();
        logger.debug((Object)("Total amount of contractor bills (Vouchers amount not included in this contractor bill amount) | " + totalBillAmount));
        if (totalBillAmount == null) {
            totalBillAmount = BigDecimal.ZERO;
        }
        logger.debug((Object)("End of getBilledAmount(AbstractEstimate estimate) ||returned value is (including voucher amount and contractor bill)" + totalBillAmount.add(totalVoucherAmount)));
        return totalBillAmount.add(totalVoucherAmount);
    }

    @Override
    public List<EgBillregister> getListOfNonCancelledBillsforEstimate(AbstractEstimate estimate, Date date) {
        List egBillRegisterList = null;
        Query query = null;
        if (estimate == null || date == null) {
            throw new ApplicationRuntimeException("Invalid Arguments passed to getApprovedBillAmountforEstimate()");
        }
        logger.debug((Object)("Arguments passed to getListOfApprovedBillforEstimate() ||estimate " + estimate.getEstimateNumber() + "||date=" + date));
        if (estimate.getDepositCode() != null) {
            logger.debug((Object)("Estimate is of DEPOSIT WORKS|| estimate Number " + estimate.getEstimateNumber()));
            query = this.persistenceService.getSession().createQuery("select egbr from MBHeader as mbh left outer join mbh.egBillregister egbr left outer join egbr.egBillregistermis egbrmis where mbh.workOrderEstimate.estimate.id=:estimateId and egbr.status.code!=:code and trunc(egbr.billdate)<=trunc(:date) ");
            query.setLong("estimateId", estimate.getId().longValue());
            query.setDate("date", date);
            query.setString("code", "CANCELLED");
            egBillRegisterList = query.list();
        } else {
            logger.debug((Object)("Estimate is of CAPITAL WORKS|| estimate Number " + estimate.getEstimateNumber()));
            query = this.persistenceService.getSession().createQuery("select egbr from MBHeader as mbh left outer join mbh.egBillregister egbr where mbh.workOrderEstimate.estimate.id=:estimateId and egbr.status.code!=:code and trunc(egbr.billdate)<=trunc(:date) ");
            query.setLong("estimateId", estimate.getId().longValue());
            query.setDate("date", date);
            query.setString("code", "CANCELLED");
            egBillRegisterList = query.list();
        }
        if (egBillRegisterList == null) {
            egBillRegisterList = Collections.EMPTY_LIST;
        }
        logger.debug((Object)("Number of Approved bills for ||estimate " + estimate.getEstimateNumber() + "||date=" + date + "||is " + egBillRegisterList.size()));
        logger.debug((Object)">>>>>>End of getListOfApprovedBillforEstimate()>>>>>>");
        return egBillRegisterList;
    }

    private List<WorkOrderActivity> getWorkOrderActivityListForIds(List<Long> woaIds) {
        Query createQuery = this.persistenceService.getSession().createQuery(" from WorkOrderActivity woa where woa.id in (:woActivityIds) ");
        createQuery.setParameterList("woActivityIds", woaIds);
        return createQuery.list();
    }

    public void setContractorAdvanceService(ContractorAdvanceService contractorAdvanceService) {
        this.contractorAdvanceService = contractorAdvanceService;
    }

    public String getBudgetHeadFromMappingObject(String depositCOA) {
        String mappingGLCode = (String)this.genericService.find("select workDoneBudgetGroup from DepositCOABudgetHead where depositCOA = ?", new Object[]{depositCOA});
        return mappingGLCode;
    }

    @Override
    public List<CChartOfAccounts> getBudgetHeadForDepositCOA(AbstractEstimate estimate) {
        List<CChartOfAccounts> coaList = new ArrayList<CChartOfAccounts>();
        String estimateDepositCOA = estimate.getFinancialDetails().get(0).getCoa().getGlcode();
        String mappingGLCode = this.getBudgetHeadFromMappingObject(estimateDepositCOA);
        if (StringUtils.isNotBlank((String)mappingGLCode)) {
            coaList = Arrays.asList(this.chartOfAccountsHibernateDAO.getCChartOfAccountsByGlCode(mappingGLCode));
        }
        return coaList;
    }

    @Override
    public String validateForBudgetHeadInWorkflow(Set<EgBilldetails> billDetails, AbstractEstimate estimate) {
        String allowForward = "yes";
        String mappingBudgetHead = this.getBudgetHeadFromMappingObject(estimate.getFinancialDetails().get(0).getCoa().getGlcode());
        if (StringUtils.isNotBlank((String)mappingBudgetHead)) {
            for (EgBilldetails details : billDetails) {
                CChartOfAccounts coaObj;
                if (details.getDebitamount() == null || details.getDebitamount().compareTo(BigDecimal.ZERO) != 1 || (coaObj = this.chartOfAccountsHibernateDAO.findById((Number)details.getGlcodeid(), false)) == null || !StringUtils.isNotBlank((String)coaObj.getGlcode()) || mappingBudgetHead.equalsIgnoreCase(coaObj.getGlcode())) continue;
                allowForward = "no";
                break;
            }
        }
        return allowForward;
    }

    @Override
    public List<Integer> getProjCodeIdsListForDepositCode(Integer fundId, Long coaId, Long depositCodeId) {
        List pcIds = this.genericService.findAllBy("select distinct fd.abstractEstimate.projectCode.id from FinancialDetail fd where fd.abstractEstimate.egwStatus.code = ? and fd.abstractEstimate.depositCode.id = ? and fd.fund.id = ? and fd.coa.id = ?", new Object[]{AbstractEstimate.EstimateStatus.ADMIN_SANCTIONED.toString(), depositCodeId, fundId, coaId});
        ArrayList<Integer> projCodeIds = new ArrayList<Integer>();
        if (pcIds != null && !pcIds.isEmpty()) {
            for (Long id : pcIds) {
                projCodeIds.add(id.intValue());
            }
        }
        return projCodeIds;
    }

    @Override
    public BigDecimal getTotalExpenditure(List<Integer> projectCodeIdsList, String accDetailType) {
        BigDecimal totalExpenditureAmount = BigDecimal.ZERO;
        Integer accDetailTypeId = (Integer)this.genericService.find("select id from Accountdetailtype where name=?", new Object[]{accDetailType});
        BigDecimal totalBillAmt = this.getTotalBillAmount(new Date(), projectCodeIdsList, accDetailTypeId);
        BigDecimal voucherExpdAmount = this.egovCommon.getVoucherExpenditureByEntities(accDetailTypeId, projectCodeIdsList);
        BigDecimal dbpExpdAmount = this.egovCommon.getDirectBankPaymentExpenditureByEntities(accDetailTypeId, projectCodeIdsList);
        totalExpenditureAmount = totalBillAmt.add(voucherExpdAmount).add(dbpExpdAmount);
        return totalExpenditureAmount;
    }

    public BigDecimal getTotalBillAmount(Date asOnDate, List<Integer> projectCodeIdsList, Integer accDetailTypeId) {
        BigDecimal totalBillAmount = BigDecimal.ZERO;
        String payQuery = " select coalesce(sum(br.BILLAMOUNT),0) as \"Total Bill Amount\" FROM EG_BILLPAYEEDETAILS bpd, EG_BILLDETAILS bd, EG_BILLREGISTER br, EG_BILLREGISTERMIS mis  WHERE bpd.BILLDETAILID = bd.ID AND bd.BILLID = br.ID AND br.ID = mis.BILLID AND br.BILLSTATUS != 'CANCELLED' AND bpd.ACCOUNTDETAILTYPEID=(SELECT ID FROM ACCOUNTDETAILTYPE WHERE NAME='PROJECTCODE') AND bpd.ACCOUNTDETAILKEYID IN (:projCodeIds) AND br.BILLDATE <=:date AND ((mis.VOUCHERHEADERID   IS NULL) OR (mis.VOUCHERHEADERID IS NOT NULL and EXISTS (select id from voucherheader where id=mis.VOUCHERHEADERID and status=" + FinancialConstants.CANCELLEDVOUCHERSTATUS + ")))";
        SQLQuery query = this.persistenceService.getSession().createSQLQuery(payQuery);
        query.setParameterList("projCodeIds", projectCodeIdsList);
        query.setDate("date", asOnDate);
        List billAmountResult = query.list();
        for (Object obj : billAmountResult) {
            totalBillAmount = BigDecimal.valueOf(Double.valueOf(obj.toString()));
        }
        return totalBillAmount;
    }

    @Override
    public Object[] getLatestMBCreatedDateAndRefNo(Long woId, Long estId) {
        Object[] mbDateRefNo = (Object[])this.persistenceService.getSession().createQuery("select mbRefNo,mbDate from MBHeader where id = (select max(mbh.id) from MBHeader mbh where mbh.egwStatus.code = ? and mbh.workOrder.id= ? and mbh.workOrderEstimate.estimate.id=? and mbh.workOrderEstimate.estimate.egwStatus.code= ? )").setParameter(0, (Object)"APPROVED").setParameter(1, (Object)woId).setParameter(2, (Object)estId).setParameter(3, (Object)"ADMIN_SANCTIONED").uniqueResult();
        return mbDateRefNo;
    }

    @Override
    public Collection<StatutoryDeductionsForBill> getStatutoryDeductions(List<StatutoryDeductionsForBill> actionStatutorydetails) {
        return CollectionUtils.select(actionStatutorydetails, statutoryDeductionsForBill -> (StatutoryDeductionsForBill)((Object)((Object)statutoryDeductionsForBill)) != null);
    }

    @Override
    public Collection<EgBilldetails> getCustomDeductionTypes(List<EgBilldetails> customDeductions) {
        return CollectionUtils.select(customDeductions, egBilldetails -> (EgBilldetails)egBilldetails != null);
    }

    @Override
    public Collection<EgBilldetails> getRetentionMoneyTypes(List<EgBilldetails> retentionMoneyDeductions) {
        return CollectionUtils.select(retentionMoneyDeductions, egBilldetails -> (EgBilldetails)egBilldetails != null);
    }

    @Override
    public Collection<AssetForBill> getAssetAndAccountDetails(List<AssetForBill> accountDetailsForBill) {
        return CollectionUtils.select(accountDetailsForBill, assetForBill -> (AssetForBill)((Object)((Object)assetForBill)) != null);
    }

    @Override
    public Collection<DeductionTypeForBill> getStandardDeductionTypes(List<DeductionTypeForBill> standardDeductions) {
        return CollectionUtils.select(standardDeductions, deductionTypeForBill -> (DeductionTypeForBill)((Object)((Object)deductionTypeForBill)) != null);
    }
}

