/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.revisionestimate.service;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.service.UOMService;
import org.egov.egf.budget.model.BudgetControlType;
import org.egov.egf.budget.service.BudgetControlTypeService;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.persistence.entity.component.Money;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.pims.commons.Position;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.abstractestimate.entity.MeasurementSheet;
import org.egov.works.abstractestimate.repository.ActivityRepository;
import org.egov.works.abstractestimate.service.MeasurementSheetService;
import org.egov.works.letterofacceptance.service.WorkOrderActivityService;
import org.egov.works.lineestimate.service.LineEstimateAppropriationService;
import org.egov.works.lineestimate.service.LineEstimateDetailService;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.master.service.ScheduleCategoryService;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.mb.service.MBDetailsService;
import org.egov.works.mb.service.MBHeaderService;
import org.egov.works.revisionestimate.entity.RevisionAbstractEstimate;
import org.egov.works.revisionestimate.entity.RevisionWorkOrder;
import org.egov.works.revisionestimate.entity.SearchRevisionEstimate;
import org.egov.works.revisionestimate.entity.enums.RevisionType;
import org.egov.works.revisionestimate.repository.RevisionEstimateRepository;
import org.egov.works.revisionestimate.service.RevisionWorkOrderService;
import org.egov.works.utils.WorksConstants;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorder.entity.WorkOrderActivity;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.egov.works.workorder.entity.WorkOrderMeasurementSheet;
import org.egov.works.workorder.service.WorkOrderEstimateService;
import org.egov.works.workorder.service.WorkOrderMeasurementSheetService;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.transform.Transformers;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.DateType;
import org.hibernate.type.LongType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;

@Service
@Transactional(readOnly=true)
public class RevisionEstimateService {
    private static final Logger LOG = LoggerFactory.getLogger(RevisionEstimateService.class);
    @PersistenceContext
    private EntityManager entityManager;
    private final RevisionEstimateRepository revisionEstimateRepository;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<RevisionAbstractEstimate> revisionAbstractEstimateWorkflowService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private UOMService uomService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private ScheduleCategoryService scheduleCategoryService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private ActivityRepository activityRepository;
    @Autowired
    WorkOrderActivityService workOrderActivityService;
    @Autowired
    private MBHeaderService mbHeaderService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private MeasurementSheetService measurementSheetService;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource messageSource;
    @Autowired
    private RevisionWorkOrderService revisionWorkOrderService;
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private LineEstimateDetailService lineEstimateDetailService;
    @Autowired
    private LineEstimateAppropriationService lineEstimateAppropriationService;
    @Autowired
    private WorkOrderMeasurementSheetService workOrderMeasurementSheetService;
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;
    @Autowired
    private MBDetailsService mBDetailsService;
    @Autowired
    private BudgetControlTypeService budgetControlTypeService;

    @Autowired
    public RevisionEstimateService(RevisionEstimateRepository revisionEstimateRepository) {
        this.revisionEstimateRepository = revisionEstimateRepository;
    }

    public List<RevisionAbstractEstimate> findApprovedRevisionEstimatesByParent(Long id) {
        return this.revisionEstimateRepository.findByParent_IdAndStatus(id, RevisionAbstractEstimate.RevisionEstimateStatus.APPROVED.toString());
    }

    public List<RevisionAbstractEstimate> findApprovedRevisionEstimatesByParentForView(Long id, Long reId) {
        return this.revisionEstimateRepository.findByParent_IdAndStatusForView(id, reId, RevisionAbstractEstimate.RevisionEstimateStatus.APPROVED.toString());
    }

    public RevisionAbstractEstimate getRevisionEstimateById(Long id) {
        return (RevisionAbstractEstimate)((Object)this.revisionEstimateRepository.findOne(id));
    }

    public List<User> getRevisionEstimateCreatedByUsers() {
        return this.revisionEstimateRepository.findRevisionEstimateCreatedByUsers();
    }

    public List<String> getRevisionEstimateByEstimateNumberLike(String revisionEstimateNumber) {
        return this.revisionEstimateRepository.findDistinctEstimateNumberContainingIgnoreCase("%" + revisionEstimateNumber + "%");
    }

    @Transactional
    public RevisionAbstractEstimate createRevisionEstimate(RevisionAbstractEstimate revisionEstimate, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        this.mergeSorAndNonSorActivities(revisionEstimate);
        AbstractEstimate abstractEstimate = revisionEstimate.getParent();
        List<RevisionAbstractEstimate> revisionEstimates = this.revisionEstimateRepository.findByParent_Id(abstractEstimate.getId());
        Integer reCount = revisionEstimates.size();
        if (revisionEstimate.getId() != null) {
            reCount = reCount - 1;
        }
        if (revisionEstimate.getId() == null) {
            revisionEstimate.setParent(abstractEstimate);
            revisionEstimate.setEstimateDate(new Date());
            reCount = reCount + 1;
            revisionEstimate.setEstimateNumber(abstractEstimate.getEstimateNumber() + "/RE".concat(Integer.toString(reCount)));
            revisionEstimate.setName("Revision Estimate for: " + abstractEstimate.getName());
            revisionEstimate.setDescription("Revision Estimate for: " + abstractEstimate.getDescription());
            revisionEstimate.setNatureOfWork(abstractEstimate.getNatureOfWork());
            revisionEstimate.setExecutingDepartment(abstractEstimate.getExecutingDepartment());
            revisionEstimate.setWard(abstractEstimate.getWard());
            revisionEstimate.setParentCategory(abstractEstimate.getParentCategory());
        }
        this.mergeChangeQuantityActivities(revisionEstimate);
        this.revisionEstimateRepository.save((Object)revisionEstimate);
        this.createRevisionEstimateWorkflowTransition(revisionEstimate, approvalPosition, approvalComent, additionalRule, workFlowAction);
        this.revisionEstimateRepository.save((Object)revisionEstimate);
        return revisionEstimate;
    }

    private void releaseBudgetOnReject(RevisionAbstractEstimate revisionEstimate) {
        String appropriationNumber = this.lineEstimateAppropriationService.generateBudgetAppropriationNumber(revisionEstimate.getParent().getLineEstimateDetails());
        this.lineEstimateService.releaseBudgetOnReject(revisionEstimate.getParent().getLineEstimateDetails(), revisionEstimate.getEstimateValue().doubleValue(), appropriationNumber);
    }

    private void doBudgetoryAppropriation(String workFlowAction, RevisionAbstractEstimate revisionEstimate) {
        ArrayList<Long> budgetheadid = new ArrayList<Long>();
        budgetheadid.add(revisionEstimate.getParent().getLineEstimateDetails().getLineEstimate().getBudgetHead().getId());
        boolean flag = this.lineEstimateDetailService.checkConsumeEncumbranceBudget(revisionEstimate.getParent().getLineEstimateDetails(), this.worksUtils.getFinancialYearByDate(new Date()).getId(), revisionEstimate.getEstimateValue().doubleValue(), budgetheadid);
        if (!flag) {
            throw new ValidationException("", "error.budgetappropriation.insufficient.amount", new String[0]);
        }
    }

    private void removeEmptyMS(Activity activity) {
        LinkedList<MeasurementSheet> toRemove = new LinkedList<MeasurementSheet>();
        for (MeasurementSheet ms : activity.getMeasurementSheetList()) {
            if (ms.getQuantity() != null && (ms.getQuantity() == null || !ms.getQuantity().equals(""))) continue;
            toRemove.add(ms);
        }
        for (MeasurementSheet msremove : toRemove) {
            activity.getMeasurementSheetList().remove((Object)msremove);
        }
    }

    @Transactional
    public RevisionAbstractEstimate updateRevisionEstimate(RevisionAbstractEstimate revisionEstimate, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction, String removedActivityIds, WorkOrderEstimate workOrderEstimate) throws ValidationException, IOException {
        RevisionAbstractEstimate updateRevisionEstimate = null;
        if ((AbstractEstimate.EstimateStatus.NEW.toString().equals(revisionEstimate.getEgwStatus().getCode()) || AbstractEstimate.EstimateStatus.REJECTED.toString().equals(revisionEstimate.getEgwStatus().getCode())) && !"Cancel".equals(workFlowAction)) {
            this.mergeSorAndNonSorActivities(revisionEstimate);
            this.mergeChangeQuantityActivities(revisionEstimate);
            List<Activity> activities = new ArrayList<Activity>(revisionEstimate.getActivities());
            activities = this.removeDeletedActivities(activities, removedActivityIds);
            revisionEstimate.setActivities(activities);
        }
        if (RevisionAbstractEstimate.RevisionEstimateStatus.TECH_SANCTIONED.toString().equals(revisionEstimate.getEgwStatus().getCode()) && !WorksConstants.REJECT_ACTION.equals(workFlowAction) && !BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue())) {
            this.doBudgetoryAppropriation(workFlowAction, revisionEstimate);
        }
        if (WorksConstants.REJECT_ACTION.toString().equalsIgnoreCase(workFlowAction) && RevisionAbstractEstimate.RevisionEstimateStatus.TECH_SANCTIONED.toString().equals(revisionEstimate.getEgwStatus().getCode()) && !BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue())) {
            this.releaseBudgetOnReject(revisionEstimate);
        }
        revisionEstimate.setApprovedBy((User)((Session)this.entityManager.unwrap(Session.class)).load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
        revisionEstimate.setApprovedDate(new Date());
        updateRevisionEstimate = (RevisionAbstractEstimate)((Object)this.revisionEstimateRepository.save((Object)revisionEstimate));
        this.revisionEstimateStatusChange(updateRevisionEstimate, workFlowAction);
        this.createRevisionEstimateWorkflowTransition(updateRevisionEstimate, approvalPosition, approvalComent, additionalRule, workFlowAction);
        if ("Approve".toString().equalsIgnoreCase(workFlowAction)) {
            RevisionWorkOrder revisionWorkOrder = new RevisionWorkOrder();
            revisionWorkOrder = this.createRevisionWorkOrder(updateRevisionEstimate, revisionWorkOrder, workOrderEstimate);
            this.revisionWorkOrderService.create(revisionWorkOrder);
            updateRevisionEstimate.getParent().setTotalIncludingRE(updateRevisionEstimate.getParent().getTotalIncludingRE() + updateRevisionEstimate.getWorkValue());
        }
        this.revisionEstimateRepository.save((Object)updateRevisionEstimate);
        return updateRevisionEstimate;
    }

    private RevisionWorkOrder createRevisionWorkOrder(RevisionAbstractEstimate revisionEstimate, RevisionWorkOrder revisionWorkOrder, WorkOrderEstimate workOrderEstimate) {
        List<RevisionAbstractEstimate> revisionEstimates = this.revisionEstimateRepository.findByParent_Id(revisionEstimate.getParent().getId());
        Integer reCount = revisionEstimates.size();
        revisionWorkOrder.setParent(workOrderEstimate.getWorkOrder());
        revisionWorkOrder.setWorkOrderDate(revisionEstimate.getEstimateDate());
        reCount = reCount + 1;
        revisionWorkOrder.setWorkOrderNumber(workOrderEstimate.getWorkOrder().getWorkOrderNumber() + "/RW".concat(Integer.toString(reCount)));
        revisionWorkOrder.setContractor(workOrderEstimate.getWorkOrder().getContractor());
        revisionWorkOrder.setEngineerIncharge(workOrderEstimate.getWorkOrder().getEngineerIncharge());
        revisionWorkOrder.setEmdAmountDeposited(0.0);
        revisionWorkOrder.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("WorkOrder", "APPROVED"));
        revisionWorkOrder.setApprovedDate(new Date());
        this.populateWorkOrderActivities(revisionWorkOrder, revisionEstimate);
        revisionWorkOrder.getParent().setTotalIncludingRE(revisionWorkOrder.getParent().getTotalIncludingRE() + revisionWorkOrder.getWorkOrderAmount());
        return revisionWorkOrder;
    }

    protected void populateWorkOrderActivities(RevisionWorkOrder revisionWorkOrder, RevisionAbstractEstimate revisionEstimate) {
        WorkOrderEstimate workOrderEstimate = new WorkOrderEstimate();
        workOrderEstimate.setEstimate(revisionEstimate);
        workOrderEstimate.setWorkOrder(revisionWorkOrder);
        this.addWorkOrderEstimateActivities(workOrderEstimate, revisionWorkOrder, revisionEstimate);
        revisionWorkOrder.addWorkOrderEstimate(workOrderEstimate);
    }

    private void addWorkOrderEstimateActivities(WorkOrderEstimate workOrderEstimate, RevisionWorkOrder revisionWorkOrder, RevisionAbstractEstimate revisionEstimate) {
        double woTotalAmount = 0.0;
        double approvedAmount = 0.0;
        Double tenderFinalizedPercentage = revisionWorkOrder.getParent().getTenderFinalizedPercentage();
        for (Activity activity : revisionEstimate.getActivities()) {
            WorkOrderActivity workOrderActivity = new WorkOrderActivity();
            workOrderActivity.setActivity(activity);
            this.populateWorkOrderMeasurementSheet(workOrderActivity);
            approvedAmount = 0.0;
            if (activity != null && activity.getRevisionType() != null && (RevisionType.NON_TENDERED_ITEM.toString().equalsIgnoreCase(activity.getRevisionType().toString()) || RevisionType.LUMP_SUM_ITEM.toString().equalsIgnoreCase(activity.getRevisionType().toString()))) {
                workOrderActivity.setApprovedRate(activity.getRate());
            } else if (activity != null && activity.getRevisionType() != null && (RevisionType.ADDITIONAL_QUANTITY.toString().equalsIgnoreCase(activity.getRevisionType().toString()) || RevisionType.REDUCED_QUANTITY.toString().equalsIgnoreCase(activity.getRevisionType().toString()))) {
                if (!tenderFinalizedPercentage.equals(0.0)) {
                    workOrderActivity.setApprovedRate(activity.getRate() + activity.getRate() * tenderFinalizedPercentage / 100.0);
                } else {
                    workOrderActivity.setApprovedRate(activity.getRate());
                }
            }
            workOrderActivity.setApprovedQuantity(activity.getQuantity());
            approvedAmount = new Money(activity.getRate() * workOrderActivity.getApprovedQuantity()).getValue();
            if (activity.getRevisionType() != null && RevisionType.REDUCED_QUANTITY.equals((Object)activity.getRevisionType())) {
                approvedAmount *= -1.0;
            }
            if (activity != null && activity.getParent() != null && activity.getParent().getRevisionType() == null && (RevisionType.ADDITIONAL_QUANTITY.toString().equalsIgnoreCase(activity.getRevisionType().toString()) || RevisionType.REDUCED_QUANTITY.toString().equalsIgnoreCase(activity.getRevisionType().toString())) && !tenderFinalizedPercentage.equals(0.0)) {
                approvedAmount += approvedAmount * tenderFinalizedPercentage / 100.0;
            }
            woTotalAmount += approvedAmount;
            workOrderActivity.setApprovedAmount(approvedAmount);
            workOrderActivity.setWorkOrderEstimate(workOrderEstimate);
            workOrderEstimate.addWorkOrderActivity(workOrderActivity);
        }
        workOrderEstimate.getWorkOrder().setWorkOrderAmount(woTotalAmount);
        workOrderEstimate.setEstimateWOAmount(woTotalAmount);
    }

    private void populateWorkOrderMeasurementSheet(WorkOrderActivity workOrderActivity) {
        for (MeasurementSheet mSheet : workOrderActivity.getActivity().getMeasurementSheetList()) {
            WorkOrderMeasurementSheet workOrderMeasurementSheet = new WorkOrderMeasurementSheet();
            workOrderMeasurementSheet.setNo(mSheet.getNo());
            workOrderMeasurementSheet.setLength(mSheet.getLength());
            workOrderMeasurementSheet.setWidth(mSheet.getWidth());
            workOrderMeasurementSheet.setDepthOrHeight(mSheet.getDepthOrHeight());
            workOrderMeasurementSheet.setQuantity(mSheet.getQuantity());
            workOrderMeasurementSheet.setMeasurementSheet(mSheet);
            workOrderMeasurementSheet.setWoActivity(workOrderActivity);
            workOrderActivity.getWorkOrderMeasurementSheets().add(workOrderMeasurementSheet);
        }
    }

    private List<Activity> removeDeletedActivities(List<Activity> activities, String removedActivityIds) {
        ArrayList<Activity> activityList = new ArrayList<Activity>();
        if (null != removedActivityIds) {
            String[] ids = removedActivityIds.split(",");
            ArrayList<String> strList = new ArrayList<String>();
            for (String str : ids) {
                strList.add(str);
            }
            for (Activity activity : activities) {
                if (activity.getId() != null) {
                    if (strList.contains(activity.getId().toString())) continue;
                    activityList.add(activity);
                    continue;
                }
                activityList.add(activity);
            }
        } else {
            return activities;
        }
        return activityList;
    }

    public void createRevisionEstimateWorkflowTransition(RevisionAbstractEstimate revisionEstimate, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        Assignment userAssignment = this.assignmentService.getPrimaryAssignmentForUser(user.getId());
        Position pos = null;
        Assignment wfInitiator = null;
        String currState = "";
        WorkFlowMatrix wfmatrix = null;
        if (null != revisionEstimate.getId()) {
            wfInitiator = this.assignmentService.getPrimaryAssignmentForUser(revisionEstimate.getCreatedBy().getId());
        }
        if (WorksConstants.REJECT_ACTION.toString().equalsIgnoreCase(workFlowAction)) {
            if (wfInitiator.equals(userAssignment)) {
                revisionEstimate.transition(true).end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNatureOfTask("Revision Estimate");
            } else {
                revisionEstimate.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("").withNatureOfTask("Revision Estimate");
            }
        } else if ("Save".toString().equalsIgnoreCase(workFlowAction)) {
            if (revisionEstimate.getState() == null) {
                revisionEstimate.transition(true).start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("NEW").withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("Pending Submission").withNatureOfTask("Revision Estimate");
            }
        } else {
            if (null != approvalPosition && approvalPosition != -1L && !approvalPosition.equals(0L)) {
                pos = this.positionMasterService.getPositionById(approvalPosition);
            }
            if (null == revisionEstimate.getState()) {
                wfmatrix = this.revisionAbstractEstimateWorkflowService.getWfMatrix(revisionEstimate.getStateType(), null, revisionEstimate.getEstimateValue(), additionalRule, "", null);
                revisionEstimate.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Revision Estimate");
            } else if ("Cancel".toString().equalsIgnoreCase(workFlowAction)) {
                String stateValue = "Cancelled";
                wfmatrix = this.revisionAbstractEstimateWorkflowService.getWfMatrix(revisionEstimate.getStateType(), null, revisionEstimate.getEstimateValue(), additionalRule, revisionEstimate.getCurrentState().getValue(), revisionEstimate.getCurrentState().getNextAction());
                revisionEstimate.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Cancelled").withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction("").withNatureOfTask("Revision Estimate");
            } else if ("Approve".toString().equalsIgnoreCase(workFlowAction)) {
                wfmatrix = this.revisionAbstractEstimateWorkflowService.getWfMatrix(revisionEstimate.getStateType(), null, revisionEstimate.getEstimateValue(), additionalRule, revisionEstimate.getCurrentState().getValue(), revisionEstimate.getCurrentState().getNextAction());
                revisionEstimate.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Revision Estimate");
                revisionEstimate.transition(true).end().withSenderName(user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate());
            } else {
                wfmatrix = this.revisionAbstractEstimateWorkflowService.getWfMatrix(revisionEstimate.getStateType(), null, revisionEstimate.getEstimateValue(), additionalRule, revisionEstimate.getCurrentState().getValue(), revisionEstimate.getCurrentState().getNextAction());
                revisionEstimate.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Revision Estimate");
            }
        }
    }

    private void mergeSorAndNonSorActivities(RevisionAbstractEstimate revisionEstimate) {
        for (Activity activity : revisionEstimate.getNonTenderedActivities()) {
            if (activity.getId() == null) {
                activity.setAbstractEstimate(revisionEstimate);
                activity.setRevisionType(RevisionType.NON_TENDERED_ITEM);
                revisionEstimate.addActivity(activity);
                continue;
            }
            for (Activity oldActivity : revisionEstimate.getSORActivities()) {
                if (!oldActivity.getId().equals(activity.getId())) continue;
                this.updateActivity(oldActivity, activity);
            }
        }
        for (Activity activity : revisionEstimate.getLumpSumActivities()) {
            if (activity.getId() == null) {
                activity.setAbstractEstimate(revisionEstimate);
                activity.setRevisionType(RevisionType.LUMP_SUM_ITEM);
                revisionEstimate.addActivity(activity);
                continue;
            }
            for (Activity oldActivity : revisionEstimate.getNonSORActivities()) {
                if (!oldActivity.getId().equals(activity.getId())) continue;
                this.updateActivity(oldActivity, activity);
            }
        }
        if (LOG.isDebugEnabled()) {
            for (Activity ac : revisionEstimate.getActivities()) {
                LOG.debug(ac.getMeasurementSheetList().size() + "    " + ac.getQuantity());
            }
        }
        for (Activity ac : revisionEstimate.getNonTenderedActivities()) {
            for (MeasurementSheet ms : ac.getMeasurementSheetList()) {
                if (ms.getActivity() != null) continue;
                ms.setActivity(ac);
            }
        }
        for (Activity ac : revisionEstimate.getLumpSumActivities()) {
            for (MeasurementSheet ms : ac.getMeasurementSheetList()) {
                if (ms.getActivity() != null) continue;
                ms.setActivity(ac);
            }
        }
    }

    private void mergeChangeQuantityActivities(RevisionAbstractEstimate revisionEstimate) {
        for (Activity activity : revisionEstimate.getChangeQuantityActivities()) {
            if (activity.getId() == null) {
                this.removeEmptyMS(activity);
                Activity act = (Activity)((Object)this.activityRepository.findOne(activity.getParent().getId()));
                activity.setParent(act);
                activity.setAbstractEstimate(revisionEstimate);
                activity.setSchedule(act.getSchedule());
                activity.setNonSor(act.getNonSor());
                activity.setUom(act.getUom());
                activity.setRate(act.getRate());
                if ("-".equals(activity.getSignValue())) {
                    activity.setRevisionType(RevisionType.REDUCED_QUANTITY);
                } else {
                    activity.setRevisionType(RevisionType.ADDITIONAL_QUANTITY);
                }
                activity.setEstimateRate(act.getEstimateRate());
                for (MeasurementSheet ms : activity.getMeasurementSheetList()) {
                    MeasurementSheet sheet = this.measurementSheetService.findOne(ms.getParent().getId());
                    ms.setActivity(activity);
                    ms.setParent(sheet);
                    ms.setIdentifier(sheet.getIdentifier());
                    ms.setRemarks(sheet.getRemarks());
                    ms.setSlNo(sheet.getSlNo());
                }
                revisionEstimate.addActivity(activity);
                continue;
            }
            for (Activity oldActivity : revisionEstimate.getActivities()) {
                if (oldActivity.getId() == null || !oldActivity.getId().equals(activity.getId())) continue;
                this.updateChangeQuantityActivity(oldActivity, activity);
            }
        }
    }

    private void updateChangeQuantityActivity(Activity oldActivity, Activity activity) {
        Activity parent = (Activity)((Object)this.activityRepository.findOne(activity.getParent().getId()));
        oldActivity.setParent(parent);
        oldActivity.setSchedule(parent.getSchedule());
        oldActivity.setAmt(activity.getAmt());
        oldActivity.setNonSor(parent.getNonSor());
        oldActivity.setQuantity(activity.getQuantity());
        oldActivity.setRate(parent.getRate());
        oldActivity.setServiceTaxPerc(activity.getServiceTaxPerc());
        oldActivity.setEstimateRate(parent.getEstimateRate());
        oldActivity.setUom(parent.getUom());
        oldActivity.setMeasurementSheetList(this.mergeCQMeasurementSheet(oldActivity, activity));
        if ("+".equals(activity.getSignValue())) {
            oldActivity.setRevisionType(RevisionType.ADDITIONAL_QUANTITY);
        } else {
            oldActivity.setRevisionType(RevisionType.REDUCED_QUANTITY);
        }
    }

    private List<MeasurementSheet> mergeMeasurementSheet(Activity oldActivity, Activity activity) {
        LinkedList<MeasurementSheet> newMsList = new LinkedList<MeasurementSheet>(oldActivity.getMeasurementSheetList());
        for (MeasurementSheet msnew : activity.getMeasurementSheetList()) {
            if (msnew.getId() == null && msnew.getQuantity() != null) {
                msnew.setActivity(oldActivity);
                oldActivity.getMeasurementSheetList().add(msnew);
                continue;
            }
            for (MeasurementSheet msold : oldActivity.getMeasurementSheetList()) {
                if (msnew.getId().longValue() != msold.getId().longValue()) continue;
                msold.setLength(msnew.getLength());
                msold.setWidth(msnew.getWidth());
                msold.setDepthOrHeight(msnew.getDepthOrHeight());
                msold.setNo(msnew.getNo());
                msold.setActivity(msnew.getActivity());
                if (msnew.getParent() != null) {
                    msold.setIdentifier(msnew.getParent().getIdentifier());
                    msold.setRemarks(msnew.getParent().getRemarks());
                    msold.setSlNo(msnew.getParent().getSlNo());
                }
                msold.setQuantity(msnew.getQuantity());
                newMsList.add(msold);
            }
        }
        LinkedList<MeasurementSheet> toRemove = new LinkedList<MeasurementSheet>();
        for (MeasurementSheet msold : oldActivity.getMeasurementSheetList()) {
            Boolean found = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug(oldActivity.getMeasurementSheetList().size() + "activity.getMeasurementSheetList()");
                LOG.debug(msold.getId() + "------msold.getId()");
            }
            if (msold.getId() == null) continue;
            for (MeasurementSheet msnew : activity.getMeasurementSheetList()) {
                if (msnew.getId() == null || msnew.getId().longValue() != msold.getId().longValue()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(msnew.getId() + "------msnew.getId()");
                    LOG.debug(msnew.getRemarks() + "------remarks");
                }
                found = true;
            }
            if (found.booleanValue()) continue;
            toRemove.add(msold);
        }
        for (MeasurementSheet msremove : toRemove) {
            if (LOG.isInfoEnabled()) {
                LOG.info("...........Removing rows....................Of MeasurementSheet" + msremove.getId());
            }
            oldActivity.getMeasurementSheetList().remove((Object)msremove);
        }
        this.removeEmptyMS(oldActivity);
        return oldActivity.getMeasurementSheetList();
    }

    private List<MeasurementSheet> mergeCQMeasurementSheet(Activity oldActivity, Activity activity) {
        for (MeasurementSheet msnew : activity.getMeasurementSheetList()) {
            if (msnew.getId() == null && msnew.getQuantity() != null) {
                msnew.setActivity(oldActivity);
                if (msnew.getParent() != null) {
                    msnew.setIdentifier(msnew.getParent().getIdentifier());
                }
                oldActivity.getMeasurementSheetList().add(msnew);
                continue;
            }
            for (MeasurementSheet msold : oldActivity.getMeasurementSheetList()) {
                if (msnew.getId() != msold.getId()) continue;
                msold.setLength(msnew.getLength());
                msold.setWidth(msnew.getWidth());
                msold.setDepthOrHeight(msnew.getDepthOrHeight());
                msold.setNo(msnew.getNo());
                msold.setIdentifier(msnew.getParent().getIdentifier());
                msold.setRemarks(msnew.getParent().getRemarks());
                msold.setSlNo(msnew.getParent().getSlNo());
                msold.setQuantity(msnew.getQuantity());
                msold.setActivity(oldActivity);
            }
        }
        this.removeEmptyMS(oldActivity);
        return oldActivity.getMeasurementSheetList();
    }

    private void updateActivity(Activity oldActivity, Activity activity) {
        oldActivity.setSchedule(activity.getSchedule());
        oldActivity.setAmt(activity.getAmt());
        oldActivity.setNonSor(activity.getNonSor());
        oldActivity.setQuantity(activity.getQuantity());
        oldActivity.setRate(activity.getRate());
        oldActivity.setServiceTaxPerc(activity.getServiceTaxPerc());
        oldActivity.setEstimateRate(activity.getEstimateRate());
        oldActivity.setUom(activity.getUom());
        oldActivity.setMeasurementSheetList(this.mergeMeasurementSheet(oldActivity, activity));
    }

    public void populateHeaderActivities(RevisionAbstractEstimate revisionEstimate, List<RevisionAbstractEstimate> revisionAbstractEstimates, Model model) {
        ArrayList<Activity> sorActivities = new ArrayList<Activity>(revisionEstimate.getParent().getSORActivities());
        ArrayList<Activity> nonSorActivities = new ArrayList<Activity>(revisionEstimate.getParent().getNonSORActivities());
        ArrayList<Activity> nonTenderedActivities = new ArrayList<Activity>();
        ArrayList<Activity> lumpSumActivities = new ArrayList<Activity>();
        HashMap<Long, String> previousEstimates = new HashMap<Long, String>();
        Boolean measurementsPresent = false;
        for (RevisionAbstractEstimate re : revisionAbstractEstimates) {
            for (Activity activity : re.getActivities()) {
                if (activity.getParent() == null && activity.getRevisionType() != null && RevisionType.NON_TENDERED_ITEM.equals((Object)activity.getRevisionType())) {
                    nonTenderedActivities.add(activity);
                    continue;
                }
                if (activity.getParent() != null || activity.getRevisionType() == null || !RevisionType.LUMP_SUM_ITEM.equals((Object)activity.getRevisionType())) continue;
                lumpSumActivities.add(activity);
            }
            previousEstimates.put(re.getId(), re.getEstimateNumber());
            if (measurementsPresent.booleanValue()) continue;
            measurementsPresent = this.measurementSheetService.existsByEstimate(re.getId());
        }
        for (RevisionAbstractEstimate re : revisionAbstractEstimates) {
            for (Activity activity : re.getActivities()) {
                if (activity.getParent() != null && activity.getSchedule() != null) {
                    this.populateChangeQuantityActivities(activity, sorActivities, nonTenderedActivities);
                    continue;
                }
                if (activity.getParent() == null || activity.getSchedule() != null) continue;
                this.populateChangeQuantityActivities(activity, nonSorActivities, lumpSumActivities);
            }
        }
        if (!revisionAbstractEstimates.isEmpty()) {
            for (Activity sa : sorActivities) {
                if (sa.getMeasurementSheetList().isEmpty()) continue;
                for (MeasurementSheet ms : sa.getMeasurementSheetList()) {
                    this.deriveMeasurementSheetQuantity(ms, revisionEstimate.getId());
                }
            }
            for (Activity sa : nonSorActivities) {
                if (sa.getMeasurementSheetList().isEmpty()) continue;
                for (MeasurementSheet ms : sa.getMeasurementSheetList()) {
                    this.deriveMeasurementSheetQuantity(ms, revisionEstimate.getId());
                }
            }
            for (Activity sa : nonTenderedActivities) {
                if (sa.getMeasurementSheetList().isEmpty()) continue;
                for (MeasurementSheet ms : sa.getMeasurementSheetList()) {
                    this.deriveMeasurementSheetQuantity(ms, revisionEstimate.getId());
                }
            }
            for (Activity sa : lumpSumActivities) {
                if (sa.getMeasurementSheetList().isEmpty()) continue;
                for (MeasurementSheet ms : sa.getMeasurementSheetList()) {
                    this.deriveMeasurementSheetQuantity(ms, revisionEstimate.getId());
                }
            }
        }
        revisionEstimate.getSorActivities().addAll(sorActivities);
        revisionEstimate.getNonSorActivities().addAll(nonSorActivities);
        revisionEstimate.getChangeQuantityNTActivities().addAll(nonTenderedActivities);
        revisionEstimate.getChangeQuantityLSActivities().addAll(lumpSumActivities);
        model.addAttribute("previousEstimates", previousEstimates);
        model.addAttribute("measurementsPresent", (Object)measurementsPresent);
    }

    public void populateChangeQuantityActivities(Activity activity, List<Activity> activities, List<Activity> nonTenderedLumpSumActivities) {
        for (Activity sa : activities) {
            if (!activity.getParent().getId().equals(sa.getId())) continue;
            if (activity.getRevisionType() != null && RevisionType.ADDITIONAL_QUANTITY.equals((Object)activity.getRevisionType())) {
                sa.setQuantity(sa.getQuantity() + activity.getQuantity());
                sa.setQuantityChanged(true);
                continue;
            }
            if (activity.getRevisionType() == null || !RevisionType.REDUCED_QUANTITY.equals((Object)activity.getRevisionType())) continue;
            sa.setQuantity(sa.getQuantity() - activity.getQuantity());
            sa.setQuantityChanged(true);
        }
        for (Activity sa : nonTenderedLumpSumActivities) {
            if (!activity.getParent().getId().equals(sa.getId())) continue;
            if (activity.getRevisionType() != null && RevisionType.ADDITIONAL_QUANTITY.equals((Object)activity.getRevisionType())) {
                sa.setQuantity(sa.getQuantity() + activity.getQuantity());
                sa.setQuantityChanged(true);
                continue;
            }
            if (activity.getRevisionType() == null || !RevisionType.REDUCED_QUANTITY.equals((Object)activity.getRevisionType())) continue;
            sa.setQuantity(sa.getQuantity() - activity.getQuantity());
            sa.setQuantityChanged(true);
        }
    }

    public void loadDataForView(RevisionAbstractEstimate revisionEstimate, WorkOrderEstimate workOrderEstimate, Model model) {
        this.loadViewData(revisionEstimate, workOrderEstimate, model);
        this.prepareNonTenderedAndLumpSumActivities(revisionEstimate);
        this.prepareChangeQuantityActivities(revisionEstimate);
    }

    public void loadViewData(RevisionAbstractEstimate revisionEstimate, WorkOrderEstimate workOrderEstimate, Model model) {
        List values = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "SHOW_SERVICE_FIELDS");
        AppConfigValues value = (AppConfigValues)values.get(0);
        if (value.getValue().equalsIgnoreCase("Yes")) {
            model.addAttribute("isServiceVATRequired", (Object)true);
        } else {
            model.addAttribute("isServiceVATRequired", (Object)false);
        }
        model.addAttribute("uoms", (Object)this.uomService.findAll());
        List<RevisionAbstractEstimate> revisionAbstractEstimates = revisionEstimate != null && revisionEstimate.getId() != null ? this.findApprovedRevisionEstimatesByParentForView(workOrderEstimate.getEstimate().getId(), revisionEstimate.getId()) : this.findApprovedRevisionEstimatesByParent(workOrderEstimate.getEstimate().getId());
        this.populateHeaderActivities(revisionEstimate, revisionAbstractEstimates, model);
        model.addAttribute("revisionEstimate", (Object)revisionEstimate);
        model.addAttribute("exceptionaluoms", (Object)this.worksUtils.getExceptionalUOMS());
        model.addAttribute("workOrderDate", (Object)DateUtils.getDefaultFormattedDate((Date)workOrderEstimate.getWorkOrder().getWorkOrderDate()));
        model.addAttribute("workOrderEstimate", (Object)workOrderEstimate);
        model.addAttribute("scheduleCategories", this.scheduleCategoryService.getAllScheduleCategories());
        model.addAttribute("stateType", (Object)((Object)((Object)revisionEstimate)).getClass().getSimpleName());
    }

    public void revisionEstimateStatusChange(RevisionAbstractEstimate revisionEstimate, String workFlowAction) {
        if (revisionEstimate != null && revisionEstimate.getEgwStatus() != null && revisionEstimate.getEgwStatus().getCode() != null) {
            if ("Save".equals(workFlowAction)) {
                revisionEstimate.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("RevisionAbstractEstimate", RevisionAbstractEstimate.RevisionEstimateStatus.NEW.toString()));
            } else if ("Cancel".equals(workFlowAction)) {
                revisionEstimate.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("RevisionAbstractEstimate", RevisionAbstractEstimate.RevisionEstimateStatus.CANCELLED.toString()));
            } else if (RevisionAbstractEstimate.RevisionEstimateStatus.NEW.toString().equals(revisionEstimate.getEgwStatus().getCode())) {
                revisionEstimate.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("RevisionAbstractEstimate", RevisionAbstractEstimate.RevisionEstimateStatus.CREATED.toString()));
            } else if ("Approve".equals(workFlowAction) && RevisionAbstractEstimate.RevisionEstimateStatus.BUDGET_SANCTIONED.toString().equals(revisionEstimate.getEgwStatus().getCode())) {
                revisionEstimate.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("RevisionAbstractEstimate", RevisionAbstractEstimate.RevisionEstimateStatus.APPROVED.toString()));
            } else if (WorksConstants.REJECT_ACTION.equals(workFlowAction)) {
                revisionEstimate.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("RevisionAbstractEstimate", RevisionAbstractEstimate.RevisionEstimateStatus.REJECTED.toString()));
            } else if (RevisionAbstractEstimate.RevisionEstimateStatus.REJECTED.toString().equals(revisionEstimate.getEgwStatus().getCode()) && "Cancel".equals(workFlowAction)) {
                revisionEstimate.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("RevisionAbstractEstimate", RevisionAbstractEstimate.RevisionEstimateStatus.CANCELLED.toString()));
            } else if (RevisionAbstractEstimate.RevisionEstimateStatus.REJECTED.toString().equals(revisionEstimate.getEgwStatus().getCode()) && WorksConstants.FORWARD_ACTION.equals(workFlowAction)) {
                revisionEstimate.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("RevisionAbstractEstimate", RevisionAbstractEstimate.RevisionEstimateStatus.RESUBMITTED.toString()));
            } else if (RevisionAbstractEstimate.RevisionEstimateStatus.CREATED.toString().equals(revisionEstimate.getEgwStatus().getCode()) && !revisionEstimate.getState().getNextAction().equals("Pending Technical Sanction") && "Submit".equals(workFlowAction)) {
                revisionEstimate.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("RevisionAbstractEstimate", RevisionAbstractEstimate.RevisionEstimateStatus.CHECKED.toString()));
            } else if (RevisionAbstractEstimate.RevisionEstimateStatus.RESUBMITTED.toString().equals(revisionEstimate.getEgwStatus().getCode()) && !revisionEstimate.getState().getNextAction().equals("Pending Technical Sanction")) {
                revisionEstimate.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("RevisionAbstractEstimate", RevisionAbstractEstimate.RevisionEstimateStatus.CHECKED.toString()));
            } else if (RevisionAbstractEstimate.RevisionEstimateStatus.CHECKED.toString().equals(revisionEstimate.getEgwStatus().getCode()) && !WorksConstants.REJECT_ACTION.equals(workFlowAction) && revisionEstimate.getState().getNextAction().equals("Pending Technical Sanction") || revisionEstimate.getEgwStatus().getCode().equals(RevisionAbstractEstimate.RevisionEstimateStatus.CREATED.toString()) && !WorksConstants.REJECT_ACTION.equals(workFlowAction) && revisionEstimate.getState().getNextAction().equals("Pending Technical Sanction") || revisionEstimate.getEgwStatus().getCode().equals(RevisionAbstractEstimate.RevisionEstimateStatus.RESUBMITTED.toString()) && !WorksConstants.REJECT_ACTION.equals(workFlowAction) && revisionEstimate.getState().getNextAction().equals("Pending Technical Sanction")) {
                revisionEstimate.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("RevisionAbstractEstimate", RevisionAbstractEstimate.RevisionEstimateStatus.TECH_SANCTIONED.toString()));
            } else if (revisionEstimate.getEgwStatus().getCode().equals(RevisionAbstractEstimate.RevisionEstimateStatus.TECH_SANCTIONED.toString()) && !WorksConstants.REJECT_ACTION.equals(workFlowAction)) {
                revisionEstimate.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("RevisionAbstractEstimate", RevisionAbstractEstimate.RevisionEstimateStatus.BUDGET_SANCTIONED.toString()));
            }
        }
    }

    public List<SearchRevisionEstimate> searchRevisionEstimates(SearchRevisionEstimate searchRevisionEstimate) {
        Query query = null;
        query = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(this.getQueryForSearchRevisionEstimates(searchRevisionEstimate)).addScalar("id", (Type)LongType.INSTANCE).addScalar("aeId", (Type)LongType.INSTANCE).addScalar("woId", (Type)LongType.INSTANCE).addScalar("revisionEstimateNumber").addScalar("reDate", (Type)DateType.INSTANCE).addScalar("loaNumber", (Type)StringType.INSTANCE).addScalar("contractorName", (Type)StringType.INSTANCE).addScalar("estimateNumber", (Type)StringType.INSTANCE).addScalar("reValue", (Type)BigDecimalType.INSTANCE).addScalar("revisionEstimateStatus", (Type)StringType.INSTANCE).addScalar("currentOwner", (Type)StringType.INSTANCE).setResultTransformer(Transformers.aliasToBean(SearchRevisionEstimate.class));
        query = this.setParameterForSearchRevisionEstimates(searchRevisionEstimate, query);
        return query.list();
    }

    private String getQueryForSearchRevisionEstimates(SearchRevisionEstimate searchRevisionEstimate) {
        StringBuilder filterConditions = new StringBuilder();
        if (searchRevisionEstimate != null) {
            if (searchRevisionEstimate.getRevisionEstimateNumber() != null) {
                filterConditions.append(" AND aec.estimateNumber =:estimateNumber ");
            }
            if (searchRevisionEstimate.getFromDate() != null) {
                filterConditions.append(" AND aec.estimateDate >=:fromDate ");
            }
            if (searchRevisionEstimate.getToDate() != null) {
                filterConditions.append(" AND aec.estimateDate <=:toDate ");
            }
            if (searchRevisionEstimate.getLoaNumber() != null) {
                filterConditions.append(" AND lower(wo.workOrder_Number) like :loaNumber ");
            }
            if (searchRevisionEstimate.getCreatedBy() != null) {
                filterConditions.append(" AND aec.createdBy =:createdBy ");
            }
            if (searchRevisionEstimate.getStatus() != null) {
                filterConditions.append(" AND aec.status =:status ");
            }
        }
        StringBuilder query = new StringBuilder();
        query.append(" SELECT distinct re.id                     AS id, ");
        query.append(" aep.id                           AS aeId ,  ");
        query.append(" wo.id                            AS woId ,  ");
        query.append(" aec.estimateNumber               AS revisionEstimateNumber ,  ");
        query.append(" aec.estimateDate                 AS reDate ,  ");
        query.append(" wo.workOrder_Number              AS loaNumber ,  ");
        query.append(" contractor.name                  AS contractorName,  ");
        query.append(" aep.estimateNumber               AS estimateNumber,  ");
        query.append(" aec.estimateValue                AS reValue,  ");
        query.append(" status.description               AS revisionEstimateStatus, ");
        query.append(" u.name                           AS currentOwner  ");
        query.append(" FROM egw_revision_estimate re,egw_abstractestimate aec,egw_abstractestimate aep,");
        query.append(" egw_workorder wo,egw_workorder_estimate woe,egw_contractor contractor,egw_status status,eg_user u ");
        query.append(" WHERE aec.parent = aep.id ");
        query.append(" AND aec.id = re.id ");
        query.append(" AND aep.id = woe.abstractestimate_id ");
        query.append(" AND woe.workorder_id = wo.id ");
        query.append(" AND wo.contractor_id = contractor.id ");
        query.append(" AND aec.createdby = u.id ");
        query.append(" AND aec.status = status.id ");
        query.append(filterConditions.toString());
        return query.toString();
    }

    private Query setParameterForSearchRevisionEstimates(SearchRevisionEstimate searchRevisionEstimate, Query query) {
        if (searchRevisionEstimate != null) {
            if (searchRevisionEstimate.getRevisionEstimateNumber() != null) {
                query.setString("estimateNumber", searchRevisionEstimate.getRevisionEstimateNumber());
            }
            if (searchRevisionEstimate.getFromDate() != null) {
                query.setDate("fromDate", searchRevisionEstimate.getFromDate());
            }
            if (searchRevisionEstimate.getToDate() != null) {
                query.setDate("toDate", searchRevisionEstimate.getToDate());
            }
            if (searchRevisionEstimate.getLoaNumber() != null) {
                query.setString("loaNumber", "%" + searchRevisionEstimate.getLoaNumber().toLowerCase() + "%");
            }
            if (searchRevisionEstimate.getCreatedBy() != null) {
                query.setLong("createdBy", searchRevisionEstimate.getCreatedBy().longValue());
            }
            if (searchRevisionEstimate.getStatus() != null) {
                query.setLong("status", searchRevisionEstimate.getStatus().longValue());
            }
        }
        return query;
    }

    public List<Activity> searchActivities(Long estimateId, String sorType) {
        StringBuilder queryStr = new StringBuilder(500);
        queryStr.append("select act from Activity act where (act.abstractEstimate.egwStatus.code = :aeStatus or act.abstractEstimate.egwStatus.code = :reStatus) ");
        if (estimateId != null) {
            queryStr.append(" and (act.abstractEstimate.id = :estimateId or act.abstractEstimate.parent.id = :estimateId )");
        }
        if (sorType != null && "SOR".equalsIgnoreCase(sorType)) {
            queryStr.append(" and act.schedule != null");
        }
        if (sorType != null && "Non Sor".equalsIgnoreCase(sorType)) {
            queryStr.append(" and act.schedule = null");
        }
        queryStr.append(" order by act.id");
        Query query = ((Session)this.entityManager.unwrap(Session.class)).createQuery(queryStr.toString());
        query = this.setParameterForSearchActivities(estimateId, query);
        return query.list();
    }

    private Query setParameterForSearchActivities(Long estimateId, Query query) {
        if (estimateId != null) {
            query.setLong("estimateId", estimateId.longValue());
        }
        query.setString("aeStatus", AbstractEstimate.EstimateStatus.APPROVED.toString());
        query.setString("reStatus", RevisionAbstractEstimate.RevisionEstimateStatus.APPROVED.toString());
        return query;
    }

    public void validateChangeQuantityActivities(RevisionAbstractEstimate revisionEstimate, BindingResult bindErrors) {
        for (Activity activity : revisionEstimate.getChangeQuantityActivities()) {
            WorkOrderActivity workOrderActivity;
            if (activity.getQuantity() <= 0.0) {
                bindErrors.reject("error.quantity.zero", "error.quantity.zero");
            }
            if (activity.getRate() <= 0.0) {
                bindErrors.reject("error.rates.zero", "error.rates.zero");
            }
            if (!"-".equals(activity.getSignValue()) || (workOrderActivity = this.workOrderActivityService.getWorkOrderActivityByActivity(activity.getParent().getId())) == null) continue;
            Double consumedQuantity = this.mbHeaderService.getPreviousCumulativeQuantity(-1L, workOrderActivity.getId());
            if (consumedQuantity == null) {
                consumedQuantity = 0.0;
            }
            if (!"-".equals(activity.getSignValue()) || !(workOrderActivity.getApprovedQuantity() - consumedQuantity - activity.getQuantity() < 0.0)) continue;
            bindErrors.reject("error.change.quantity", "error.change.quantity");
        }
    }

    public List<String> findRENumbersToCancel(String estimateNumber) {
        return this.revisionEstimateRepository.getRENumbersToCancel("%" + estimateNumber + "%", AbstractEstimate.EstimateStatus.APPROVED.toString(), AbstractEstimate.EstimateStatus.CANCELLED.toString());
    }

    public List<SearchRevisionEstimate> searchRevisionEstimatesToCancel(SearchRevisionEstimate searchRevisionEstimate) {
        Query query = null;
        query = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(this.createQueryForSearchRevisionEstimates(searchRevisionEstimate)).addScalar("id", (Type)LongType.INSTANCE).addScalar("woId", (Type)LongType.INSTANCE).addScalar("revisionEstimateNumber", (Type)StringType.INSTANCE).addScalar("reDate", (Type)DateType.INSTANCE).addScalar("loaNumber", (Type)StringType.INSTANCE).addScalar("estimateNumber", (Type)StringType.INSTANCE).addScalar("reValue", (Type)BigDecimalType.INSTANCE).addScalar("revisionEstimateStatus", (Type)StringType.INSTANCE).setResultTransformer(Transformers.aliasToBean(SearchRevisionEstimate.class));
        query = this.setQueryParameterForSearchRevisionEstimates(searchRevisionEstimate, query);
        return query.list();
    }

    private String createQueryForSearchRevisionEstimates(SearchRevisionEstimate searchRevisionEstimate) {
        StringBuilder filterConditions = new StringBuilder();
        if (searchRevisionEstimate != null) {
            if (searchRevisionEstimate.getRevisionEstimateNumber() != null) {
                filterConditions.append(" AND aec.estimateNumber =:estimateNumber ");
            }
            if (searchRevisionEstimate.getFromDate() != null) {
                filterConditions.append(" AND aec.estimateDate >=:fromDate ");
            }
            if (searchRevisionEstimate.getToDate() != null) {
                filterConditions.append(" AND aec.estimateDate <=:toDate ");
            }
            if (searchRevisionEstimate.getLoaNumber() != null) {
                filterConditions.append(" AND wo.workOrder_Number like :loaNumber ");
            }
            if (searchRevisionEstimate.getCreatedBy() != null) {
                filterConditions.append(" AND aec.createdBy =:createdBy ");
            }
        }
        StringBuilder query = new StringBuilder();
        query.append(" SELECT distinct re.id            AS id, ");
        query.append(" wo.id                            AS woId ,  ");
        query.append(" aec.estimateNumber               AS revisionEstimateNumber ,  ");
        query.append(" aec.estimateDate                 AS reDate ,  ");
        query.append(" wo.workOrder_Number              AS loaNumber ,  ");
        query.append(" aep.estimateNumber               AS estimateNumber,  ");
        query.append(" aec.estimateValue                AS reValue,  ");
        query.append(" status.description               AS revisionEstimateStatus ");
        query.append(" FROM egw_revision_estimate re,egw_abstractestimate aec,egw_abstractestimate aep,");
        query.append(" egw_workorder wo,egw_workorder_estimate woe,egw_status status ");
        query.append(" WHERE aec.parent = aep.id ");
        query.append(" AND aec.id = re.id ");
        query.append(" AND aep.id = woe.abstractestimate_id ");
        query.append(" AND woe.workorder_id = wo.id ");
        query.append(" AND aec.status = status.id AND status.code =:restatus ");
        query.append(" AND exists (select wo.id from egw_mb_header mbh ,egw_status mbstatus where mbh.status_id = mbstatus.id and mbstatus.code = 'CANCELLED')");
        query.append(filterConditions.toString());
        return query.toString();
    }

    private Query setQueryParameterForSearchRevisionEstimates(SearchRevisionEstimate searchRevisionEstimate, Query query) {
        if (searchRevisionEstimate != null) {
            if (StringUtils.isNotBlank((CharSequence)searchRevisionEstimate.getRevisionEstimateNumber())) {
                query.setString("estimateNumber", searchRevisionEstimate.getRevisionEstimateNumber());
            }
            if (searchRevisionEstimate.getFromDate() != null) {
                query.setDate("fromDate", searchRevisionEstimate.getFromDate());
            }
            if (searchRevisionEstimate.getToDate() != null) {
                query.setDate("toDate", searchRevisionEstimate.getToDate());
            }
            if (StringUtils.isNotBlank((CharSequence)searchRevisionEstimate.getLoaNumber())) {
                query.setString("loaNumber", "%" + searchRevisionEstimate.getLoaNumber() + "%");
            }
            if (searchRevisionEstimate.getCreatedBy() != null) {
                query.setLong("createdBy", searchRevisionEstimate.getCreatedBy().longValue());
            }
            if (StringUtils.isNotBlank((CharSequence)searchRevisionEstimate.getRevisionEstimateStatus())) {
                query.setString("restatus", searchRevisionEstimate.getRevisionEstimateStatus());
            }
        }
        return query;
    }

    public String checkIfMBCreatedForRENonTenderedLumpSum(RevisionAbstractEstimate revisionEstimate, WorkOrderEstimate workOrderEstimate) {
        StringBuilder mbRefNumbersForRE = new StringBuilder();
        List<MBHeader> mbHeaders = this.mbHeaderService.getMBHeadersForTenderedLumpSumAcivitiesToCancelRE(revisionEstimate, workOrderEstimate);
        if (!mbHeaders.isEmpty()) {
            for (MBHeader mBHeader : mbHeaders) {
                mbRefNumbersForRE.append(mBHeader.getMbRefNo()).append(",");
            }
        }
        return mbRefNumbersForRE.toString();
    }

    public String checkIfMBCreatedForREChangedQuantity(RevisionAbstractEstimate revisionEstimate, WorkOrderEstimate workOrderEstimate) {
        ArrayList<Long> originalActivtityIdList = new ArrayList<Long>();
        String message = "";
        WorkOrderEstimate revisionWorkOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateByAbstractEstimateId(revisionEstimate.getId());
        List<WorkOrderActivity> reWoaList = this.workOrderActivityService.getChangedQuantityActivities(revisionEstimate, revisionWorkOrderEstimate);
        for (WorkOrderActivity woa : reWoaList) {
            originalActivtityIdList.add(woa.getActivity().getParent().getId());
        }
        List<Object[]> activityIdQuantityList = null;
        if (originalActivtityIdList != null && originalActivtityIdList.size() > 0) {
            activityIdQuantityList = this.mBDetailsService.getMBDetailsByWorkOrderActivity(originalActivtityIdList);
        }
        if (activityIdQuantityList != null && activityIdQuantityList.size() > 0) {
            block1: for (WorkOrderActivity revWoa : reWoaList) {
                for (Object[] activityIdQuantity : activityIdQuantityList) {
                    List values;
                    AppConfigValues value;
                    Double maxPercent;
                    Double maxAllowedQuantity;
                    double revEstQuantity;
                    if (Long.parseLong(activityIdQuantity[0].toString()) != revWoa.getActivity().getParent().getId()) continue;
                    Long activityId = null;
                    activityId = revWoa.getActivity().getParent() == null ? revWoa.getActivity().getId() : revWoa.getActivity().getParent().getId();
                    Double originalQuantity = (Double)this.workOrderActivityService.getQuantityForActivity(activityId);
                    Object revEstQuantityObj = this.workOrderActivityService.getREActivityQuantity(revisionEstimate.getId(), activityId);
                    double d = revEstQuantity = revEstQuantityObj == null ? 0.0 : (Double)revEstQuantityObj;
                    if (originalQuantity + revEstQuantity >= Double.parseDouble(activityIdQuantity[1].toString()) || (maxAllowedQuantity = Double.valueOf((maxPercent = (maxPercent = Double.valueOf((value = (AppConfigValues)(values = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "MB_QUANTITY_TOLERANCE_LEVEL")).get(0)).getValue())) != null ? Double.valueOf(maxPercent + 100.0) : Double.valueOf(100.0)) * (originalQuantity + revEstQuantity) / 100.0)) >= Double.parseDouble(activityIdQuantity[1].toString())) continue;
                    message = this.messageSource.getMessage("error.mbexistsfor.rechangequantity", (Object[])new String[]{revisionEstimate.getEstimateNumber()}, null);
                    continue block1;
                }
            }
        }
        return message;
    }

    @Transactional
    public RevisionAbstractEstimate cancelRevisionEstimate(RevisionAbstractEstimate revisionEstimate) {
        revisionEstimate.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("RevisionAbstractEstimate", AbstractEstimate.EstimateStatus.CANCELLED.toString()));
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateByAbstractEstimateId(revisionEstimate.getId());
        RevisionWorkOrder revisionWorkOrder = this.revisionWorkOrderService.getRevisionWorkOrderById(workOrderEstimate.getWorkOrder().getId());
        if (revisionWorkOrder != null) {
            revisionWorkOrder.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("WorkOrder", "CANCELLED"));
            revisionWorkOrder.getParent().setTotalIncludingRE(revisionWorkOrder.getParent().getTotalIncludingRE() - revisionWorkOrder.getWorkOrderAmount());
            this.revisionWorkOrderService.create(revisionWorkOrder);
        }
        if (!BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue())) {
            String appropriationNumber = this.lineEstimateAppropriationService.generateBudgetAppropriationNumber(revisionEstimate.getParent().getLineEstimateDetails());
            this.lineEstimateService.releaseBudgetOnReject(revisionEstimate.getParent().getLineEstimateDetails(), revisionEstimate.getEstimateValue().doubleValue(), appropriationNumber);
        }
        revisionEstimate.getParent().setTotalIncludingRE(revisionEstimate.getParent().getTotalIncludingRE() - revisionEstimate.getWorkValue());
        return (RevisionAbstractEstimate)((Object)this.revisionEstimateRepository.save((Object)revisionEstimate));
    }

    public String getRevisionEstimatesGreaterThanCurrent(Long parentId, Date createdDate) {
        List<RevisionAbstractEstimate> revisionEstimatesList = this.revisionEstimateRepository.findByParent_idAndCreatedDateAfterAndEgwStatus_codeNotLike(parentId, createdDate, "CANCELLED");
        StringBuilder revisionEstimates = new StringBuilder();
        for (RevisionAbstractEstimate revisionAbstractEstimate : revisionEstimatesList) {
            revisionEstimates.append(revisionAbstractEstimate.getEstimateNumber()).append(",");
        }
        return revisionEstimates.toString();
    }

    public void validateREInDrafts(Long estimateId, JsonObject jsonObject, BindingResult errors) {
        RevisionAbstractEstimate revisionEstimate = this.revisionEstimateRepository.findByParent_IdAndEgwStatus_codeEquals(estimateId, "NEW");
        String userName = "";
        if (revisionEstimate != null) {
            String message = this.messageSource.getMessage("error.re.newstatus", (Object[])new String[]{revisionEstimate.getEstimateNumber(), revisionEstimate.getEgwStatus().getDescription(), userName}, null);
            userName = this.worksUtils.getApproverName(revisionEstimate.getState().getOwnerPosition().getId());
            jsonObject.addProperty("draftsError", message);
            if (errors != null) {
                errors.reject("draftsError", message);
            }
        }
    }

    public void validateREInWorkFlow(Long estimateId, JsonObject jsonObject, BindingResult errors) {
        RevisionAbstractEstimate revisionEstimate = this.revisionEstimateRepository.findByParentAndStatus(estimateId, RevisionAbstractEstimate.RevisionEstimateStatus.CANCELLED.toString(), RevisionAbstractEstimate.RevisionEstimateStatus.APPROVED.toString(), RevisionAbstractEstimate.RevisionEstimateStatus.NEW.toString());
        String userName = "";
        if (revisionEstimate != null) {
            String message = this.messageSource.getMessage("error.re.workflow", (Object[])new String[]{revisionEstimate.getEstimateNumber(), revisionEstimate.getEgwStatus().getDescription(), userName}, null);
            userName = this.worksUtils.getApproverName(revisionEstimate.getState().getOwnerPosition().getId());
            jsonObject.addProperty("workFlowError", message);
            if (errors != null) {
                errors.reject("workFlowError", message);
            }
        }
    }

    public void deriveWorkOrderActivityQuantity(WorkOrderActivity workOrderActivity, Long reId) {
        if (!workOrderActivity.getWorkOrderMeasurementSheets().isEmpty()) {
            for (WorkOrderMeasurementSheet woms : workOrderActivity.getWorkOrderMeasurementSheets()) {
                List<WorkOrderMeasurementSheet> rewomsList = this.workOrderMeasurementSheetService.findByMeasurementSheetParentId_ForView(woms.getMeasurementSheet().getId(), reId);
                Double no = woms.getNo() == null ? 0.0 : woms.getNo().doubleValue();
                Double length = woms.getLength() == null ? 0.0 : woms.getLength().doubleValue();
                Double width = woms.getWidth() == null ? 0.0 : woms.getWidth().doubleValue();
                Double depthOrHeight = woms.getDepthOrHeight() == null ? 0.0 : woms.getDepthOrHeight().doubleValue();
                for (WorkOrderMeasurementSheet rems : rewomsList) {
                    if (rems.getNo() != null) {
                        no = no + rems.getNo().doubleValue();
                    }
                    if (rems.getLength() != null) {
                        length = length + rems.getLength().doubleValue();
                    }
                    if (rems.getWidth() != null) {
                        width = width + rems.getWidth().doubleValue();
                    }
                    if (rems.getDepthOrHeight() == null) continue;
                    depthOrHeight = depthOrHeight + rems.getDepthOrHeight().doubleValue();
                }
                if (no != null && no != 0.0) {
                    woms.setNo(new BigDecimal(no));
                }
                if (length != null && length != 0.0) {
                    woms.setLength(new BigDecimal(length));
                }
                if (width != null && width != 0.0) {
                    woms.setWidth(new BigDecimal(width));
                }
                if (depthOrHeight != null && depthOrHeight != 0.0) {
                    woms.setDepthOrHeight(new BigDecimal(depthOrHeight));
                }
                woms.setQuantity(new BigDecimal((no == null || no == 0.0 ? 1.0 : no) * (length == null || length == 0.0 ? 1.0 : length) * (width == null || width == 0.0 ? 1.0 : width) * (depthOrHeight == null || depthOrHeight == 0.0 ? 1.0 : depthOrHeight)));
            }
        }
        Double qty = 0.0;
        for (WorkOrderMeasurementSheet woms : workOrderActivity.getWorkOrderMeasurementSheets()) {
            if (woms.getMeasurementSheet().getIdentifier() == 'A') {
                qty = qty + woms.getQuantity().doubleValue();
                continue;
            }
            qty = qty - woms.getQuantity().doubleValue();
        }
        if (!workOrderActivity.getWorkOrderMeasurementSheets().isEmpty()) {
            workOrderActivity.setApprovedQuantity(qty);
        }
    }

    public void deriveMeasurementSheetQuantity(MeasurementSheet measurementSheet, Long reId) {
        List<Object> remsList = new ArrayList();
        remsList = reId != null ? this.measurementSheetService.findByParentIdForView(measurementSheet.getId(), reId) : this.measurementSheetService.findByParentId(measurementSheet.getId());
        Double no = measurementSheet.getNo() == null ? 0.0 : measurementSheet.getNo().doubleValue();
        Double length = measurementSheet.getLength() == null ? 0.0 : measurementSheet.getLength().doubleValue();
        Double width = measurementSheet.getWidth() == null ? 0.0 : measurementSheet.getWidth().doubleValue();
        Double depthOrHeight = measurementSheet.getDepthOrHeight() == null ? 0.0 : measurementSheet.getDepthOrHeight().doubleValue();
        Double quantity = measurementSheet.getQuantity() == null ? 0.0 : measurementSheet.getQuantity().doubleValue();
        for (MeasurementSheet rems : remsList) {
            if (rems.getId() == measurementSheet.getId()) continue;
            if (rems.getNo() != null) {
                no = no + rems.getNo().doubleValue();
            }
            if (rems.getLength() != null) {
                length = length + rems.getLength().doubleValue();
            }
            if (rems.getWidth() != null) {
                width = width + rems.getWidth().doubleValue();
            }
            if (rems.getDepthOrHeight() != null) {
                depthOrHeight = depthOrHeight + rems.getDepthOrHeight().doubleValue();
            }
            quantity = quantity + rems.getQuantity().doubleValue();
        }
        if (no != null && no != 0.0) {
            measurementSheet.setNo(new BigDecimal(no));
        }
        if (length != null && length != 0.0) {
            measurementSheet.setLength(new BigDecimal(length));
        }
        if (width != null && width != 0.0) {
            measurementSheet.setWidth(new BigDecimal(width));
        }
        if (depthOrHeight != null && depthOrHeight != 0.0) {
            measurementSheet.setDepthOrHeight(new BigDecimal(depthOrHeight));
        }
        measurementSheet.setQuantity(new BigDecimal(quantity.toString()));
    }

    public List<RevisionAbstractEstimate> findRevisionEstimatesByParentAndStatus(Long parentId) {
        return this.revisionEstimateRepository.findByParent_IdAndEgwStatus_codeNotLike(parentId, "%CANCELLED%");
    }

    public void prepareNonTenderedAndLumpSumActivities(RevisionAbstractEstimate revisionEstimate) {
        for (Activity activity : revisionEstimate.getActivities()) {
            if (activity.getSchedule() != null && activity.getParent() == null) {
                revisionEstimate.getNonTenderedActivities().add(activity);
                continue;
            }
            if (activity.getNonSor() == null || activity.getParent() != null) continue;
            revisionEstimate.getLumpSumActivities().add(activity);
        }
    }

    public void prepareChangeQuantityActivities(RevisionAbstractEstimate revisionEstimate) {
        for (Activity activity : revisionEstimate.getActivities()) {
            if (activity.getParent() == null) continue;
            WorkOrderActivity workOrderActivity = this.workOrderActivityService.getWorkOrderActivityByActivity(activity.getParent().getId());
            if (workOrderActivity != null) {
                this.deriveWorkOrderActivityQuantity(workOrderActivity, revisionEstimate.getId());
                Double consumedQuantity = this.mbHeaderService.getPreviousCumulativeQuantity(-1L, workOrderActivity.getId());
                activity.setConsumedQuantity(consumedQuantity == null ? 0.0 : consumedQuantity);
                activity.setEstimateQuantity(workOrderActivity.getApprovedQuantity());
            }
            revisionEstimate.getChangeQuantityActivities().add(activity);
        }
    }
}

