/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.revisionestimate.repository;

import java.util.Date;
import java.util.List;
import org.egov.infra.admin.master.entity.User;
import org.egov.works.revisionestimate.entity.RevisionAbstractEstimate;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface RevisionEstimateRepository
extends JpaRepository<RevisionAbstractEstimate, Long> {
    @Query(value="from RevisionAbstractEstimate re where re.parent.id=:id and re.egwStatus.code=:status order by re.id")
    public List<RevisionAbstractEstimate> findByParent_IdAndStatus(@Param(value="id") Long var1, @Param(value="status") String var2);

    @Query(value="from RevisionAbstractEstimate re where re.parent.id=:id and re.egwStatus.code=:status and re.id<:reId order by re.id")
    public List<RevisionAbstractEstimate> findByParent_IdAndStatusForView(@Param(value="id") Long var1, @Param(value="reId") Long var2, @Param(value="status") String var3);

    public List<RevisionAbstractEstimate> findByParent_Id(Long var1);

    @Query(value="select distinct(re.createdBy) from RevisionAbstractEstimate as re")
    public List<User> findRevisionEstimateCreatedByUsers();

    public List<RevisionAbstractEstimate> findByParent_idAndCreatedDateAfterAndEgwStatus_codeNotLike(@Param(value="parentId") Long var1, @Param(value="createdDate") Date var2, @Param(value="status") String var3);

    @Query(value="select distinct(re.estimateNumber) from RevisionAbstractEstimate as re where upper(re.estimateNumber) like upper(:estimateNumber)")
    public List<String> findDistinctEstimateNumberContainingIgnoreCase(@Param(value="estimateNumber") String var1);

    @Query(value="select distinct(re.estimateNumber) from RevisionAbstractEstimate re where re.parent is not null and re.egwStatus.code =:statusApproved and upper(re.estimateNumber) like upper(:code) and exists (select estimate from WorkOrderEstimate woe where woe.estimate.id = re.id OR exists(select mbh.workOrderEstimate from MBHeader mbh where egwStatus.code =:statusCancelled))")
    public List<String> getRENumbersToCancel(@Param(value="code") String var1, @Param(value="statusApproved") String var2, @Param(value="statusCancelled") String var3);

    public RevisionAbstractEstimate findByParent_IdAndEgwStatus_codeEquals(Long var1, String var2);

    @Query(value="select re from RevisionAbstractEstimate as re where re.parent.id =:estimateId and egwStatus.code not in (:cancelledStatus, :approvedStatus, :newStatus)")
    public RevisionAbstractEstimate findByParentAndStatus(@Param(value="estimateId") Long var1, @Param(value="cancelledStatus") String var2, @Param(value="approvedStatus") String var3, @Param(value="newStatus") String var4);

    public List<RevisionAbstractEstimate> findByParent_IdAndEgwStatus_codeNotLike(@Param(value="id") Long var1, @Param(value="status") String var2);
}

