/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.revisionestimate.entity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.Activity;

@Entity
@Table(name="EGW_REVISION_ESTIMATE")
public class RevisionAbstractEstimate
extends AbstractEstimate {
    private static final long serialVersionUID = 4389815027807161766L;
    @Transient
    private List<String> revisionEstActions = new ArrayList<String>();
    @Transient
    private String additionalRule;
    @Transient
    private BigDecimal amountRule;
    private transient List<Activity> nonTenderedActivities = new ArrayList<Activity>(0);
    private transient List<Activity> lumpSumActivities = new ArrayList<Activity>(0);
    private transient List<Activity> changeQuantityNTActivities = new ArrayList<Activity>(0);
    private transient List<Activity> changeQuantityLSActivities = new ArrayList<Activity>(0);
    private transient List<Activity> changeQuantityActivities = new ArrayList<Activity>(0);

    @Override
    public String getStateDetails() {
        return "Revision Estimate : " + this.getEstimateNumber();
    }

    public List<String> getRevisionEstActions() {
        return this.revisionEstActions;
    }

    public void setRevisionEstActions(List<String> revisionEstActions) {
        this.revisionEstActions = revisionEstActions;
    }

    public void deleteNonSORActivities() {
        if (this.getActivities() != null && this.getActivities().size() > 0) {
            for (Activity estActivity : this.getActivities()) {
                if (estActivity.getNonSor() == null) continue;
                estActivity.setNonSor(null);
            }
        }
    }

    public String getAdditionalRule() {
        return this.additionalRule;
    }

    public BigDecimal getAmountRule() {
        return this.amountRule;
    }

    public void setAdditionalRule(String additionalRule) {
        this.additionalRule = additionalRule;
    }

    public void setAmountRule(BigDecimal amountRule) {
        this.amountRule = amountRule;
    }

    public List<Activity> getNonTenderedActivities() {
        return this.nonTenderedActivities;
    }

    public void setNonTenderedActivities(List<Activity> nonTenderedActivities) {
        this.nonTenderedActivities = nonTenderedActivities;
    }

    public List<Activity> getLumpSumActivities() {
        return this.lumpSumActivities;
    }

    public void setLumpSumActivities(List<Activity> lumpSumActivities) {
        this.lumpSumActivities = lumpSumActivities;
    }

    public List<Activity> getChangeQuantityNTActivities() {
        return this.changeQuantityNTActivities;
    }

    public void setChangeQuantityNTActivities(List<Activity> changeQuantityNTActivities) {
        this.changeQuantityNTActivities = changeQuantityNTActivities;
    }

    public List<Activity> getChangeQuantityLSActivities() {
        return this.changeQuantityLSActivities;
    }

    public void setChangeQuantityLSActivities(List<Activity> changeQuantityLSActivities) {
        this.changeQuantityLSActivities = changeQuantityLSActivities;
    }

    public List<Activity> getChangeQuantityActivities() {
        return this.changeQuantityActivities;
    }

    public void setChangeQuantityActivities(List<Activity> changeQuantityActivities) {
        this.changeQuantityActivities = changeQuantityActivities;
    }

    public static enum RevisionEstimateStatus {
        NEW,
        CREATED,
        CHECKED,
        REJECTED,
        RESUBMITTED,
        CANCELLED,
        APPROVED,
        BUDGET_SANCTIONED,
        TECH_SANCTIONED;

    }
}

