/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.models.masters;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Transient;
import javax.validation.Valid;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.egov.common.entity.UOM;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.component.Period;
import org.egov.infra.persistence.validator.annotation.OptionalPattern;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.infra.utils.StringUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infstr.models.BaseModel;
import org.egov.works.models.masters.MarketRate;
import org.egov.works.models.masters.SORRate;
import org.egov.works.models.masters.ScheduleCategory;
import org.hibernate.validator.constraints.NotEmpty;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

@Unique(fields={"code"}, id="id", tableName="EGW_SCHEDULEOFRATE", columnName={"CODE"}, message="sor.code.isunique")
public class ScheduleOfRate
extends BaseModel {
    private static final long serialVersionUID = -7797787370112941401L;
    private static final Logger logger = Logger.getLogger(ScheduleOfRate.class);
    static Integer MAX_DESCRIPTION_LENGTH = 100;
    @OptionalPattern(regex="[0-9a-zA-Z_@./#&+/-/!(){}\",^$%*|=;:<>?`~]+", message="sor.code.alphaNumeric")
    @NotEmpty(message="sor.code.not.empty")
    private String code;
    @Required(message="sor.category.not.null")
    private ScheduleCategory scheduleCategory;
    @OptionalPattern(regex="[0-9a-zA-Z_@./#&+/-/!(){}\",^$%*|=;:<>?`~ ]+", message="sor.description.alphaNumeric")
    @NotEmpty(message="sor.description.not.empty")
    private String description;
    @Required(message="sor.uom.not.null")
    private UOM uom;
    private List<SORRate> sorRates = new LinkedList<SORRate>();
    private List<MarketRate> marketRates = new LinkedList<MarketRate>();
    @Transient
    private Double sorRateValue;

    public ScheduleOfRate() {
    }

    public ScheduleOfRate(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Valid
    public ScheduleCategory getScheduleCategory() {
        return this.scheduleCategory;
    }

    public void setScheduleCategory(ScheduleCategory scheduleCategory) {
        this.scheduleCategory = scheduleCategory;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptionJS() {
        return StringUtils.escapeJavaScript((String)this.description);
    }

    public void setDescription(String description) {
        this.description = StringEscapeUtils.unescapeHtml((String)description);
    }

    public UOM getUom() {
        return this.uom;
    }

    public void setUom(UOM uomid) {
        this.uom = uomid;
    }

    public List<SORRate> getSorRates() {
        return this.sorRates;
    }

    @JsonIgnore
    public List<SORRate> getSorRatesOrderById() {
        Collections.sort(this.sorRates, (c1, c2) -> c1.getId().compareTo(c2.getId()));
        Collections.reverse(this.sorRates);
        return this.sorRates;
    }

    public void setSorRates(List<SORRate> sorRates) {
        this.sorRates = sorRates;
    }

    public String getSummary() {
        if (this.description.length() <= MAX_DESCRIPTION_LENGTH) {
            return this.description;
        }
        return this.first(MAX_DESCRIPTION_LENGTH / 2, this.description) + "..." + this.last(MAX_DESCRIPTION_LENGTH / 2, this.description);
    }

    public String getSummaryJS() {
        return StringUtils.escapeJavaScript((String)this.getSummary());
    }

    public String getSorRate() {
        return this.sorRateValue != null ? this.sorRateValue.toString() : "";
    }

    public String getScheduleCategorId() {
        return String.valueOf(this.scheduleCategory.getId());
    }

    protected String first(int number, String description) {
        return description.substring(0, number >= description.length() ? description.length() : number);
    }

    protected String last(int number, String description) {
        int begin = description.length() - number;
        return description.substring(begin < 0 ? description.length() : begin, description.length());
    }

    public String getSearchableData() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getCode()).append(" ").append(this.getDescription());
        return builder.toString();
    }

    public SORRate getRateOn(Date estimateDate) {
        if (estimateDate == null) {
            throw new ApplicationRuntimeException("no.rate.for.date");
        }
        for (SORRate rate : this.sorRates) {
            if (rate == null || !this.isWithin(rate.getValidity(), estimateDate)) continue;
            return rate;
        }
        throw new ApplicationRuntimeException("no.rate.for.date");
    }

    public boolean isWithin(Period period, Date dateTime) {
        LocalDate start = new LocalDate((Object)period.getStartDate());
        LocalDate end = null;
        if (period.getEndDate() != null) {
            end = new LocalDate((Object)period.getEndDate());
        }
        LocalDate date = new LocalDate((Object)dateTime);
        if (end == null) {
            return start.compareTo((ReadablePartial)date) <= 0;
        }
        return start.compareTo((ReadablePartial)date) <= 0 && end.compareTo((ReadablePartial)date) >= 0;
    }

    public boolean hasValidRateFor(Date estimateDate) {
        try {
            SORRate rate = this.getRateOn(estimateDate);
            return rate != null;
        }
        catch (ApplicationRuntimeException e) {
            logger.error((Object)("Rate :" + e.getMessage()));
            return false;
        }
    }

    private List<ValidationError> checkForNoRatePresent() {
        if (this.sorRates != null && this.sorRates.isEmpty()) {
            return Arrays.asList(new ValidationError("sorRate", "sor.rate.altleastone_sorRate_needed"));
        }
        return null;
    }

    private void removeEmptyRates() {
        LinkedList<SORRate> emptyRateObjs = new LinkedList<SORRate>();
        for (SORRate rat : this.sorRates) {
            if (rat.getRate() != null && rat.getRate().getValue() != 0.0 || rat.getValidity() != null && (rat.getValidity().getStartDate() != null || rat.getValidity().getEndDate() != null)) continue;
            emptyRateObjs.add(rat);
        }
        this.sorRates.removeAll(emptyRateObjs);
    }

    protected List<ValidationError> validateRates() {
        List<ValidationError> errorList = null;
        boolean openEndedRangeFlag = false;
        for (SORRate rate : this.sorRates) {
            if (rate.getValidity().getEndDate() == null && openEndedRangeFlag) {
                return Arrays.asList(new ValidationError("openendedrange", "sor.rate.multiple.openendedrange"));
            }
            if (rate.getValidity().getEndDate() == null) {
                openEndedRangeFlag = true;
            }
            if ((errorList = rate.validate()) == null) continue;
            return errorList;
        }
        return errorList;
    }

    public void setSorRate(List<SORRate> sorRates) {
        this.sorRates = sorRates;
    }

    public void addSorRate(SORRate sorRate) {
        this.sorRates.add(sorRate);
    }

    private List<ValidationError> validateDateRanges() {
        ArrayList<Period> validDates = new ArrayList<Period>();
        validDates.add(0, this.sorRates.get(0).getValidity());
        Date existingStartDate = null;
        Date existingEndDate = null;
        Date checkStartDate = null;
        Date checkEndDate = null;
        Period existingPeriod = null;
        Period checkPeriod1 = null;
        boolean flag1 = true;
        int k = 1;
        for (int i = 1; i < this.sorRates.size(); ++i) {
            checkStartDate = this.sorRates.get(i).getValidity().getStartDate();
            checkEndDate = this.sorRates.get(i).getValidity().getEndDate();
            checkPeriod1 = new Period(checkStartDate, checkEndDate);
            for (int j = 0; j < validDates.size(); ++j) {
                existingStartDate = ((Period)validDates.get(j)).getStartDate();
                existingPeriod = (Period)validDates.get(j);
                existingEndDate = ((Period)validDates.get(j)).getEndDate() == null ? null : ((Period)validDates.get(j)).getEndDate();
                if (this.isWithin(existingPeriod, checkStartDate) || this.isWithin(checkPeriod1, existingStartDate) || checkEndDate != null && this.isWithin(existingPeriod, checkEndDate) || existingEndDate != null && this.isWithin(checkPeriod1, existingEndDate)) {
                    flag1 = false;
                    break;
                }
                if (checkEndDate == null || existingEndDate == null || !this.isWithin(existingPeriod, checkEndDate) && !this.isWithin(checkPeriod1, existingEndDate)) continue;
                flag1 = false;
                break;
            }
            if (!flag1) {
                return Arrays.asList(new ValidationError("dateoverlap", "sor.rate.dates.overlap"));
            }
            validDates.add(k++, checkPeriod1);
        }
        return null;
    }

    public List<MarketRate> getMarketRates() {
        return this.marketRates;
    }

    public void setMarketRates(List<MarketRate> marketRates) {
        this.marketRates = marketRates;
    }

    public MarketRate getMarketRateOn(Date estimateDate) {
        if (estimateDate == null) {
            return null;
        }
        for (MarketRate marketRate : this.marketRates) {
            if (!this.isWithin(marketRate.getValidity(), estimateDate)) continue;
            return marketRate;
        }
        return null;
    }

    public boolean hasValidMarketRateFor(Date estimateDate) {
        MarketRate marketRate = this.getMarketRateOn(estimateDate);
        return marketRate != null;
    }

    private void removeEmptyMarketRates() {
        LinkedList<MarketRate> emptyMarketRateObjs = new LinkedList<MarketRate>();
        for (MarketRate marketRate : this.marketRates) {
            if (marketRate.getMarketRate() != null && marketRate.getMarketRate().getValue() != 0.0 || marketRate.getValidity() != null && (marketRate.getValidity().getStartDate() != null || marketRate.getValidity().getEndDate() != null)) continue;
            emptyMarketRateObjs.add(marketRate);
        }
        this.marketRates.removeAll(emptyMarketRateObjs);
    }

    protected List<ValidationError> validateMarketRates() {
        List<ValidationError> errorList = null;
        boolean openEndedRangeFlag = false;
        for (MarketRate marketRate : this.marketRates) {
            if (marketRate == null) continue;
            if (marketRate.getValidity().getEndDate() == null && openEndedRangeFlag) {
                return Arrays.asList(new ValidationError("openendedrange", "sor.marketrate.multiple.openendedrange"));
            }
            if (marketRate.getValidity().getEndDate() == null) {
                openEndedRangeFlag = true;
            }
            if ((errorList = marketRate.validate()) == null) continue;
            return errorList;
        }
        return errorList;
    }

    public void setMarketRate(List<MarketRate> marketRates) {
        this.marketRates = marketRates;
    }

    public void addMarketRate(MarketRate marketRate) {
        this.marketRates.add(marketRate);
    }

    private List<ValidationError> validateDateRangesForMarketRate() {
        ArrayList<Period> validDates = new ArrayList<Period>();
        validDates.add(0, this.marketRates.get(0).getValidity());
        Date existingStartDate = null;
        Date existingEndDate = null;
        Date checkStartDate = null;
        Date checkEndDate = null;
        Period existingPeriod = null;
        Period checkPeriod1 = null;
        boolean flag1 = true;
        int k = 1;
        for (int i = 1; i < this.marketRates.size(); ++i) {
            checkStartDate = this.marketRates.get(i).getValidity().getStartDate();
            checkEndDate = this.marketRates.get(i).getValidity().getEndDate();
            checkPeriod1 = new Period(checkStartDate, checkEndDate);
            for (int j = 0; j < validDates.size(); ++j) {
                existingStartDate = ((Period)validDates.get(j)).getStartDate();
                existingPeriod = (Period)validDates.get(j);
                existingEndDate = ((Period)validDates.get(j)).getEndDate() == null ? null : ((Period)validDates.get(j)).getEndDate();
                if (this.isWithin(existingPeriod, checkStartDate) || this.isWithin(checkPeriod1, existingStartDate) || checkEndDate != null && this.isWithin(existingPeriod, checkEndDate) || existingEndDate != null && this.isWithin(checkPeriod1, existingEndDate)) {
                    flag1 = false;
                    break;
                }
                if (checkEndDate == null || existingEndDate == null || !this.isWithin(existingPeriod, checkEndDate) && !this.isWithin(checkPeriod1, existingEndDate)) continue;
                flag1 = false;
                break;
            }
            if (!flag1) {
                return Arrays.asList(new ValidationError("dateoverlap", "sor.marketrate.dates.overlap"));
            }
            validDates.add(k++, checkPeriod1);
        }
        return null;
    }

    public List<ValidationError> validate() {
        List<ValidationError> errorList = null;
        this.removeEmptyRates();
        if (this.marketRates != null && !this.marketRates.isEmpty()) {
            this.removeEmptyMarketRates();
        }
        if ((errorList = this.checkForNoRatePresent()) != null) {
            return errorList;
        }
        errorList = this.validateDateRanges();
        if (errorList != null) {
            return errorList;
        }
        errorList = this.validateRates();
        if (errorList != null) {
            return errorList;
        }
        if (this.marketRates != null && !this.marketRates.isEmpty()) {
            errorList = this.validateDateRangesForMarketRate();
            if (errorList != null) {
                return errorList;
            }
            errorList = this.validateMarketRates();
            if (errorList != null) {
                return errorList;
            }
        }
        return errorList;
    }

    public Double getSorRateValue() {
        return this.sorRateValue;
    }

    public void setSorRateValue(Double sorRateValue) {
        this.sorRateValue = sorRateValue;
    }
}

