/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.master.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.works.uploadsor.UploadSOR;
import org.egov.works.uploadsor.UploadScheduleOfRate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;

@Service
@Transactional(readOnly=true)
public class UploadSORService {
    @PersistenceContext
    private EntityManager entityManager;
    private static final int DATA_STARTING_ROW_INDEX = 1;
    private static final int SORCODE_CELL_INDEX = 0;
    private static final int SORCATEGORY_CELL_INDEX = 1;
    private static final int SOR_DESCRIPTION_CELL_INDEX = 2;
    private static final int UOM_CELL_INDEX = 3;
    private static final int RATE_CELL_INDEX = 4;
    private static final int FROMDATE_CELL_INDEX = 5;
    private static final int TODATE_CELL_INDEX = 6;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource messageSource;
    @Autowired
    protected FileStoreService fileStoreService;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;

    public List<UploadScheduleOfRate> loadToList(HSSFSheet sheet) {
        ArrayList<UploadScheduleOfRate> uploadSORRatesList = new ArrayList<UploadScheduleOfRate>();
        try {
            for (int i = 1; i <= sheet.getLastRowNum(); ++i) {
                uploadSORRatesList.add(this.getRowData(sheet.getRow(i)));
            }
        }
        catch (ValidationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        return uploadSORRatesList;
    }

    public UploadScheduleOfRate getRowData(HSSFRow row) {
        UploadScheduleOfRate sorRate;
        block10: {
            sorRate = new UploadScheduleOfRate();
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
            try {
                if (row == null) break block10;
                sorRate.setSorCode(this.getStrValue(row.getCell(0)) == null ? null : this.getStrValue(row.getCell(0)));
                sorRate.setSorCategoryCode(this.getStrValue(row.getCell(1)) == null ? null : this.getStrValue(row.getCell(1)));
                sorRate.setSorDescription(this.getStrValue(row.getCell(2)) == null ? null : this.getStrValue(row.getCell(2)));
                sorRate.setUomCode(this.getStrValue(row.getCell(3)) == null ? null : this.getStrValue(row.getCell(3)));
                sorRate.setRate(this.getNumericValue(row.getCell(4)).compareTo(BigDecimal.ZERO) == 0 ? null : this.getNumericValue(row.getCell(4)));
                try {
                    sorRate.setTempFromDate(row.getCell(5) == null ? null : row.getCell(5).getStringCellValue());
                    if (sorRate.getTempFromDate() != null && !sorRate.getTempFromDate().equalsIgnoreCase("")) {
                        sorRate.setFromDate(df.parse(sorRate.getTempFromDate()));
                    } else {
                        sorRate.setErrorReason(sorRate.getErrorReason() != null ? sorRate.getErrorReason() + "," : "" + this.messageSource.getMessage("error.fromdate.invalid", null, null));
                    }
                }
                catch (Exception e) {
                    sorRate.setErrorReason(sorRate.getErrorReason() != null ? sorRate.getErrorReason() + "," : "" + this.messageSource.getMessage("error.fromdate.invalid", null, null));
                }
                try {
                    sorRate.setTempToDate(row.getCell(6) == null ? null : this.getStrValue(row.getCell(6)));
                    if (sorRate.getTempToDate() != null && !sorRate.getTempToDate().equalsIgnoreCase("")) {
                        sorRate.setToDate(df.parse(sorRate.getTempToDate()));
                    }
                }
                catch (Exception e) {
                    sorRate.setErrorReason(sorRate.getErrorReason() != null ? sorRate.getErrorReason() + "," : "" + this.messageSource.getMessage("error.todate.invalid", null, null));
                }
            }
            catch (ValidationException e) {
                throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
            }
            catch (Exception e) {
                throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
            }
        }
        return sorRate;
    }

    public String getStrValue(HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        double numericCellValue = 0.0;
        String strValue = "";
        switch (cell.getCellType()) {
            case 0: {
                numericCellValue = cell.getNumericCellValue();
                DecimalFormat decimalFormat = new DecimalFormat("#");
                strValue = decimalFormat.format(numericCellValue);
                break;
            }
            case 1: {
                strValue = cell.getStringCellValue();
            }
        }
        return strValue;
    }

    public BigDecimal getNumericValue(HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        double numericCellValue = 0.0;
        BigDecimal bigDecimalValue = BigDecimal.ZERO;
        String strValue = "";
        switch (cell.getCellType()) {
            case 0: {
                numericCellValue = cell.getNumericCellValue();
                bigDecimalValue = BigDecimal.valueOf(numericCellValue);
                break;
            }
            case 1: {
                strValue = cell.getStringCellValue();
                if (strValue != null && strValue.contains("E+")) {
                    String[] split = strValue.split("E+");
                    String mantissa = split[0].replaceAll(".", "");
                    int exp = Integer.parseInt(split[1]);
                    while (mantissa.length() <= exp + 1) {
                        mantissa = mantissa + "0";
                    }
                    numericCellValue = Double.parseDouble(mantissa);
                    bigDecimalValue = BigDecimal.valueOf(numericCellValue);
                } else if (strValue != null && strValue.contains(",")) {
                    strValue = strValue.replaceAll(",", "");
                }
                try {
                    numericCellValue = Double.parseDouble(strValue);
                    bigDecimalValue = BigDecimal.valueOf(numericCellValue);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return bigDecimalValue;
    }

    @Transactional
    public String prepareOutPutFileWithErrors(String originalNameKey, String outputNameKey, File inputFile, List<UploadScheduleOfRate> uploadSORRatesList, UploadSOR uploadSOR, BindingResult errors) {
        String outPutFileStoreId;
        try {
            FileInputStream fIS = new FileInputStream(inputFile);
            String timeStamp = new Timestamp(new Date().getTime()).toString().replace(".", "_");
            HashMap<String, String> errorsMap = new HashMap<String, String>();
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)fIS);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            wb.getNumberOfSheets();
            HSSFSheet sheet = wb.getSheetAt(0);
            HSSFRow row = sheet.getRow(0);
            HSSFCell cell = row.createCell(7);
            cell.setCellValue("Error Reason");
            for (UploadScheduleOfRate obj : uploadSORRatesList) {
                errorsMap.put(obj.getSorCode() + "-" + obj.getSorCategoryCode() + "-" + obj.getSorDescription() + "-" + obj.getUomCode() + "-" + obj.getRate(), obj.getErrorReason());
            }
            for (int i = 1; i <= uploadSORRatesList.size(); ++i) {
                HSSFRow errorRow = sheet.getRow(i);
                HSSFCell errorCell = errorRow.createCell(7);
                errorCell.setCellValue((String)errorsMap.get(this.getStrValue(sheet.getRow(i).getCell(0)) + "-" + this.getStrValue(sheet.getRow(i).getCell(1)) + "-" + this.getStrValue(sheet.getRow(i).getCell(2)) + "-" + this.getStrValue(sheet.getRow(i).getCell(3)) + "-" + (this.getNumericValue(sheet.getRow(i).getCell(4)).compareTo(BigDecimal.ZERO) == 0 ? null : this.getNumericValue(sheet.getRow(i).getCell(4)))));
            }
            FileOutputStream output_file = new FileOutputStream(inputFile);
            wb.write((OutputStream)output_file);
            output_file.close();
            String loadSorRateOutPutFileName = this.prepareOutPutFileName(originalNameKey, outputNameKey, timeStamp, uploadSOR.getFile().getOriginalFilename(), errors);
            FileStoreMapper outPutFileStore = this.fileStoreService.store(inputFile, loadSorRateOutPutFileName, uploadSOR.getFile().getContentType(), "WMS");
            this.persistenceService.persist((Object)outPutFileStore);
            outPutFileStoreId = outPutFileStore.getFileStoreId();
        }
        catch (FileNotFoundException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        catch (IOException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        return outPutFileStoreId;
    }

    @Transactional
    public String prepareOutPutFileWithFinalStatus(String originalNameKey, String outputNameKey, File inputFile, List<UploadScheduleOfRate> uploadSORRatesList, UploadSOR uploadSOR, BindingResult errors) {
        String outPutFileStoreId;
        String timeStamp = new Timestamp(new Date().getTime()).toString().replace(".", "_");
        try {
            FileInputStream fIS = new FileInputStream(inputFile);
            HashMap<String, String> finalStatusMap = new HashMap<String, String>();
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)fIS);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            wb.getNumberOfSheets();
            HSSFSheet sheet = wb.getSheetAt(0);
            HSSFRow row = sheet.getRow(0);
            HSSFCell cell = row.createCell(7);
            cell.setCellValue("Status");
            for (UploadScheduleOfRate obj : uploadSORRatesList) {
                finalStatusMap.put(obj.getSorCode() + "-" + obj.getSorCategoryCode() + "-" + obj.getSorDescription() + "-" + obj.getUomCode() + "-" + obj.getRate(), obj.getFinalStatus());
            }
            for (int i = 1; i <= uploadSORRatesList.size(); ++i) {
                HSSFRow errorRow = sheet.getRow(i);
                HSSFCell errorCell = errorRow.createCell(7);
                errorCell.setCellValue((String)finalStatusMap.get(this.getStrValue(sheet.getRow(i).getCell(0)) + "-" + this.getStrValue(sheet.getRow(i).getCell(1)) + "-" + this.getStrValue(sheet.getRow(i).getCell(2)) + "-" + this.getStrValue(sheet.getRow(i).getCell(3)) + "-" + this.getNumericValue(sheet.getRow(i).getCell(4))));
            }
            FileOutputStream output_file = new FileOutputStream(inputFile);
            wb.write((OutputStream)output_file);
            output_file.close();
            String loadSorRateOutPutFileName = this.prepareOutPutFileName(originalNameKey, outputNameKey, timeStamp, uploadSOR.getFile().getOriginalFilename(), errors);
            FileStoreMapper outPutFileStore = this.fileStoreService.store(inputFile, loadSorRateOutPutFileName, uploadSOR.getFile().getContentType(), "WMS");
            this.persistenceService.persist((Object)outPutFileStore);
            outPutFileStoreId = outPutFileStore.getFileStoreId();
        }
        catch (FileNotFoundException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        catch (IOException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        return outPutFileStoreId;
    }

    public List<UploadScheduleOfRate> removeEmptyRows(List<UploadScheduleOfRate> uploadSORRatesList) {
        ArrayList<UploadScheduleOfRate> tempList = new ArrayList<UploadScheduleOfRate>();
        for (UploadScheduleOfRate obj : uploadSORRatesList) {
            if (obj.getErrorReason() != null && obj.getErrorReason().equalsIgnoreCase("Empty Record")) continue;
            tempList.add(obj);
        }
        return tempList;
    }

    public String prepareOriginalFileName(String originalNameKey, String outputNameKey, String timeStamp, String originalFilename, BindingResult errors) {
        String loadSorRateOriginalFileName = "";
        if (originalFilename.contains(originalNameKey)) {
            loadSorRateOriginalFileName = originalFilename.split("_" + originalNameKey + "_")[0] + "_" + originalNameKey + "_" + timeStamp + "." + originalFilename.split("\\.")[1];
        } else if (originalFilename.contains("_" + outputNameKey + "_")) {
            loadSorRateOriginalFileName = originalFilename.split("_" + outputNameKey + "_")[0] + "_" + originalNameKey + "_" + timeStamp + "." + originalFilename.split("\\.")[1];
        } else if (originalFilename.length() > 60) {
            errors.reject("error.file.name.should.be.less.then.60.characters", "error.file.name.should.be.less.then.60.characters");
        } else {
            loadSorRateOriginalFileName = originalFilename.split("\\.")[0] + "_" + originalNameKey + "_" + timeStamp + "." + originalFilename.split("\\.")[1];
        }
        return loadSorRateOriginalFileName;
    }

    public String prepareOutPutFileName(String originalNameKey, String outputNameKey, String timeStamp, String originalFilename, BindingResult errors) {
        String loadSorRateOutPutFileName = "";
        if (originalFilename.contains(originalNameKey)) {
            loadSorRateOutPutFileName = originalFilename.split("_" + originalNameKey + "_")[0] + "_" + outputNameKey + "_" + timeStamp + "." + originalFilename.split("\\.")[1];
        } else if (originalFilename.contains("_" + outputNameKey + "_")) {
            loadSorRateOutPutFileName = originalFilename.split("_" + outputNameKey + "_")[0] + "_" + outputNameKey + "_" + timeStamp + "." + originalFilename.split("\\.")[1];
        } else if (originalFilename.length() > 60) {
            errors.reject("error.file.name.should.be.less.then.60.characters", "error.file.name.should.be.less.then.60.characters");
        } else {
            loadSorRateOutPutFileName = originalFilename.split("\\.")[0] + "_" + outputNameKey + "_" + timeStamp + "." + originalFilename.split("\\.")[1];
        }
        return loadSorRateOutPutFileName;
    }

    public Boolean isContainsWhitespace(String name) {
        Pattern pattern = Pattern.compile("\\s");
        Matcher matcher = pattern.matcher(name);
        return matcher.find();
    }

    public boolean isSpecialCharacterExist(String name) {
        return name.indexOf(92) != -1 || name.indexOf(39) != -1;
    }

    public Boolean isNewLineOrTabExist(String name) {
        Pattern pattern = Pattern.compile("\\n");
        Matcher matcher = pattern.matcher(name);
        Pattern pattern1 = Pattern.compile("\\t");
        Matcher matcher1 = pattern1.matcher(name);
        return matcher.find() || matcher1.find();
    }
}

