/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.master.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.works.master.repository.ScheduleCategoryRepository;
import org.egov.works.models.masters.ScheduleCategory;
import org.egov.works.models.masters.SearchRequestScheduleCategory;
import org.egov.works.services.WorksService;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ScheduleCategoryService {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private ScheduleCategoryRepository scheduleCategoryRepository;
    @Autowired
    private WorksService worksService;
    @Autowired
    private UserService userService;

    public ScheduleCategory getScheduleCategoryById(Long scheduleCategoryId) {
        ScheduleCategory scheduleCategory = (ScheduleCategory)((Object)this.entityManager.find(ScheduleCategory.class, (Object)scheduleCategoryId));
        return scheduleCategory;
    }

    public boolean checkForSOR(Long id) {
        Query query = this.entityManager.createQuery(" from ScheduleOfRate rate where sor_category_id  = (select id from ScheduleCategory  where id = :id)");
        query.setParameter("id", (Object)id);
        List retList = query.getResultList();
        return retList == null || retList.isEmpty();
    }

    public boolean checkForScheduleCategory(String code) {
        Query query = this.entityManager.createQuery(" from ScheduleCategory  where code = :code");
        query.setParameter("code", (Object)code);
        List retList = query.getResultList();
        return retList != null && !retList.isEmpty();
    }

    public List<ScheduleCategory> getAllScheduleCategories() {
        return this.scheduleCategoryRepository.findAll();
    }

    public ScheduleCategory findById(Long id, boolean b) {
        return (ScheduleCategory)((Object)this.scheduleCategoryRepository.findOne(id));
    }

    @Transactional
    public ScheduleCategory save(ScheduleCategory scheduleCategory) {
        return (ScheduleCategory)((Object)this.scheduleCategoryRepository.save((Object)scheduleCategory));
    }

    public List<String> getCategoryNames(String categoryName) {
        List<ScheduleCategory> scheduleCategory = this.scheduleCategoryRepository.findByDescriptionContainingIgnoreCase(categoryName);
        ArrayList<String> results = new ArrayList<String>();
        for (ScheduleCategory details : scheduleCategory) {
            results.add(details.getDescription());
        }
        return results;
    }

    public List<ScheduleCategory> searchScheduleCategory(SearchRequestScheduleCategory searchRequestScheduleCategory) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(ScheduleCategory.class);
        if (searchRequestScheduleCategory != null) {
            if (searchRequestScheduleCategory.getCategoryName() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"description", (Object)searchRequestScheduleCategory.getCategoryName()).ignoreCase());
            }
            if (searchRequestScheduleCategory.getCategoryDescription() != null) {
                criteria.add(Restrictions.ilike((String)"code", (String)searchRequestScheduleCategory.getCategoryDescription(), (MatchMode)MatchMode.ANYWHERE));
            }
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public ScheduleCategory setPrimaryDetails(ScheduleCategory scheduleCategory) {
        User user = this.userService.getUserById(this.worksService.getCurrentLoggedInUserId());
        if (scheduleCategory.getId() == null) {
            scheduleCategory.setCreatedBy(user);
            scheduleCategory.setCreatedDate(new Date());
        }
        scheduleCategory.setModifiedBy(user);
        scheduleCategory.setModifiedDate(new Date());
        return scheduleCategory;
    }

    public ScheduleCategory findByCode(String code) {
        return this.scheduleCategoryRepository.findByCodeIgnoreCase(code);
    }
}

