/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.lineestimate.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.egf.budget.model.BudgetControlType;
import org.egov.egf.budget.service.BudgetControlTypeService;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EisCommonService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.model.budget.BudgetUsage;
import org.egov.pims.commons.Position;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.EstimatePhotographSearchRequest;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.autonumber.BudgetAppropriationNumberGenerator;
import org.egov.works.autonumber.EstimateNumberGenerator;
import org.egov.works.autonumber.LineEstimateNumberGenerator;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.lineestimate.entity.DocumentDetails;
import org.egov.works.lineestimate.entity.LineEstimate;
import org.egov.works.lineestimate.entity.LineEstimateAppropriation;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.entity.LineEstimateSearchRequest;
import org.egov.works.lineestimate.entity.LineEstimatesForAbstractEstimate;
import org.egov.works.lineestimate.entity.enums.LineEstimateStatus;
import org.egov.works.lineestimate.repository.LineEstimateAppropriationRepository;
import org.egov.works.lineestimate.repository.LineEstimateDetailsRepository;
import org.egov.works.lineestimate.repository.LineEstimateRepository;
import org.egov.works.lineestimate.service.LineEstimateAppropriationService;
import org.egov.works.lineestimate.service.LineEstimateDetailService;
import org.egov.works.utils.WorksConstants;
import org.egov.works.utils.WorksUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class LineEstimateService {
    private static final Logger LOG = LoggerFactory.getLogger(LineEstimateService.class);
    @PersistenceContext
    private EntityManager entityManager;
    private final LineEstimateRepository lineEstimateRepository;
    private final LineEstimateDetailsRepository lineEstimateDetailsRepository;
    private final LineEstimateAppropriationRepository lineEstimateAppropriationRepository;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<LineEstimate> lineEstimateWorkflowService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private BudgetDetailsDAO budgetDetailsDAO;
    @Autowired
    private LineEstimateDetailService lineEstimateDetailService;
    @Autowired
    private UserService userService;
    @Autowired
    private EstimateService estimateService;
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;
    @Autowired
    private BudgetControlTypeService budgetControlTypeService;
    @Autowired
    private ScriptService scriptService;
    @Autowired
    private CityService cityService;
    @Autowired
    private LineEstimateAppropriationService lineEstimateAppropriationService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Autowired
    public LineEstimateService(LineEstimateRepository lineEstimateRepository, LineEstimateDetailsRepository lineEstimateDetailsRepository, LineEstimateAppropriationRepository lineEstimateAppropriationRepository) {
        this.lineEstimateRepository = lineEstimateRepository;
        this.lineEstimateDetailsRepository = lineEstimateDetailsRepository;
        this.lineEstimateAppropriationRepository = lineEstimateAppropriationRepository;
    }

    public LineEstimate getLineEstimateById(Long id) {
        return this.lineEstimateRepository.findById(id);
    }

    @Transactional
    public LineEstimate create(LineEstimate lineEstimate, MultipartFile[] files, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) throws IOException {
        lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.CREATED.toString()));
        CFinancialYear financialYear = this.worksUtils.getFinancialYearByDate(lineEstimate.getLineEstimateDate());
        for (LineEstimateDetails lineEstimateDetail : lineEstimate.getLineEstimateDetails()) {
            EstimateNumberGenerator e = (EstimateNumberGenerator)this.beanResolver.getAutoNumberServiceFor(EstimateNumberGenerator.class);
            String estimateNumber = e.getNextNumber(lineEstimate, financialYear);
            lineEstimateDetail.setEstimateNumber(estimateNumber);
            lineEstimateDetail.setLineEstimate(lineEstimate);
        }
        if (lineEstimate.getLineEstimateNumber() == null || lineEstimate.getLineEstimateNumber().isEmpty()) {
            LineEstimateNumberGenerator l = (LineEstimateNumberGenerator)this.beanResolver.getAutoNumberServiceFor(LineEstimateNumberGenerator.class);
            String lineEstimateNumber = l.getNextNumber(lineEstimate);
            lineEstimate.setLineEstimateNumber(lineEstimateNumber);
        }
        LineEstimate newLineEstimate = (LineEstimate)((Object)this.lineEstimateRepository.save((Object)lineEstimate));
        this.createLineEstimateWorkflowTransition(newLineEstimate, approvalPosition, approvalComent, additionalRule, workFlowAction);
        this.lineEstimateRepository.save((Object)newLineEstimate);
        List<DocumentDetails> documentDetails = this.worksUtils.getDocumentDetails(files, (Object)newLineEstimate, "LineEstimate");
        if (!documentDetails.isEmpty()) {
            newLineEstimate.setDocumentDetails(documentDetails);
            this.worksUtils.persistDocuments(documentDetails);
        }
        return newLineEstimate;
    }

    private LineEstimate update(LineEstimate lineEstimate, String removedLineEstimateDetailsIds, MultipartFile[] files, CFinancialYear financialYear) throws IOException {
        for (LineEstimateDetails lineEstimateDetails : lineEstimate.getLineEstimateDetails()) {
            if (lineEstimateDetails == null || lineEstimateDetails.getId() != null) continue;
            EstimateNumberGenerator e = (EstimateNumberGenerator)this.beanResolver.getAutoNumberServiceFor(EstimateNumberGenerator.class);
            String estimateNumber = e.getNextNumber(lineEstimate, financialYear);
            lineEstimateDetails.setEstimateNumber(estimateNumber);
            lineEstimateDetails.setLineEstimate(lineEstimate);
        }
        List<LineEstimateDetails> list = new ArrayList<LineEstimateDetails>(lineEstimate.getLineEstimateDetails());
        list = this.removeDeletedLineEstimateDetails(list, removedLineEstimateDetailsIds);
        lineEstimate.setLineEstimateDetails(list);
        LineEstimate persistedLineEstimate = (LineEstimate)((Object)this.lineEstimateRepository.save((Object)lineEstimate));
        List<DocumentDetails> documentDetails = this.worksUtils.getDocumentDetails(files, (Object)persistedLineEstimate, "LineEstimate");
        if (!documentDetails.isEmpty()) {
            persistedLineEstimate.setDocumentDetails(documentDetails);
            this.worksUtils.persistDocuments(documentDetails);
        }
        return (LineEstimate)((Object)this.lineEstimateRepository.save((Object)persistedLineEstimate));
    }

    public LineEstimate getLineEstimateByLineEstimateNumber(String lineEstimateNumber) {
        return this.lineEstimateRepository.findByLineEstimateNumber(lineEstimateNumber);
    }

    public List<LineEstimateDetails> removeDeletedLineEstimateDetails(List<LineEstimateDetails> list, String removedLineEstimateDetailsIds) {
        ArrayList<LineEstimateDetails> details = new ArrayList<LineEstimateDetails>();
        if (null != removedLineEstimateDetailsIds) {
            String[] ids = removedLineEstimateDetailsIds.split(",");
            ArrayList<String> strList = new ArrayList<String>();
            for (String str : ids) {
                strList.add(str);
            }
            for (LineEstimateDetails line : list) {
                if (line.getId() != null) {
                    if (strList.contains(line.getId().toString())) continue;
                    details.add(line);
                    continue;
                }
                details.add(line);
            }
        } else {
            return list;
        }
        return details;
    }

    public List<LineEstimate> searchLineEstimates(LineEstimateSearchRequest lineEstimateSearchRequest) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(LineEstimate.class).createAlias("lineEstimateDetails", "lineEstimateDetail").createAlias("status", "les");
        if (lineEstimateSearchRequest != null) {
            if (lineEstimateSearchRequest.getAdminSanctionNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"adminSanctionNumber", (Object)lineEstimateSearchRequest.getAdminSanctionNumber()).ignoreCase());
            }
            if (lineEstimateSearchRequest.getBudgetHead() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"budgetHead.id", (Object)lineEstimateSearchRequest.getBudgetHead()));
            }
            if (lineEstimateSearchRequest.getExecutingDepartment() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"executingDepartment.id", (Object)lineEstimateSearchRequest.getExecutingDepartment()));
            }
            if (lineEstimateSearchRequest.getFunction() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"function.id", (Object)lineEstimateSearchRequest.getFunction()));
            }
            if (lineEstimateSearchRequest.getFund() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"fund.id", (Object)lineEstimateSearchRequest.getFund().intValue()));
            }
            if (lineEstimateSearchRequest.getEstimateNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"lineEstimateNumber", (Object)lineEstimateSearchRequest.getEstimateNumber()).ignoreCase());
            }
            if (lineEstimateSearchRequest.getAdminSanctionFromDate() != null) {
                criteria.add((Criterion)Restrictions.ge((String)"adminSanctionDate", (Object)lineEstimateSearchRequest.getAdminSanctionFromDate()));
            }
            if (lineEstimateSearchRequest.getAdminSanctionToDate() != null) {
                criteria.add((Criterion)Restrictions.le((String)"adminSanctionDate", (Object)lineEstimateSearchRequest.getAdminSanctionToDate()));
            }
            if (lineEstimateSearchRequest.getLineEstimateStatus() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"les.code", (Object)lineEstimateSearchRequest.getLineEstimateStatus()));
            }
            criteria.add((Criterion)Restrictions.eq((String)"spillOverFlag", (Object)lineEstimateSearchRequest.isSpillOverFlag()));
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public List<LineEstimateDetails> getLineEstimatesForAbstractEstimate(LineEstimatesForAbstractEstimate lineEstimatesForAbstractEstimate) {
        StringBuilder mainQuery = new StringBuilder();
        StringBuilder filterConditions = new StringBuilder();
        List<LineEstimateDetails> lineEstimateDetailsList = new ArrayList();
        Query query = null;
        if (lineEstimatesForAbstractEstimate.getAdminSanctionNumber() != null) {
            filterConditions.append(" and lineEstimate.adminSanctionNumber =:adminSanctionNumber ");
        }
        if (lineEstimatesForAbstractEstimate.getExecutingDepartment() != null) {
            filterConditions.append(" and lineEstimate.executingDepartment.id =:executingDepartment ");
        }
        if (lineEstimatesForAbstractEstimate.getEstimateNumber() != null) {
            filterConditions.append(" and upper(estimateNumber) =:estimateNumber ");
        }
        if (lineEstimatesForAbstractEstimate.getAdminSanctionFromDate() != null) {
            filterConditions.append(" and lineEstimate.adminSanctionDate >=:adminSanctionFromDate ");
        }
        if (lineEstimatesForAbstractEstimate.getAdminSanctionToDate() != null) {
            filterConditions.append(" and lineEstimate.adminSanctionDate <=:adminSanctionToDate ");
        }
        if (lineEstimatesForAbstractEstimate.getLineEstimateCreatedBy() != null) {
            filterConditions.append(" and lineEstimate.createdBy.id =:createdBy ");
        }
        if (lineEstimatesForAbstractEstimate.getWorkIdentificationNumber() != null) {
            filterConditions.append(" and upper(projectCode.code) =:projectCode ");
        }
        if (lineEstimatesForAbstractEstimate.isSpillOverFlag()) {
            filterConditions.append(" and lineEstimate.spillOverFlag =:spillOverFlag ");
        }
        mainQuery.append("select led from LineEstimateDetails as led ");
        mainQuery.append(" where not exists (select distinct(wo.estimateNumber) from WorkOrder as wo where led.estimateNumber = wo.estimateNumber and upper(wo.egwStatus.code) !=:wostatus) ");
        mainQuery.append(" and (upper(led.lineEstimate.status.code) =:lestatus1 or upper(led.lineEstimate.status.code) =:lestatus2 )");
        mainQuery.append(" and  not exists (select distinct(ae.lineEstimateDetails.id) from AbstractEstimate as ae where ae.lineEstimateDetails.id = led.id and upper(ae.egwStatus.code) !=:aestatus) ");
        mainQuery.append(filterConditions.toString());
        query = this.entityManager.createQuery(mainQuery.toString());
        query.setParameter("lestatus1", (Object)LineEstimateStatus.ADMINISTRATIVE_SANCTIONED.toString());
        query.setParameter("lestatus2", (Object)LineEstimateStatus.TECHNICAL_SANCTIONED.toString());
        query = this.setParameterToGetLineEstimatesForAbstractEstimate(lineEstimatesForAbstractEstimate, query);
        lineEstimateDetailsList = query.getResultList();
        mainQuery = new StringBuilder();
        mainQuery.append("select led from LineEstimateDetails as led ");
        mainQuery.append(" where not exists (select distinct(wo.estimateNumber) from WorkOrder as wo where led.estimateNumber = wo.estimateNumber and upper(wo.egwStatus.code) !=:wostatus) ");
        mainQuery.append(" and upper(led.lineEstimate.status.code) =:lestatus ");
        mainQuery.append(" and exists (select distinct(ae.lineEstimateDetails.id) from AbstractEstimate as ae where ae.state is null and not exists (select act.abstractEstimate from Activity as act where ae = act.abstractEstimate) and ae.lineEstimateDetails.id = led.id and upper(ae.egwStatus.code) !=:aestatus) ");
        mainQuery.append(filterConditions.toString());
        query = null;
        query = this.entityManager.createQuery(mainQuery.toString());
        query.setParameter("lestatus", (Object)LineEstimateStatus.TECHNICAL_SANCTIONED.toString());
        query = this.setParameterToGetLineEstimatesForAbstractEstimate(lineEstimatesForAbstractEstimate, query);
        lineEstimateDetailsList.addAll(query.getResultList());
        mainQuery = new StringBuilder();
        return lineEstimateDetailsList;
    }

    private Query setParameterToGetLineEstimatesForAbstractEstimate(LineEstimatesForAbstractEstimate lineEstimatesForAbstractEstimate, Query query) {
        query.setParameter("wostatus", (Object)"CANCELLED");
        query.setParameter("aestatus", (Object)"CANCELLED");
        if (lineEstimatesForAbstractEstimate.isSpillOverFlag()) {
            query.setParameter("spillOverFlag", (Object)lineEstimatesForAbstractEstimate.isSpillOverFlag());
        }
        if (lineEstimatesForAbstractEstimate.getAdminSanctionNumber() != null) {
            query.setParameter("adminSanctionNumber", (Object)lineEstimatesForAbstractEstimate.getAdminSanctionNumber());
        }
        if (lineEstimatesForAbstractEstimate.getExecutingDepartment() != null) {
            query.setParameter("executingDepartment", (Object)lineEstimatesForAbstractEstimate.getExecutingDepartment());
        }
        if (lineEstimatesForAbstractEstimate.getEstimateNumber() != null) {
            query.setParameter("estimateNumber", (Object)lineEstimatesForAbstractEstimate.getEstimateNumber().toUpperCase());
        }
        if (lineEstimatesForAbstractEstimate.getAdminSanctionFromDate() != null) {
            query.setParameter("adminSanctionFromDate", (Object)lineEstimatesForAbstractEstimate.getAdminSanctionFromDate());
        }
        if (lineEstimatesForAbstractEstimate.getAdminSanctionToDate() != null) {
            query.setParameter("adminSanctionToDate", (Object)lineEstimatesForAbstractEstimate.getAdminSanctionToDate());
        }
        if (lineEstimatesForAbstractEstimate.getLineEstimateCreatedBy() != null) {
            query.setParameter("createdBy", (Object)lineEstimatesForAbstractEstimate.getLineEstimateCreatedBy());
        }
        if (lineEstimatesForAbstractEstimate.getWorkIdentificationNumber() != null) {
            query.setParameter("projectCode", (Object)lineEstimatesForAbstractEstimate.getWorkIdentificationNumber().toUpperCase());
        }
        return query;
    }

    public List<String> findLineEstimateNumbers(String name) {
        List<LineEstimate> lineEstimates = this.lineEstimateRepository.findByLineEstimateNumberContainingIgnoreCase(name);
        ArrayList<String> results = new ArrayList<String>();
        for (LineEstimate details : lineEstimates) {
            results.add(details.getLineEstimateNumber());
        }
        return results;
    }

    public List<String> findEstimateNumbersForLoa(String name) {
        List<String> lineEstimateNumbers = this.lineEstimateDetailsRepository.findEstimateNumbersForLoa("%" + name.toUpperCase() + "%", LineEstimateStatus.ADMINISTRATIVE_SANCTIONED.toString(), "CANCELLED");
        return lineEstimateNumbers;
    }

    public List<String> findEstimateNumbersForAbstractEstimate(String name) {
        List<Object> lineEstimateNumbers = new ArrayList();
        lineEstimateNumbers = this.lineEstimateDetailsRepository.findEstimateNumbersForLoa("%" + name.toUpperCase() + "%", LineEstimateStatus.TECHNICAL_SANCTIONED.toString(), "CANCELLED");
        lineEstimateNumbers.addAll(this.lineEstimateDetailsRepository.findEstimateNumbersForAbstractEstimate("%" + name.toUpperCase() + "%", LineEstimateStatus.ADMINISTRATIVE_SANCTIONED.toString(), "CANCELLED"));
        return lineEstimateNumbers;
    }

    public List<String> findAdminSanctionNumbers(String name) {
        List<String> adminSanctionNumbers = this.lineEstimateRepository.findDistinctAdminSanctionNumberContainingIgnoreCase("%" + name + "%");
        return adminSanctionNumbers;
    }

    public List<String> findAdminSanctionNumbersForLoa(String name) {
        List<String> adminSanctionNumbers = this.lineEstimateDetailsRepository.findAdminSanctionNumbersForLoa("%" + name.toUpperCase() + "%", AbstractEstimate.EstimateStatus.APPROVED.toString(), "CANCELLED");
        return adminSanctionNumbers;
    }

    public List<String> findAdminSanctionNumbersForAbstractEstimate(String name) {
        List<Object> adminSanctionNumbers = new ArrayList();
        adminSanctionNumbers = this.lineEstimateDetailsRepository.findAdminSanctionNumbersForAbstractEstimate("%" + name.toUpperCase() + "%", LineEstimateStatus.TECHNICAL_SANCTIONED.toString(), "CANCELLED");
        adminSanctionNumbers.addAll(this.lineEstimateDetailsRepository.findAdminSanctionNumbersForAbstractEstimate("%" + name.toUpperCase() + "%", LineEstimateStatus.ADMINISTRATIVE_SANCTIONED.toString(), "CANCELLED"));
        return adminSanctionNumbers;
    }

    public List<String> findWorkIdentificationNumbersToSearchEstimatesForLoa(String name) {
        List<String> workIdNumbers = this.lineEstimateDetailsRepository.findWorkIdentificationNumbersToSearchEstimatesForLoa("%" + name.toUpperCase() + "%", "CANCELLED", AbstractEstimate.EstimateStatus.APPROVED.toString().toUpperCase());
        return workIdNumbers;
    }

    public List<String> findWorkIdentificationNumbersToSearchEstimates(String name) {
        List<String> workIdNumbers = this.lineEstimateDetailsRepository.findWorkIdentificationNumbersToSearchEstimates("%" + name.toUpperCase() + "%", "CANCELLED", LineEstimateStatus.ADMINISTRATIVE_SANCTIONED.toString());
        return workIdNumbers;
    }

    public List<LineEstimatesForAbstractEstimate> searchLineEstimatesForAbstractEstimate(LineEstimatesForAbstractEstimate lineEstimatesForAbstractEstimate) {
        List<LineEstimateDetails> lineEstimateDetails = this.getLineEstimatesForAbstractEstimate(lineEstimatesForAbstractEstimate);
        ArrayList<LineEstimatesForAbstractEstimate> lineEstimatesForAbstractEstimates = new ArrayList<LineEstimatesForAbstractEstimate>();
        for (LineEstimateDetails led : lineEstimateDetails) {
            LineEstimatesForAbstractEstimate result = new LineEstimatesForAbstractEstimate();
            result.setId(led.getId());
            result.setLeId(led.getLineEstimate().getId());
            result.setAdminSanctionNumber(led.getLineEstimate().getAdminSanctionNumber());
            result.setCreatedBy(led.getLineEstimate().getCreatedBy().getName());
            result.setEstimateAmount(led.getEstimateAmount());
            result.setEstimateNumber(led.getEstimateNumber());
            result.setNameOfWork(led.getNameOfWork());
            if (led.getLineEstimate().getAdminSanctionBy() != null) {
                result.setAdminSanctionBy(led.getLineEstimate().getAdminSanctionBy().getName());
            }
            result.setActualEstimateAmount(led.getActualEstimateAmount());
            result.setWorkIdentificationNumber(led.getProjectCode().getCode());
            lineEstimatesForAbstractEstimates.add(result);
        }
        return lineEstimatesForAbstractEstimates;
    }

    public List<Hashtable<String, Object>> getHistory(State state, List<StateHistory> history) {
        User user = null;
        ArrayList<Hashtable<String, Object>> historyTable = new ArrayList<Hashtable<String, Object>>();
        Hashtable<String, Object> map = new Hashtable<String, Object>(0);
        if (null != state) {
            for (StateHistory stateHistory : history) {
                Hashtable<String, Object> HistoryMap = new Hashtable<String, Object>(0);
                HistoryMap.put("date", stateHistory.getDateInfo());
                HistoryMap.put("comments", stateHistory.getComments());
                HistoryMap.put("updatedBy", stateHistory.getLastModifiedBy().getUsername() + "::" + stateHistory.getLastModifiedBy().getName());
                HistoryMap.put("status", stateHistory.getValue());
                Position owner = stateHistory.getOwnerPosition();
                user = stateHistory.getOwnerUser();
                if (null != user) {
                    HistoryMap.put("user", user.getUsername() + "::" + user.getName());
                    HistoryMap.put("department", null != this.eisCommonService.getDepartmentForUser(user.getId()) ? this.eisCommonService.getDepartmentForUser(user.getId()).getName() : "");
                } else if (null != owner && null != owner.getDeptDesig()) {
                    user = this.eisCommonService.getUserForPosition(owner.getId(), new Date());
                    HistoryMap.put("user", null != user.getUsername() ? user.getUsername() + "::" + user.getName() : "");
                    HistoryMap.put("department", null != owner.getDeptDesig().getDepartment() ? owner.getDeptDesig().getDepartment().getName() : "");
                }
                historyTable.add(HistoryMap);
            }
            map.put("date", state.getDateInfo());
            map.put("comments", state.getComments() != null ? state.getComments() : "");
            map.put("updatedBy", state.getLastModifiedBy().getUsername() + "::" + state.getLastModifiedBy().getName());
            map.put("status", state.getValue());
            Position ownerPosition = state.getOwnerPosition();
            user = state.getOwnerUser();
            if (null != user) {
                map.put("user", user.getUsername() + "::" + user.getName());
                map.put("department", null != this.eisCommonService.getDepartmentForUser(user.getId()) ? this.eisCommonService.getDepartmentForUser(user.getId()).getName() : "");
            } else if (null != ownerPosition && null != ownerPosition.getDeptDesig()) {
                user = this.eisCommonService.getUserForPosition(ownerPosition.getId(), new Date());
                map.put("user", null != user.getUsername() ? user.getUsername() + "::" + user.getName() : "");
                map.put("department", null != ownerPosition.getDeptDesig().getDepartment() ? ownerPosition.getDeptDesig().getDepartment().getName() : "");
            }
            historyTable.add(map);
        }
        return historyTable;
    }

    public Long getApprovalPositionByMatrixDesignation(LineEstimate lineEstimate, Long approvalPosition, String additionalRule, String mode, String workFlowAction) {
        WorkFlowMatrix wfmatrix = this.lineEstimateWorkflowService.getWfMatrix(lineEstimate.getStateType(), null, null, additionalRule, lineEstimate.getCurrentState().getValue(), null);
        if (lineEstimate.getStatus() != null && lineEstimate.getStatus().getCode() != null && (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.CREATED.toString()) || lineEstimate.getStatus().getCode().equals(LineEstimateStatus.RESUBMITTED.toString())) && lineEstimate.getState() != null) {
            approvalPosition = mode.equals("edit") ? lineEstimate.getState().getOwnerPosition().getId() : this.worksUtils.getApproverPosition(wfmatrix.getNextDesignation(), lineEstimate.getState(), lineEstimate.getCreatedBy().getId());
        }
        if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.CHECKED.toString())) {
            approvalPosition = this.worksUtils.getApproverPosition(wfmatrix.getNextDesignation(), lineEstimate.getState(), lineEstimate.getCreatedBy().getId());
        }
        if (workFlowAction.equals("Cancel") && wfmatrix.getNextState().equals("Created")) {
            approvalPosition = null;
        }
        return approvalPosition;
    }

    /*
     * Unable to fully structure code
     */
    @Transactional
    public LineEstimate updateLineEstimateDetails(LineEstimate lineEstimate, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction, String mode, ReportOutput reportOutput, String removedLineEstimateDetailsIds, MultipartFile[] files, CFinancialYear financialYear) throws ValidationException, IOException {
        updatedLineEstimate = null;
        if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.REJECTED.toString())) {
            updatedLineEstimate = this.update(lineEstimate, removedLineEstimateDetailsIds, files, financialYear);
            try {
                if (!workFlowAction.equals(WorksConstants.FORWARD_ACTION) && !workFlowAction.equals("Cancel")) ** GOTO lbl32
                this.lineEstimateStatusChange(updatedLineEstimate, workFlowAction, mode);
            }
            catch (ValidationException e) {
                throw new ValidationException(e.getErrors());
            }
        } else {
            try {
                if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.BUDGET_SANCTIONED.toString()) && workFlowAction.equals(WorksConstants.REJECT_ACTION)) {
                    this.resetAdminSanctionDetails(lineEstimate);
                } else if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.BUDGET_SANCTIONED.toString()) && !workFlowAction.equals(WorksConstants.REJECT_ACTION)) {
                    this.setAdminSanctionByAndDate(lineEstimate);
                    for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
                        this.lineEstimateDetailService.setProjectCode(led);
                    }
                }
                if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.TECHNICALLY_APPROVED.toString()) && !workFlowAction.equals(WorksConstants.REJECT_ACTION)) {
                    if (!BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue())) {
                        this.doBudgetoryAppropriation(lineEstimate);
                    }
                } else if (workFlowAction.equals(WorksConstants.REJECT_ACTION) && lineEstimate.getStatus().getCode().equals(LineEstimateStatus.BUDGET_SANCTIONED.toString()) && !BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue())) {
                    for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
                        this.releaseBudgetOnReject(led, null, null);
                    }
                }
                this.lineEstimateStatusChange(lineEstimate, workFlowAction, mode);
            }
            catch (ValidationException e) {
                throw new ValidationException(e.getErrors());
            }
        }
lbl32:
        // 3 sources

        updatedLineEstimate = (LineEstimate)this.lineEstimateRepository.save((Object)lineEstimate);
        this.createLineEstimateWorkflowTransition(updatedLineEstimate, approvalPosition, approvalComent, additionalRule, workFlowAction);
        updatedLineEstimate = (LineEstimate)this.lineEstimateRepository.save((Object)updatedLineEstimate);
        return updatedLineEstimate;
    }

    private void resetAdminSanctionDetails(LineEstimate lineEstimate) {
        lineEstimate.setAdminSanctionNumber(null);
        lineEstimate.setCouncilResolutionNumber(null);
        lineEstimate.setCouncilResolutionDate(null);
    }

    private void setAdminSanctionByAndDate(LineEstimate lineEstimate) {
        lineEstimate.setAdminSanctionDate(new Date());
        lineEstimate.setAdminSanctionBy(this.securityUtils.getCurrentUser());
    }

    private void doBudgetoryAppropriation(LineEstimate lineEstimate) {
        ArrayList<Long> budgetheadid = new ArrayList<Long>();
        budgetheadid.add(lineEstimate.getBudgetHead().getId());
        for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
            boolean flag;
            BigDecimal appropriationAmount = lineEstimate.isBillsCreated() && led.getGrossAmountBilled() != null ? led.getEstimateAmount().subtract(led.getGrossAmountBilled()) : led.getEstimateAmount();
            if (appropriationAmount.compareTo(BigDecimal.ZERO) != 1 || (flag = this.lineEstimateDetailService.checkConsumeEncumbranceBudget(led, this.worksUtils.getFinancialYearByDate(new Date()).getId(), appropriationAmount.doubleValue(), budgetheadid))) continue;
            throw new ValidationException("", "error.budgetappropriation.insufficient.amount", new String[0]);
        }
    }

    public void lineEstimateStatusChange(LineEstimate lineEstimate, String workFlowAction, String mode) throws ValidationException {
        if (null != lineEstimate && null != lineEstimate.getStatus() && null != lineEstimate.getStatus().getCode()) {
            if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.CREATED.toString()) && !lineEstimate.getState().getNextAction().equals("Pending Technical Approve") && lineEstimate.getState() != null && workFlowAction.equals("Submit")) {
                lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.CHECKED.toString()));
            } else if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.RESUBMITTED.toString()) && lineEstimate.getState() != null && workFlowAction.equals("Submit") && !lineEstimate.getState().getNextAction().equals("Pending Technical Approve")) {
                lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.CHECKED.toString()));
            } else if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.TECHNICALLY_APPROVED.toString()) && !workFlowAction.equals(WorksConstants.REJECT_ACTION)) {
                lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.BUDGET_SANCTIONED.toString()));
            } else if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.CHECKED.toString()) && !workFlowAction.equals(WorksConstants.REJECT_ACTION) && lineEstimate.getState().getNextAction().equals("Pending Technical Approve") || lineEstimate.getStatus().getCode().equals(LineEstimateStatus.CREATED.toString()) && !workFlowAction.equals(WorksConstants.REJECT_ACTION) && lineEstimate.getState().getNextAction().equals("Pending Technical Approve") || lineEstimate.getStatus().getCode().equals(LineEstimateStatus.RESUBMITTED.toString()) && !workFlowAction.equals(WorksConstants.REJECT_ACTION) && lineEstimate.getState().getNextAction().equals("Pending Technical Approve")) {
                lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.TECHNICALLY_APPROVED.toString()));
            } else if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.BUDGET_SANCTIONED.toString()) && !workFlowAction.equals(WorksConstants.REJECT_ACTION)) {
                lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.ADMINISTRATIVE_SANCTIONED.toString()));
            } else if (workFlowAction.equals(WorksConstants.REJECT_ACTION)) {
                lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.REJECTED.toString()));
            } else if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.REJECTED.toString()) && workFlowAction.equals("Cancel")) {
                lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.CANCELLED.toString()));
            } else if (lineEstimate.getStatus().getCode().equals(LineEstimateStatus.REJECTED.toString()) && workFlowAction.equals(WorksConstants.FORWARD_ACTION)) {
                lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.RESUBMITTED.toString()));
            }
        }
    }

    public List<User> getLineEstimateCreatedByUsers() {
        return this.lineEstimateRepository.getLineEstimateCreatedByUsers(LineEstimateStatus.TECHNICAL_SANCTIONED.toString());
    }

    public List<Department> getUserDepartments(User currentUser) {
        List assignments = this.assignmentService.findByEmployeeAndGivenDate(currentUser.getId(), new Date());
        ArrayList<Department> uniqueDepartmentList = new ArrayList<Department>();
        Department prevDepartment = new Department();
        for (Assignment assignment : assignments) {
            if (!assignment.getDepartment().getName().equals(prevDepartment.getName())) {
                uniqueDepartmentList.add(assignment.getDepartment());
            }
            prevDepartment = assignment.getDepartment();
        }
        return uniqueDepartmentList;
    }

    public LineEstimateDetails findByEstimateNumber(String estimateNumber) {
        return this.lineEstimateDetailsRepository.findByEstimateNumberAndLineEstimate_Status_CodeEquals(estimateNumber, LineEstimateStatus.TECHNICAL_SANCTIONED.toString());
    }

    public void createLineEstimateWorkflowTransition(LineEstimate lineEstimate, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(" Create WorkFlow Transition Started  ...");
        }
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        Position pos = null;
        Assignment wfInitiator = null;
        String currState = "";
        String natureOfwork = "Estimate";
        if (null != lineEstimate.getId()) {
            wfInitiator = this.assignmentService.getPrimaryAssignmentForUser(lineEstimate.getCreatedBy().getId());
        }
        if (WorksConstants.REJECT_ACTION.toString().equalsIgnoreCase(workFlowAction)) {
            String stateValue = "Rejected";
            lineEstimate.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("").withNatureOfTask("Estimate");
        } else {
            if (null != approvalPosition && approvalPosition != -1L && !approvalPosition.equals(0L)) {
                pos = this.positionMasterService.getPositionById(approvalPosition);
            }
            WorkFlowMatrix wfmatrix = null;
            if (null == lineEstimate.getState()) {
                wfmatrix = this.lineEstimateWorkflowService.getWfMatrix(lineEstimate.getStateType(), null, lineEstimate.getTotalEstimateAmount(), additionalRule, "", null);
                lineEstimate.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Estimate");
            } else if ("Cancel".toString().equalsIgnoreCase(workFlowAction)) {
                String stateValue = "Cancelled";
                wfmatrix = this.lineEstimateWorkflowService.getWfMatrix(lineEstimate.getStateType(), null, lineEstimate.getTotalEstimateAmount(), additionalRule, lineEstimate.getCurrentState().getValue(), lineEstimate.getCurrentState().getNextAction());
                lineEstimate.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Cancelled").withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction("").withNatureOfTask("Estimate");
            } else {
                wfmatrix = this.lineEstimateWorkflowService.getWfMatrix(lineEstimate.getStateType(), null, lineEstimate.getTotalEstimateAmount(), additionalRule, lineEstimate.getCurrentState().getValue(), lineEstimate.getCurrentState().getNextAction());
                lineEstimate.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Estimate");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" WorkFlow Transition Completed  ...");
        }
    }

    public LineEstimate getLineEstimateByTechnicalSanctionNumber(String technicalSanctionNumber) {
        return this.lineEstimateRepository.findByTechnicalSanctionNumberIgnoreCaseAndStatus_CodeNot(technicalSanctionNumber, LineEstimateStatus.CANCELLED.toString());
    }

    public LineEstimate getLineEstimateByAdminSanctionNumber(String adminSanctionNumber) {
        return this.lineEstimateRepository.findByAdminSanctionNumberIgnoreCaseAndStatus_codeNotLike(adminSanctionNumber, "CANCELLED");
    }

    public boolean releaseBudgetOnReject(LineEstimateDetails lineEstimateDetails, Double budgApprAmnt, String appropriationnumber) throws ValidationException {
        LineEstimateAppropriation lineEstimateAppropriation = this.lineEstimateAppropriationRepository.findLatestByLineEstimateDetails_EstimateNumber(lineEstimateDetails.getEstimateNumber());
        ArrayList<Long> budgetheadid = new ArrayList<Long>();
        budgetheadid.add(lineEstimateDetails.getLineEstimate().getBudgetHead().getId());
        BudgetUsage budgetUsage = null;
        boolean flag = false;
        if (lineEstimateAppropriation != null) {
            if (budgApprAmnt == null) {
                budgApprAmnt = lineEstimateAppropriation.getBudgetUsage().getConsumedAmount();
            }
            if (appropriationnumber == null) {
                appropriationnumber = lineEstimateAppropriation.getBudgetUsage().getAppropriationnumber();
            }
            BudgetAppropriationNumberGenerator b = (BudgetAppropriationNumberGenerator)this.beanResolver.getAutoNumberServiceFor(BudgetAppropriationNumberGenerator.class);
            budgetUsage = this.budgetDetailsDAO.releaseEncumbranceBudget(lineEstimateAppropriation.getBudgetUsage() == null ? null : b.generateCancelledBudgetAppropriationNumber(appropriationnumber), Long.valueOf(lineEstimateAppropriation.getBudgetUsage().getFinancialYearId().longValue()), Integer.valueOf(11), lineEstimateAppropriation.getLineEstimateDetails().getEstimateNumber(), Integer.valueOf(Integer.parseInt(lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getExecutingDepartment().getId().toString())), lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getFunction() == null ? null : lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getFunction().getId(), null, lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getScheme() == null ? null : lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getScheme().getId(), lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getSubScheme() == null ? null : lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getSubScheme().getId(), lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getWard() == null ? null : Integer.valueOf(Integer.parseInt(lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getWard().getId().toString())), lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getBudgetHead() == null ? null : budgetheadid, lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getFund() == null ? null : lineEstimateAppropriation.getLineEstimateDetails().getLineEstimate().getFund().getId(), budgApprAmnt.doubleValue());
            if (lineEstimateAppropriation.getLineEstimateDetails() != null) {
                this.persistBudgetReleaseDetails(lineEstimateDetails, budgetUsage);
            }
        }
        return false;
    }

    private void persistBudgetReleaseDetails(LineEstimateDetails lineEstimateDetails, BudgetUsage budgetUsage) {
        LineEstimateAppropriation lineEstimateAppropriation = null;
        lineEstimateAppropriation = this.lineEstimateAppropriationRepository.findLatestByLineEstimateDetails_EstimateNumber(lineEstimateDetails.getEstimateNumber());
        lineEstimateAppropriation.setBudgetUsage(budgetUsage);
        this.lineEstimateAppropriationRepository.save((Object)lineEstimateAppropriation);
    }

    @Transactional
    public LineEstimate createSpillOver(LineEstimate lineEstimate, MultipartFile[] files) throws IOException {
        List<DocumentDetails> documentDetails;
        lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.ADMINISTRATIVE_SANCTIONED.toString()));
        lineEstimate.setSpillOverFlag(true);
        List assignments = this.assignmentService.findPrimaryAssignmentForDesignationName("Commissioner");
        if (assignments != null && !assignments.isEmpty()) {
            User adminUser = this.userService.getUserById(((Assignment)assignments.get(0)).getEmployee().getId());
            lineEstimate.setAdminSanctionBy(adminUser);
        }
        if (lineEstimate.getLineEstimateNumber() == null || lineEstimate.getLineEstimateNumber().isEmpty()) {
            Iterator<LineEstimateDetails> l = (LineEstimateNumberGenerator)this.beanResolver.getAutoNumberServiceFor(LineEstimateNumberGenerator.class);
            String lineEstimateNumber = l.getNextNumber(lineEstimate);
            lineEstimate.setLineEstimateNumber(lineEstimateNumber);
        }
        for (LineEstimateDetails lineEstimateDetails : lineEstimate.getLineEstimateDetails()) {
            lineEstimateDetails.setLineEstimate(lineEstimate);
        }
        for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
            this.lineEstimateDetailService.setProjectCode(led);
        }
        LineEstimate newLineEstimate = (LineEstimate)((Object)this.lineEstimateRepository.save((Object)lineEstimate));
        if (!BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue())) {
            this.doBudgetoryAppropriation(lineEstimate);
        }
        if (!(documentDetails = this.worksUtils.getDocumentDetails(files, (Object)newLineEstimate, "LineEstimate")).isEmpty()) {
            newLineEstimate.setDocumentDetails(documentDetails);
            this.worksUtils.persistDocuments(documentDetails);
        }
        return newLineEstimate;
    }

    public List<String> getEstimateNumberForDepartment(Long departmentId) {
        return this.lineEstimateDetailsRepository.findEstimateNumbersForDepartment(departmentId);
    }

    public List<String> getEstimateNumbersForWorkIdentificationNumber(String workIdentificationNumber) {
        return this.lineEstimateDetailsRepository.findEstimateNumbersForWorkIdentificationNumber(workIdentificationNumber);
    }

    public List<String> getEstimateNumbersForSpillOverFlag(boolean spillOverFlag) {
        return this.lineEstimateDetailsRepository.findEstimateNumbersForSpillOverFlag(spillOverFlag);
    }

    public List<User> getLineEstimateCreatedByUsersForCancelLineEstimateByDepartment(Long department) {
        return this.lineEstimateDetailsRepository.findCreatedByForCancelLineEstimateByDepartment(department, LineEstimateStatus.ADMINISTRATIVE_SANCTIONED.toString(), LineEstimateStatus.TECHNICAL_SANCTIONED.toString(), "APPROVED");
    }

    public List<LineEstimate> searchLineEstimatesToCancel(LineEstimateSearchRequest lineEstimateSearchRequest) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(LineEstimate.class).createAlias("lineEstimateDetails", "led").createAlias("executingDepartment", "ed").createAlias("led.projectCode", "pc").createAlias("status", "status");
        if (lineEstimateSearchRequest != null) {
            if (lineEstimateSearchRequest.getExecutingDepartment() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"ed.id", (Object)lineEstimateSearchRequest.getExecutingDepartment()));
            }
            if (lineEstimateSearchRequest.getLineEstimateNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"lineEstimateNumber", (Object)lineEstimateSearchRequest.getLineEstimateNumber()).ignoreCase());
            }
            if (lineEstimateSearchRequest.getWorkIdentificationNumber() != null) {
                criteria.add(Restrictions.ilike((String)"pc.code", (String)lineEstimateSearchRequest.getWorkIdentificationNumber(), (MatchMode)MatchMode.ANYWHERE));
            }
        }
        if (lineEstimateSearchRequest.getCreatedBy() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"createdBy.id", (Object)lineEstimateSearchRequest.getCreatedBy()));
        }
        if (lineEstimateSearchRequest.isSpillOverFlag()) {
            criteria.add((Criterion)Restrictions.eq((String)"spillOverFlag", (Object)lineEstimateSearchRequest.isSpillOverFlag()));
        }
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"status.code", (Object)LineEstimateStatus.TECHNICAL_SANCTIONED.toString()).ignoreCase(), (Criterion)Restrictions.eq((String)"status.code", (Object)LineEstimateStatus.ADMINISTRATIVE_SANCTIONED.toString()).ignoreCase()));
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public String checkIfLOAsCreated(Long lineEstimateId) {
        List<String> listString = this.letterOfAcceptanceService.getEstimateNumbersToCancelLineEstimate(lineEstimateId);
        String estimateNumbers = "";
        for (String estimateNumber : listString) {
            estimateNumbers = estimateNumbers + estimateNumber + ", ";
        }
        if (estimateNumbers.equals("")) {
            return "";
        }
        return estimateNumbers;
    }

    @Transactional
    public LineEstimate cancel(LineEstimate lineEstimate) {
        lineEstimate.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("LINEESTIMATE", LineEstimateStatus.CANCELLED.toString()));
        if (!BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue())) {
            for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
                this.releaseBudgetOnReject(led, null, null);
            }
        }
        for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
            Long id = led.getId();
            AbstractEstimate abstractEstimate = this.estimateService.getAbstractEstimateByLineEstimateDetailsForCancelLineEstimate(id);
            if (abstractEstimate == null || !abstractEstimate.getActivities().isEmpty()) continue;
            abstractEstimate.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("AbstractEstimate", AbstractEstimate.EstimateStatus.CANCELLED.toString()));
            abstractEstimate.getProjectCode().setActive(Boolean.FALSE);
        }
        return (LineEstimate)((Object)this.lineEstimateRepository.save((Object)lineEstimate));
    }

    public LineEstimate getLineEstimateByCouncilResolutionNumber(String councilResolutionNumber) {
        return this.lineEstimateRepository.findByCouncilResolutionNumberIgnoreCaseAndStatus_codeNotLike(councilResolutionNumber, "CANCELLED");
    }

    public LineEstimate getLineEstimateByContractCommitteeApprovalNumber(String contractCommitteeApprovalNumber) {
        return this.lineEstimateRepository.findByContractCommitteeApprovalNumberIgnoreCaseAndStatus_codeNotLike(contractCommitteeApprovalNumber, "CANCELLED");
    }

    public LineEstimate getLineEstimateByStandingCommitteeApprovalNumber(String standingCommitteeApprovalNumber) {
        return this.lineEstimateRepository.findByStandingCommitteeApprovalNumberIgnoreCaseAndStatus_codeNotLike(standingCommitteeApprovalNumber, "CANCELLED");
    }

    public LineEstimate getLineEstimateByGovernmentApprovalNumber(String governmentApprovalNumber) {
        return this.lineEstimateRepository.findByGovernmentApprovalNumberIgnoreCaseAndStatus_codeNotLike(governmentApprovalNumber, "CANCELLED");
    }

    public String checkAbstractEstimatesWithBOQForLineEstimate(Long lineEstimateId) {
        List<String> listString = this.estimateService.getAbstractEstimateNumbersToCancelLineEstimate(lineEstimateId);
        String estimateNumbers = "";
        for (String estimateNumber : listString) {
            estimateNumbers = estimateNumbers + estimateNumber + ", ";
        }
        if (estimateNumbers.equals("")) {
            return "";
        }
        return estimateNumbers;
    }

    public List<String> getEstimateNumbersForEstimatePhotograph(String estimateNumber) {
        return this.lineEstimateDetailsRepository.findEstimateNumbersForEstimatePhotograph("%" + estimateNumber + "%", "CANCELLED");
    }

    public List<String> getWinForEstimatePhotograph(String workIdentificationNumber) {
        return this.lineEstimateDetailsRepository.findWorkIdentificationNumberForEstimatePhotograph("%" + workIdentificationNumber + "%", "CANCELLED");
    }

    public List<LineEstimateDetails> searchLineEstimatesForEstimatePhotograph(EstimatePhotographSearchRequest estimatePhotographSearchRequest) {
        StringBuilder queryStr = new StringBuilder(500);
        this.buildWhereClauseForEstimatePhotograph(estimatePhotographSearchRequest, queryStr);
        Query query = this.setParameterForEstimatePhotograph(estimatePhotographSearchRequest, queryStr);
        List lineEstimateDetailsList = query.getResultList();
        return lineEstimateDetailsList;
    }

    private void buildWhereClauseForEstimatePhotograph(EstimatePhotographSearchRequest estimatePhotographSearchRequest, StringBuilder queryStr) {
        queryStr.append("select distinct led from LineEstimateDetails as led where led.lineEstimate.status.code != :lineEstimateStatus ");
        if (estimatePhotographSearchRequest.getExecutingDepartment() != null) {
            queryStr.append(" and led.lineEstimate.executingDepartment.id = :executingDepartment");
        }
        if (StringUtils.isNotBlank((String)estimatePhotographSearchRequest.getWorkIdentificationNumber())) {
            queryStr.append(" and upper(led.projectCode.code) = :workIdentificationNumber");
        }
        if (StringUtils.isNotBlank((String)estimatePhotographSearchRequest.getEstimateNumber())) {
            queryStr.append(" and upper(led.estimateNumber) = :estimateNumber");
        }
        if (estimatePhotographSearchRequest.getFromDate() != null) {
            queryStr.append(" and led.lineEstimate.createdDate >= :createdDate");
        }
        if (estimatePhotographSearchRequest.getToDate() != null) {
            queryStr.append(" and led.lineEstimate.createdDate >= :createdDate");
        }
        if (estimatePhotographSearchRequest.getNatureOfWork() != null) {
            queryStr.append(" and led.lineEstimate.natureOfWork.id = :natureOfWork");
        }
    }

    private Query setParameterForEstimatePhotograph(EstimatePhotographSearchRequest estimatePhotographSearchRequest, StringBuilder queryStr) {
        Query qry = this.entityManager.createQuery(queryStr.toString());
        qry.setParameter("lineEstimateStatus", (Object)"CANCELLED");
        if (estimatePhotographSearchRequest != null) {
            if (estimatePhotographSearchRequest.getExecutingDepartment() != null) {
                qry.setParameter("executingDepartment", (Object)estimatePhotographSearchRequest.getExecutingDepartment());
            }
            if (StringUtils.isNotBlank((String)estimatePhotographSearchRequest.getWorkIdentificationNumber())) {
                qry.setParameter("workIdentificationNumber", (Object)estimatePhotographSearchRequest.getWorkIdentificationNumber().toUpperCase());
            }
            if (StringUtils.isNotBlank((String)estimatePhotographSearchRequest.getEstimateNumber())) {
                qry.setParameter("estimateNumber", (Object)estimatePhotographSearchRequest.getEstimateNumber().toUpperCase());
            }
            if (estimatePhotographSearchRequest.getFromDate() != null) {
                qry.setParameter("createdDate", (Object)estimatePhotographSearchRequest.getFromDate());
            }
            if (estimatePhotographSearchRequest.getToDate() != null) {
                qry.setParameter("createdDate", (Object)estimatePhotographSearchRequest.getToDate());
            }
            if (estimatePhotographSearchRequest.getNatureOfWork() != null) {
                qry.setParameter("natureOfWork", (Object)estimatePhotographSearchRequest.getNatureOfWork());
            }
        }
        return qry;
    }

    public Map<String, Object> getWorkFlowLevelFields(LineEstimate lineEstimate) {
        String cityGrade = (String)this.cityService.cityDataAsMap().get("cityGrade");
        return (Map)this.scriptService.executeScript("LINEESTIMATE-APPROVALRULES", ScriptService.createContext((Object[])new Object[]{"estimateAmount", lineEstimate.getTotalEstimateAmount(), "cityGrade", cityGrade}));
    }

    public void validateWorkFlowFields(LineEstimate lineEstimate, BindingResult errors) {
        Map<String, Object> requiredFieldsMap = this.getWorkFlowLevelFields(lineEstimate);
        LineEstimateAppropriation lineEstimateAppropriation = this.lineEstimateAppropriationService.findLatestByLineEstimateDetails_EstimateNumber(lineEstimate.getLineEstimateDetails().get(0).getEstimateNumber());
        DateTime budgetAppropriationDateWithTimeStamp = new DateTime((Object)lineEstimateAppropriation.getBudgetUsage().getUpdatedTime());
        Date budgetAppropriationDate = budgetAppropriationDateWithTimeStamp.toLocalDate().toDate();
        if (requiredFieldsMap != null) {
            if (requiredFieldsMap.get("councilResolutionDetailsRequired") != null && requiredFieldsMap.get("councilResolutionDetailsRequired").equals(true)) {
                if (StringUtils.isBlank((String)lineEstimate.getCouncilResolutionNumber())) {
                    errors.rejectValue("councilResolutionNumber", "error.councilResolutionNumber.required");
                } else {
                    LineEstimate LEByCouncilResolutionNumber = this.getLineEstimateByCouncilResolutionNumber(lineEstimate.getCouncilResolutionNumber());
                    if (LEByCouncilResolutionNumber != null) {
                        errors.rejectValue("councilResolutionNumber", "error.councilresolutionnumber.unique");
                    }
                }
                if (lineEstimate.getCouncilResolutionDate() == null) {
                    errors.rejectValue("councilResolutionDate", "error.councilResolutionDate.required");
                } else if (lineEstimate.getCouncilResolutionDate().before(budgetAppropriationDate)) {
                    errors.rejectValue("councilResolutionDate", "error.councilResolutiondate.lessthan.budgetappropriation");
                }
            }
            if (requiredFieldsMap.get("contractCommitteeDetailsRequired") != null && requiredFieldsMap.get("contractCommitteeDetailsRequired").equals(true)) {
                if (StringUtils.isBlank((String)lineEstimate.getContractCommitteeApprovalNumber())) {
                    errors.rejectValue("contractCommitteeApprovalNumber", "error.contractCommitteeApprovalNumber.required");
                } else {
                    LineEstimate LEByContractCommiiteeApprovalNumber = this.getLineEstimateByContractCommitteeApprovalNumber(lineEstimate.getContractCommitteeApprovalNumber());
                    if (LEByContractCommiiteeApprovalNumber != null) {
                        errors.rejectValue("contractCommitteeApprovalNumber", "error.contractCommitteeApprovalNumber.unique");
                    }
                }
                if (lineEstimate.getContractCommitteeApprovalDate() == null) {
                    errors.rejectValue("contractCommitteeApprovalDate", "error.contractCommitteeApprovalDate.required");
                } else if (lineEstimate.getContractCommitteeApprovalDate().before(budgetAppropriationDate)) {
                    errors.rejectValue("contractCommitteeApprovalDate", "error.contractCommitteeApprovalDate.lessthan.budgetappropriation");
                }
            }
            if (requiredFieldsMap.get("standingCommitteeDetailsRequired") != null && requiredFieldsMap.get("standingCommitteeDetailsRequired").equals(true)) {
                if (StringUtils.isBlank((String)lineEstimate.getStandingCommitteeApprovalNumber())) {
                    errors.rejectValue("standingCommitteeApprovalNumber", "error.standingCommitteeApprovalNumber.required");
                } else {
                    LineEstimate LEByStandingCommiteeApprovalNumber = this.getLineEstimateByStandingCommitteeApprovalNumber(lineEstimate.getStandingCommitteeApprovalNumber());
                    if (LEByStandingCommiteeApprovalNumber != null) {
                        errors.rejectValue("standingCommitteeApprovalNumber", "error.standingCommitteeApprovalNumber.unique");
                    }
                }
                if (lineEstimate.getStandingCommitteeApprovalDate() == null) {
                    errors.rejectValue("standingCommitteeApprovalDate", "error.standingCommitteeApprovalDate.required");
                } else if (lineEstimate.getStandingCommitteeApprovalDate().before(budgetAppropriationDate)) {
                    errors.rejectValue("standingCommitteeApprovalDate", "error.standingCommitteeApprovalDate.lessthan.budgetappropriation");
                }
            }
            if (requiredFieldsMap.get("governmentApprovalRequired") != null && requiredFieldsMap.get("governmentApprovalRequired").equals(true)) {
                if (StringUtils.isBlank((String)lineEstimate.getGovernmentApprovalNumber())) {
                    errors.rejectValue("governmentApprovalNumber", "error.governmentApprovalNumber.required");
                } else {
                    LineEstimate LEByGovernmentApprovalNumber = this.getLineEstimateByGovernmentApprovalNumber(lineEstimate.getGovernmentApprovalNumber());
                    if (LEByGovernmentApprovalNumber != null) {
                        errors.rejectValue("governmentApprovalNumber", "error.governmentApprovalNumber.unique");
                    }
                }
                if (lineEstimate.getGovernmentApprovalDate() == null) {
                    errors.rejectValue("governmentApprovalDate", "error.governmentApprovalDate.required");
                } else if (lineEstimate.getGovernmentApprovalDate().before(budgetAppropriationDate)) {
                    errors.rejectValue("governmentApprovalDate", "error.governmentApprovalDate.lessthan.budgetappropriation");
                }
            }
        }
    }
}

