/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.lineestimate.repository;

import java.util.List;
import org.egov.infra.admin.master.entity.User;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface LineEstimateDetailsRepository
extends JpaRepository<LineEstimateDetails, Long> {
    public List<LineEstimateDetails> findByEstimateNumberContainingIgnoreCase(String var1);

    public LineEstimateDetails findByEstimateNumberAndLineEstimate_Status_CodeEquals(String var1, String var2);

    public LineEstimateDetails findByEstimateNumberAndLineEstimate_Status_CodeNot(String var1, String var2);

    @Query(value="select distinct(led.estimateNumber) from LineEstimateDetails as led where upper(led.estimateNumber) like upper(:estimateNumber) and led.lineEstimate.status.code = :egwStatus and not exists (select distinct(wo.estimateNumber) from WorkOrder as wo where wo.estimateNumber = led.estimateNumber and upper(wo.egwStatus.code) != :status)")
    public List<String> findEstimateNumbersForLoa(@Param(value="estimateNumber") String var1, @Param(value="egwStatus") String var2, @Param(value="status") String var3);

    @Query(value="select distinct(led.estimateNumber) from LineEstimateDetails as led where upper(led.estimateNumber) like :estimateNumber and led.lineEstimate.status.code = :egwStatus and not exists (select distinct(wo.estimateNumber) from WorkOrder as wo where wo.estimateNumber = led.estimateNumber and upper(wo.egwStatus.code) != :status) and  not exists (select distinct(ae.lineEstimateDetails.id) from AbstractEstimate as ae where ae.lineEstimateDetails.id = led.id and upper(ae.egwStatus.code) !=:status)")
    public List<String> findEstimateNumbersForAbstractEstimate(@Param(value="estimateNumber") String var1, @Param(value="egwStatus") String var2, @Param(value="status") String var3);

    @Query(value="select distinct(ae.estimateNumber) from AbstractEstimate as ae where not exists (select distinct(woe.estimate) from WorkOrderEstimate as woe where ae.id = woe.estimate.id and upper(woe.workOrder.egwStatus.code) != :woStatus) and upper(egwStatus.code) = :aeStatus")
    public List<String> findEstimateNumbersToSearchAbstractEstimatesForLoa(@Param(value="aeStatus") String var1, @Param(value="woStatus") String var2);

    @Query(value="select distinct(led.lineEstimate.adminSanctionNumber) from LineEstimateDetails as led  where upper(led.lineEstimate.adminSanctionNumber) like upper(:adminSanctionNumber) and led.lineEstimate.status.code = :egwStatus and not exists (select distinct(woe.estimate.estimateNumber) from WorkOrderEstimate as woe where led.estimateNumber = woe.estimate.estimateNumber and upper(woe.workOrder.egwStatus.code) != :status) and  not exists (select distinct(ae.lineEstimateDetails.id) from AbstractEstimate as ae where ae.lineEstimateDetails.id = led.id and upper(ae.egwStatus.code) !=:status)")
    public List<String> findAdminSanctionNumbersForAbstractEstimate(@Param(value="adminSanctionNumber") String var1, @Param(value="egwStatus") String var2, @Param(value="status") String var3);

    @Query(value="select distinct(ae.lineEstimateDetails.lineEstimate.adminSanctionNumber) from AbstractEstimate as ae  where upper(ae.lineEstimateDetails.lineEstimate.adminSanctionNumber) like :adminSanctionNumber and ae.egwStatus.code = :egwStatus and not exists (select distinct(woe.estimate) from WorkOrderEstimate as woe where ae.id = woe.estimate.id and upper(woe.workOrder.egwStatus.code) != :woStatus)")
    public List<String> findAdminSanctionNumbersForLoa(@Param(value="adminSanctionNumber") String var1, @Param(value="egwStatus") String var2, @Param(value="woStatus") String var3);

    @Query(value="select distinct(estimateNumber) from LineEstimateDetails as led where led.lineEstimate.executingDepartment.id = :departmentId")
    public List<String> findEstimateNumbersForDepartment(@Param(value="departmentId") Long var1);

    @Query(value="select distinct(led.projectCode.code) from LineEstimateDetails as led  where upper(led.projectCode.code) like :code and upper(led.lineEstimate.status.code) =:leStatus and not exists (select distinct(woe.estimate.estimateNumber) from WorkOrderEstimate as woe where led.estimateNumber = woe.estimate.estimateNumber and upper(woe.workOrder.egwStatus.code) != :woStatus)")
    public List<String> findWorkIdentificationNumbersToSearchEstimates(@Param(value="code") String var1, @Param(value="woStatus") String var2, @Param(value="leStatus") String var3);

    @Query(value="select distinct(ae.projectCode.code) from AbstractEstimate as ae  where upper(ae.egwStatus.code) =:aeStatus and upper(ae.projectCode.code) like :code and not exists (select distinct(woe.estimate) from WorkOrderEstimate as woe where ae.id = woe.estimate.id and upper(woe.workOrder.egwStatus.code) != :woStatus)")
    public List<String> findWorkIdentificationNumbersToSearchEstimatesForLoa(@Param(value="code") String var1, @Param(value="woStatus") String var2, @Param(value="aeStatus") String var3);

    @Query(value="select distinct(estimateNumber) from LineEstimateDetails as led where upper(led.projectCode.code) = upper(:workIdentificationNumber)")
    public List<String> findEstimateNumbersForWorkIdentificationNumber(@Param(value="workIdentificationNumber") String var1);

    @Query(value="select distinct(estimateNumber) from LineEstimateDetails as led where led.lineEstimate.spillOverFlag = :spillOverFlag")
    public List<String> findEstimateNumbersForSpillOverFlag(@Param(value="spillOverFlag") boolean var1);

    @Query(value="select distinct(led.projectCode.code) from LineEstimateDetails as led  where upper(led.projectCode.code) like upper(:code) and led.lineEstimate.status.code in (:adminSanctionstatus, :technicalSanctionstatus)")
    public List<String> findWorkIdentificationNumbersToSearchWorkProgressRegister(@Param(value="code") String var1, @Param(value="adminSanctionstatus") String var2, @Param(value="technicalSanctionstatus") String var3);

    @Query(value="select distinct(led.lineEstimate.createdBy) from LineEstimateDetails as led where led.lineEstimate.executingDepartment.id = :department and led.lineEstimate.status.code in(:lineEstimateStatus1, :lineEstimateStatus2 ) and not exists (select distinct(woe.estimate.estimateNumber) from WorkOrderEstimate as woe where led.estimateNumber = woe.estimate.estimateNumber and upper(woe.workOrder.egwStatus.code) = :workOrderStatus)")
    public List<User> findCreatedByForCancelLineEstimateByDepartment(@Param(value="department") Long var1, @Param(value="lineEstimateStatus1") String var2, @Param(value="lineEstimateStatus2") String var3, @Param(value="workOrderStatus") String var4);

    public LineEstimateDetails findByProjectCode_codeAndLineEstimate_Status_CodeNotLike(String var1, String var2);

    @Query(value="select distinct(led.estimateNumber) from LineEstimateDetails as led where upper(led.estimateNumber) like upper(:estimateNumber) and led.lineEstimate.status.code != :lineEstimateStatus")
    public List<String> findEstimateNumbersForEstimatePhotograph(@Param(value="estimateNumber") String var1, @Param(value="lineEstimateStatus") String var2);

    @Query(value="select distinct(led.projectCode.code) from LineEstimateDetails as led where upper(led.projectCode.code) like upper(:workIdentificationNumber) and led.lineEstimate.status.code != :lineEstimateStatus")
    public List<String> findWorkIdentificationNumberForEstimatePhotograph(@Param(value="workIdentificationNumber") String var1, @Param(value="lineEstimateStatus") String var2);
}

