/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.lineestimate.entity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.works.abstractestimate.entity.EstimatePhotographs;
import org.egov.works.abstractestimate.entity.ProjectCode;
import org.egov.works.lineestimate.entity.LineEstimate;
import org.egov.works.lineestimate.entity.LineEstimateAppropriation;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="EGW_LINEESTIMATE_DETAILS")
@Unique(id="id", tableName="EGW_LINEESTIMATE_DETAILS", columnName={"estimatenumber"}, fields={"estimateNumber"}, enableDfltMsg=true)
@SequenceGenerator(name="SEQ_EGW_LINEESTIMATE_DETAILS", sequenceName="SEQ_EGW_LINEESTIMATE_DETAILS", allocationSize=1)
public class LineEstimateDetails
extends AbstractAuditable {
    private static final long serialVersionUID = -788818018131193299L;
    public static final String SEQ_EGW_LINEESTIMATE_DETAILS = "SEQ_EGW_LINEESTIMATE_DETAILS";
    @DocumentId
    @Id
    @GeneratedValue(generator="SEQ_EGW_LINEESTIMATE_DETAILS", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="lineestimate", nullable=false)
    private LineEstimate lineEstimate;
    @NotNull
    @SafeHtml
    @Length(max=1024)
    private String nameOfWork;
    @NotNull
    private BigDecimal estimateAmount;
    @NotNull
    @SafeHtml
    @Length(max=50)
    private String estimateNumber;
    @NotNull
    @Length(max=50)
    private double quantity;
    @NotNull
    @Length(max=50)
    private String uom;
    @NotNull
    @Length(max=50)
    private String beneficiary;
    private BigDecimal actualEstimateAmount;
    private BigDecimal grossAmountBilled;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="projectCode")
    private ProjectCode projectCode;
    @OneToMany(mappedBy="lineEstimateDetails", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=LineEstimateAppropriation.class)
    private List<LineEstimateAppropriation> lineEstimateAppropriations = new ArrayList<LineEstimateAppropriation>(0);
    @OrderBy(value="id")
    @OneToMany(mappedBy="lineEstimateDetails", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=EstimatePhotographs.class)
    private List<EstimatePhotographs> estimatePhotographsList = new ArrayList<EstimatePhotographs>(0);

    public List<EstimatePhotographs> getEstimatePhotographsList() {
        return this.estimatePhotographsList;
    }

    public void setEstimatePhotographsList(List<EstimatePhotographs> estimatePhotographsList) {
        this.estimatePhotographsList = estimatePhotographsList;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LineEstimate getLineEstimate() {
        return this.lineEstimate;
    }

    public void setLineEstimate(LineEstimate lineEstimate) {
        this.lineEstimate = lineEstimate;
    }

    public String getNameOfWork() {
        return this.nameOfWork;
    }

    public void setNameOfWork(String nameOfWork) {
        this.nameOfWork = nameOfWork;
    }

    public BigDecimal getEstimateAmount() {
        return this.estimateAmount;
    }

    public void setEstimateAmount(BigDecimal estimateAmount) {
        this.estimateAmount = estimateAmount;
    }

    public String getEstimateNumber() {
        return this.estimateNumber;
    }

    public void setEstimateNumber(String estimateNumber) {
        this.estimateNumber = estimateNumber;
    }

    public String getUom() {
        return this.uom;
    }

    public void setUom(String uom) {
        this.uom = uom;
    }

    public String getBeneficiary() {
        return this.beneficiary;
    }

    public void setBeneficiary(String beneficiary) {
        this.beneficiary = beneficiary;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getActualEstimateAmount() {
        return this.actualEstimateAmount;
    }

    public void setActualEstimateAmount(BigDecimal actualEstimateAmount) {
        this.actualEstimateAmount = actualEstimateAmount;
    }

    public ProjectCode getProjectCode() {
        return this.projectCode;
    }

    public void setProjectCode(ProjectCode projectCode) {
        this.projectCode = projectCode;
    }

    public List<LineEstimateAppropriation> getLineEstimateAppropriations() {
        return this.lineEstimateAppropriations;
    }

    public void setLineEstimateAppropriations(List<LineEstimateAppropriation> lineEstimateAppropriations) {
        this.lineEstimateAppropriations = lineEstimateAppropriations;
    }

    public BigDecimal getGrossAmountBilled() {
        return this.grossAmountBilled;
    }

    public void setGrossAmountBilled(BigDecimal grossAmountBilled) {
        this.grossAmountBilled = grossAmountBilled;
    }
}

