/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.letterofacceptance.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.egf.budget.model.BudgetControlType;
import org.egov.egf.budget.service.BudgetControlTypeService;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.abstractestimate.entity.AssetsForEstimate;
import org.egov.works.abstractestimate.entity.MeasurementSheet;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.contractorbill.entity.enums.BillTypes;
import org.egov.works.contractorbill.repository.ContractorBillRegisterRepository;
import org.egov.works.letterofacceptance.entity.SearchRequestContractor;
import org.egov.works.letterofacceptance.entity.SearchRequestLetterOfAcceptance;
import org.egov.works.letterofacceptance.entity.WorkOrderHistory;
import org.egov.works.letterofacceptance.repository.LetterOfAcceptanceRepository;
import org.egov.works.letterofacceptance.repository.WorkOrderHistoryRepository;
import org.egov.works.lineestimate.entity.DocumentDetails;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.repository.LineEstimateDetailsRepository;
import org.egov.works.lineestimate.service.LineEstimateAppropriationService;
import org.egov.works.lineestimate.service.LineEstimateDetailService;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.mb.service.MBHeaderService;
import org.egov.works.milestone.entity.Milestone;
import org.egov.works.milestone.service.MilestoneService;
import org.egov.works.models.masters.ContractorDetail;
import org.egov.works.utils.WorksConstants;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorder.entity.AssetsForWorkOrder;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderActivity;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.egov.works.workorder.entity.WorkOrderMeasurementSheet;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.sql.JoinType;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class LetterOfAcceptanceService {
    private static final Logger LOG = LoggerFactory.getLogger(LetterOfAcceptanceService.class);
    @PersistenceContext
    private EntityManager entityManager;
    private final LetterOfAcceptanceRepository letterOfAcceptanceRepository;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private LineEstimateDetailsRepository lineEstimateDetailsRepository;
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private LineEstimateDetailService lineEstimateDetailService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private LineEstimateAppropriationService lineEstimateAppropriationService;
    @Autowired
    private WorkOrderHistoryRepository workOrderHistoryRepository;
    @Autowired
    private ContractorBillRegisterRepository contractorBillRegisterRepository;
    @Autowired
    private EstimateService estimateService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private MilestoneService milestoneService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<WorkOrder> workOrderWorkflowService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private MBHeaderService mBHeaderService;
    @Autowired
    private BudgetControlTypeService budgetControlTypeService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Autowired
    public LetterOfAcceptanceService(LetterOfAcceptanceRepository letterOfAcceptanceRepository) {
        this.letterOfAcceptanceRepository = letterOfAcceptanceRepository;
    }

    public WorkOrder getWorkOrderById(Long id) {
        return this.letterOfAcceptanceRepository.findById(id);
    }

    public List<String> getApprovedWorkOrderByNumber(String workOrderNumber) {
        return this.letterOfAcceptanceRepository.findDistinctWorkOrderNumberContainingIgnoreCase("%" + workOrderNumber + "%");
    }

    @Transactional
    public WorkOrder create(WorkOrder workOrder, MultipartFile[] files, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction, AbstractEstimate abstractEstimate) throws IOException {
        if (StringUtils.isNotBlank((String)workOrder.getPercentageSign()) && workOrder.getPercentageSign().equals("-")) {
            workOrder.setTenderFinalizedPercentage(workOrder.getTenderFinalizedPercentage() * -1.0);
        }
        workOrder.setTotalIncludingRE(workOrder.getWorkOrderAmount());
        workOrder = this.createWorkOrderActivities(workOrder);
        workOrder = this.createAssetsForWorkOrder(workOrder);
        WorkOrder savedworkOrder = null;
        if (abstractEstimate != null && abstractEstimate.getLineEstimateDetails() != null && abstractEstimate.getLineEstimateDetails().getLineEstimate().isSpillOverFlag() && abstractEstimate.getLineEstimateDetails().getLineEstimate().isWorkOrderCreated()) {
            workOrder.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("WorkOrder", "APPROVED"));
        } else {
            this.createWorkOrderWorkflowTransition(workOrder, approvalPosition, approvalComent, additionalRule, workFlowAction);
        }
        savedworkOrder = (WorkOrder)((Object)this.letterOfAcceptanceRepository.save((Object)workOrder));
        List<DocumentDetails> documentDetails = this.worksUtils.getDocumentDetails(files, (Object)savedworkOrder, "WorkOrder");
        if (!documentDetails.isEmpty()) {
            savedworkOrder.setDocumentDetails(documentDetails);
            this.worksUtils.persistDocuments(documentDetails);
        }
        return savedworkOrder;
    }

    public void createWorkOrderWorkflowTransition(WorkOrder workOrder, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(" Create WorkFlow Transition Started  ...");
        }
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        Assignment userAssignment = this.assignmentService.getPrimaryAssignmentForUser(user.getId());
        Position pos = null;
        Assignment wfInitiator = null;
        String currState = "";
        String natureOfwork = "Letter Of Acceptance";
        WorkFlowMatrix wfmatrix = null;
        if (null != workOrder.getId()) {
            wfInitiator = this.assignmentService.getPrimaryAssignmentForUser(workOrder.getCreatedBy().getId());
        }
        if (WorksConstants.REJECT_ACTION.toString().equalsIgnoreCase(workFlowAction)) {
            workOrder.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("WorkOrder", "REJECTED"));
            if (wfInitiator.equals(userAssignment)) {
                workOrder.transition(true).end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNatureOfTask("Letter Of Acceptance");
            } else {
                workOrder.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("").withNatureOfTask("Letter Of Acceptance");
            }
        } else if ("Save".toString().equalsIgnoreCase(workFlowAction)) {
            wfmatrix = this.workOrderWorkflowService.getWfMatrix(workOrder.getStateType(), null, new BigDecimal(workOrder.getWorkOrderAmount()), additionalRule, "NEW", null);
            if (workOrder.getState() == null) {
                workOrder.transition(true).start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("NEW").withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Letter Of Acceptance");
            } else {
                workOrder.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("NEW").withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Letter Of Acceptance");
            }
        } else {
            if (null != approvalPosition && approvalPosition != -1L && !approvalPosition.equals(0L)) {
                pos = this.positionMasterService.getPositionById(approvalPosition);
            }
            if (null == workOrder.getState()) {
                workOrder.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("WorkOrder", "CREATED"));
                wfmatrix = this.workOrderWorkflowService.getWfMatrix(workOrder.getStateType(), null, new BigDecimal(workOrder.getWorkOrderAmount()), additionalRule, "", null);
                workOrder.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Letter Of Acceptance");
            } else if ("Cancel".toString().equalsIgnoreCase(workFlowAction)) {
                workOrder.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("WorkOrder", "CANCELLED"));
                String stateValue = "Cancelled";
                wfmatrix = this.workOrderWorkflowService.getWfMatrix(workOrder.getStateType(), null, null, additionalRule, workOrder.getCurrentState().getValue(), null);
                workOrder.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Cancelled").withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction("").withNatureOfTask("Letter Of Acceptance");
            } else if ("Approve".toString().equalsIgnoreCase(workFlowAction)) {
                wfmatrix = this.workOrderWorkflowService.getWfMatrix(workOrder.getStateType(), null, null, additionalRule, workOrder.getCurrentState().getValue(), null);
                workOrder.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction("").withNatureOfTask("Letter Of Acceptance");
            } else {
                if (workOrder.getEgwStatus().getCode().equals("REJECTED".toString()) && workFlowAction.equals(WorksConstants.FORWARD_ACTION)) {
                    workOrder.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("WorkOrder", "RESUBMITTED"));
                } else {
                    workOrder.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("WorkOrder", "CREATED"));
                }
                wfmatrix = this.workOrderWorkflowService.getWfMatrix(workOrder.getStateType(), null, new BigDecimal(workOrder.getWorkOrderAmount()), additionalRule, workOrder.getCurrentState().getValue(), workOrder.getState().getNextAction());
                workOrder.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Letter Of Acceptance");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" WorkFlow Transition Completed  ...");
        }
    }

    public Long getApprovalPositionByMatrixDesignation(WorkOrder workOrder, Long approvalPosition, String additionalRule, String mode, String workFlowAction) {
        WorkFlowMatrix wfmatrix = this.workOrderWorkflowService.getWfMatrix(workOrder.getStateType(), null, null, additionalRule, workOrder.getCurrentState().getValue(), null);
        if (workOrder.getEgwStatus() != null && workOrder.getEgwStatus().getCode() != null && (workOrder.getEgwStatus().getCode().equals("CREATED") || workOrder.getEgwStatus().getCode().equals("RESUBMITTED")) && workOrder.getState() != null) {
            approvalPosition = mode.equals("edit") ? workOrder.getState().getOwnerPosition().getId() : this.worksUtils.getApproverPosition(wfmatrix.getNextDesignation(), workOrder.getState(), workOrder.getCreatedBy().getId());
        }
        if (workFlowAction.equals("Cancel") && wfmatrix.getNextState().equals("Created")) {
            approvalPosition = null;
        }
        return approvalPosition;
    }

    private WorkOrder createAssetsForWorkOrder(WorkOrder workOrder) {
        WorkOrderEstimate workOrderEstimate;
        AssetsForWorkOrder assetsForWorkOrder = null;
        WorkOrderEstimate workOrderEstimate2 = workOrderEstimate = workOrder.getWorkOrderEstimates() != null ? workOrder.getWorkOrderEstimates().get(0) : null;
        if (workOrderEstimate != null) {
            workOrderEstimate.getAssetValues().clear();
            for (AssetsForEstimate assetsForEstimate : workOrderEstimate.getEstimate().getAssetValues()) {
                assetsForWorkOrder = new AssetsForWorkOrder();
                assetsForWorkOrder.setAsset(assetsForEstimate.getAsset());
                assetsForWorkOrder.setWorkOrderEstimate(workOrderEstimate);
                workOrder.getWorkOrderEstimates().get(0).getAssetValues().add(assetsForWorkOrder);
            }
        }
        return workOrder;
    }

    private WorkOrder createWorkOrderActivities(WorkOrder workOrder) {
        WorkOrderEstimate workOrderEstimate;
        WorkOrderActivity workOrderActivity = null;
        Double tenderFinalizedPercentage = workOrder.getTenderFinalizedPercentage();
        WorkOrderEstimate workOrderEstimate2 = workOrderEstimate = workOrder.getWorkOrderEstimates() != null ? workOrder.getWorkOrderEstimates().get(0) : null;
        if (workOrderEstimate != null) {
            workOrderEstimate.getWorkOrderActivities().clear();
            for (Activity activity : workOrderEstimate.getEstimate().getActivities()) {
                workOrderActivity = new WorkOrderActivity();
                if (!tenderFinalizedPercentage.equals(0.0)) {
                    workOrderActivity.setApprovedRate(activity.getRate() + activity.getRate() * workOrder.getTenderFinalizedPercentage() / 100.0);
                } else {
                    workOrderActivity.setApprovedRate(activity.getRate());
                }
                workOrderActivity.setApprovedQuantity(activity.getQuantity());
                workOrderActivity.setApprovedAmount(workOrderActivity.getApprovedRate() * workOrderActivity.getApprovedQuantity());
                this.createWorkOrderMSheet(workOrderActivity, activity);
                workOrderActivity.setActivity(activity);
                workOrderActivity.setWorkOrderEstimate(workOrderEstimate);
                workOrder.getWorkOrderEstimates().get(0).getWorkOrderActivities().add(workOrderActivity);
            }
        }
        return workOrder;
    }

    private void createWorkOrderMSheet(WorkOrderActivity workOrderActivity, Activity activity) {
        LOG.info("adding Msheet to work order......");
        ArrayList<WorkOrderMeasurementSheet> womSheetList = new ArrayList<WorkOrderMeasurementSheet>();
        WorkOrderMeasurementSheet womSheet = null;
        for (MeasurementSheet msheet : activity.getMeasurementSheetList()) {
            womSheet = new WorkOrderMeasurementSheet();
            womSheet.setNo(msheet.getNo());
            womSheet.setLength(msheet.getLength());
            womSheet.setWidth(msheet.getWidth());
            womSheet.setDepthOrHeight(msheet.getDepthOrHeight());
            womSheet.setWoActivity(workOrderActivity);
            womSheet.setQuantity(msheet.getQuantity());
            womSheet.setMeasurementSheet(msheet);
            womSheetList.add(womSheet);
            LOG.info("added msheet" + msheet.getId());
        }
        workOrderActivity.setWorkOrderMeasurementSheets(womSheetList);
    }

    public WorkOrderEstimate createWorkOrderEstimate(WorkOrder workOrder) {
        workOrder.getWorkOrderEstimates().clear();
        WorkOrderEstimate workOrderEstimate = new WorkOrderEstimate();
        workOrderEstimate.setWorkOrder(workOrder);
        workOrderEstimate.setEstimate(this.estimateService.getAbstractEstimateByEstimateNumberAndStatus(workOrder.getEstimateNumber()));
        workOrderEstimate.setEstimateWOAmount(workOrder.getWorkOrderAmount());
        workOrder.addWorkOrderEstimate(workOrderEstimate);
        return workOrderEstimate;
    }

    public WorkOrder getWorkOrderByWorkOrderNumber(String workOrderNumber) {
        return this.letterOfAcceptanceRepository.findByWorkOrderNumberAndEgwStatus_codeNotLike(workOrderNumber, "CANCELLED");
    }

    public List<Long> getEngineerInchargeDesignationIds() {
        ArrayList<Long> designationIds = new ArrayList<Long>();
        ArrayList<String> designationNames = new ArrayList<String>();
        List configList = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "ENGINEERINCHARGE_DESIGNATION");
        for (AppConfigValues value : configList) {
            designationNames.add(value.getValue().toUpperCase());
        }
        List designations = this.designationService.getDesignationsByNames(designationNames);
        for (Designation designation : designations) {
            designationIds.add(designation.getId());
        }
        return designationIds;
    }

    public List<Assignment> getEngineerInchargeList(Long departmentId, List<Long> designationIds) {
        return this.assignmentService.findByDepartmentDesignationsAndGivenDate(departmentId, designationIds, new Date());
    }

    public WorkOrder getWorkOrderByEstimateNumber(String estimateNumber) {
        return this.letterOfAcceptanceRepository.findByEstimateNumberAndEgwStatus_codeNotLike(estimateNumber, "CANCELLED");
    }

    public WorkOrder getLetterOfAcceptanceDocumentAttachments(WorkOrder workOrder) {
        ArrayList<DocumentDetails> documentDetailsList = new ArrayList();
        documentDetailsList = this.worksUtils.findByObjectIdAndObjectType(workOrder.getId(), "WorkOrder");
        workOrder.setDocumentDetails(documentDetailsList);
        return workOrder;
    }

    public WorkOrder getApprovedWorkOrder(String workOrderNumber) {
        return this.letterOfAcceptanceRepository.findByWorkOrderNumberAndEgwStatus_codeEquals(workOrderNumber, "APPROVED");
    }

    public List<WorkOrder> searchLetterOfAcceptance(SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance) {
        List<String> estimateNumbers = this.lineEstimateDetailsRepository.findEstimateNumbersForDepartment(searchRequestLetterOfAcceptance.getDepartmentName());
        if (estimateNumbers.isEmpty()) {
            estimateNumbers.add("");
        }
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(WorkOrder.class, "wo").addOrder(Order.asc((String)"workOrderDate")).createAlias("wo.contractor", "woc").createAlias("egwStatus", "status");
        criteria.add(Restrictions.isNull((String)"parent.id"));
        if (searchRequestLetterOfAcceptance != null) {
            if (searchRequestLetterOfAcceptance.getWorkOrderNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"workOrderNumber", (Object)searchRequestLetterOfAcceptance.getWorkOrderNumber()).ignoreCase());
            }
            if (searchRequestLetterOfAcceptance.getFromDate() != null) {
                criteria.add((Criterion)Restrictions.ge((String)"workOrderDate", (Object)searchRequestLetterOfAcceptance.getFromDate()));
            }
            if (searchRequestLetterOfAcceptance.getToDate() != null) {
                criteria.add((Criterion)Restrictions.le((String)"workOrderDate", (Object)searchRequestLetterOfAcceptance.getToDate()));
            }
            if (searchRequestLetterOfAcceptance.getName() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"woc.name", (Object)searchRequestLetterOfAcceptance.getName()).ignoreCase());
            }
            if (searchRequestLetterOfAcceptance.getFileNumber() != null) {
                criteria.add(Restrictions.ilike((String)"fileNumber", (String)searchRequestLetterOfAcceptance.getFileNumber(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (searchRequestLetterOfAcceptance.getEstimateNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"estimateNumber", (Object)searchRequestLetterOfAcceptance.getEstimateNumber()).ignoreCase());
            }
            if (searchRequestLetterOfAcceptance.getDepartmentName() != null) {
                criteria.add(Restrictions.in((String)"estimateNumber", estimateNumbers));
            }
            if (searchRequestLetterOfAcceptance.getEgwStatus() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"status.code", (Object)searchRequestLetterOfAcceptance.getEgwStatus()));
            }
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public List<WorkOrderEstimate> searchLetterOfAcceptanceForContractorBill(SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance) {
        ArrayList<WorkOrderEstimate> workOrderEstimateList = new ArrayList();
        StringBuilder queryStr = new StringBuilder(500);
        this.getWorkOrdersWhereBoqIsCreated(searchRequestLetterOfAcceptance, queryStr);
        Query query = this.setParameterForLetterOfAcceptanceForContractorBill(searchRequestLetterOfAcceptance, queryStr);
        query.setParameter("offlineStatus", (Object)WorkOrder.OfflineStatuses.WORK_COMMENCED.toString().toLowerCase());
        query.setParameter("objectType", (Object)"WorkOrder");
        workOrderEstimateList = query.getResultList();
        if (searchRequestLetterOfAcceptance.getMbRefNumber() == null || searchRequestLetterOfAcceptance.getMbRefNumber().isEmpty()) {
            queryStr = new StringBuilder(500);
            this.getWorkOrdersWhereBoqIsNotCreated(searchRequestLetterOfAcceptance, queryStr);
            query = this.setParameterForLetterOfAcceptanceForContractorBill(searchRequestLetterOfAcceptance, queryStr);
            workOrderEstimateList.addAll(query.getResultList());
        }
        return workOrderEstimateList;
    }

    private Query setParameterForLetterOfAcceptanceForContractorBill(SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance, StringBuilder queryStr) {
        Query qry = this.entityManager.createQuery(queryStr.toString());
        qry.setParameter("woStatus", (Object)"APPROVED");
        if (queryStr.toString().indexOf("mbStatus") != -1) {
            qry.setParameter("mbStatus", (Object)"APPROVED");
        }
        qry.setParameter("billStatus", (Object)ContractorBillRegister.BillStatus.CANCELLED.toString());
        qry.setParameter("billType", (Object)BillTypes.Final_Bill.toString());
        if (searchRequestLetterOfAcceptance != null) {
            if (searchRequestLetterOfAcceptance.getDepartmentName() != null) {
                qry.setParameter("executingDepartment", (Object)searchRequestLetterOfAcceptance.getDepartmentName());
            }
            if (searchRequestLetterOfAcceptance.getWorkOrderNumber() != null) {
                qry.setParameter("workOrderNumber", (Object)searchRequestLetterOfAcceptance.getWorkOrderNumber());
            }
            if (searchRequestLetterOfAcceptance.getFromDate() != null) {
                qry.setParameter("fromWorkOrderDate", (Object)searchRequestLetterOfAcceptance.getFromDate());
            }
            if (searchRequestLetterOfAcceptance.getToDate() != null) {
                qry.setParameter("toWorkOrderDate", (Object)searchRequestLetterOfAcceptance.getToDate());
            }
            if (searchRequestLetterOfAcceptance.getName() != null) {
                qry.setParameter("contractorName", (Object)searchRequestLetterOfAcceptance.getName().toUpperCase());
            }
            if (searchRequestLetterOfAcceptance.getEstimateNumber() != null) {
                qry.setParameter("estimateNumber", (Object)searchRequestLetterOfAcceptance.getEstimateNumber().toUpperCase());
            }
            if (searchRequestLetterOfAcceptance.getMbRefNumber() != null && !searchRequestLetterOfAcceptance.getMbRefNumber().isEmpty()) {
                qry.setParameter("mbRefNo", (Object)searchRequestLetterOfAcceptance.getMbRefNumber().toUpperCase());
            }
        }
        return qry;
    }

    private void getWorkOrdersWhereBoqIsNotCreated(SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance, StringBuilder queryStr) {
        queryStr.append(" select distinct woe from WorkOrderEstimate woe where woe.workOrder.egwStatus.code = :woStatus and not exists (select cbr.workOrderEstimate from ContractorBillRegister as cbr where woe.id = cbr.workOrderEstimate.id and  upper(cbr.billstatus) != :billStatus and cbr.billtype = :billType and cbr.workOrderEstimate.id is not null) and  not exists (select workOrderEstimate  from WorkOrderActivity where woe.id =workOrderEstimate.id ) ");
        if (searchRequestLetterOfAcceptance != null) {
            this.getSubQuery(searchRequestLetterOfAcceptance, queryStr);
        }
    }

    private void getWorkOrdersWhereBoqIsCreated(SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance, StringBuilder queryStr) {
        queryStr.append(" select distinct woe from WorkOrderEstimate woe where woe.workOrder.parent is null and woe.workOrder.egwStatus.code = :woStatus and  not exists (select distinct(cbr.workOrderEstimate) from ContractorBillRegister as cbr where woe.id = cbr.workOrderEstimate.id and upper(cbr.billstatus) !=:billStatus and cbr.billtype =:billType and cbr.workOrderEstimate.id is not null) ");
        queryStr.append(" and exists (select workOrderEstimate  from WorkOrderActivity where woe.id =workOrderEstimate.id ) ");
        queryStr.append(" and  exists (select mb.workOrderEstimate from MBHeader mb where mb.egwStatus.code =:mbStatus and woe = mb.workOrderEstimate and not exists (select cbr from ContractorBillRegister cbr where upper(cbr.billstatus) != :billStatus and cbr = mb.egBillregister) ");
        if (searchRequestLetterOfAcceptance != null && searchRequestLetterOfAcceptance.getMbRefNumber() != null) {
            queryStr.append(" and upper(mb.mbRefNo) =:mbRefNo ) ");
        } else {
            queryStr.append(")");
        }
        queryStr.append(" and exists ( select distinct(woe1) from WorkOrderEstimate as woe1 where woe1 = woe and woe1.workOrder.id = (select distinct(os.objectId) from OfflineStatus as os where os.id = (select max(status.id) from OfflineStatus status where status.objectType = :objectType and status.objectId = woe1.workOrder.id) and os.objectId = woe1.workOrder.id and lower(os.egwStatus.code) = :offlineStatus and os.objectType = :objectType ) ) ");
        if (searchRequestLetterOfAcceptance != null) {
            this.getSubQuery(searchRequestLetterOfAcceptance, queryStr);
        }
    }

    private void getSubQuery(SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance, StringBuilder queryStr) {
        if (searchRequestLetterOfAcceptance.getDepartmentName() != null) {
            queryStr.append(" and woe.estimate.executingDepartment.id =:executingDepartment ");
        }
        if (searchRequestLetterOfAcceptance.getWorkOrderNumber() != null) {
            queryStr.append(" and woe.workOrder.workOrderNumber =:workOrderNumber ");
        }
        if (searchRequestLetterOfAcceptance.getFromDate() != null) {
            queryStr.append(" and woe.workOrder.workOrderDate >=:fromWorkOrderDate ");
        }
        if (searchRequestLetterOfAcceptance.getToDate() != null) {
            queryStr.append(" and woe.workOrder.workOrderDate <=:toWorkOrderDate ");
        }
        if (searchRequestLetterOfAcceptance.getName() != null) {
            queryStr.append(" and upper(woe.workOrder.contractor.name) =:contractorName ");
        }
        if (searchRequestLetterOfAcceptance.getEstimateNumber() != null) {
            queryStr.append(" and upper(woe.workOrder.estimateNumber) =:estimateNumber ");
        }
    }

    public List<String> getApprovedEstimateNumbersToModifyLOA(String name) {
        return this.letterOfAcceptanceRepository.findDistinctEstimateNumberToModifyLOA("%" + name + "%", "APPROVED", ContractorBillRegister.BillStatus.CANCELLED.toString(), BillTypes.Final_Bill.toString());
    }

    public List<String> findDistinctContractorsInWorkOrderByCodeOrName(String name) {
        List<String> results = this.letterOfAcceptanceRepository.findDistinctContractorByContractor_codeAndNameContainingIgnoreCase("%" + name + "%");
        return results;
    }

    public List<String> findLoaEstimateNumbersForContractorBill(String estimateNumber) {
        List<WorkOrder> workorders = this.letterOfAcceptanceRepository.findByEstimateNumberAndEgwStatus_codeEquals(estimateNumber, "APPROVED");
        ArrayList<String> results = new ArrayList<String>();
        for (WorkOrder details : workorders) {
            results.add(details.getEstimateNumber());
        }
        return results;
    }

    public List<String> getApprovedWorkOrdersForCreateContractorBill(String workOrderNumber) {
        HashSet<String> result = new HashSet<String>();
        List<String> results = this.letterOfAcceptanceRepository.findWorkOrderNumberForContractorBill("%" + workOrderNumber + "%", "APPROVED", ContractorBillRegister.BillStatus.CANCELLED.toString(), BillTypes.Final_Bill.toString());
        results.addAll(this.letterOfAcceptanceRepository.findWorkOrderNumberForContractorBillWithMB("%" + workOrderNumber + "%", "APPROVED", ContractorBillRegister.BillStatus.CANCELLED.toString(), BillTypes.Final_Bill.toString()));
        result.addAll(results);
        return new ArrayList<String>(result);
    }

    public List<String> getApprovedEstimateNumbersForCreateContractorBill(String estimateNumber) {
        HashSet<String> result = new HashSet<String>();
        List<String> results = this.letterOfAcceptanceRepository.findEstimateNumberForContractorBill("%" + estimateNumber + "%", "APPROVED", ContractorBillRegister.BillStatus.CANCELLED.toString(), BillTypes.Final_Bill.toString());
        results.addAll(this.letterOfAcceptanceRepository.findEstimateNumberForContractorBillWithMB("%" + estimateNumber + "%", "APPROVED", ContractorBillRegister.BillStatus.CANCELLED.toString(), BillTypes.Final_Bill.toString()));
        result.addAll(results);
        return new ArrayList<String>(result);
    }

    public List<String> getApprovedContractorsForCreateContractorBill(String contractorname) {
        HashSet<String> result = new HashSet<String>();
        List<String> results = this.letterOfAcceptanceRepository.findContractorForContractorBill("%" + contractorname + "%", "APPROVED", ContractorBillRegister.BillStatus.CANCELLED.toString(), BillTypes.Final_Bill.toString());
        results.addAll(this.letterOfAcceptanceRepository.findContractorForContractorBillWithMB("%" + contractorname + "%", "APPROVED", ContractorBillRegister.BillStatus.CANCELLED.toString(), BillTypes.Final_Bill.toString()));
        result.addAll(results);
        return new ArrayList<String>(result);
    }

    public Boolean validateContractorBillInWorkflowForWorkorder(Long workOrderId) {
        List<String> results = this.letterOfAcceptanceRepository.getContractorBillInWorkflowForWorkorder(workOrderId, ContractorBillRegister.BillStatus.CANCELLED.toString(), ContractorBillRegister.BillStatus.APPROVED.toString());
        if (results.isEmpty()) {
            return true;
        }
        return false;
    }

    public List<ContractorDetail> searchContractorDetails(SearchRequestContractor searchRequestContractor) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(ContractorDetail.class, "cd").createAlias("contractor", "contractor");
        if (searchRequestContractor != null) {
            if (searchRequestContractor.getDepartment() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"department.id", (Object)searchRequestContractor.getDepartment()));
            }
            if (searchRequestContractor.getContractorClass() != null) {
                criteria.add((Criterion)Restrictions.ge((String)"grade.id", (Object)searchRequestContractor.getContractorClass()));
            }
            if (searchRequestContractor.getContractorCode() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"contractor.code", (Object)searchRequestContractor.getContractorCode()).ignoreCase());
            }
            if (searchRequestContractor.getNameOfAgency() != null) {
                criteria.add(Restrictions.ilike((String)"contractor.name", (String)searchRequestContractor.getNameOfAgency(), (MatchMode)MatchMode.ANYWHERE));
            }
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public List<String> findLoaWorkOrderNumberForMilestone(String workOrderNumber) {
        List<WorkOrder> workorders = this.letterOfAcceptanceRepository.findByWorkOrderNumberContainingIgnoreCaseAndEgwStatus_codeEqualsAndParent_idIsNull(workOrderNumber, "APPROVED");
        ArrayList<String> results = new ArrayList<String>();
        for (WorkOrder details : workorders) {
            results.add(details.getWorkOrderNumber());
        }
        return results;
    }

    public List<String> findWorkIdentificationNumbersToCreateMilestone(String code) {
        List<String> workIdNumbers = this.letterOfAcceptanceRepository.findWorkIdentificationNumberToCreateMilestone("%" + code + "%");
        return workIdNumbers;
    }

    public List<WorkOrderEstimate> getLoaForCreateMilestone(SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(WorkOrderEstimate.class, "woe").createAlias("woe.workOrder", "wo").createAlias("woe.estimate", "woeestimate").createAlias("woeestimate.lineEstimateDetails", "woeled").createAlias("woeled.lineEstimate", "lineestimate").createAlias("woeestimate.projectCode", "projectcode").createAlias("woeestimate.executingDepartment", "executingDepartment").createAlias("wo.contractor", "woc").createAlias("wo.egwStatus", "status").createAlias("woe.milestone", "ms", JoinType.LEFT_OUTER_JOIN).addOrder(Order.asc((String)"wo.workOrderDate"));
        criteria.add(Restrictions.isNull((String)"wo.parent.id"));
        if (searchRequestLetterOfAcceptance != null) {
            if (searchRequestLetterOfAcceptance.getWorkIdentificationNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"projectcode.code", (Object)searchRequestLetterOfAcceptance.getWorkIdentificationNumber()).ignoreCase());
            }
            if (searchRequestLetterOfAcceptance.getDepartmentName() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"executingDepartment.id", (Object)searchRequestLetterOfAcceptance.getDepartmentName()));
            }
            if (searchRequestLetterOfAcceptance.getEstimateNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"woeestimate.estimateNumber", (Object)searchRequestLetterOfAcceptance.getEstimateNumber()).ignoreCase());
            }
            if (searchRequestLetterOfAcceptance.getWorkOrderNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"wo.workOrderNumber", (Object)searchRequestLetterOfAcceptance.getWorkOrderNumber()).ignoreCase());
            }
            if (searchRequestLetterOfAcceptance.getAdminSanctionFromDate() != null) {
                criteria.add((Criterion)Restrictions.ge((String)"lineestimate.adminSanctionDate", (Object)searchRequestLetterOfAcceptance.getAdminSanctionFromDate()));
            }
            if (searchRequestLetterOfAcceptance.getAdminSanctionToDate() != null) {
                criteria.add((Criterion)Restrictions.le((String)"lineestimate.adminSanctionDate", (Object)searchRequestLetterOfAcceptance.getAdminSanctionToDate()));
            }
            if (searchRequestLetterOfAcceptance.getTypeOfWork() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"woeestimate.parentCategory.id", (Object)searchRequestLetterOfAcceptance.getTypeOfWork()));
            }
            if (searchRequestLetterOfAcceptance.getSubTypeOfWork() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"woeestimate.category.id", (Object)searchRequestLetterOfAcceptance.getSubTypeOfWork()));
            }
        }
        criteria.add((Criterion)Restrictions.eq((String)"status.code", (Object)"APPROVED"));
        criteria.add(Restrictions.isNull((String)"ms.id"));
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public Double getGrossBillAmountOfBillsCreated(String workOrderNumber, String status, String billstatus) {
        return this.letterOfAcceptanceRepository.getGrossBillAmountOfBillsCreated(workOrderNumber, status, billstatus);
    }

    @Transactional
    public WorkOrder forward(WorkOrder workOrder, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) throws ValidationException {
        this.createWorkOrderWorkflowTransition(workOrder, approvalPosition, approvalComent, additionalRule, workFlowAction);
        WorkOrder savedworkOrder = (WorkOrder)((Object)this.letterOfAcceptanceRepository.save((Object)workOrder));
        this.workOrderStatusChange(savedworkOrder, workFlowAction);
        return savedworkOrder;
    }

    private void workOrderStatusChange(WorkOrder workOrder, String workFlowAction) {
        if ("approve".equalsIgnoreCase(workFlowAction)) {
            workOrder.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("WorkOrder", "APPROVED"));
        } else if (("RESUBMITTED".equalsIgnoreCase(workOrder.getEgwStatus().getCode()) || "CREATED".equalsIgnoreCase(workOrder.getEgwStatus().getCode()) || "CHECKED".equalsIgnoreCase(workOrder.getEgwStatus().getCode())) && workOrder.getState() != null && "Submit".equalsIgnoreCase(workFlowAction)) {
            workOrder.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("WorkOrder", "CHECKED"));
        }
    }

    @Transactional
    public WorkOrder update(WorkOrder workOrder, LineEstimateDetails lineEstimateDetails, Double appropriationAmount, Double revisedWorkOrderAmount) throws ValidationException {
        WorkOrderHistory history = new WorkOrderHistory();
        history.setWorkOrder(workOrder);
        history.setWorkOrderAmount(workOrder.getWorkOrderAmount());
        history.setRevisedWorkOrderAmount(revisedWorkOrderAmount);
        this.workOrderHistoryRepository.save((Object)history);
        workOrder.setWorkOrderAmount(revisedWorkOrderAmount);
        if (StringUtils.isNotBlank((String)workOrder.getPercentageSign()) && workOrder.getPercentageSign().equals("-")) {
            workOrder.setTenderFinalizedPercentage(workOrder.getTenderFinalizedPercentage() * -1.0);
        }
        if (workOrder.getPercentageSign().equals("+")) {
            if (appropriationAmount > 0.0 && !BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue())) {
                ArrayList<Long> budgetheadid = new ArrayList<Long>();
                budgetheadid.add(lineEstimateDetails.getLineEstimate().getBudgetHead().getId());
                boolean flag = this.lineEstimateDetailService.checkConsumeEncumbranceBudget(lineEstimateDetails, this.worksUtils.getFinancialYearByDate(new Date()).getId(), appropriationAmount, budgetheadid);
                if (!flag) {
                    throw new ValidationException("", "error.budgetappropriation.insufficient.amount", new String[0]);
                }
            }
        } else if (workOrder.getPercentageSign().equals("-") && appropriationAmount > 0.0 && !BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue())) {
            String appropriationNumber = this.lineEstimateAppropriationService.generateBudgetAppropriationNumber(lineEstimateDetails);
            this.lineEstimateService.releaseBudgetOnReject(lineEstimateDetails, appropriationAmount, appropriationNumber);
        }
        WorkOrder savedworkOrder = (WorkOrder)((Object)this.letterOfAcceptanceRepository.save((Object)workOrder));
        return savedworkOrder;
    }

    public List<WorkOrderEstimate> searchLetterOfAcceptanceToModify(SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance) {
        ArrayList<WorkOrderEstimate> workOrderEstimateList = new ArrayList();
        StringBuilder queryStr = new StringBuilder(500);
        queryStr.append("select distinct(woe) from WorkOrderEstimate woe where woe.workOrder.egwStatus.code =:workOrderStatus and not exists (select distinct(cbr.workOrderEstimate.workOrder) from ContractorBillRegister as cbr where woe.workOrder.id = cbr.workOrderEstimate.workOrder.id and upper(cbr.billstatus) != :billstatus and cbr.billtype = :billtype)");
        queryStr.append(" and not exists (select woa.workOrderEstimate from WorkOrderActivity as woa where woe.id = woa.workOrderEstimate.id )");
        if (searchRequestLetterOfAcceptance != null) {
            if (searchRequestLetterOfAcceptance.getWorkOrderNumber() != null) {
                queryStr.append(" and upper(woe.workOrder.workOrderNumber) =:workOrderNumber");
            }
            if (searchRequestLetterOfAcceptance.getFileNumber() != null) {
                queryStr.append(" and woe.workOrder.fileNumber like upper(:fileNumber)");
            }
            if (searchRequestLetterOfAcceptance.getFromDate() != null) {
                queryStr.append(" and woe.workOrder.workOrderDate >= :workOrderFromDate");
            }
            if (searchRequestLetterOfAcceptance.getToDate() != null) {
                queryStr.append(" and woe.workOrder.workOrderDate <= :workOrderToDate");
            }
            if (searchRequestLetterOfAcceptance.getName() != null) {
                queryStr.append(" and (upper(woe.workOrder.contractor.name) like upper(:contractorName) or upper(woe.workOrder.contractor.code) like upper(:contractorCode)) ");
            }
            if (searchRequestLetterOfAcceptance.getDepartmentName() != null) {
                queryStr.append(" and woe.estimate.executingDepartment.id =:department");
            }
            if (searchRequestLetterOfAcceptance.getEstimateNumber() != null) {
                queryStr.append(" and upper(woe.estimate.estimateNumber) =:estimateNumber");
            }
        }
        Query query = this.setQueryParametersForModifyLOA(searchRequestLetterOfAcceptance, queryStr);
        workOrderEstimateList = query.getResultList();
        return workOrderEstimateList;
    }

    private Query setQueryParametersForModifyLOA(SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance, StringBuilder queryStr) {
        Query qry = this.entityManager.createQuery(queryStr.toString());
        if (searchRequestLetterOfAcceptance != null) {
            if (searchRequestLetterOfAcceptance.getWorkOrderNumber() != null) {
                qry.setParameter("workOrderNumber", (Object)searchRequestLetterOfAcceptance.getWorkOrderNumber().toUpperCase());
            }
            if (searchRequestLetterOfAcceptance.getFileNumber() != null) {
                qry.setParameter("fileNumber", (Object)("%" + searchRequestLetterOfAcceptance.getFileNumber() + "%"));
            }
            if (searchRequestLetterOfAcceptance.getFromDate() != null) {
                qry.setParameter("workOrderFromDate", (Object)searchRequestLetterOfAcceptance.getFromDate());
            }
            if (searchRequestLetterOfAcceptance.getToDate() != null) {
                qry.setParameter("workOrderToDate", (Object)searchRequestLetterOfAcceptance.getToDate());
            }
            if (searchRequestLetterOfAcceptance.getName() != null) {
                qry.setParameter("contractorName", (Object)("%" + searchRequestLetterOfAcceptance.getName() + "%"));
                qry.setParameter("contractorCode", (Object)("%" + searchRequestLetterOfAcceptance.getName() + "%"));
            }
            if (searchRequestLetterOfAcceptance.getDepartmentName() != null) {
                qry.setParameter("department", (Object)searchRequestLetterOfAcceptance.getDepartmentName());
            }
            if (searchRequestLetterOfAcceptance.getEstimateNumber() != null) {
                qry.setParameter("estimateNumber", (Object)searchRequestLetterOfAcceptance.getEstimateNumber().toUpperCase());
            }
            qry.setParameter("workOrderStatus", (Object)"APPROVED");
            qry.setParameter("billtype", (Object)BillTypes.Final_Bill.toString());
            qry.setParameter("billstatus", (Object)ContractorBillRegister.BillStatus.CANCELLED.toString());
        }
        return qry;
    }

    public List<WorkOrder> searchLOAsToCancel(SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance) {
        ArrayList<WorkOrder> workOrderList = new ArrayList();
        StringBuilder queryStr = new StringBuilder(500);
        queryStr.append("select distinct(wo) from WorkOrder wo where  wo.parent.id is null and wo.egwStatus.code =:workOrderStatus");
        if (searchRequestLetterOfAcceptance != null) {
            if (searchRequestLetterOfAcceptance.getWorkOrderNumber() != null) {
                queryStr.append(" and upper(wo.workOrderNumber) like upper(:workOrderNumber)");
            }
            if (searchRequestLetterOfAcceptance.getContractor() != null) {
                queryStr.append(" and upper(wo.contractor.name) like upper(:contractorName) or upper(wo.contractor.code) like upper(:contractorCode) ");
            }
            if (searchRequestLetterOfAcceptance.getDepartmentName() != null) {
                queryStr.append(" and exists (select distinct(woe.workOrder) from WorkOrderEstimate woe where woe.estimate.executingDepartment.id = :department and woe.workOrder = wo)");
            }
            if (searchRequestLetterOfAcceptance.getWorkIdentificationNumber() != null) {
                queryStr.append(" and exists (select distinct(woe.workOrder) from WorkOrderEstimate woe where woe.estimate.projectCode.code = :projectCode and woe.workOrder = wo)");
            }
            if (searchRequestLetterOfAcceptance.getEgwStatus() != null && !searchRequestLetterOfAcceptance.getEgwStatus().equals("APPROVED")) {
                queryStr.append(" and wo.id = (select distinct(os.objectId) from OfflineStatus as os where os.id = (select max(status.id) from OfflineStatus status where status.objectType = :objectType and status.objectId = wo.id) and os.objectId = wo.id and lower(os.egwStatus.code) = :offlineStatus and os.objectType = :objectType )");
            }
        }
        Query query = this.setQueryParameters(searchRequestLetterOfAcceptance, queryStr);
        workOrderList = query.getResultList();
        return workOrderList;
    }

    private Query setQueryParameters(SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance, StringBuilder queryStr) {
        Query qry = this.entityManager.createQuery(queryStr.toString());
        if (searchRequestLetterOfAcceptance != null) {
            if (searchRequestLetterOfAcceptance.getWorkOrderNumber() != null) {
                qry.setParameter("workOrderNumber", (Object)("%" + searchRequestLetterOfAcceptance.getWorkOrderNumber() + "%"));
            }
            if (searchRequestLetterOfAcceptance.getContractor() != null) {
                qry.setParameter("contractorName", (Object)("%" + searchRequestLetterOfAcceptance.getContractor() + "%"));
                qry.setParameter("contractorCode", (Object)("%" + searchRequestLetterOfAcceptance.getContractor() + "%"));
            }
            if (searchRequestLetterOfAcceptance.getDepartmentName() != null) {
                qry.setParameter("department", (Object)searchRequestLetterOfAcceptance.getDepartmentName());
            }
            if (searchRequestLetterOfAcceptance.getWorkIdentificationNumber() != null) {
                qry.setParameter("projectCode", (Object)searchRequestLetterOfAcceptance.getWorkIdentificationNumber());
            }
            if (searchRequestLetterOfAcceptance.getEgwStatus() != null && !searchRequestLetterOfAcceptance.getEgwStatus().equals("APPROVED")) {
                qry.setParameter("offlineStatus", (Object)searchRequestLetterOfAcceptance.getEgwStatus().toString().toLowerCase());
                qry.setParameter("objectType", (Object)"WorkOrder");
            }
            qry.setParameter("workOrderStatus", (Object)"APPROVED");
        }
        return qry;
    }

    public List<String> findWorkIdentificationNumbersToSearchLOAToCancel(String code) {
        List<String> workIdNumbers = this.letterOfAcceptanceRepository.findWorkIdentificationNumbersToSearchLOAToCancel("%" + code + "%", "APPROVED".toString());
        return workIdNumbers;
    }

    public List<String> findContractorsToSearchLOAToCancel(String code) {
        List<String> contractors = this.letterOfAcceptanceRepository.findContractorsToSearchLOAToCancel("%" + code + "%", "APPROVED".toString());
        return contractors;
    }

    public String checkIfBillsCreated(Long id) {
        String billNumbers = "";
        WorkOrder workOrder = this.letterOfAcceptanceRepository.findById(id);
        List<ContractorBillRegister> bills = this.contractorBillRegisterRepository.findByWorkOrderAndBillstatusNot(workOrder, ContractorBillRegister.BillStatus.CANCELLED.toString());
        if (bills == null || bills.isEmpty()) {
            return "";
        }
        for (ContractorBillRegister cbr : bills) {
            billNumbers = billNumbers + cbr.getBillnumber() + ", ";
        }
        return billNumbers;
    }

    public boolean checkIfMileStonesCreated(WorkOrder workOrder) {
        Boolean flag = false;
        block0: for (WorkOrderEstimate woe : workOrder.getWorkOrderEstimates()) {
            List<Milestone> milestones = this.milestoneService.getMilestoneByWorkOrderEstimateId(woe.getId());
            for (Milestone ms : milestones) {
                if (!ms.getStatus().getCode().equalsIgnoreCase("cancelled")) {
                    flag = true;
                    continue block0;
                }
                if (!flag.booleanValue()) continue;
                continue block0;
            }
        }
        return flag;
    }

    @Transactional
    public WorkOrder cancel(WorkOrder workOrder) {
        workOrder.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("WorkOrder", "CANCELLED"));
        workOrder.setStatus("cancelled".toString());
        return (WorkOrder)((Object)this.letterOfAcceptanceRepository.save((Object)workOrder));
    }

    public List<WorkOrder> findWorkOrderByEstimateNumberAndEgwStatus(String estimateNumber) {
        return this.letterOfAcceptanceRepository.findByEstimateNumberAndEgwStatus_codeEquals(estimateNumber, "APPROVED");
    }

    public List<String> getEstimateNumbersToCancelLineEstimate(Long lineEstimateId) {
        List<String> estimateNumbers = this.letterOfAcceptanceRepository.findEstimateNumbersToCancelLineEstimate(lineEstimateId, "APPROVED");
        return estimateNumbers;
    }

    public List<String> getWorkOrderNumbersForViewEstimatePhotograph(String workOrderNumber) {
        List<String> workOrderNumbers = this.letterOfAcceptanceRepository.findworkOrderNumbersToViewEstimatePhotograph("%" + workOrderNumber + "%", "APPROVED".toString());
        return workOrderNumbers;
    }

    public List<String> getContractorsNamesForViewEstimatePhotograph(String contractorName) {
        List<String> contractorNames = this.letterOfAcceptanceRepository.findContractorsToViewEstimatePhotograph("%" + contractorName + "%", "APPROVED".toString());
        return contractorNames;
    }

    public List<String> getEstimateNumbersForApprovedLoa(String estimateNumber) {
        List<WorkOrder> workorders = this.letterOfAcceptanceRepository.findByEstimateNumberContainingIgnoreCaseAndEgwStatus_codeEquals(estimateNumber, "APPROVED");
        ArrayList<String> results = new ArrayList<String>();
        for (WorkOrder details : workorders) {
            results.add(details.getEstimateNumber());
        }
        return results;
    }

    public WorkOrder getWorkOrderDocuments(WorkOrder workOrder) {
        ArrayList<DocumentDetails> documentDetailsList = new ArrayList();
        documentDetailsList = this.worksUtils.findByObjectIdAndObjectType(workOrder.getId(), "WorkOrder");
        workOrder.setDocumentDetails(documentDetailsList);
        return workOrder;
    }

    public List<Long> getWorkOrdersForLoaStatus(String offlineStatus) {
        return this.letterOfAcceptanceRepository.findWorkOrderForLoaStatus(offlineStatus, "WorkOrder");
    }

    public List<WorkOrderEstimate> searchLetterOfAcceptanceForOfflineStatus(SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance) {
        ArrayList<WorkOrderEstimate> workOrderList = new ArrayList();
        StringBuilder queryStr = new StringBuilder(500);
        queryStr.append("select distinct(woe) from WorkOrderEstimate as woe where woe.workOrder.parent.id is null and  woe.workOrder.egwStatus.code =:workOrderStatus ");
        queryStr.append(" and exists (select woa.workOrderEstimate from WorkOrderActivity as woa where woe.id = woa.workOrderEstimate.id )");
        if (searchRequestLetterOfAcceptance != null) {
            if (searchRequestLetterOfAcceptance.getWorkOrderNumber() != null) {
                queryStr.append(" and upper(woe.workOrder.workOrderNumber) =:workOrderNumber");
            }
            if (searchRequestLetterOfAcceptance.getFileNumber() != null) {
                queryStr.append(" and woe.workOrder.fileNumber like upper(:fileNumber)");
            }
            if (searchRequestLetterOfAcceptance.getFromDate() != null) {
                queryStr.append(" and woe.workOrder.workOrderDate >= :workOrderFromDate");
            }
            if (searchRequestLetterOfAcceptance.getToDate() != null) {
                queryStr.append(" and woe.workOrder.workOrderDate <= :workOrderToDate");
            }
            if (searchRequestLetterOfAcceptance.getDepartmentName() != null) {
                queryStr.append(" and woe.estimate.executingDepartment.id =:department");
            }
            if (searchRequestLetterOfAcceptance.getEstimateNumber() != null) {
                queryStr.append(" and upper(woe.estimate.estimateNumber) =:estimateNumber");
            }
            if (searchRequestLetterOfAcceptance.getEgwStatus() != null) {
                if (searchRequestLetterOfAcceptance.getEgwStatus().equals("APPROVED")) {
                    queryStr.append(" and not exists (select distinct(os.objectId) from OfflineStatus as os where os.objectType = :objectType and woe.workOrder.id = os.objectId )");
                } else if (searchRequestLetterOfAcceptance.getEgwStatus() != null) {
                    queryStr.append(" and woe.workOrder.id = (select distinct(os.objectId) from OfflineStatus as os where os.id = (select max(status.id) from OfflineStatus status where status.objectType = :objectType and status.objectId = woe.workOrder.id) and os.objectId = woe.workOrder.id and lower(os.egwStatus.code) = :offlineStatus and os.objectType = :objectType )");
                }
            }
        }
        if (searchRequestLetterOfAcceptance.getContractorName() != null) {
            queryStr.append(" and (upper(woe.workOrder.contractor.name) like upper(:contractorName) or upper(woe.workOrder.contractor.code) like upper(:contractorCode)) ");
        }
        Query query = this.setQueryParametersForOfflineStatus(searchRequestLetterOfAcceptance, queryStr);
        workOrderList = query.getResultList();
        return workOrderList;
    }

    private Query setQueryParametersForOfflineStatus(SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance, StringBuilder queryStr) {
        Query qry = this.entityManager.createQuery(queryStr.toString());
        if (searchRequestLetterOfAcceptance != null) {
            if (searchRequestLetterOfAcceptance.getWorkOrderNumber() != null) {
                qry.setParameter("workOrderNumber", (Object)searchRequestLetterOfAcceptance.getWorkOrderNumber().toUpperCase());
            }
            if (searchRequestLetterOfAcceptance.getFileNumber() != null) {
                qry.setParameter("fileNumber", (Object)("%" + searchRequestLetterOfAcceptance.getFileNumber() + "%"));
            }
            if (searchRequestLetterOfAcceptance.getFromDate() != null) {
                qry.setParameter("workOrderFromDate", (Object)searchRequestLetterOfAcceptance.getFromDate());
            }
            if (searchRequestLetterOfAcceptance.getToDate() != null) {
                qry.setParameter("workOrderToDate", (Object)searchRequestLetterOfAcceptance.getToDate());
            }
            if (searchRequestLetterOfAcceptance.getContractorName() != null) {
                qry.setParameter("contractorName", (Object)("%" + searchRequestLetterOfAcceptance.getContractorName() + "%"));
                qry.setParameter("contractorCode", (Object)("%" + searchRequestLetterOfAcceptance.getContractorName() + "%"));
            }
            if (searchRequestLetterOfAcceptance.getDepartmentName() != null) {
                qry.setParameter("department", (Object)searchRequestLetterOfAcceptance.getDepartmentName());
            }
            if (searchRequestLetterOfAcceptance.getEstimateNumber() != null) {
                qry.setParameter("estimateNumber", (Object)searchRequestLetterOfAcceptance.getEstimateNumber().toUpperCase());
            }
            if (searchRequestLetterOfAcceptance.getEgwStatus() != null) {
                qry.setParameter("objectType", (Object)"WorkOrder");
                if (!searchRequestLetterOfAcceptance.getEgwStatus().equals("APPROVED")) {
                    qry.setParameter("offlineStatus", (Object)searchRequestLetterOfAcceptance.getEgwStatus().toString().toLowerCase());
                }
            }
            qry.setParameter("workOrderStatus", (Object)"APPROVED");
        }
        return qry;
    }

    public String checkIfMBCreatedForLOA(WorkOrderEstimate workOrderEstimate) {
        String mbrefNumbres = "";
        List<MBHeader> mbHeaders = this.mBHeaderService.getMBHeadersToCancelLOA(workOrderEstimate);
        for (MBHeader mBHeader : mbHeaders) {
            mbrefNumbres = mbrefNumbres + mBHeader.getMbRefNo() + ", ";
        }
        if (mbrefNumbres.equals("")) {
            return "";
        }
        return mbrefNumbres;
    }

    public List<String> getApprovedEstimateNumbersForModfyLOA(String estimateNumber) {
        List<String> estimateNumbers = this.letterOfAcceptanceRepository.findEstimateNumbersToModifyLOA("%" + estimateNumber + "%", "APPROVED".toString());
        return estimateNumbers;
    }

    public List<String> getApprovedWorkOrderNumberForModfyLOA(String workOrderNumber) {
        List<String> workOrderNumbers = this.letterOfAcceptanceRepository.findWorkOrderNumbersToModifyLOA("%" + workOrderNumber + "%", "APPROVED".toString());
        return workOrderNumbers;
    }

    public List<String> getApprovedEstimateNumbersForSetOfflineStatus(String estimateNumber) {
        List<String> estimateNumbers = this.letterOfAcceptanceRepository.findEstimateNumbersToSetOfflineStatus("%" + estimateNumber + "%", "APPROVED".toString());
        return estimateNumbers;
    }

    public List<String> getApprovedWorkOrderNumberForSetOfflineStatus(String workOrderNumber) {
        List<String> workOrderNumbers = this.letterOfAcceptanceRepository.findWorkOrderNumbersToSetOfflineStatus("%" + workOrderNumber + "%", "APPROVED".toString());
        return workOrderNumbers;
    }

    public List<String> getApprovedContractorForSetOfflineStatus(String contractorName) {
        List<String> contractorNames = this.letterOfAcceptanceRepository.findContractorToSetOfflineStatus("%" + contractorName + "%", "APPROVED".toString());
        return contractorNames;
    }

    public List<String> getApprovedContractorsForModfyLOA(String contractorName) {
        List<String> contractorNames = this.letterOfAcceptanceRepository.findContractorToModifyLOA("%" + contractorName + "%", "APPROVED".toString());
        return contractorNames;
    }

    public List<User> getWorkAssignedUsers() {
        return this.letterOfAcceptanceRepository.getWorkAssignedUsers("APPROVED".toString());
    }

    public List<String> findContractorsToSearchLOAToCreateRE(String code) {
        List<String> contractors = this.letterOfAcceptanceRepository.findContractorsToSearchLOAToCreateRE("%" + code + "%", "APPROVED".toString());
        return contractors;
    }
}

