/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.contractorbill.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.script.ScriptContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.model.bills.EgBillPayeedetails;
import org.egov.model.bills.EgBilldetails;
import org.egov.model.bills.EgBillregister;
import org.egov.model.bills.EgBillregistermis;
import org.egov.pims.commons.Position;
import org.egov.services.voucher.VoucherService;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.contractorbill.entity.SearchRequestContractorBill;
import org.egov.works.contractorbill.entity.enums.BillTypes;
import org.egov.works.contractorbill.repository.ContractorBillRegisterRepository;
import org.egov.works.letterofacceptance.service.WorkOrderActivityService;
import org.egov.works.lineestimate.entity.DocumentDetails;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.mb.entity.MBDetails;
import org.egov.works.mb.entity.MBForCancelledBill;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.mb.service.MBDetailsService;
import org.egov.works.mb.service.MBForCancelledBillService;
import org.egov.works.mb.service.MBHeaderService;
import org.egov.works.milestone.entity.TrackMilestone;
import org.egov.works.milestone.service.TrackMilestoneService;
import org.egov.works.models.contractorBill.ContractorBillCertificateInfo;
import org.egov.works.utils.WorksConstants;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorder.entity.WorkOrderActivity;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class ContractorBillRegisterService {
    private static final Logger LOG = LoggerFactory.getLogger(ContractorBillRegisterService.class);
    @PersistenceContext
    private EntityManager entityManager;
    private final ContractorBillRegisterRepository contractorBillRegisterRepository;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<ContractorBillRegister> contractorBillRegisterWorkflowService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private LineEstimateService lineEstimateService;
    private final ScriptService scriptExecutionService;
    @Autowired
    private VoucherService voucherService;
    @Autowired
    private MBHeaderService mbHeaderService;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    @Autowired
    private TrackMilestoneService trackMilestoneService;
    @Autowired
    private MBForCancelledBillService mbForCancelledBillService;
    @Autowired
    private MBDetailsService mBDetailsService;
    @Autowired
    private WorkOrderActivityService workOrderActivityService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Autowired
    public ContractorBillRegisterService(ContractorBillRegisterRepository contractorBillRegisterRepository, ScriptService scriptExecutionService) {
        this.contractorBillRegisterRepository = contractorBillRegisterRepository;
        this.scriptExecutionService = scriptExecutionService;
    }

    public ContractorBillRegister getContractorBillById(Long id) {
        return (ContractorBillRegister)((Object)this.contractorBillRegisterRepository.findOne(id));
    }

    public Integer getMaxSequenceNumberByWorkOrder(WorkOrderEstimate workOrderEstimate) {
        return this.contractorBillRegisterRepository.findMaxBillSequenceNumberByWorkOrder(workOrderEstimate.getEstimate().getProjectCode().getCode());
    }

    public ContractorBillRegister getContractorBillByBillNumber(String billNumber) {
        return this.contractorBillRegisterRepository.findByBillnumber(billNumber);
    }

    @Transactional
    public ContractorBillRegister create(ContractorBillRegister contractorBillRegister, MultipartFile[] files, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) throws IOException {
        contractorBillRegister.setStatus(this.worksUtils.getStatusByModuleAndCode("CONTRACTORBILL", ContractorBillRegister.BillStatus.CREATED.toString()));
        contractorBillRegister.setBillstatus(contractorBillRegister.getStatus().getCode());
        contractorBillRegister.setExpendituretype("Works");
        EgBillregistermis egBillRegisterMis = this.setEgBillRegisterMis(contractorBillRegister, contractorBillRegister.getWorkOrderEstimate());
        contractorBillRegister.setEgBillregistermis(egBillRegisterMis);
        if (contractorBillRegister.getWorkOrderEstimate() != null && !contractorBillRegister.getWorkOrderEstimate().getWorkOrderActivities().isEmpty() && !contractorBillRegister.getWorkOrderEstimate().getAssetValues().isEmpty()) {
            contractorBillRegister.getAssetDetailsList().get(0).setAmount(contractorBillRegister.getBillamount());
            contractorBillRegister.getAssetDetailsList().get(0).setWorkOrderEstimate(contractorBillRegister.getWorkOrderEstimate());
            contractorBillRegister.getAssetDetailsList().get(0).setEgbill(contractorBillRegister);
            contractorBillRegister.getAssetDetailsList().get(0).setCoa(contractorBillRegister.getWorkOrderEstimate().getEstimate().getFinancialDetails().get(0).getBudgetGroup().getMaxCode());
        }
        try {
            this.checkBudgetAndGenerateBANumber(contractorBillRegister);
        }
        catch (ValidationException e) {
            throw new ValidationException(e.getErrors());
        }
        ContractorBillRegister savedContractorBillRegister = (ContractorBillRegister)((Object)this.contractorBillRegisterRepository.save((Object)contractorBillRegister));
        if (StringUtils.isNotBlank((CharSequence)workFlowAction)) {
            this.createContractorBillRegisterWorkflowTransition(savedContractorBillRegister, approvalPosition, approvalComent, additionalRule, workFlowAction);
        } else {
            contractorBillRegister.setApprovedDate(contractorBillRegister.getBilldate());
            contractorBillRegister.setApprovedBy(this.securityUtils.getCurrentUser());
            contractorBillRegister.setStatus(this.worksUtils.getStatusByModuleAndCode("CONTRACTORBILL", ContractorBillRegister.BillStatus.APPROVED.toString()));
            contractorBillRegister.setBillstatus(contractorBillRegister.getStatus().getCode());
        }
        savedContractorBillRegister = (ContractorBillRegister)((Object)this.contractorBillRegisterRepository.save((Object)contractorBillRegister));
        this.populateAndSaveMBHeader(savedContractorBillRegister);
        List<DocumentDetails> documentDetails = this.worksUtils.getDocumentDetails(files, (Object)savedContractorBillRegister, "CONTRACTORBILL");
        if (!documentDetails.isEmpty()) {
            savedContractorBillRegister.setDocumentDetails(documentDetails);
            this.worksUtils.persistDocuments(documentDetails);
        }
        return savedContractorBillRegister;
    }

    @Transactional
    public ContractorBillRegister updateContractorBillRegister(ContractorBillRegister contractorBillRegister, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction, String mode, MultipartFile[] files) throws ValidationException, IOException {
        ContractorBillRegister updatedContractorBillRegister = null;
        if (contractorBillRegister.getStatus().getCode().equals(ContractorBillRegister.BillStatus.REJECTED.toString())) {
            if (workFlowAction.equalsIgnoreCase(WorksConstants.FORWARD_ACTION.toString())) {
                this.populateAndSaveMBHeader(contractorBillRegister);
            } else if (workFlowAction.equalsIgnoreCase("Cancel")) {
                if (contractorBillRegister.getWorkOrderEstimate() != null && contractorBillRegister.getWorkOrderEstimate().getWorkOrderActivities().isEmpty()) {
                    this.cancelMBHeader(contractorBillRegister);
                }
                List<MBHeader> mbHeaders = this.mbHeaderService.getMBHeadersByContractorBill(contractorBillRegister);
                this.saveMBForCancelledBill(mbHeaders);
            }
            updatedContractorBillRegister = this.update(contractorBillRegister, files);
            this.contractorBillRegisterStatusChange(updatedContractorBillRegister, workFlowAction, mode);
        } else {
            this.contractorBillRegisterStatusChange(contractorBillRegister, workFlowAction, mode);
            if (workFlowAction.equalsIgnoreCase("approve")) {
                contractorBillRegister.setApprovedDate(new Date());
                contractorBillRegister.setApprovedBy(this.securityUtils.getCurrentUser());
                contractorBillRegister.getEgBillregistermis().setSourcePath("/egworks/contractorbill/view/" + contractorBillRegister.getId());
                if (contractorBillRegister.getWorkOrderEstimate() != null && contractorBillRegister.getWorkOrderEstimate().getWorkOrderActivities().isEmpty()) {
                    this.approveMBHeader(contractorBillRegister);
                }
            }
        }
        updatedContractorBillRegister = (ContractorBillRegister)((Object)this.contractorBillRegisterRepository.save((Object)contractorBillRegister));
        updatedContractorBillRegister.setBillstatus(updatedContractorBillRegister.getStatus().getCode());
        this.createContractorBillRegisterWorkflowTransition(updatedContractorBillRegister, approvalPosition, approvalComent, additionalRule, workFlowAction);
        updatedContractorBillRegister = (ContractorBillRegister)((Object)this.contractorBillRegisterRepository.save((Object)contractorBillRegister));
        return updatedContractorBillRegister;
    }

    private ContractorBillRegister update(ContractorBillRegister contractorBillRegister, MultipartFile[] files) throws IOException {
        List<DocumentDetails> documentDetails = this.worksUtils.getDocumentDetails(files, (Object)contractorBillRegister, "CONTRACTORBILL");
        if (!documentDetails.isEmpty()) {
            contractorBillRegister.setDocumentDetails(documentDetails);
            this.worksUtils.persistDocuments(documentDetails);
        }
        return (ContractorBillRegister)((Object)this.contractorBillRegisterRepository.save((Object)contractorBillRegister));
    }

    public Set<EgBilldetails> removeDeletedBillDetails(Set<EgBilldetails> set, String removedBillDetailsIds) {
        HashSet<EgBilldetails> details = new HashSet<EgBilldetails>();
        if (null != removedBillDetailsIds) {
            String[] ids = removedBillDetailsIds.split(",");
            ArrayList<String> strList = new ArrayList<String>();
            for (String str : ids) {
                strList.add(str);
            }
            for (EgBilldetails line : set) {
                if (line.getId() != null) {
                    if (strList.contains(line.getId().toString())) continue;
                    details.add(line);
                    continue;
                }
                details.add(line);
            }
        } else {
            return set;
        }
        return details;
    }

    private EgBillregistermis setEgBillRegisterMis(ContractorBillRegister contractorBillRegister, WorkOrderEstimate workOrderEstimate) {
        EgBillregistermis egBillRegisterMis = contractorBillRegister.getEgBillregistermis();
        egBillRegisterMis.setEgBillregister((EgBillregister)contractorBillRegister);
        egBillRegisterMis.setPayto(contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getContractor().getName());
        egBillRegisterMis.setFieldid(workOrderEstimate.getEstimate().getWard());
        if (workOrderEstimate.getEstimate().getFinancialDetails().get(0).getFund() != null) {
            egBillRegisterMis.setFund(workOrderEstimate.getEstimate().getFinancialDetails().get(0).getFund());
        }
        if (workOrderEstimate.getEstimate().getFinancialDetails().get(0).getFunction() != null) {
            egBillRegisterMis.setFunction(workOrderEstimate.getEstimate().getFinancialDetails().get(0).getFunction());
        }
        if (workOrderEstimate.getEstimate().getFinancialDetails().get(0).getScheme() != null) {
            egBillRegisterMis.setScheme(workOrderEstimate.getEstimate().getFinancialDetails().get(0).getScheme());
        }
        if (workOrderEstimate.getEstimate().getFinancialDetails().get(0).getSubScheme() != null) {
            egBillRegisterMis.setSubScheme(workOrderEstimate.getEstimate().getFinancialDetails().get(0).getSubScheme());
        }
        egBillRegisterMis.setEgDepartment(workOrderEstimate.getEstimate().getExecutingDepartment());
        CFinancialYear financialYear = this.worksUtils.getActiveForPostingFinancialYearByDate(contractorBillRegister.getBilldate());
        egBillRegisterMis.setFinancialyear(financialYear);
        egBillRegisterMis.setLastupdatedtime(new Date());
        return egBillRegisterMis;
    }

    public Long getApprovalPositionByMatrixDesignation(ContractorBillRegister contractorBillRegister, Long approvalPosition, String additionalRule, String mode, String workFlowAction) {
        WorkFlowMatrix wfmatrix = this.contractorBillRegisterWorkflowService.getWfMatrix(contractorBillRegister.getStateType(), null, null, additionalRule, contractorBillRegister.getCurrentState().getValue(), null);
        if (contractorBillRegister.getStatus() != null && contractorBillRegister.getStatus().getCode() != null && (contractorBillRegister.getStatus().getCode().equals(ContractorBillRegister.BillStatus.CREATED.toString()) || contractorBillRegister.getStatus().getCode().equals(ContractorBillRegister.BillStatus.RESUBMITTED.toString())) && contractorBillRegister.getState() != null && !contractorBillRegister.getState().getHistory().isEmpty()) {
            approvalPosition = mode.equals("edit") || workFlowAction.equals(WorksConstants.REJECT_ACTION) ? contractorBillRegister.getState().getOwnerPosition().getId() : this.worksUtils.getApproverPosition(wfmatrix.getNextDesignation(), contractorBillRegister.getState(), contractorBillRegister.getCreatedBy().getId());
        }
        if (workFlowAction.equals("Cancel") && wfmatrix.getNextState().equals("Created")) {
            approvalPosition = null;
        }
        return approvalPosition;
    }

    public void createContractorBillRegisterWorkflowTransition(ContractorBillRegister contractorBillRegister, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(" Create WorkFlow Transition Started  ...");
        }
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        Position pos = null;
        Assignment wfInitiator = null;
        String currState = "";
        String natureOfwork = "Contractor Bill";
        if (null != contractorBillRegister.getId()) {
            wfInitiator = this.assignmentService.getPrimaryAssignmentForUser(contractorBillRegister.getCreatedBy().getId());
        }
        if (WorksConstants.REJECT_ACTION.toString().equalsIgnoreCase(workFlowAction)) {
            String stateValue = "Rejected";
            contractorBillRegister.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("").withNatureOfTask("Contractor Bill");
        } else {
            if (null != approvalPosition && approvalPosition != -1L && !approvalPosition.equals(0L)) {
                pos = this.positionMasterService.getPositionById(approvalPosition);
            }
            WorkFlowMatrix wfmatrix = null;
            if (null == contractorBillRegister.getState()) {
                wfmatrix = this.contractorBillRegisterWorkflowService.getWfMatrix(contractorBillRegister.getStateType(), null, null, additionalRule, "", null);
                contractorBillRegister.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Contractor Bill");
            } else if ("Cancel".toString().equalsIgnoreCase(workFlowAction)) {
                String stateValue = "Cancelled";
                wfmatrix = this.contractorBillRegisterWorkflowService.getWfMatrix(contractorBillRegister.getStateType(), null, null, additionalRule, contractorBillRegister.getCurrentState().getValue(), null);
                contractorBillRegister.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Cancelled").withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction("").withNatureOfTask("Contractor Bill");
            } else {
                wfmatrix = this.contractorBillRegisterWorkflowService.getWfMatrix(contractorBillRegister.getStateType(), null, contractorBillRegister.getBillamount(), additionalRule, contractorBillRegister.getCurrentState().getValue(), contractorBillRegister.getState().getNextAction());
                contractorBillRegister.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Contractor Bill");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" WorkFlow Transition Completed  ...");
        }
    }

    public void contractorBillRegisterStatusChange(ContractorBillRegister contractorBillRegister, String workFlowAction, String mode) throws ValidationException {
        if (null != contractorBillRegister && null != contractorBillRegister.getStatus() && null != contractorBillRegister.getStatus().getCode()) {
            if (workFlowAction.equalsIgnoreCase("approve")) {
                contractorBillRegister.setStatus(this.worksUtils.getStatusByModuleAndCode("CONTRACTORBILL", ContractorBillRegister.BillStatus.APPROVED.toString()));
            } else if (workFlowAction.equals(WorksConstants.REJECT_ACTION)) {
                contractorBillRegister.setStatus(this.worksUtils.getStatusByModuleAndCode("CONTRACTORBILL", ContractorBillRegister.BillStatus.REJECTED.toString()));
            } else if (contractorBillRegister.getStatus().getCode().equals(ContractorBillRegister.BillStatus.REJECTED.toString()) && workFlowAction.equals("Cancel")) {
                contractorBillRegister.setStatus(this.worksUtils.getStatusByModuleAndCode("CONTRACTORBILL", ContractorBillRegister.BillStatus.CANCELLED.toString()));
            } else if (contractorBillRegister.getStatus().getCode().equals(ContractorBillRegister.BillStatus.REJECTED.toString()) && workFlowAction.equals(WorksConstants.FORWARD_ACTION)) {
                contractorBillRegister.setStatus(this.worksUtils.getStatusByModuleAndCode("CONTRACTORBILL", ContractorBillRegister.BillStatus.RESUBMITTED.toString()));
            } else if (("RESUBMITTED".equalsIgnoreCase(contractorBillRegister.getStatus().getCode()) || "CREATED".equalsIgnoreCase(contractorBillRegister.getStatus().getCode()) || "CHECKED".equalsIgnoreCase(contractorBillRegister.getStatus().getCode())) && contractorBillRegister.getState() != null && "Submit".equalsIgnoreCase(workFlowAction)) {
                contractorBillRegister.setStatus(this.worksUtils.getStatusByModuleAndCode("CONTRACTORBILL", "CHECKED"));
            }
        }
    }

    public List<ContractorBillRegister> searchContractorBill(SearchRequestContractorBill searchRequestContractorBill) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(ContractorBillRegister.class).createAlias("workOrderEstimate", "workOrderEstimate").createAlias("workOrderEstimate.estimate", "estimate").createAlias("workOrderEstimate.workOrder", "cbrwo").createAlias("cbrwo.contractor", "cbrwocont");
        if (searchRequestContractorBill != null) {
            if (searchRequestContractorBill.getBillFromDate() != null) {
                criteria.add((Criterion)Restrictions.ge((String)"billdate", (Object)searchRequestContractorBill.getBillFromDate()));
            }
            if (searchRequestContractorBill.getBillToDate() != null) {
                criteria.add((Criterion)Restrictions.le((String)"billdate", (Object)searchRequestContractorBill.getBillToDate()));
            }
            if (searchRequestContractorBill.getBillType() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"billtype", (Object)searchRequestContractorBill.getBillType()));
            }
            if (searchRequestContractorBill.getBillNumber() != null) {
                criteria.add(Restrictions.ilike((String)"billnumber", (String)searchRequestContractorBill.getBillNumber(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (searchRequestContractorBill.getStatus() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"billstatus", (Object)searchRequestContractorBill.getStatus()));
            }
            if (searchRequestContractorBill.getWorkIdentificationNumber() != null) {
                List<String> estimateNumbersforWIN = this.lineEstimateService.getEstimateNumbersForWorkIdentificationNumber(searchRequestContractorBill.getWorkIdentificationNumber());
                if (estimateNumbersforWIN.isEmpty()) {
                    estimateNumbersforWIN.add("");
                }
                criteria.add(Restrictions.in((String)"estimate.estimateNumber", estimateNumbersforWIN));
            }
            if (searchRequestContractorBill.getContractorName() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"cbrwocont.name", (Object)searchRequestContractorBill.getContractorName()).ignoreCase());
            }
            if (searchRequestContractorBill.getDepartment() != null) {
                List<String> estimateNumbers = this.lineEstimateService.getEstimateNumberForDepartment(searchRequestContractorBill.getDepartment());
                if (estimateNumbers.isEmpty()) {
                    estimateNumbers.add("");
                }
                criteria.add(Restrictions.in((String)"estimate.estimateNumber", estimateNumbers));
            }
            if (searchRequestContractorBill.isSpillOverFlag()) {
                List<String> estimateNumbersforSpillOverFlag = this.lineEstimateService.getEstimateNumbersForSpillOverFlag(searchRequestContractorBill.isSpillOverFlag());
                criteria.add(Restrictions.in((String)"estimate.estimateNumber", estimateNumbersforSpillOverFlag));
            }
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public List<String> findWorkIdentificationNumbersToSearchContractorBill(String code) {
        List<String> workIdNumbers = this.contractorBillRegisterRepository.findWorkIdentificationNumberToSearchContractorBill("%" + code + "%");
        return workIdNumbers;
    }

    public List<String> getApprovedContractorsForCreateContractorBill(String contractorname) {
        List<String> results = this.contractorBillRegisterRepository.findContractorForContractorBill("%" + contractorname + "%", "APPROVED");
        return results;
    }

    public BigDecimal getTotalBillAmountByWorkOrder(WorkOrderEstimate workOrderEstimate) {
        return this.contractorBillRegisterRepository.findSumOfBillAmountByWorkOrderAndStatus(workOrderEstimate, ContractorBillRegister.BillStatus.CANCELLED.toString());
    }

    public ContractorBillRegister checkBudgetAndGenerateBANumber(ContractorBillRegister contractorBill) {
        ScriptContext scriptContext = ScriptService.createContext((Object[])new Object[]{"voucherService", this.voucherService, "bill", contractorBill});
        this.scriptExecutionService.executeScript("egf.bill.budgetcheck", scriptContext);
        return contractorBill;
    }

    private void populateAndSaveMBHeader(ContractorBillRegister contractorBillRegister) {
        MBHeader mbHeader = contractorBillRegister.getMbHeader();
        if (contractorBillRegister.getWorkOrderEstimate() != null && contractorBillRegister.getWorkOrderEstimate().getWorkOrderActivities().isEmpty()) {
            MBHeader existingMBHeader = null;
            if (contractorBillRegister.getMbHeader() != null && contractorBillRegister.getMbHeader().getId() != null) {
                existingMBHeader = this.mbHeaderService.getMBHeaderById(contractorBillRegister.getMbHeader().getId());
            }
            if (existingMBHeader != null) {
                mbHeader.setCreatedBy(existingMBHeader.getCreatedBy());
                mbHeader.setCreatedDate(existingMBHeader.getCreatedDate());
            }
            mbHeader.setMbAmount(contractorBillRegister.getBillamount());
            if (contractorBillRegister.getStatus().getCode().equals(ContractorBillRegister.BillStatus.REJECTED.toString())) {
                mbHeader.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("MBHeader", MBHeader.MeasurementBookStatus.RESUBMITTED.toString()));
            } else if (contractorBillRegister.getStatus().getCode().equals(ContractorBillRegister.BillStatus.APPROVED.toString())) {
                mbHeader.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("MBHeader", MBHeader.MeasurementBookStatus.APPROVED.toString()));
            } else {
                mbHeader.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("MBHeader", MBHeader.MeasurementBookStatus.CREATED.toString()));
            }
            mbHeader.setEgBillregister(contractorBillRegister);
            mbHeader.setWorkOrderEstimate(contractorBillRegister.getWorkOrderEstimate());
            mbHeader.setWorkOrder(contractorBillRegister.getWorkOrderEstimate().getWorkOrder());
            this.mbHeaderService.save(mbHeader);
        } else {
            ArrayList<Long> mBHeaderIds = new ArrayList<Long>(Arrays.asList(contractorBillRegister.getMbHeaderIds()));
            if (mBHeaderIds != null && !mBHeaderIds.isEmpty()) {
                for (Long mbId : mBHeaderIds) {
                    MBHeader mBHeader = this.mbHeaderService.getMBHeaderById(mbId);
                    mBHeader.setEgBillregister(contractorBillRegister);
                    this.mbHeaderService.save(mBHeader);
                }
            }
        }
    }

    private void approveMBHeader(ContractorBillRegister contractorBillRegister) {
        MBHeader mbHeader = this.mbHeaderService.getMBHeaderById(contractorBillRegister.getMbHeader().getId());
        mbHeader.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("MBHeader", MBHeader.MeasurementBookStatus.APPROVED.toString()));
        this.mbHeaderService.save(mbHeader);
    }

    private void cancelMBHeader(ContractorBillRegister contractorBillRegister) {
        MBHeader mbHeader = this.mbHeaderService.getMBHeaderById(contractorBillRegister.getMbHeader().getId());
        this.mbHeaderService.cancel(mbHeader);
    }

    public BigDecimal getTotalBillAmountByWorkOrderAndNotContractorBillRegister(WorkOrderEstimate workOrderEstimate, Long id) {
        return this.contractorBillRegisterRepository.findSumOfBillAmountByWorkOrderAndStatusAndNotContractorBillRegister(workOrderEstimate, ContractorBillRegister.BillStatus.CANCELLED.toString(), id);
    }

    public List<ContractorBillRegister> searchContractorBillsToCancel(SearchRequestContractorBill searchRequestContractorBill) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(ContractorBillRegister.class).createAlias("workOrderEstimate", "workOrderEstimate").createAlias("workOrderEstimate.workOrder", "cbrwo");
        if (searchRequestContractorBill != null) {
            if (searchRequestContractorBill.getBillNumber() != null) {
                criteria.add(Restrictions.ilike((String)"billnumber", (String)searchRequestContractorBill.getBillNumber(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (searchRequestContractorBill.getStatus() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"billstatus", (Object)searchRequestContractorBill.getStatus()));
            }
            if (searchRequestContractorBill.getWorkIdentificationNumber() != null) {
                List<String> estimateNumbersforWIN = this.lineEstimateService.getEstimateNumbersForWorkIdentificationNumber(searchRequestContractorBill.getWorkIdentificationNumber());
                if (estimateNumbersforWIN.isEmpty()) {
                    estimateNumbersforWIN.add("");
                }
                criteria.add(Restrictions.in((String)"cbrwo.estimateNumber", estimateNumbersforWIN));
            }
            if (searchRequestContractorBill.getDepartment() != null) {
                List<String> estimateNumbers = this.lineEstimateService.getEstimateNumberForDepartment(searchRequestContractorBill.getDepartment());
                if (estimateNumbers.isEmpty()) {
                    estimateNumbers.add("");
                }
                criteria.add(Restrictions.in((String)"cbrwo.estimateNumber", estimateNumbers));
            }
            if (searchRequestContractorBill.getWorkOrderNumber() != null) {
                List<String> workOrderNumbers = this.contractorBillRegisterRepository.findWorkOrderNumbersToCancel("%" + searchRequestContractorBill.getWorkOrderNumber() + "%", ContractorBillRegister.BillStatus.APPROVED.toString());
                if (workOrderNumbers.isEmpty()) {
                    workOrderNumbers.add("");
                }
                criteria.add(Restrictions.in((String)"cbrwo.workOrderNumber", workOrderNumbers));
            }
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public List<String> findWorkIdentificationNumbersToSearchContractorBillToCancel(String code) {
        List<String> workIdNumbers = this.contractorBillRegisterRepository.findWorkIdentificationNumberToSearchContractorBillToCancel("%" + code + "%", ContractorBillRegister.BillStatus.APPROVED.toString());
        return workIdNumbers;
    }

    public List<String> findBillNumbersToSearchContractorBillToCancel(String billNumber) {
        List<String> workIdNumbers = this.contractorBillRegisterRepository.findBillNumberToSearchContractorBillToCancel("%" + billNumber + "%", ContractorBillRegister.BillStatus.APPROVED.toString());
        return workIdNumbers;
    }

    @Transactional
    public ContractorBillRegister cancel(ContractorBillRegister contractorBillRegister) {
        contractorBillRegister.setStatus(this.worksUtils.getStatusByModuleAndCode("CONTRACTORBILL", ContractorBillRegister.BillStatus.CANCELLED.toString()));
        contractorBillRegister.setBillstatus(ContractorBillRegister.BillStatus.CANCELLED.toString());
        List<MBHeader> mbHeaders = this.mbHeaderService.getMBHeadersByContractorBill(contractorBillRegister);
        if (contractorBillRegister.getWorkOrderEstimate() != null && contractorBillRegister.getWorkOrderEstimate().getWorkOrderActivities().isEmpty()) {
            for (MBHeader mbHeader : mbHeaders) {
                this.mbHeaderService.cancel(mbHeader);
            }
        }
        this.saveMBForCancelledBill(mbHeaders);
        return (ContractorBillRegister)((Object)this.contractorBillRegisterRepository.save((Object)contractorBillRegister));
    }

    private void saveMBForCancelledBill(List<MBHeader> mbHeaders) {
        for (MBHeader mbObj : mbHeaders) {
            MBForCancelledBill mbCB = new MBForCancelledBill();
            mbCB.setContractorBillRegister(mbObj.getEgBillregister());
            mbCB.setMbHeader(mbObj);
            this.mbForCancelledBillService.save(mbCB);
        }
    }

    public ContractorBillRegister getContratorBillForWorkOrder(WorkOrderEstimate workOrderEstimate, String status, String billtype) {
        return this.contractorBillRegisterRepository.findByWorkOrderAndBillTypeAndStatus(workOrderEstimate, status, billtype);
    }

    public void mergeDeductionDetails(ContractorBillRegister contractorBillRegister) {
        for (EgBilldetails billDetails : contractorBillRegister.getStatutoryDeductionDetailes()) {
            if (billDetails.getId() != null) continue;
            contractorBillRegister.getBillDetailes().add(billDetails);
        }
        for (EgBilldetails billDetails : contractorBillRegister.getOtherDeductionDetailes()) {
            if (billDetails.getId() != null) continue;
            contractorBillRegister.getBillDetailes().add(billDetails);
        }
        for (EgBilldetails billDetails : contractorBillRegister.getRetentionMoneyDeductionDetailes()) {
            if (billDetails.getId() != null) continue;
            contractorBillRegister.getBillDetailes().add(billDetails);
        }
    }

    public Date getLastPartBillDateForContractorBill(Date billCreatedDate, Long workOrderEstimateId) {
        return this.contractorBillRegisterRepository.getLastPartBillDate(billCreatedDate, workOrderEstimateId, ContractorBillRegister.BillStatus.APPROVED.toString(), BillTypes.Part_Bill.toString());
    }

    public List<ContractorBillCertificateInfo> getContractCertificateDetails(ContractorBillRegister contractorBillRegister, Map<String, Object> reportParams) {
        ArrayList<ContractorBillCertificateInfo> contractCertificateInfoList = new ArrayList<ContractorBillCertificateInfo>();
        Double lastExecutionTotal = 0.0;
        Double uptoDateTotal = 0.0;
        List<Object[]> distinctWoaList = this.mBDetailsService.getActivitiesByContractorBillForApprovedMB(contractorBillRegister.getId());
        List<MBDetails> mbDetailsListTillDate = this.mBDetailsService.getActivitiesByContractorBillTillDate(contractorBillRegister.getWorkOrderEstimate().getId(), contractorBillRegister.getCreatedDate());
        for (Object[] Object2 : distinctWoaList) {
            WorkOrderActivity woa = this.workOrderActivityService.getWorkOrderActivityById(Long.valueOf(Object2[0].toString()));
            double lastExecutionQuantity = 0.0;
            ContractorBillCertificateInfo contractorBillCertificateInfo = new ContractorBillCertificateInfo();
            for (MBDetails mbDetailsTillDate : mbDetailsListTillDate) {
                if (!woa.getId().equals(mbDetailsTillDate.getWorkOrderActivity().getId())) continue;
                lastExecutionQuantity += mbDetailsTillDate.getQuantity();
            }
            contractorBillCertificateInfo.setLastExecutionQuantity(lastExecutionQuantity);
            contractorBillCertificateInfo.setLastExecutionAmount(woa.getActivity().getRate() * lastExecutionQuantity);
            contractorBillCertificateInfo.setExecutionQuantity(Double.valueOf(Object2[1].toString()));
            contractorBillCertificateInfo.setExecutionAmount(woa.getActivity().getRate() * contractorBillCertificateInfo.getExecutionQuantity());
            contractorBillCertificateInfo.setWorkOrderActivity(woa);
            lastExecutionTotal = lastExecutionTotal + contractorBillCertificateInfo.getLastExecutionAmount();
            uptoDateTotal = uptoDateTotal + contractorBillCertificateInfo.getExecutionAmount();
            contractCertificateInfoList.add(contractorBillCertificateInfo);
        }
        reportParams.put("lastExecutionTotal", lastExecutionTotal);
        reportParams.put("uptoDateTotal", uptoDateTotal);
        return contractCertificateInfoList;
    }

    public EgBillPayeedetails getEgPayeeDetails(EgBilldetails billDetails, Integer accountsDetailTypeId, BigDecimal amount, boolean isDebit, Integer accountsDetailKeyId) {
        EgBillPayeedetails egBillPaydetail = new EgBillPayeedetails();
        egBillPaydetail.setAccountDetailKeyId(accountsDetailKeyId);
        egBillPaydetail.setAccountDetailTypeId(accountsDetailTypeId);
        if (isDebit) {
            egBillPaydetail.setDebitAmount(amount);
        } else {
            egBillPaydetail.setCreditAmount(amount);
        }
        egBillPaydetail.setEgBilldetailsId(billDetails);
        egBillPaydetail.setLastUpdatedTime(new Date());
        return egBillPaydetail;
    }

    public List<Map<String, Object>> getBillDetailsMap(ContractorBillRegister contractorBillRegister, Model model) {
        ArrayList<Map<String, Object>> billDetailsList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> billDetails = new HashMap<String, Object>();
        List contractorRefundAccountList = this.chartOfAccountsHibernateDAO.getAccountCodeByListOfPurposeName(WorksConstants.CONTRACTOR_REFUND_PURPOSE);
        List contractorNetPayableAccountList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurposeName("Creditors-Contractor Payable");
        List contractorDeductionAccountList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurposeName("Contractor Deductions");
        List retentionMoneyDeductionAccountList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurposeName("RETENTION_MONEY");
        for (EgBilldetails egBilldetails : contractorBillRegister.getEgBilldetailes()) {
            CChartOfAccounts coa = this.chartOfAccountsHibernateDAO.findById((Number)egBilldetails.getGlcodeid().longValue(), false);
            if (egBilldetails.getDebitamount() != null) {
                billDetails = new HashMap();
                billDetails.put("id", egBilldetails.getId());
                billDetails.put("glcodeId", coa.getId());
                billDetails.put("glcode", coa.getGlcode());
                billDetails.put("accountHead", coa.getName());
                billDetails.put("amount", egBilldetails.getDebitamount());
                billDetails.put("isDebit", true);
                billDetails.put("isNetPayable", false);
                if (!contractorRefundAccountList.isEmpty() && contractorRefundAccountList.contains(coa)) {
                    String amounts = this.getTotalDebitAndCreditAmountByAccountCode(contractorBillRegister.getWorkOrderEstimate().getId(), new BigDecimal(coa.getId()), contractorBillRegister.getId() != null ? contractorBillRegister.getId() : -1L);
                    String[] creditDebitAmounts = amounts.split(",");
                    billDetails.put("withHeldAmount", creditDebitAmounts[0]);
                    billDetails.put("RefundedAmount", creditDebitAmounts[1]);
                    billDetails.put("isRefund", true);
                } else {
                    billDetails.put("isRefund", false);
                }
            } else if (egBilldetails.getCreditamount() != null) {
                billDetails = new HashMap();
                billDetails.put("id", egBilldetails.getId());
                billDetails.put("glcodeId", coa.getId());
                billDetails.put("glcode", coa.getGlcode());
                billDetails.put("accountHead", coa.getName());
                billDetails.put("amount", egBilldetails.getCreditamount());
                billDetails.put("isDebit", false);
                if (contractorNetPayableAccountList != null && !contractorNetPayableAccountList.isEmpty() && contractorNetPayableAccountList.contains(coa)) {
                    billDetails.put("isNetPayable", true);
                    model.addAttribute("netPayableAccountId", (Object)egBilldetails.getId());
                    model.addAttribute("netPayableAccountCode", (Object)coa.getId());
                    model.addAttribute("netPayableAmount", (Object)egBilldetails.getCreditamount());
                } else {
                    billDetails.put("isNetPayable", false);
                }
                if (contractorDeductionAccountList != null && !contractorDeductionAccountList.isEmpty() && contractorDeductionAccountList.contains(coa)) {
                    billDetails.put("isStatutoryDeduction", true);
                } else {
                    billDetails.put("isStatutoryDeduction", false);
                }
                if (retentionMoneyDeductionAccountList != null && !retentionMoneyDeductionAccountList.isEmpty() && retentionMoneyDeductionAccountList.contains(coa)) {
                    billDetails.put("isRetentionMoneyDeduction", true);
                } else {
                    billDetails.put("isRetentionMoneyDeduction", false);
                }
            }
            billDetailsList.add(billDetails);
        }
        return billDetailsList;
    }

    public boolean checkForDuplicateAccountCodes(ContractorBillRegister contractorBillRegister) {
        HashSet<Long> glCodeIdSet = new HashSet<Long>();
        for (EgBilldetails egBilldetails : contractorBillRegister.getEgBilldetailes()) {
            if (egBilldetails.getGlcodeid() == null || contractorBillRegister.getRefundBillDetails().contains(egBilldetails)) continue;
            if (glCodeIdSet.contains(egBilldetails.getGlcodeid().longValue())) {
                return false;
            }
            glCodeIdSet.add(egBilldetails.getGlcodeid().longValue());
        }
        return true;
    }

    public boolean validateDuplicateRefundAccountCodes(ContractorBillRegister contractorBillRegister) {
        HashSet<Long> glCodeIdSet = new HashSet<Long>();
        for (EgBilldetails egBilldetails : contractorBillRegister.getEgBilldetailes()) {
            if (egBilldetails.getGlcodeid() == null || egBilldetails.getDebitamount() == null) continue;
            if (glCodeIdSet.contains(egBilldetails.getGlcodeid().longValue())) {
                return false;
            }
            glCodeIdSet.add(egBilldetails.getGlcodeid().longValue());
        }
        return true;
    }

    public void validateTotalDebitAndCreditAmount(ContractorBillRegister contractorBillRegister, BindingResult resultBinder) {
        BigDecimal totalDebitAmount = BigDecimal.ZERO;
        BigDecimal totalCreditAmount = BigDecimal.ZERO;
        for (EgBilldetails egBilldetails : contractorBillRegister.getEgBilldetailes()) {
            if (egBilldetails.getDebitamount() != null && BigDecimal.ZERO.compareTo(egBilldetails.getDebitamount()) != 0) {
                totalDebitAmount = totalDebitAmount.add(egBilldetails.getDebitamount());
            }
            if (egBilldetails.getCreditamount() == null || BigDecimal.ZERO.compareTo(egBilldetails.getCreditamount()) == 0) continue;
            totalCreditAmount = totalCreditAmount.add(egBilldetails.getCreditamount());
        }
        if (totalDebitAmount.compareTo(totalCreditAmount) != 0) {
            resultBinder.reject("error.total.debitamount.creditamount.notequal", "error.total.debitamount.creditamount.notequal");
        }
    }

    public void validateRefundAmount(ContractorBillRegister contractorBillRegister, BindingResult resultBinder) {
        int index = 0;
        for (EgBilldetails egBillDetail : contractorBillRegister.getRefundBillDetails()) {
            if (egBillDetail.getGlcodeid() != null && egBillDetail.getDebitamount() == null) {
                resultBinder.rejectValue("refundBillDetails[" + index + "].debitamount", "error.refundamount.required");
            }
            if (egBillDetail.getDebitamount() != null && egBillDetail.getGlcodeid() == null) {
                resultBinder.rejectValue("refundBillDetails[" + index + "].glcodeid", "error.refundaccountcode.required");
            }
            if (egBillDetail.getGlcodeid() != null && egBillDetail.getDebitamount() != null) {
                CChartOfAccounts coa = this.chartOfAccountsHibernateDAO.findById((Number)egBillDetail.getGlcodeid().longValue(), false);
                String amounts = this.getTotalDebitAndCreditAmountByAccountCode(contractorBillRegister.getWorkOrderEstimate().getId(), new BigDecimal(coa.getId()), contractorBillRegister.getId() != null ? contractorBillRegister.getId() : -1L);
                if (!StringUtils.isBlank((CharSequence)amounts)) {
                    String[] creditDebitAmounts = amounts.split(",");
                    BigDecimal withheldAmount = BigDecimal.ZERO;
                    BigDecimal refundedAmount = BigDecimal.ZERO;
                    if (!creditDebitAmounts[0].equals("0")) {
                        withheldAmount = new BigDecimal(creditDebitAmounts[0]);
                    }
                    if (!creditDebitAmounts[1].equals("0")) {
                        refundedAmount = new BigDecimal(creditDebitAmounts[1]);
                    }
                    if (withheldAmount.equals("0")) {
                        resultBinder.reject("error.contractorBill.nowithheldtorefund", (Object[])new String[]{coa.getGlcode()}, null);
                    } else {
                        BigDecimal validRefundAmount = egBillDetail.getDebitamount().add(refundedAmount);
                        BigDecimal diffAmount = validRefundAmount.subtract(withheldAmount);
                        if (validRefundAmount.compareTo(new BigDecimal(creditDebitAmounts[0])) == 1 && !contractorBillRegister.getWorkOrderEstimate().getEstimate().getLineEstimateDetails().getLineEstimate().isSpillOverFlag()) {
                            resultBinder.reject("error.contractorBill.validate.refundAmount", (Object[])new String[]{coa.getGlcode(), diffAmount.toString()}, null);
                        }
                    }
                }
            }
            ++index;
        }
    }

    public EgBilldetails getBillDetails(ContractorBillRegister billregister, EgBilldetails egBilldetails, WorkOrderEstimate workOrderEstimate, BindingResult resultBinder, HttpServletRequest request) {
        egBilldetails.setFunctionid(new BigDecimal(workOrderEstimate.getEstimate().getFinancialDetails().get(0).getFunction().getId()));
        boolean isDebit = false;
        CChartOfAccounts coa = null;
        if (BigDecimal.ZERO.compareTo(egBilldetails.getGlcodeid()) != 0) {
            coa = this.chartOfAccountsHibernateDAO.findById((Number)egBilldetails.getGlcodeid().longValue(), false);
        }
        if (coa != null && coa.getId() != null) {
            egBilldetails.setGlcodeid(BigDecimal.valueOf(coa.getId()));
        }
        if (egBilldetails.getDebitamount() != null && BigDecimal.ZERO.compareTo(egBilldetails.getDebitamount()) != 0) {
            egBilldetails.setDebitamount(egBilldetails.getDebitamount());
            isDebit = true;
        } else if (egBilldetails.getCreditamount() != null && BigDecimal.ZERO.compareTo(egBilldetails.getCreditamount()) != 0) {
            egBilldetails.setCreditamount(egBilldetails.getCreditamount());
        } else if (!StringUtils.isBlank((CharSequence)request.getParameter("netPayableAccountCode")) && request.getParameter("netPayableAccountCode").toString().equals(egBilldetails.getGlcodeid())) {
            resultBinder.reject("error.contractorbill.accountdetails.amount.required", "error.contractorbill.accountdetails.amount.required");
        }
        egBilldetails.setEgBillregister((EgBillregister)billregister);
        List contractorRefundAccountList = this.chartOfAccountsHibernateDAO.getAccountCodeByListOfPurposeName(WorksConstants.CONTRACTOR_REFUND_PURPOSE);
        if (coa != null && coa.getGlcode() != null) {
            List detailCode;
            Accountdetailtype projectCodeAccountDetailType = null;
            Accountdetailtype contractorAccountDetailType = null;
            if (isDebit && !contractorRefundAccountList.isEmpty() && !contractorRefundAccountList.contains(coa) && (projectCodeAccountDetailType = this.chartOfAccountsHibernateDAO.getAccountDetailTypeIdByName(coa.getGlcode(), "PROJECTCODE")) == null) {
                resultBinder.reject("error.contractorBill.validate.glcode.for.projectcode.subledger", (Object[])new String[]{coa.getGlcode()}, null);
            }
            if ((detailCode = this.chartOfAccountsHibernateDAO.getAccountdetailtypeListByGLCode(coa.getGlcode())) != null && !detailCode.isEmpty()) {
                if (isDebit && !contractorRefundAccountList.isEmpty() && !contractorRefundAccountList.contains(coa)) {
                    if (projectCodeAccountDetailType != null) {
                        egBilldetails.addEgBillPayeedetail(this.getEgPayeeDetails(egBilldetails, projectCodeAccountDetailType.getId(), egBilldetails.getDebitamount(), isDebit, Integer.valueOf(workOrderEstimate.getEstimate().getProjectCode().getId().toString())));
                    }
                } else {
                    contractorAccountDetailType = this.chartOfAccountsHibernateDAO.getAccountDetailTypeIdByName(coa.getGlcode(), "contractor");
                    if (contractorAccountDetailType != null) {
                        egBilldetails.getEgBillPaydetailes().add(this.getEgPayeeDetails(egBilldetails, contractorAccountDetailType.getId(), isDebit ? egBilldetails.getDebitamount() : egBilldetails.getCreditamount(), isDebit, Integer.valueOf(billregister.getWorkOrderEstimate().getWorkOrder().getContractor().getId().toString())));
                    }
                }
                if (projectCodeAccountDetailType == null && contractorAccountDetailType == null) {
                    resultBinder.reject("error.contractorbill.validate.glcode.for.subledger", (Object[])new String[]{coa.getGlcode()}, null);
                }
            }
        }
        egBilldetails.setLastupdatedtime(new Date());
        return egBilldetails;
    }

    public String getTotalDebitAndCreditAmountByAccountCode(Long workOrderEstmateId, BigDecimal glCodeId, Long contractorBillId) {
        return this.contractorBillRegisterRepository.findSumOfDebitByAccountCodeForWorkOrder(workOrderEstmateId, glCodeId, ContractorBillRegister.BillStatus.APPROVED.toString(), contractorBillId);
    }

    public void validateMileStonePercentage(ContractorBillRegister contractorBillRegister, BindingResult resultBinder) {
        TrackMilestone trackMileStone = null;
        if (contractorBillRegister.getBilltype().equalsIgnoreCase(BillTypes.Final_Bill.toString())) {
            trackMileStone = this.trackMilestoneService.getCompletionPercentageToCreateContractorFinalBill(contractorBillRegister.getWorkOrderEstimate().getId());
            if (trackMileStone == null) {
                resultBinder.reject("error.contractor.finalbill.milestonepercentage", "error.contractor.finalbill.milestonepercentage");
            }
        } else {
            trackMileStone = this.trackMilestoneService.getMinimumPercentageToCreateContractorBill(contractorBillRegister.getWorkOrderEstimate().getId());
            if (trackMileStone == null) {
                resultBinder.reject("error.contractorbil.milestone.percentage", "error.contractorbil.milestone.percentage");
            }
        }
    }

    public void validateZeroCreditAndDebitAmount(ContractorBillRegister contractorBillRegister, BindingResult resultBinder) {
        for (EgBilldetails egBillDetail : contractorBillRegister.getEgBilldetailes()) {
            if ((egBillDetail.getCreditamount() == null || BigDecimal.ZERO.compareTo(egBillDetail.getCreditamount()) != 0) && (egBillDetail.getDebitamount() == null || BigDecimal.ZERO.compareTo(egBillDetail.getDebitamount()) != 0)) continue;
            resultBinder.reject("error.creditordebitamount.zero", "error.creditordebitamount.zero");
            break;
        }
    }
}

