/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.autonumber.impl;

import java.io.Serializable;
import java.util.Date;
import org.egov.commons.CFinancialYear;
import org.egov.commons.service.FinancialYearService;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.autonumber.TechnicalSanctionNumberGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class TechnicalSanctionNumberGeneratorImpl
implements TechnicalSanctionNumberGenerator {
    @Autowired
    @Qualifier(value="financialYearService")
    private FinancialYearService financialYearService;
    @Autowired
    private ApplicationSequenceNumberGenerator applicationSequenceNumberGenerator;

    @Override
    public String getNextNumber(AbstractEstimate abstractEstimate) {
        CFinancialYear fy = this.financialYearService.getCurrentFinancialYear();
        Date currnetDate = new Date();
        String technicalSanctionNumber = "";
        String sequenceName = "seq_estimate_technicalsanctionnumber_" + fy.getFinYearRange();
        Serializable nextSequence = this.applicationSequenceNumberGenerator.getNextSequence(sequenceName);
        technicalSanctionNumber = String.format("%s/%05d/%02d/%s", "TS", nextSequence, currnetDate.getMonth() + 1, fy.getFinYearRange());
        return technicalSanctionNumber;
    }
}

