/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.abstractestimate.service;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.EstimatePhotographSearchRequest;
import org.egov.works.abstractestimate.entity.EstimatePhotographs;
import org.egov.works.abstractestimate.repository.EstimatePhotographRepository;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class EstimatePhotographService {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private EstimatePhotographRepository estimatePhotographRepository;
    @Autowired
    private FileStoreService fileStoreService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public void save(EstimatePhotographs estimatePhotographs) {
        this.estimatePhotographRepository.save((Object)estimatePhotographs);
    }

    public List<EstimatePhotographs> getEstimatePhotographs(MultipartFile[] files, Object object) throws IOException {
        ArrayList<EstimatePhotographs> estimatePhotographsList = new ArrayList<EstimatePhotographs>();
        Method method = null;
        try {
            method = object.getClass().getMethod("getId", null);
            method.invoke(object, null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ApplicationRuntimeException("lineestimate.document.error", (Throwable)e);
        }
        File compressedImageFile = null;
        if (files != null && files.length > 0 && !files[0].isEmpty()) {
            compressedImageFile = this.compressImage(files);
        }
        EstimatePhotographs estimatePhotographs = new EstimatePhotographs();
        estimatePhotographs.setFileStore(this.fileStoreService.store(compressedImageFile, files[0].getOriginalFilename(), files[0].getContentType(), "WMS"));
        estimatePhotographsList.add(estimatePhotographs);
        return estimatePhotographsList;
    }

    public File compressImage(MultipartFile[] files) throws IOException, FileNotFoundException {
        BufferedImage image = ImageIO.read(files[0].getInputStream());
        File compressedImageFile = new File(files[0].getOriginalFilename());
        FileOutputStream os = new FileOutputStream(compressedImageFile);
        String fileExtenstion = files[0].getOriginalFilename();
        fileExtenstion = fileExtenstion.substring(fileExtenstion.lastIndexOf(".") + 1);
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(fileExtenstion);
        ImageWriter writer = writers.next();
        ImageOutputStream ios = ImageIO.createImageOutputStream(os);
        writer.setOutput(ios);
        ImageWriteParam param = writer.getDefaultWriteParam();
        if (!fileExtenstion.equalsIgnoreCase("png")) {
            param.setCompressionMode(2);
            param.setCompressionQuality(0.5f);
        }
        writer.write(null, new IIOImage(image, null, null), param);
        ((OutputStream)os).close();
        ios.close();
        writer.dispose();
        return compressedImageFile;
    }

    public List<EstimatePhotographs> getEstimatePhotographByLineEstimateDetail(Long lineEstimateDetailId) {
        return this.estimatePhotographRepository.findByLineEstimateDetails_id(lineEstimateDetailId);
    }

    public List<EstimatePhotographs> getEstimatePhotographsByEstimatePhotographStageAndLineEstimateDetails(EstimatePhotographs.WorkProgress estimatePhotographtrackStage, Long lineEstimateDetailId) {
        return this.estimatePhotographRepository.findByEstimatePhotographAndLineEstimateDetails(estimatePhotographtrackStage, lineEstimateDetailId);
    }

    public List<LineEstimateDetails> searchEstimatePhotograph(EstimatePhotographSearchRequest estimatePhotographSearchRequest) {
        StringBuilder queryStr = new StringBuilder(500);
        this.buildWhereClause(estimatePhotographSearchRequest, queryStr);
        Query query = this.setParameterForEstimatePhotograph(estimatePhotographSearchRequest, queryStr);
        List estimatePhotographsList = query.getResultList();
        return estimatePhotographsList;
    }

    private void buildWhereClause(EstimatePhotographSearchRequest estimatePhotographSearchRequest, StringBuilder queryStr) {
        queryStr.append("select distinct(ep.lineEstimateDetails) from EstimatePhotographs as ep where ep.lineEstimateDetails.lineEstimate.status.code != :lineEstimateStatus and ep.workProgress is not null");
        if (StringUtils.isNotBlank((String)estimatePhotographSearchRequest.getWorkIdentificationNumber())) {
            queryStr.append(" and upper(ep.lineEstimateDetails.projectCode.code) = :workIdentificationNumber");
        }
        if (StringUtils.isNotBlank((String)estimatePhotographSearchRequest.getWorkOrderNumber())) {
            queryStr.append(" and ep.lineEstimateDetails.id in (select distinct(woe.estimate.lineEstimateDetails.id) from WorkOrderEstimate as woe where woe.workOrder.egwStatus.code =:workOrderStatus and upper(woe.workOrder.workOrderNumber) =:workOrderNumber) ");
        }
        if (estimatePhotographSearchRequest.getEstimateCreatedBy() != null) {
            queryStr.append(" and ep.lineEstimateDetails.id in (select distinct(ae.lineEstimateDetails.id) from AbstractEstimate as ae where ae.egwStatus.code =:abstractEstimateStatus and ae.createdBy.id =:aeCreatedById) ");
        }
        if (StringUtils.isNotBlank((String)estimatePhotographSearchRequest.getContractorName())) {
            queryStr.append(" and ep.lineEstimateDetails.id in (select distinct(woe.estimate.lineEstimateDetails.id) from WorkOrderEstimate as woe where woe.workOrder.egwStatus.code =:workOrderStatus and upper(woe.workOrder.contractor.name) =:contractorName or upper(woe.workOrder.contractor.code) =:contractorName) ");
        }
    }

    private Query setParameterForEstimatePhotograph(EstimatePhotographSearchRequest estimatePhotographSearchRequest, StringBuilder queryStr) {
        Query qry = this.entityManager.createQuery(queryStr.toString());
        qry.setParameter("lineEstimateStatus", (Object)"CANCELLED");
        if (estimatePhotographSearchRequest != null) {
            if (StringUtils.isNotBlank((String)estimatePhotographSearchRequest.getWorkIdentificationNumber())) {
                qry.setParameter("workIdentificationNumber", (Object)estimatePhotographSearchRequest.getWorkIdentificationNumber().toUpperCase());
            }
            if (StringUtils.isNotBlank((String)estimatePhotographSearchRequest.getEstimateNumber())) {
                qry.setParameter("estimateNumber", (Object)estimatePhotographSearchRequest.getEstimateNumber().toUpperCase());
            }
            if (StringUtils.isNotBlank((String)estimatePhotographSearchRequest.getWorkOrderNumber())) {
                qry.setParameter("workOrderStatus", (Object)"APPROVED");
                qry.setParameter("workOrderNumber", (Object)estimatePhotographSearchRequest.getWorkOrderNumber().toUpperCase());
            }
            if (estimatePhotographSearchRequest.getEstimateCreatedBy() != null) {
                qry.setParameter("abstractEstimateStatus", (Object)AbstractEstimate.EstimateStatus.APPROVED.toString());
                qry.setParameter("aeCreatedById", (Object)estimatePhotographSearchRequest.getEstimateCreatedBy());
            }
            if (StringUtils.isNotBlank((String)estimatePhotographSearchRequest.getContractorName())) {
                qry.setParameter("workOrderStatus", (Object)"APPROVED");
                qry.setParameter("contractorName", (Object)estimatePhotographSearchRequest.getContractorName().toUpperCase());
            }
        }
        return qry;
    }

    public EstimatePhotographs getEstimatePhotographByFilestore(Long filestoreId) {
        return this.estimatePhotographRepository.findByFileStore_id(filestoreId);
    }

    @Transactional
    public void delete(EstimatePhotographs estimatePhotographs) {
        this.estimatePhotographRepository.delete((Object)estimatePhotographs);
    }

    public List<String> getEstimateNumbersForViewEstimatePhotograph(String estimateNumber) {
        return this.estimatePhotographRepository.findEstimateNumbersForViewEstimatePhotograph("%" + estimateNumber + "%", "CANCELLED");
    }

    public List<String> getWinForViewEstimatePhotograph(String workIdentificationNumber) {
        return this.estimatePhotographRepository.findWorkIdentificationNumberForViewEstimatePhotograph("%" + workIdentificationNumber + "%", "CANCELLED");
    }
}

