/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.abstractestimate.entity;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.egov.commons.EgwStatus;
import org.egov.commons.utils.EntityType;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="EGW_PROJECTCODE")
@NamedQueries(value={@NamedQuery(name="ALL_ACTIVEPROJECTCODES", query=" select distinct pc from ProjectCode as pc left join pc.estimates as e where e.egwStatus.code not in('CANCELLED') order by pc.code "), @NamedQuery(name="GET_ACTIVEPROJECTCODE_BY_CODE", query=" select distinct pc from ProjectCode as pc left join pc.estimates as e where e.egwStatus.code not in('CANCELLED') and pc.code = ? ")})
@SequenceGenerator(name="SEQ_EGW_PROJECTCODE", sequenceName="SEQ_EGW_PROJECTCODE", allocationSize=1)
public class ProjectCode
extends AbstractAuditable
implements EntityType {
    private static final long serialVersionUID = -1569796745047275070L;
    public static final String SEQ_EGW_PROJECTCODE = "SEQ_EGW_PROJECTCODE";
    public static final String ALLACTIVEPROJECTCODES = "ALL_ACTIVEPROJECTCODES";
    public static final String GETPROJECTCODEBYCODE = "GET_ACTIVEPROJECTCODE_BY_CODE";
    @Id
    @GeneratedValue(generator="SEQ_EGW_PROJECTCODE", strategy=GenerationType.SEQUENCE)
    private Long id;
    private String code;
    @OneToMany(mappedBy="projectCode", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=AbstractEstimate.class)
    private Set<AbstractEstimate> estimates = new HashSet<AbstractEstimate>();
    @Column(name="ISACTIVE")
    private boolean active;
    @SafeHtml
    @Length(max=1024, message="projectCode.description.length")
    private String description;
    @SafeHtml
    @Length(max=1024, message="projectCode.name.length")
    @Column(name="NAME")
    private String codeName;
    @JoinColumn(name="STATUS_ID")
    @ManyToOne(fetch=FetchType.LAZY)
    private EgwStatus egwStatus;
    @Column(name="PROJECT_VALUE")
    private Double projectValue;
    @Column(name="COMPLETION_DATE")
    private Date completionDate;

    public ProjectCode() {
    }

    public ProjectCode(AbstractEstimate abstractEstimate, String code) {
        this.estimates.add(abstractEstimate);
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void addEstimate(AbstractEstimate estimate) {
        this.estimates.add(estimate);
    }

    public Set<AbstractEstimate> getEstimates() {
        return this.estimates;
    }

    public void setEstimates(Set<AbstractEstimate> estimates) {
        this.estimates = estimates;
    }

    public String getBankaccount() {
        return null;
    }

    public String getBankname() {
        return null;
    }

    public String getIfsccode() {
        return null;
    }

    public String getModeofpay() {
        return null;
    }

    public String getName() {
        return this.codeName;
    }

    public String getPanno() {
        return null;
    }

    public String getTinno() {
        return null;
    }

    public Integer getEntityId() {
        return this.id.intValue();
    }

    public String getEntityDescription() {
        return this.description;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public void setCodeName(String codeName) {
        this.codeName = codeName;
    }

    public EgwStatus getEgwStatus() {
        return this.egwStatus;
    }

    public void setEgwStatus(EgwStatus egwStatus) {
        this.egwStatus = egwStatus;
    }

    public Double getProjectValue() {
        return this.projectValue;
    }

    public void setProjectValue(Double projectValue) {
        this.projectValue = projectValue;
    }

    public Date getCompletionDate() {
        return this.completionDate;
    }

    public void setCompletionDate(Date completionDate) {
        this.completionDate = completionDate;
    }

    protected void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }
}

