/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.abstractestimate.entity;

import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.models.masters.DepositCode;

@Entity
@Table(name="EGW_DEPOSITWORKS_USAGE")
@NamedQueries(value={@NamedQuery(name="getDepositWorksUsageAmount", query=" select sum(dwu.consumedAmount-dwu.releasedAmount) from DepositWorksUsage dwu inner join dwu.abstractEstimate.financialDetails fd where dwu.abstractEstimate.depositCode.id=? and fd.fund.id=? and fd.coa.id=? ")})
@SequenceGenerator(name="SEQ_EGW_DEPOSITWORKS_USAGE", sequenceName="SEQ_EGW_DEPOSITWORKS_USAGE", allocationSize=1)
public class DepositWorksUsage
extends AbstractAuditable {
    private static final long serialVersionUID = -1250530369473146349L;
    public static final String SEQ_EGW_DEPOSITWORKSUSAGE = "SEQ_EGW_DEPOSITWORKS_USAGE";
    public static final String GET_DEPOSITWORKSUSAGE_AMOUNT = "getDepositWorksUsageAmount";
    @Id
    @GeneratedValue(generator="SEQ_EGW_DEPOSITWORKS_USAGE", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="abstractestimate", nullable=false)
    private AbstractEstimate abstractEstimate;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="depositcode", nullable=false)
    private DepositCode depositCode;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="coa", nullable=false)
    private CChartOfAccounts coa;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="financialyear", nullable=false)
    private CFinancialYear financialYear;
    @NotNull
    private BigDecimal totalDepositAmount;
    private BigDecimal consumedAmount;
    private BigDecimal releasedAmount;
    @NotNull
    private String appropriationNumber;
    @NotNull
    @Temporal(value=TemporalType.DATE)
    private Date appropriationDate;

    protected void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public AbstractEstimate getAbstractEstimate() {
        return this.abstractEstimate;
    }

    public void setAbstractEstimate(AbstractEstimate abstractEstimate) {
        this.abstractEstimate = abstractEstimate;
    }

    public DepositCode getDepositCode() {
        return this.depositCode;
    }

    public void setDepositCode(DepositCode depositCode) {
        this.depositCode = depositCode;
    }

    public CChartOfAccounts getCoa() {
        return this.coa;
    }

    public void setCoa(CChartOfAccounts coa) {
        this.coa = coa;
    }

    public CFinancialYear getFinancialYear() {
        return this.financialYear;
    }

    public void setFinancialYear(CFinancialYear financialYear) {
        this.financialYear = financialYear;
    }

    public BigDecimal getTotalDepositAmount() {
        return this.totalDepositAmount;
    }

    public void setTotalDepositAmount(BigDecimal totalDepositAmount) {
        this.totalDepositAmount = totalDepositAmount;
    }

    public BigDecimal getConsumedAmount() {
        return this.consumedAmount;
    }

    public void setConsumedAmount(BigDecimal consumedAmount) {
        this.consumedAmount = consumedAmount;
    }

    public BigDecimal getReleasedAmount() {
        return this.releasedAmount;
    }

    public void setReleasedAmount(BigDecimal releasedAmount) {
        this.releasedAmount = releasedAmount;
    }

    public String getAppropriationNumber() {
        return this.appropriationNumber;
    }

    public void setAppropriationNumber(String appropriationNumber) {
        this.appropriationNumber = appropriationNumber;
    }

    public Date getAppropriationDate() {
        return this.appropriationDate;
    }

    public void setAppropriationDate(Date appropriationDate) {
        this.appropriationDate = appropriationDate;
    }
}

