/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.abstractestimate.entity;

import java.math.BigDecimal;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.model.budget.BudgetUsage;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.DepositWorksUsage;

@Entity
@Table(name="EGW_ESTIMATE_APPROPRIATION")
@NamedQueries(value={@NamedQuery(name="getBudgetUsageForEstimateByFinYear", query="from AbstractEstimateAppropriation aep where aep.budgetUsage.id=(select max(budgetUsage.id) from AbstractEstimateAppropriation aep1 where aep1.abstractEstimate.id=? and aep1.budgetUsage.financialYearId=?)"), @NamedQuery(name="getLatestBudgetUsageForEstimate", query="from AbstractEstimateAppropriation aep where aep.budgetUsage.id=(select max(budgetUsage.id) from AbstractEstimateAppropriation aep where aep.abstractEstimate.id=?)"), @NamedQuery(name="getDepositWorksUsageForEstimateByFinYear", query="from AbstractEstimateAppropriation aep where aep.abstractEstimate.id=? and aep.depositWorksUsage.financialYear.id=?"), @NamedQuery(name="getLatestDepositWorksUsageForEstimate", query="from AbstractEstimateAppropriation aep where aep.depositWorksUsage.id=(select max(depositWorksUsage.id) from AbstractEstimateAppropriation aep where aep.abstractEstimate.id=?)")})
@SequenceGenerator(name="SEQ_EGW_ESTIMATE_APPROPRIATION", sequenceName="SEQ_EGW_ESTIMATE_APPROPRIATION", allocationSize=1)
public class AbstractEstimateAppropriation
extends AbstractAuditable {
    private static final long serialVersionUID = -5988721723683140437L;
    public static final String BUDGETUSAGE_BY_ESTIMATE_AND_FINANCIALYEAR = "getBudgetUsageForEstimateByFinYear";
    public static final String BUDGETUSAGE_BY_ESTIMATE = "getLatestBudgetUsageForEstimate";
    public static final String DEPOSITWORKSUSAGE_BY_ESTIMATE_AND_FINANCIALYEAR = "getDepositWorksUsageForEstimateByFinYear";
    public static final String DEPOSITWORKSUSAGE_BY_ESTIMATE = "getLatestDepositWorksUsageForEstimate";
    public static final String SEQ_EGW_ESTIMATEAPPROPRIATION = "SEQ_EGW_ESTIMATE_APPROPRIATION";
    @Id
    @GeneratedValue(generator="SEQ_EGW_ESTIMATE_APPROPRIATION", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="abstractestimate", nullable=false)
    private AbstractEstimate abstractEstimate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="budgetusage")
    private BudgetUsage budgetUsage;
    private BigDecimal balanceAvailable;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="depositworksusage")
    private DepositWorksUsage depositWorksUsage;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public DepositWorksUsage getDepositWorksUsage() {
        return this.depositWorksUsage;
    }

    public void setDepositWorksUsage(DepositWorksUsage depositWorksUsage) {
        this.depositWorksUsage = depositWorksUsage;
    }

    public BudgetUsage getBudgetUsage() {
        return this.budgetUsage;
    }

    public void setBudgetUsage(BudgetUsage budgetUsage) {
        this.budgetUsage = budgetUsage;
    }

    public AbstractEstimate getAbstractEstimate() {
        return this.abstractEstimate;
    }

    public void setAbstractEstimate(AbstractEstimate abstractEstimate) {
        this.abstractEstimate = abstractEstimate;
    }

    public BigDecimal getBalanceAvailable() {
        return this.balanceAvailable;
    }

    public void setBalanceAvailable(BigDecimal balanceAvailable) {
        this.balanceAvailable = balanceAvailable;
    }
}

