/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.egov.commons.CFinancialYear;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.works.services.BaseService;

public class BaseServiceImpl<T, ID extends Serializable>
implements BaseService<T, ID> {
    protected PersistenceService<T, ID> persistenceService;
    protected PersistenceService genericService;

    public BaseServiceImpl(PersistenceService<T, ID> persistenceService) {
        this.persistenceService = persistenceService;
    }

    @Override
    public T findById(ID id, boolean lock) {
        return (T)this.persistenceService.findById(id, lock);
    }

    @Override
    public List<T> findAll() {
        return this.persistenceService.findAll();
    }

    @Override
    public List<T> findByExample(T exampleT) {
        return this.persistenceService.findByExample(exampleT);
    }

    @Override
    public T create(T entity) {
        return (T)this.persistenceService.create(entity);
    }

    @Override
    public T persist(T entity) {
        return (T)this.persistenceService.persist(entity);
    }

    @Override
    public T merge(T model) {
        return (T)this.persistenceService.merge(model);
    }

    @Override
    public void delete(T entity) {
        this.persistenceService.delete(entity);
    }

    @Override
    public T update(T entity) {
        return (T)this.persistenceService.update(entity);
    }

    @Override
    public T find(String query, Object ... params) {
        return (T)this.persistenceService.find(query, params);
    }

    @Override
    public T find(String query) {
        return (T)this.persistenceService.find(query);
    }

    @Override
    public List<T> findAllBy(String query, Object ... params) {
        return this.persistenceService.findAllBy(query, params);
    }

    @Override
    public List<T> findAllByNamedQuery(String namedQuery, Object ... params) {
        return this.persistenceService.findAllByNamedQuery(namedQuery, params);
    }

    @Override
    public T findByNamedQuery(String namedQuery, Object ... params) {
        return (T)this.persistenceService.findByNamedQuery(namedQuery, params);
    }

    public void setGenericService(PersistenceService genericService) {
        this.genericService = genericService;
    }

    @Override
    public CFinancialYear getCurrentFinancialYear(Date date) {
        List financialYear = null;
        financialYear = this.persistenceService.getSession().createQuery("from CFinancialYear cfinancialyear where ? between cfinancialyear.startingDate and cfinancialyear.endingDate").setDate(0, date).list();
        if (financialYear == null || financialYear != null && financialYear.isEmpty()) {
            throw new ValidationException(Arrays.asList(new ValidationError("financialyear", "estimate.estimateDate.financialyear.invalid")));
        }
        return (CFinancialYear)financialYear.get(0);
    }
}

