/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.reports.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.infra.admin.master.entity.Department;
import org.egov.works.lineestimate.entity.enums.LineEstimateStatus;
import org.egov.works.lineestimate.repository.LineEstimateDetailsRepository;
import org.egov.works.reports.entity.EstimateAbstractReport;
import org.egov.works.reports.entity.WorkProgressRegister;
import org.egov.works.reports.entity.WorkProgressRegisterSearchRequest;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.hibernate.type.LongType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkProgressRegisterService {
    @Autowired
    private LineEstimateDetailsRepository lineEstimateDetailsRepository;
    @PersistenceContext
    private EntityManager entityManager;

    public List<String> findWorkIdentificationNumbersToSearchLineEstimatesForLoa(String code) {
        List<String> workIdNumbers = this.lineEstimateDetailsRepository.findWorkIdentificationNumbersToSearchWorkProgressRegister("%" + code + "%", LineEstimateStatus.ADMINISTRATIVE_SANCTIONED.toString(), LineEstimateStatus.TECHNICAL_SANCTIONED.toString());
        return workIdNumbers;
    }

    @Transactional
    public List<WorkProgressRegister> searchWorkProgressRegister(WorkProgressRegisterSearchRequest workProgressRegisterSearchRequest) {
        if (workProgressRegisterSearchRequest != null) {
            Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(WorkProgressRegister.class);
            if (workProgressRegisterSearchRequest.getDepartment() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"department.id", (Object)workProgressRegisterSearchRequest.getDepartment()));
            }
            if (workProgressRegisterSearchRequest.getWorkIdentificationNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"winCode", (Object)workProgressRegisterSearchRequest.getWorkIdentificationNumber()).ignoreCase());
            }
            if (workProgressRegisterSearchRequest.getContractor() != null) {
                criteria.createAlias("contractor", "contractor");
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)"contractor.code", (String)workProgressRegisterSearchRequest.getContractor(), (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.ilike((String)"contractor.name", (String)workProgressRegisterSearchRequest.getContractor(), (MatchMode)MatchMode.ANYWHERE)));
            }
            if (workProgressRegisterSearchRequest.getAdminSanctionFromDate() != null) {
                criteria.add((Criterion)Restrictions.ge((String)"adminSanctionDate", (Object)workProgressRegisterSearchRequest.getAdminSanctionFromDate()));
            }
            if (workProgressRegisterSearchRequest.getAdminSanctionToDate() != null) {
                criteria.add((Criterion)Restrictions.le((String)"adminSanctionDate", (Object)workProgressRegisterSearchRequest.getAdminSanctionToDate()));
            }
            if (workProgressRegisterSearchRequest.isSpillOverFlag()) {
                criteria.add((Criterion)Restrictions.eq((String)"spillOverFlag", (Object)workProgressRegisterSearchRequest.isSpillOverFlag()));
            }
            criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
            return criteria.list();
        }
        return new ArrayList<WorkProgressRegister>();
    }

    public Date getReportSchedulerRunDate() {
        Query query = null;
        query = ((Session)this.entityManager.unwrap(Session.class)).createQuery("from WorkProgressRegister ");
        List obj = query.setMaxResults(1).list();
        Date runDate = null;
        if (obj != null) {
            runDate = ((WorkProgressRegister)((Object)obj.get(0))).getCreatedDate();
        }
        return runDate;
    }

    @Transactional
    public List<EstimateAbstractReport> searchEstimateAbstractReportByDepartmentWise(EstimateAbstractReport estimateAbstractReport) {
        Query query = null;
        query = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(this.getQueryForDepartmentWiseReport(estimateAbstractReport)).addScalar("departmentName", (Type)StringType.INSTANCE).addScalar("lineEstimates", (Type)LongType.INSTANCE).addScalar("adminSanctionedEstimates", (Type)LongType.INSTANCE).addScalar("adminSanctionedAmountInCrores", (Type)StringType.INSTANCE).addScalar("technicalSanctionedEstimates", (Type)LongType.INSTANCE).addScalar("loaCreated", (Type)LongType.INSTANCE).addScalar("agreementValueInCrores", (Type)StringType.INSTANCE).addScalar("workInProgress", (Type)LongType.INSTANCE).addScalar("workCompleted", (Type)LongType.INSTANCE).addScalar("billsCreated", (Type)LongType.INSTANCE).addScalar("billValueInCrores", (Type)StringType.INSTANCE).setResultTransformer(Transformers.aliasToBean(EstimateAbstractReport.class));
        query = this.setParameterForDepartmentWiseReport(estimateAbstractReport, query);
        return query.list();
    }

    private Query setParameterForDepartmentWiseReport(EstimateAbstractReport estimateAbstractReport, Query query) {
        if (estimateAbstractReport != null) {
            if (estimateAbstractReport.isSpillOverFlag()) {
                query.setBoolean("spilloverflag", true);
            }
            if (estimateAbstractReport.getDepartment() != null) {
                query.setLong("department", estimateAbstractReport.getDepartment().longValue());
            }
            if (estimateAbstractReport.getAdminSanctionFromDate() != null) {
                query.setDate("fromDate", estimateAbstractReport.getAdminSanctionFromDate());
            }
            if (estimateAbstractReport.getAdminSanctionToDate() != null) {
                query.setDate("toDate", estimateAbstractReport.getAdminSanctionToDate());
            }
            if (estimateAbstractReport.getScheme() != null) {
                query.setLong("scheme", (long)estimateAbstractReport.getScheme().intValue());
            }
            if (estimateAbstractReport.getSubScheme() != null) {
                query.setLong("subScheme", (long)estimateAbstractReport.getSubScheme().intValue());
            }
            if (estimateAbstractReport.getWorkCategory() != null) {
                query.setString("workcategory", estimateAbstractReport.getWorkCategory());
            }
            if (estimateAbstractReport.getBeneficiary() != null) {
                query.setString("beneficiary", estimateAbstractReport.getBeneficiary());
            }
            if (estimateAbstractReport.getNatureOfWork() != null) {
                query.setLong("natureofwork", estimateAbstractReport.getNatureOfWork().longValue());
            }
        }
        return query;
    }

    private Query setParameterForTypeOfWorkWiseReport(EstimateAbstractReport estimateAbstractReport, Query query) {
        if (estimateAbstractReport != null) {
            if (estimateAbstractReport.isSpillOverFlag()) {
                query.setBoolean("spilloverflag", true);
            }
            if (estimateAbstractReport.getTypeOfWork() != null) {
                query.setLong("typeofwork", estimateAbstractReport.getTypeOfWork().longValue());
            }
            if (estimateAbstractReport.getSubTypeOfWork() != null) {
                query.setLong("subtypeofwork", estimateAbstractReport.getSubTypeOfWork().longValue());
            }
            if (estimateAbstractReport.getDepartments() != null && !estimateAbstractReport.getDepartments().toString().equalsIgnoreCase("[null]")) {
                ArrayList<Long> departmentIds = new ArrayList<Long>();
                for (Department dept : estimateAbstractReport.getDepartments()) {
                    departmentIds.add(dept.getId());
                }
                query.setParameterList("departmentIds", departmentIds);
            }
            if (estimateAbstractReport.getAdminSanctionFromDate() != null) {
                query.setDate("fromDate", estimateAbstractReport.getAdminSanctionFromDate());
            }
            if (estimateAbstractReport.getAdminSanctionToDate() != null) {
                query.setDate("toDate", estimateAbstractReport.getAdminSanctionToDate());
            }
            if (estimateAbstractReport.getScheme() != null) {
                query.setLong("scheme", (long)estimateAbstractReport.getScheme().intValue());
            }
            if (estimateAbstractReport.getSubScheme() != null) {
                query.setLong("subScheme", (long)estimateAbstractReport.getSubScheme().intValue());
            }
            if (estimateAbstractReport.getWorkCategory() != null) {
                query.setString("workcategory", estimateAbstractReport.getWorkCategory());
            }
            if (estimateAbstractReport.getBeneficiary() != null) {
                query.setString("beneficiary", estimateAbstractReport.getBeneficiary());
            }
            if (estimateAbstractReport.getNatureOfWork() != null) {
                query.setLong("natureofwork", estimateAbstractReport.getNatureOfWork().longValue());
            }
        }
        return query;
    }

    @Transactional
    public List<EstimateAbstractReport> searchEstimateAbstractReportByTypeOfWorkWise(EstimateAbstractReport estimateAbstractReport) {
        Query query = null;
        if (estimateAbstractReport.getDepartments() != null && !estimateAbstractReport.getDepartments().toString().equalsIgnoreCase("[null]")) {
            query = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(this.getQueryForTypeOfWorkWiseReport(estimateAbstractReport)).addScalar("typeOfWorkName", (Type)StringType.INSTANCE).addScalar("subTypeOfWorkName", (Type)StringType.INSTANCE).addScalar("departmentName", (Type)StringType.INSTANCE).addScalar("lineEstimates", (Type)LongType.INSTANCE).addScalar("adminSanctionedEstimates", (Type)LongType.INSTANCE).addScalar("adminSanctionedAmountInCrores", (Type)StringType.INSTANCE).addScalar("technicalSanctionedEstimates", (Type)LongType.INSTANCE).addScalar("loaCreated", (Type)LongType.INSTANCE).addScalar("agreementValueInCrores", (Type)StringType.INSTANCE).addScalar("workInProgress", (Type)LongType.INSTANCE).addScalar("workCompleted", (Type)LongType.INSTANCE).addScalar("billsCreated", (Type)LongType.INSTANCE).addScalar("billValueInCrores", (Type)StringType.INSTANCE).setResultTransformer(Transformers.aliasToBean(EstimateAbstractReport.class));
            query = this.setParameterForTypeOfWorkWiseReport(estimateAbstractReport, query);
        } else {
            query = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(this.getQueryForTypeOfWorkWiseReport(estimateAbstractReport)).addScalar("typeOfWorkName", (Type)StringType.INSTANCE).addScalar("subTypeOfWorkName", (Type)StringType.INSTANCE).addScalar("lineEstimates", (Type)LongType.INSTANCE).addScalar("adminSanctionedEstimates", (Type)LongType.INSTANCE).addScalar("adminSanctionedAmountInCrores", (Type)StringType.INSTANCE).addScalar("technicalSanctionedEstimates", (Type)LongType.INSTANCE).addScalar("loaCreated", (Type)LongType.INSTANCE).addScalar("agreementValueInCrores", (Type)StringType.INSTANCE).addScalar("workInProgress", (Type)LongType.INSTANCE).addScalar("workCompleted", (Type)LongType.INSTANCE).addScalar("billsCreated", (Type)LongType.INSTANCE).addScalar("billValueInCrores", (Type)StringType.INSTANCE).setResultTransformer(Transformers.aliasToBean(EstimateAbstractReport.class));
            query = this.setParameterForTypeOfWorkWiseReport(estimateAbstractReport, query);
        }
        return query.list();
    }

    private String getQueryForDepartmentWiseReport(EstimateAbstractReport estimateAbstractReport) {
        StringBuilder workInProgessCondition = new StringBuilder();
        StringBuilder filterConditions = new StringBuilder();
        if (estimateAbstractReport != null) {
            if (estimateAbstractReport.getDepartment() != null) {
                filterConditions.append(" AND details.department =:department ");
            }
            if (estimateAbstractReport.getAdminSanctionFromDate() != null) {
                filterConditions.append(" AND details.adminsanctiondate >=:fromDate ");
            }
            if (estimateAbstractReport.getAdminSanctionToDate() != null) {
                filterConditions.append(" AND details.adminsanctiondate <=:toDate ");
            }
            if (estimateAbstractReport.getScheme() != null) {
                filterConditions.append(" AND details.scheme =:scheme ");
            }
            if (estimateAbstractReport.getSubScheme() != null) {
                filterConditions.append(" AND details.subScheme =:subScheme ");
            }
            if (estimateAbstractReport.getWorkCategory() != null) {
                filterConditions.append(" AND details.workcategory =:workcategory ");
            }
            if (estimateAbstractReport.getBeneficiary() != null) {
                filterConditions.append(" AND details.beneficiary =:beneficiary ");
            }
            if (estimateAbstractReport.getNatureOfWork() != null) {
                filterConditions.append(" AND details.natureofwork =:natureofwork ");
            }
            if (estimateAbstractReport.isSpillOverFlag()) {
                filterConditions.append(" AND details.spilloverflag =:spilloverflag ");
                workInProgessCondition.append(" SELECT details.departmentName AS departmentName, ");
                workInProgessCondition.append(" 0                             AS lineEstimates, ");
                workInProgessCondition.append(" 0                             AS lineEstimateDetails, ");
                workInProgessCondition.append(" 0                             AS adminSanctionedAmountInCrores, ");
                workInProgessCondition.append(" 0                             AS adminSanctionedEstimates, ");
                workInProgessCondition.append(" 0                             AS technicalSanctionedEstimates, ");
                workInProgessCondition.append(" 0                             AS loaCreated, ");
                workInProgessCondition.append(" 0                             AS agreementValueInCrores, ");
                workInProgessCondition.append(" COUNT(DISTINCT details.ledid) AS workInProgress, ");
                workInProgessCondition.append(" 0                             AS workCompleted, ");
                workInProgessCondition.append(" 0                             AS billsCreated, ");
                workInProgessCondition.append(" 0                             AS billValueInCrores ");
                workInProgessCondition.append(" FROM egw_mv_work_progress_register details ");
                workInProgessCondition.append(" WHERE ");
                workInProgessCondition.append(" ( details.workordercreated  = true or details.wostatuscode = 'APPROVED') ");
                workInProgessCondition.append(" AND details.workcompleted  = false ");
                workInProgessCondition.append(filterConditions.toString());
                workInProgessCondition.append(" GROUP BY details.departmentName ");
            } else {
                workInProgessCondition.append(" SELECT details.departmentName AS departmentName, ");
                workInProgessCondition.append(" 0                             AS lineEstimates, ");
                workInProgessCondition.append(" 0                             AS lineEstimateDetails, ");
                workInProgessCondition.append(" 0                             AS adminSanctionedAmountInCrores, ");
                workInProgessCondition.append(" 0                             AS adminSanctionedEstimates, ");
                workInProgessCondition.append(" 0                             AS technicalSanctionedEstimates, ");
                workInProgessCondition.append(" 0                             AS loaCreated, ");
                workInProgessCondition.append(" 0                             AS agreementValueInCrores, ");
                workInProgessCondition.append(" COUNT(DISTINCT details.ledid) AS workInProgress, ");
                workInProgessCondition.append(" 0                             AS workCompleted, ");
                workInProgessCondition.append(" 0                             AS billsCreated, ");
                workInProgessCondition.append(" 0                             AS billValueInCrores ");
                workInProgessCondition.append(" FROM egw_mv_work_progress_register details ");
                workInProgessCondition.append(" WHERE ");
                workInProgessCondition.append(" ( details.workordercreated  = true or details.wostatuscode = 'APPROVED') ");
                workInProgessCondition.append(" AND details.workcompleted  = false ");
                workInProgessCondition.append(" AND details.spilloverflag  = true ");
                workInProgessCondition.append(filterConditions.toString());
                workInProgessCondition.append(" GROUP BY details.departmentName ");
                workInProgessCondition.append(" UNION ");
                workInProgessCondition.append(" SELECT details.departmentName AS departmentName, ");
                workInProgessCondition.append(" 0                             AS lineEstimates, ");
                workInProgessCondition.append(" 0                             AS lineEstimateDetails, ");
                workInProgessCondition.append(" 0                             AS adminSanctionedAmountInCrores, ");
                workInProgessCondition.append(" 0                             AS adminSanctionedEstimates, ");
                workInProgessCondition.append(" 0                             AS technicalSanctionedEstimates, ");
                workInProgessCondition.append(" 0                             AS loaCreated, ");
                workInProgessCondition.append(" 0                             AS agreementValueInCrores, ");
                workInProgessCondition.append(" COUNT(DISTINCT details.ledid) AS workInProgress, ");
                workInProgessCondition.append(" 0                             AS workCompleted, ");
                workInProgessCondition.append(" 0                             AS billsCreated, ");
                workInProgessCondition.append(" 0                             AS billValueInCrores ");
                workInProgessCondition.append(" FROM egw_mv_work_progress_register details ");
                workInProgessCondition.append(" WHERE ");
                workInProgessCondition.append(" details.wostatuscode = 'APPROVED' ");
                workInProgessCondition.append(" AND details.workcompleted  = false ");
                workInProgessCondition.append(" AND details.spilloverflag  = false ");
                workInProgessCondition.append(filterConditions.toString());
                workInProgessCondition.append(" GROUP BY details.departmentName ");
            }
        }
        StringBuilder query = new StringBuilder();
        query.append("SELECT departmentName AS departmentName, ");
        query.append(" SUM(lineEstimates)                 AS lineEstimates ,  ");
        query.append(" SUM(lineEstimateDetails)           AS lineEstimateDetails ,  ");
        query.append(" SUM(adminSanctionedAmountInCrores) AS adminSanctionedAmountInCrores,  ");
        query.append(" SUM(adminSanctionedEstimates)      AS adminSanctionedEstimates,  ");
        query.append(" SUM(technicalSanctionedEstimates)  AS technicalSanctionedEstimates,  ");
        query.append(" SUM(loaCreated)                    AS loaCreated,  ");
        query.append(" SUM(agreementValueInCrores)        AS agreementValueInCrores,  ");
        query.append(" SUM(workInProgress)                AS workInProgress,  ");
        query.append(" SUM(workCompleted)                 AS workCompleted ,  ");
        query.append(" SUM(billsCreated)                  AS billsCreated,  ");
        query.append(" SUM(billValueInCrores)             AS billValueInCrores  ");
        query.append(" FROM  ");
        query.append(" (  ");
        query.append(" SELECT details.departmentName       AS departmentName,  ");
        query.append(" COUNT(DISTINCT details.leid)         AS lineEstimates,  ");
        query.append(" COUNT(details.ledid)                 AS lineEstimateDetails,  ");
        query.append(" SUM(details.estimateamount)/10000000 AS adminSanctionedAmountInCrores,  ");
        query.append(" COUNT(details.lineestimatestatus)              AS adminSanctionedEstimates,  ");
        query.append(" 0                                    AS technicalSanctionedEstimates,  ");
        query.append(" 0                                    AS loaCreated,  ");
        query.append(" 0                                    AS agreementValueInCrores, ");
        query.append(" 0                                    AS workInProgress, ");
        query.append(" 0                                    AS workCompleted , ");
        query.append(" 0                                    AS billsCreated, ");
        query.append(" 0                                    AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details, ");
        query.append("   egw_status status ");
        query.append(" WHERE details.lineestimatestatus = status.code ");
        query.append(" AND status.code       IN ('TECHNICAL_SANCTIONED','ADMINISTRATIVE_SANCTIONED') ");
        query.append(filterConditions.toString());
        query.append(" GROUP BY details.departmentName ");
        query.append(" UNION ");
        query.append(" SELECT details.departmentName AS departmentName, ");
        query.append(" 0                           AS lineEstimates, ");
        query.append(" 0                           AS lineEstimateDetails, ");
        query.append(" 0                           AS adminSanctionedAmountInCrores, ");
        query.append(" 0                           AS adminSanctionedEstimates, ");
        query.append(" COUNT(details.lineestimatestatus)     AS technicalSanctionedEstimates, ");
        query.append(" 0                           AS loaCreated, ");
        query.append(" 0                           AS agreementValueInCrores, ");
        query.append(" 0                           AS workInProgress, ");
        query.append(" 0                           AS workCompleted , ");
        query.append(" 0                           AS billsCreated, ");
        query.append(" 0                           AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details, ");
        query.append(" egw_status status ");
        query.append(" WHERE details.lineestimatestatus = status.code ");
        query.append(" AND status.code       IN ('TECHNICAL_SANCTIONED') ");
        query.append(filterConditions.toString());
        query.append(" GROUP BY details.departmentName ");
        query.append(" UNION ");
        query.append(" SELECT details.departmentName         AS departmentName, ");
        query.append(" 0                                     AS lineEstimates, ");
        query.append(" 0                                     AS lineEstimateDetails, ");
        query.append(" 0                                     AS adminSanctionedAmountInCrores, ");
        query.append(" 0                                     AS adminSanctionedEstimates, ");
        query.append(" 0                                     AS technicalSanctionedEstimates, ");
        query.append(" COUNT(details.ledid)                  AS loaCreated, ");
        query.append(" SUM(details.agreementamount)/10000000 AS agreementValueInCrores, ");
        query.append(" 0                                     AS workInProgress, ");
        query.append(" 0                                     AS workCompleted, ");
        query.append(" 0                                     AS billsCreated, ");
        query.append(" 0                                     AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details ");
        query.append(" WHERE details.agreementnumber IS NOT NULL ");
        query.append(" AND details.wostatuscode       = 'APPROVED' ");
        query.append(filterConditions.toString());
        query.append(" GROUP BY details.departmentName ");
        query.append(" UNION ");
        query.append(workInProgessCondition.toString());
        query.append(" UNION ");
        query.append(" SELECT details.departmentName AS departmentName, ");
        query.append(" 0                             AS lineEstimates, ");
        query.append(" 0                             AS lineEstimateDetails, ");
        query.append(" 0                             AS adminSanctionedAmountInCrores, ");
        query.append(" 0                             AS adminSanctionedEstimates, ");
        query.append(" 0                             AS technicalSanctionedEstimates, ");
        query.append(" 0                             AS loaCreated, ");
        query.append(" 0                             AS agreementValueInCrores, ");
        query.append(" 0                             AS workInProgress, ");
        query.append(" COUNT(DISTINCT details.ledid) AS workCompleted, ");
        query.append(" 0                             AS billsCreated, ");
        query.append(" 0                             AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details ");
        query.append(" WHERE details.workcompleted = true ");
        query.append(filterConditions.toString());
        query.append(" GROUP BY details.departmentName ");
        query.append(" UNION ");
        query.append(" SELECT details.departmentName       AS departmentName, ");
        query.append(" 0                                   AS lineEstimates, ");
        query.append(" 0                                   AS lineEstimateDetails, ");
        query.append(" 0                                   AS adminSanctionedAmountInCrores, ");
        query.append(" 0                                   AS adminSanctionedEstimates, ");
        query.append(" 0                                   AS technicalSanctionedEstimates, ");
        query.append(" 0                                   AS loaCreated, ");
        query.append(" 0                                   AS agreementValueInCrores, ");
        query.append(" 0                                   AS workInProgress, ");
        query.append(" 0                                   AS workCompleted , ");
        query.append(" COUNT(DISTINCT billdetail.billid)   AS billsCreated, ");
        query.append(" SUM(billdetail.billamount)/10000000 AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details , ");
        query.append(" egw_mv_billdetail billdetail ");
        query.append(" WHERE billdetail.ledid = details.ledid ");
        query.append(filterConditions.toString());
        query.append(" GROUP BY details.departmentName ");
        query.append(" ) final ");
        query.append(" GROUP BY departmentname  ");
        return query.toString();
    }

    private String getQueryForTypeOfWorkWiseReport(EstimateAbstractReport estimateAbstractReport) {
        StringBuilder workInProgessCondition = new StringBuilder();
        StringBuilder filterConditions = new StringBuilder();
        StringBuilder selectQuery = new StringBuilder();
        StringBuilder groupByQuery = new StringBuilder();
        StringBuilder mainSelectQuery = new StringBuilder();
        StringBuilder mainGroupByQuery = new StringBuilder();
        if (estimateAbstractReport.getDepartments() != null && !estimateAbstractReport.getDepartments().toString().equalsIgnoreCase("[null]")) {
            filterConditions.append(" AND details.department in ( :departmentIds ) ");
            selectQuery.append(" SELECT details.typeOfWorkName       AS typeOfWorkName,  ");
            selectQuery.append(" details.subTypeOfWorkName         AS subTypeOfWorkName,  ");
            selectQuery.append(" details.departmentName         AS departmentName,  ");
            mainSelectQuery.append(" SELECT typeOfWorkName       AS typeOfWorkName,  ");
            mainSelectQuery.append(" subTypeOfWorkName         AS subTypeOfWorkName,  ");
            mainSelectQuery.append(" departmentName         AS departmentName,  ");
            groupByQuery.append(" GROUP BY details.typeOfWorkName,details.subTypeOfWorkName,details.departmentName ");
            mainGroupByQuery.append(" GROUP BY typeofworkname,subtypeofworkname,departmentname ");
        } else {
            selectQuery.append(" SELECT details.typeOfWorkName       AS typeOfWorkName,  ");
            selectQuery.append(" details.subTypeOfWorkName         AS subTypeOfWorkName,  ");
            mainSelectQuery.append(" SELECT typeOfWorkName       AS typeOfWorkName,  ");
            mainSelectQuery.append(" subTypeOfWorkName         AS subTypeOfWorkName,  ");
            groupByQuery.append(" GROUP BY details.typeOfWorkName,details.subTypeOfWorkName ");
            mainGroupByQuery.append(" GROUP BY typeofworkname,subtypeofworkname ");
        }
        if (estimateAbstractReport != null) {
            if (estimateAbstractReport.getTypeOfWork() != null) {
                filterConditions.append(" AND details.typeofwork =:typeofwork ");
            }
            if (estimateAbstractReport.getSubTypeOfWork() != null) {
                filterConditions.append(" AND details.subtypeofwork =:subtypeofwork ");
            }
            if (estimateAbstractReport.getAdminSanctionFromDate() != null) {
                filterConditions.append(" AND details.adminsanctiondate >=:fromDate ");
            }
            if (estimateAbstractReport.getAdminSanctionToDate() != null) {
                filterConditions.append(" AND details.adminsanctiondate <=:toDate ");
            }
            if (estimateAbstractReport.getScheme() != null) {
                filterConditions.append(" AND details.scheme =:scheme ");
            }
            if (estimateAbstractReport.getSubScheme() != null) {
                filterConditions.append(" AND details.subScheme =:subScheme ");
            }
            if (estimateAbstractReport.getWorkCategory() != null) {
                filterConditions.append(" AND details.workcategory =:workcategory ");
            }
            if (estimateAbstractReport.getBeneficiary() != null) {
                filterConditions.append(" AND details.beneficiary =:beneficiary ");
            }
            if (estimateAbstractReport.getNatureOfWork() != null) {
                filterConditions.append(" AND details.natureofwork =:natureofwork ");
            }
            if (estimateAbstractReport.isSpillOverFlag()) {
                filterConditions.append(" AND details.spilloverflag =:spilloverflag ");
                workInProgessCondition.append(selectQuery.toString());
                workInProgessCondition.append(" 0                             AS lineEstimates, ");
                workInProgessCondition.append(" 0                             AS lineEstimateDetails, ");
                workInProgessCondition.append(" 0                             AS adminSanctionedAmountInCrores, ");
                workInProgessCondition.append(" 0                             AS adminSanctionedEstimates, ");
                workInProgessCondition.append(" 0                             AS technicalSanctionedEstimates, ");
                workInProgessCondition.append(" 0                             AS loaCreated, ");
                workInProgessCondition.append(" 0                             AS agreementValueInCrores, ");
                workInProgessCondition.append(" COUNT(DISTINCT details.ledid) AS workInProgress, ");
                workInProgessCondition.append(" 0                             AS workCompleted, ");
                workInProgessCondition.append(" 0                             AS billsCreated, ");
                workInProgessCondition.append(" 0                             AS billValueInCrores ");
                workInProgessCondition.append(" FROM egw_mv_work_progress_register details ");
                workInProgessCondition.append(" WHERE ");
                workInProgessCondition.append(" ( details.workordercreated  = true or details.wostatuscode = 'APPROVED') ");
                workInProgessCondition.append(" AND details.workcompleted  = false ");
                workInProgessCondition.append(filterConditions.toString());
                workInProgessCondition.append(groupByQuery.toString());
            } else {
                workInProgessCondition.append(selectQuery.toString());
                workInProgessCondition.append(" 0                             AS lineEstimates, ");
                workInProgessCondition.append(" 0                             AS lineEstimateDetails, ");
                workInProgessCondition.append(" 0                             AS adminSanctionedAmountInCrores, ");
                workInProgessCondition.append(" 0                             AS adminSanctionedEstimates, ");
                workInProgessCondition.append(" 0                             AS technicalSanctionedEstimates, ");
                workInProgessCondition.append(" 0                             AS loaCreated, ");
                workInProgessCondition.append(" 0                             AS agreementValueInCrores, ");
                workInProgessCondition.append(" COUNT(DISTINCT details.ledid) AS workInProgress, ");
                workInProgessCondition.append(" 0                             AS workCompleted, ");
                workInProgessCondition.append(" 0                             AS billsCreated, ");
                workInProgessCondition.append(" 0                             AS billValueInCrores ");
                workInProgessCondition.append(" FROM egw_mv_work_progress_register details ");
                workInProgessCondition.append(" WHERE ");
                workInProgessCondition.append(" ( details.workordercreated  = true or details.wostatuscode = 'APPROVED') ");
                workInProgessCondition.append(" AND details.workcompleted  = false ");
                workInProgessCondition.append(" AND details.spilloverflag  = true ");
                workInProgessCondition.append(filterConditions.toString());
                workInProgessCondition.append(groupByQuery.toString());
                workInProgessCondition.append(" UNION ");
                workInProgessCondition.append(selectQuery.toString());
                workInProgessCondition.append(" 0                             AS lineEstimates, ");
                workInProgessCondition.append(" 0                             AS lineEstimateDetails, ");
                workInProgessCondition.append(" 0                             AS adminSanctionedAmountInCrores, ");
                workInProgessCondition.append(" 0                             AS adminSanctionedEstimates, ");
                workInProgessCondition.append(" 0                             AS technicalSanctionedEstimates, ");
                workInProgessCondition.append(" 0                             AS loaCreated, ");
                workInProgessCondition.append(" 0                             AS agreementValueInCrores, ");
                workInProgessCondition.append(" COUNT(DISTINCT details.ledid) AS workInProgress, ");
                workInProgessCondition.append(" 0                             AS workCompleted, ");
                workInProgessCondition.append(" 0                             AS billsCreated, ");
                workInProgessCondition.append(" 0                             AS billValueInCrores ");
                workInProgessCondition.append(" FROM egw_mv_work_progress_register details ");
                workInProgessCondition.append(" WHERE ");
                workInProgessCondition.append(" details.wostatuscode = 'APPROVED' ");
                workInProgessCondition.append(" AND details.workcompleted  = false ");
                workInProgessCondition.append(" AND details.spilloverflag  = false ");
                workInProgessCondition.append(filterConditions.toString());
                workInProgessCondition.append(groupByQuery.toString());
            }
        }
        StringBuilder query = new StringBuilder();
        query.append(mainSelectQuery.toString());
        query.append(" SUM(lineEstimates)                 AS lineEstimates ,  ");
        query.append(" SUM(lineEstimateDetails)           AS lineEstimateDetails ,  ");
        query.append(" SUM(adminSanctionedAmountInCrores) AS adminSanctionedAmountInCrores,  ");
        query.append(" SUM(adminSanctionedEstimates)      AS adminSanctionedEstimates,  ");
        query.append(" SUM(technicalSanctionedEstimates)  AS technicalSanctionedEstimates,  ");
        query.append(" SUM(loaCreated)                    AS loaCreated,  ");
        query.append(" SUM(agreementValueInCrores)        AS agreementValueInCrores,  ");
        query.append(" SUM(workInProgress)                AS workInProgress,  ");
        query.append(" SUM(workCompleted)                 AS workCompleted ,  ");
        query.append(" SUM(billsCreated)                  AS billsCreated,  ");
        query.append(" SUM(billValueInCrores)             AS billValueInCrores  ");
        query.append(" FROM  ");
        query.append(" (  ");
        query.append(selectQuery.toString());
        query.append(" COUNT(DISTINCT details.leid)         AS lineEstimates,  ");
        query.append(" COUNT(details.ledid)                 AS lineEstimateDetails,  ");
        query.append(" SUM(details.estimateamount)/10000000 AS adminSanctionedAmountInCrores,  ");
        query.append(" COUNT(details.lineestimatestatus)              AS adminSanctionedEstimates,  ");
        query.append(" 0                                    AS technicalSanctionedEstimates,  ");
        query.append(" 0                                    AS loaCreated,  ");
        query.append(" 0                                    AS agreementValueInCrores, ");
        query.append(" 0                                    AS workInProgress, ");
        query.append(" 0                                    AS workCompleted , ");
        query.append(" 0                                    AS billsCreated, ");
        query.append(" 0                                    AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details, ");
        query.append("   egw_status status ");
        query.append(" WHERE details.lineestimatestatus = status.code ");
        query.append(" AND status.code       IN ('TECHNICAL_SANCTIONED','ADMINISTRATIVE_SANCTIONED') ");
        query.append(filterConditions.toString());
        query.append(groupByQuery.toString());
        query.append(" UNION ");
        query.append(selectQuery.toString());
        query.append(" 0                           AS lineEstimates, ");
        query.append(" 0                           AS lineEstimateDetails, ");
        query.append(" 0                           AS adminSanctionedAmountInCrores, ");
        query.append(" 0                           AS adminSanctionedEstimates, ");
        query.append(" COUNT(details.lineestimatestatus)     AS technicalSanctionedEstimates, ");
        query.append(" 0                           AS loaCreated, ");
        query.append(" 0                           AS agreementValueInCrores, ");
        query.append(" 0                           AS workInProgress, ");
        query.append(" 0                           AS workCompleted , ");
        query.append(" 0                           AS billsCreated, ");
        query.append(" 0                           AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details, ");
        query.append(" egw_status status ");
        query.append(" WHERE details.lineestimatestatus = status.code ");
        query.append(" AND status.code       IN ('TECHNICAL_SANCTIONED') ");
        query.append(filterConditions.toString());
        query.append(groupByQuery.toString());
        query.append(" UNION ");
        query.append(selectQuery.toString());
        query.append(" 0                                     AS lineEstimates, ");
        query.append(" 0                                     AS lineEstimateDetails, ");
        query.append(" 0                                     AS adminSanctionedAmountInCrores, ");
        query.append(" 0                                     AS adminSanctionedEstimates, ");
        query.append(" 0                                     AS technicalSanctionedEstimates, ");
        query.append(" COUNT(details.ledid)                  AS loaCreated, ");
        query.append(" SUM(details.agreementamount)/10000000 AS agreementValueInCrores, ");
        query.append(" 0                                     AS workInProgress, ");
        query.append(" 0                                     AS workCompleted, ");
        query.append(" 0                                     AS billsCreated, ");
        query.append(" 0                                     AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details ");
        query.append(" WHERE details.agreementnumber IS NOT NULL ");
        query.append(" AND details.wostatuscode       = 'APPROVED' ");
        query.append(filterConditions.toString());
        query.append(groupByQuery.toString());
        query.append(" UNION ");
        query.append(workInProgessCondition.toString());
        query.append(" UNION ");
        query.append(selectQuery.toString());
        query.append(" 0                             AS lineEstimates, ");
        query.append(" 0                             AS lineEstimateDetails, ");
        query.append(" 0                             AS adminSanctionedAmountInCrores, ");
        query.append(" 0                             AS adminSanctionedEstimates, ");
        query.append(" 0                             AS technicalSanctionedEstimates, ");
        query.append(" 0                             AS loaCreated, ");
        query.append(" 0                             AS agreementValueInCrores, ");
        query.append(" 0                             AS workInProgress, ");
        query.append(" COUNT(DISTINCT details.ledid) AS workCompleted, ");
        query.append(" 0                             AS billsCreated, ");
        query.append(" 0                             AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details ");
        query.append(" WHERE details.workcompleted = true ");
        query.append(filterConditions.toString());
        query.append(groupByQuery.toString());
        query.append(" UNION ");
        query.append(selectQuery.toString());
        query.append(" 0                                   AS lineEstimates, ");
        query.append(" 0                                   AS lineEstimateDetails, ");
        query.append(" 0                                   AS adminSanctionedAmountInCrores, ");
        query.append(" 0                                   AS adminSanctionedEstimates, ");
        query.append(" 0                                   AS technicalSanctionedEstimates, ");
        query.append(" 0                                   AS loaCreated, ");
        query.append(" 0                                   AS agreementValueInCrores, ");
        query.append(" 0                                   AS workInProgress, ");
        query.append(" 0                                   AS workCompleted , ");
        query.append(" COUNT(DISTINCT billdetail.billid)   AS billsCreated, ");
        query.append(" SUM(billdetail.billamount)/10000000 AS billValueInCrores ");
        query.append(" FROM egw_mv_work_progress_register details , ");
        query.append(" egw_mv_billdetail billdetail ");
        query.append(" WHERE billdetail.ledid = details.ledid ");
        query.append(filterConditions.toString());
        query.append(groupByQuery.toString());
        query.append(" ) final ");
        query.append(mainGroupByQuery.toString());
        return query.toString();
    }
}

