/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.models.workorder;

import java.util.Date;
import org.egov.infra.persistence.validator.annotation.GreaterThan;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infstr.models.BaseModel;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.models.workorder.WorkOrderEstimate;
import org.egov.works.revisionestimate.entity.enums.RevisionType;

public class WorkOrderActivity
extends BaseModel {
    private static final long serialVersionUID = -5986495021099638251L;
    private WorkOrderEstimate workOrderEstimate;
    private Activity activity;
    @Required(message="WorkOrderActivity.approvedRate.not.null")
    @GreaterThan(value=0L, message="WorkOrderActivity.approvedRate.non.negative")
    private double approvedRate;
    @Required(message="WorkOrderActivity.approvedQuantity.not.null")
    @GreaterThan(value=0L, message="WorkOrderActivity.approvedQuantity.non.negative")
    private double approvedQuantity;
    private double approvedAmount;
    private String remarks;
    private double unAssignedQuantity;
    private WorkOrderActivity parent;
    private double totalEstQuantity;
    private double prevCumlvQuantity;

    public Activity getActivity() {
        return this.activity;
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    public double getApprovedRate() {
        return this.approvedRate;
    }

    public void setApprovedRate(double approvedRate) {
        this.approvedRate = approvedRate;
    }

    public double getApprovedQuantity() {
        return this.approvedQuantity;
    }

    public void setApprovedQuantity(double approvedQuantity) {
        this.approvedQuantity = approvedQuantity;
    }

    public double getApprovedAmount() {
        return this.approvedAmount;
    }

    public void setApprovedAmount(double approvedAmount) {
        this.approvedAmount = approvedAmount;
    }

    public WorkOrderEstimate getWorkOrderEstimate() {
        return this.workOrderEstimate;
    }

    public void setWorkOrderEstimate(WorkOrderEstimate workOrderEstimate) {
        this.workOrderEstimate = workOrderEstimate;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public double getUnAssignedQuantity() {
        return this.unAssignedQuantity;
    }

    public void setUnAssignedQuantity(double unAssignedQuantity) {
        this.unAssignedQuantity = unAssignedQuantity;
    }

    public double getConversionFactor() {
        if (this.workOrderEstimate.getWorkOrder().getParent() != null && this.activity.getRevisionType() != null && (this.activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.NON_TENDERED_ITEM.toString()) || this.activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.LUMP_SUM_ITEM.toString()))) {
            return this.activity.getConversionFactorForRE(this.workOrderEstimate.getWorkOrder().getParent().getWorkOrderDate());
        }
        if (this.workOrderEstimate.getWorkOrder().getParent() != null && this.workOrderEstimate.getEstimate().getParent() != null && this.activity.getRevisionType() != null && (this.activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.ADDITIONAL_QUANTITY.toString()) || this.activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.REDUCED_QUANTITY.toString()))) {
            return this.activity.getConversionFactorForRE(this.workOrderEstimate.getEstimate().getParent().getEstimateDate());
        }
        return this.activity.getConversionFactor();
    }

    public double getScheduleOfRate() {
        double sorRate = 0.0;
        if (this.getActivity().getAbstractEstimate().getParent() == null) {
            sorRate = this.getActivity().getSORCurrentRate().getValue();
        } else {
            Date workOrderDate = new Date();
            workOrderDate = this.getWorkOrderEstimate().getWorkOrder().getParent().getWorkOrderDate();
            sorRate = this.activity.getRevisionType() != null && (this.activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.NON_TENDERED_ITEM.toString()) || this.activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.LUMP_SUM_ITEM.toString())) ? this.getActivity().getSORRateForDate(workOrderDate).getValue() : (this.getActivity().getAbstractEstimate().getParent() != null && this.activity.getRevisionType() != null && (this.activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.ADDITIONAL_QUANTITY.toString()) || this.activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.REDUCED_QUANTITY.toString())) ? this.getActivity().getSORRateForDate(this.workOrderEstimate.getEstimate().getParent().getEstimateDate()).getValue() : this.getActivity().getSORCurrentRate().getValue());
        }
        return sorRate;
    }

    public WorkOrderActivity getParent() {
        return this.parent;
    }

    public void setParent(WorkOrderActivity parent) {
        this.parent = parent;
    }

    public double getTotalEstQuantity() {
        return this.totalEstQuantity;
    }

    public double getPrevCumlvQuantity() {
        return this.prevCumlvQuantity;
    }

    public void setTotalEstQuantity(double totalEstQuantity) {
        this.totalEstQuantity = totalEstQuantity;
    }

    public void setPrevCumlvQuantity(double prevCumlvQuantity) {
        this.prevCumlvQuantity = prevCumlvQuantity;
    }
}

