/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.lineestimate.entity;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;
import org.springframework.web.multipart.MultipartFile;

@Entity
@Table(name="EGW_DOCUMENTS")
@SequenceGenerator(name="SEQ_EGW_DOCUMENTS", sequenceName="SEQ_EGW_DOCUMENTS", allocationSize=1)
public class DocumentDetails {
    public static final String SEQ_EGW_DOCUMENTS = "SEQ_EGW_DOCUMENTS";
    @Id
    @GeneratedValue(generator="SEQ_EGW_DOCUMENTS", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Column(name="objectid")
    private Long objectId;
    @NotNull
    @SafeHtml
    @Length(max=128)
    private String objectType;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="filestoreid")
    private FileStoreMapper fileStore;
    private transient MultipartFile file;

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public FileStoreMapper getFileStore() {
        return this.fileStore;
    }

    public void setFileStore(FileStoreMapper fileStore) {
        this.fileStore = fileStore;
    }

    public MultipartFile getFile() {
        return this.file;
    }

    public void setFile(MultipartFile file) {
        this.file = file;
    }

    public Long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(Long objectId) {
        this.objectId = objectId;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}

