/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.letterofacceptance.repository;

import java.util.List;
import org.egov.works.models.workorder.WorkOrder;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface LetterOfAcceptanceRepository
extends JpaRepository<WorkOrder, Long> {
    public WorkOrder findById(Long var1);

    public List<WorkOrder> findByEstimateNumberAndEgwStatus_codeEquals(String var1, String var2);

    public List<WorkOrder> findByWorkOrderNumberContainingIgnoreCaseAndEgwStatus_codeEquals(String var1, String var2);

    public List<WorkOrder> findByEstimateNumberContainingIgnoreCaseAndEgwStatus_codeEquals(String var1, String var2);

    @Query(value="select distinct(wo.contractor.name) from WorkOrder as wo where wo.contractor.name like :name or wo.contractor.code like :name")
    public List<String> findDistinctContractorByContractor_codeAndNameContainingIgnoreCase(@Param(value="name") String var1);

    public WorkOrder findByWorkOrderNumberAndEgwStatus_codeNotLike(String var1, String var2);

    public WorkOrder findByEstimateNumberAndEgwStatus_codeNotLike(String var1, String var2);

    public WorkOrder findByWorkOrderNumberAndEgwStatus_codeEquals(String var1, String var2);

    @Query(value="select distinct(wo.workOrderNumber) from WorkOrder as wo where upper(wo.workOrderNumber) like upper(:workOrderNumber) and wo.egwStatus.code = :workOrderStatus and not exists (select distinct(cbr.workOrder) from ContractorBillRegister as cbr where wo.id = cbr.workOrder.id and upper(cbr.billstatus) != :status and cbr.billtype = :billtype)")
    public List<String> findWorkOrderNumberForContractorBill(@Param(value="workOrderNumber") String var1, @Param(value="workOrderStatus") String var2, @Param(value="status") String var3, @Param(value="billtype") String var4);

    @Query(value="select distinct(wo.estimateNumber) from WorkOrder as wo where upper(wo.estimateNumber) like upper(:estimateNumber) and wo.egwStatus.code = :workOrderStatus and not exists (select distinct(cbr.workOrder) from ContractorBillRegister as cbr where wo.id = cbr.workOrder.id and upper(cbr.billstatus) != :status and cbr.billtype = :billtype)")
    public List<String> findEstimateNumberForContractorBill(@Param(value="estimateNumber") String var1, @Param(value="workOrderStatus") String var2, @Param(value="status") String var3, @Param(value="billtype") String var4);

    @Query(value="select distinct(wo.contractor.name) from WorkOrder as wo where upper(wo.contractor.name) like upper(:contractorname) and wo.egwStatus.code = :workOrderStatus and not exists (select distinct(cbr.workOrder) from ContractorBillRegister as cbr where wo.id = cbr.workOrder.id and upper(cbr.billstatus) != :status and cbr.billtype = :billtype)")
    public List<String> findContractorForContractorBill(@Param(value="contractorname") String var1, @Param(value="workOrderStatus") String var2, @Param(value="status") String var3, @Param(value="billtype") String var4);

    @Query(value="select distinct(cbr.workOrder.workOrderNumber) from ContractorBillRegister as cbr where upper(cbr.billstatus) != :status and cbr.billtype = :billtype")
    public List<String> getDistinctNonCancelledWorkOrderNumbersByBillType(@Param(value="status") String var1, @Param(value="billtype") String var2);

    @Query(value="select distinct(cbr.workOrder.workOrderNumber) from ContractorBillRegister as cbr where cbr.workOrder.id = :workOrderId and upper(cbr.billstatus) not in (:billstatus1,:billstatus2)")
    public List<String> getContractorBillInWorkflowForWorkorder(@Param(value="workOrderId") Long var1, @Param(value="billstatus1") String var2, @Param(value="billstatus2") String var3);

    @Query(value="select distinct(led.projectCode.code) from LineEstimateDetails as led  where upper(led.projectCode.code) like upper(:code) and exists (select distinct(wo.estimateNumber) from WorkOrder as wo where led.estimateNumber = wo.estimateNumber)")
    public List<String> findWorkIdentificationNumberToCreateMilestone(@Param(value="code") String var1);

    @Query(value="select sum(br.billamount) from EgBillregister as br where br.workOrder.id = (select id from WorkOrder as wo where wo.workOrderNumber = :workOrderNumber and wo.egwStatus.code = :status) and br.billstatus != :billStatus")
    public Double getGrossBillAmountOfBillsCreated(@Param(value="workOrderNumber") String var1, @Param(value="status") String var2, @Param(value="billStatus") String var3);

    @Query(value="select distinct(wo.workOrderNumber) from WorkOrder as wo where wo.egwStatus.code = :workOrderStatus and not exists (select distinct(cbr.workOrder) from ContractorBillRegister as cbr where wo.id = cbr.workOrder.id and upper(cbr.billstatus) != :status and cbr.billtype = :billtype)")
    public List<String> findWorkOrderNumbersToModifyLoa(@Param(value="workOrderStatus") String var1, @Param(value="status") String var2, @Param(value="billtype") String var3);

    @Query(value="select distinct(led.projectCode.code) from LineEstimateDetails as led  where upper(led.projectCode.code) like upper(:code) and exists (select distinct(wo.estimateNumber) from WorkOrder as wo where led.estimateNumber = wo.estimateNumber and egwStatus.code = :status)")
    public List<String> findWorkIdentificationNumbersToSearchLOAToCancel(@Param(value="code") String var1, @Param(value="status") String var2);

    @Query(value="select distinct(wo.contractor.name) from WorkOrder as wo where upper(wo.contractor.name) like upper(:code) and wo.egwStatus.code = :status")
    public List<String> findContractorsToSearchLOAToCancel(@Param(value="code") String var1, @Param(value="status") String var2);

    @Query(value="select distinct(wo.estimateNumber) from WorkOrder as wo where wo.egwStatus.code = :workorderstatus and exists (select distinct(led.estimateNumber) from LineEstimateDetails as led  where led.lineEstimate.id = :lineestimateid and led.estimateNumber = wo.estimateNumber)")
    public List<String> findEstimateNumbersToSearchLOAToCancel(@Param(value="lineestimateid") Long var1, @Param(value="workorderstatus") String var2);

    @Query(value="select distinct(wo.workOrderNumber) from WorkOrder as wo where upper(wo.workOrderNumber) like upper(:workOrderNumber) and wo.egwStatus.code = :workOrderStatus and parent is null and not exists (select distinct(cbr.workOrderEstimate.workOrder) from ContractorBillRegister as cbr where wo.id = cbr.workOrderEstimate.workOrder.id and upper(cbr.billstatus) != :status and cbr.billtype = :billtype)")
    public List<String> findDistinctWorkorderNumberToModifyLOA(@Param(value="workOrderNumber") String var1, @Param(value="workOrderStatus") String var2, @Param(value="status") String var3, @Param(value="billtype") String var4);

    @Query(value="select distinct(woe.estimate.estimateNumber) from WorkOrderEstimate as woe where upper(woe.estimate.estimateNumber) like upper(:estimateNumber) and woe.workOrder.egwStatus.code = :workOrderStatus and woe.workOrder.parent is null and not exists (select distinct(cbr.workOrderEstimate) from ContractorBillRegister as cbr where woe.id = cbr.workOrderEstimate.id and upper(cbr.billstatus) != :status and cbr.billtype = :billtype)")
    public List<String> findDistinctEstimateNumberToModifyLOA(@Param(value="estimateNumber") String var1, @Param(value="workOrderStatus") String var2, @Param(value="status") String var3, @Param(value="billtype") String var4);

    @Query(value="select distinct(woe.workOrder.workOrderNumber) from WorkOrderEstimate as woe where upper(woe.workOrder.workOrderNumber) like upper(:workOrderNumber) and woe.workOrder.egwStatus.code = :workOrderStatus and woe.workOrder.parent is null and woe.estimate.lineEstimateDetails.id in (select ep.lineEstimateDetails.id from EstimatePhotographs as ep) ")
    public List<String> findworkOrderNumbersToViewEstimatePhotograph(@Param(value="workOrderNumber") String var1, @Param(value="workOrderStatus") String var2);

    @Query(value="select distinct(woe.workOrder.contractor.name) from WorkOrderEstimate as woe where upper(woe.workOrder.contractor.name) like upper(:contractorName) or upper(woe.workOrder.contractor.code) like upper(:contractorName) and woe.workOrder.egwStatus.code = :workOrderStatus and woe.workOrder.parent is null and woe.estimate.lineEstimateDetails.id in (select ep.lineEstimateDetails.id from EstimatePhotographs as ep) ")
    public List<String> findContractorsToViewEstimatePhotograph(@Param(value="contractorName") String var1, @Param(value="workOrderStatus") String var2);
}

