/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.elasticsearch.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.egov.works.elasticsearch.model.WorksIndexsRequest;
import org.egov.works.elasticsearch.model.WorksMilestoneIndexResponse;
import org.egov.works.elasticsearch.model.WorksTransactionIndex;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.LongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;

@Service
public class WorksTransactionIndexService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorksTransactionIndexService.class);
    public static final String WORKSTRANSACTION_INDEX_NAME = "workstransaction";
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;

    public List<WorksMilestoneIndexResponse> getWorksTransactionDetails(WorksIndexsRequest worksIndexsRequest) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(worksIndexsRequest);
        ArrayList<WorksMilestoneIndexResponse> resultList = new ArrayList<WorksMilestoneIndexResponse>();
        Long startTime = System.currentTimeMillis();
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{WORKSTRANSACTION_INDEX_NAME}).withPageable((Pageable)new PageRequest(0, 1000)).withQuery((QueryBuilder)boolQuery).build();
        List worksTransactionIndexs = this.elasticsearchTemplate.queryForList((SearchQuery)searchQuery, WorksTransactionIndex.class);
        for (WorksTransactionIndex response : worksTransactionIndexs) {
            WorksMilestoneIndexResponse wmIndexResponse = new WorksMilestoneIndexResponse();
            wmIndexResponse.setLineestimatedetailid(response.getLineestimatedetailid());
            wmIndexResponse.setFund(response.getLineestimatefund());
            wmIndexResponse.setScheme(response.getLineestimatescheme());
            wmIndexResponse.setSubscheme(response.getLineestimatesubscheme());
            wmIndexResponse.setWard(response.getLineestimateboundary());
            wmIndexResponse.setEstimatenumber(response.getEstimatenumber());
            wmIndexResponse.setWin(response.getEstimatewin());
            wmIndexResponse.setNameofthework(response.getNameofthework());
            wmIndexResponse.setContractornamecode(response.getLoanameofagency() + "/" + response.getLoacontractorcode());
            wmIndexResponse.setAgreementnumber(response.getLoanumber());
            wmIndexResponse.setAgreementdate(response.getAgreementdate());
            wmIndexResponse.setWorkstatus(response.getWorkstatus());
            wmIndexResponse.setContractperiod(response.getLoacontractperiod());
            resultList.add(wmIndexResponse);
        }
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by getWorksTransactionDetails is : " + timeTaken + " (millisecs) ");
        }
        return resultList;
    }

    public void getAggregationResults(WorksIndexsRequest worksIndexsRequest, WorksMilestoneIndexResponse wfmileresponse, String orderingAggregationName) {
        List resultBuckets;
        Long startTime = System.currentTimeMillis();
        BoolQueryBuilder boolQuery = this.prepareWhereClause(worksIndexsRequest);
        AggregationBuilder aggregation = ((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"by_aggregationField").field(orderingAggregationName)).size(1000).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"totalestimatedcostinlakhs").field("estimatevalue"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"totalworkordervalueinlakhs").field("loaamount"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"totalbillamountinlakhs").field("loatotalbillamt"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"totalpaidamountinlakhs").field("loatotalpaidamt"));
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{WORKSTRANSACTION_INDEX_NAME}).withQuery((QueryBuilder)boolQuery).withSort((SortBuilder)SortBuilders.fieldSort((String)orderingAggregationName).order(SortOrder.DESC)).addAggregation((AbstractAggregationBuilder)aggregation).build();
        Aggregations worksAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQuery, response -> response.getAggregations());
        if (!orderingAggregationName.equals("lineestimatedetailid")) {
            StringTerms saggr = (StringTerms)worksAggr.get("by_aggregationField");
            resultBuckets = saggr.getBuckets();
        } else {
            LongTerms laggr = (LongTerms)worksAggr.get("by_aggregationField");
            resultBuckets = laggr.getBuckets();
        }
        for (Terms.Bucket entry : resultBuckets) {
            wfmileresponse.setReporttype(worksIndexsRequest.getReportType());
            String fieldName = String.valueOf(entry.getKey());
            wfmileresponse.setName(fieldName);
            Sum totalEstimatedCostInLakhsAggregation = (Sum)entry.getAggregations().get("totalestimatedcostinlakhs");
            Sum totalWorkorderValueInLakhsAggregation = (Sum)entry.getAggregations().get("totalworkordervalueinlakhs");
            Sum totalBillAmountInLakhsAggregation = (Sum)entry.getAggregations().get("totalbillamountinlakhs");
            Sum totalPaidAmountInLakhsAggregation = (Sum)entry.getAggregations().get("totalpaidamountinlakhs");
            wfmileresponse.setTotalnoofworks(entry.getDocCount());
            wfmileresponse.setTotalestimatedcostinlakhs(totalEstimatedCostInLakhsAggregation.getValue());
            wfmileresponse.setTotalworkordervalueinlakhs(totalWorkorderValueInLakhsAggregation.getValue());
            wfmileresponse.setTotalbillamountinlakhs(totalBillAmountInLakhsAggregation.getValue());
            wfmileresponse.setTotalpaidamountinlakhs(totalPaidAmountInLakhsAggregation.getValue());
        }
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken for setting values in getAggregationResults() is : " + timeTaken + " (millisecs) ");
        }
    }

    private BoolQueryBuilder prepareWhereClause(WorksIndexsRequest worksIndexsRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)worksIndexsRequest.getTypeofwork())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"lineestimatetypeofworkname", (Object)worksIndexsRequest.getTypeofwork()));
        }
        if (StringUtils.isNotBlank((CharSequence)worksIndexsRequest.getDistname())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"distname", (Object)worksIndexsRequest.getDistname()));
        }
        if (StringUtils.isNotBlank((CharSequence)worksIndexsRequest.getUlbname())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"ulbname", (Object)worksIndexsRequest.getUlbname()));
        }
        if (worksIndexsRequest.getLineestimatedetailid() != null) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"lineestimatedetailid", (Object)worksIndexsRequest.getLineestimatedetailid()));
        }
        boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"loastatus", (Object)"APPROVED"));
        return boolQuery;
    }
}

