/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.elasticsearch.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.egov.works.elasticsearch.model.WorksIndexsRequest;
import org.egov.works.elasticsearch.model.WorksMilestoneIndexResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.LongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.avg.Avg;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;

@Service
public class WorksMilestoneIndexService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorksMilestoneIndexService.class);
    public static final String WORKSMILESTONE_INDEX_NAME = "worksmilestone";
    public static final String WORKSTRANSACTION_INDEX_NAME = "workstransaction";
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;

    public List<WorksMilestoneIndexResponse> getAggregationResults(WorksIndexsRequest worksIndexsRequest, String orderingAggregationName) {
        String fieldName;
        WorksMilestoneIndexResponse wmIndexResponse;
        LongTerms laggr;
        List resultBuckets;
        StringTerms saggr;
        ArrayList<WorksMilestoneIndexResponse> finalResponses = new ArrayList<WorksMilestoneIndexResponse>();
        ArrayList<WorksMilestoneIndexResponse> worksTransactionResponses = new ArrayList<WorksMilestoneIndexResponse>();
        ArrayList<WorksMilestoneIndexResponse> worksMilestoneResponses = new ArrayList<WorksMilestoneIndexResponse>();
        HashMap<String, WorksMilestoneIndexResponse> worksMilestoneResponseMap = new HashMap<String, WorksMilestoneIndexResponse>();
        Long startTime = System.currentTimeMillis();
        BoolQueryBuilder boolQuery = this.prepareWhereClauseForTransaction(worksIndexsRequest);
        AggregationBuilder aggregation = ((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"by_aggregationField").field(orderingAggregationName)).size(1000).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"totalestimatedcostinlakhs").field("estimatevalue"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"totalworkordervalueinlakhs").field("loaamount"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"totalbillamountinlakhs").field("loatotalbillamt"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"totalpaidamountinlakhs").field("loatotalpaidamt"));
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{WORKSTRANSACTION_INDEX_NAME}).withQuery((QueryBuilder)boolQuery).withSort((SortBuilder)SortBuilders.fieldSort((String)orderingAggregationName).order(SortOrder.DESC)).addAggregation((AbstractAggregationBuilder)aggregation).build();
        Aggregations worksAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQuery, response -> response.getAggregations());
        if (!orderingAggregationName.equals("lineestimatedetailid")) {
            saggr = (StringTerms)worksAggr.get("by_aggregationField");
            resultBuckets = saggr.getBuckets();
        } else {
            laggr = (LongTerms)worksAggr.get("by_aggregationField");
            resultBuckets = laggr.getBuckets();
        }
        for (Terms.Bucket entry : resultBuckets) {
            wmIndexResponse = new WorksMilestoneIndexResponse();
            wmIndexResponse.setReporttype(worksIndexsRequest.getReportType());
            fieldName = String.valueOf(entry.getKey());
            wmIndexResponse.setName(fieldName);
            Sum totalEstimatedCostInLakhsAggregation = (Sum)entry.getAggregations().get("totalestimatedcostinlakhs");
            Sum totalWorkorderValueInLakhsAggregation = (Sum)entry.getAggregations().get("totalworkordervalueinlakhs");
            Sum totalBillAmountInLakhsAggregation = (Sum)entry.getAggregations().get("totalbillamountinlakhs");
            Sum totalPaidAmountInLakhsAggregation = (Sum)entry.getAggregations().get("totalpaidamountinlakhs");
            wmIndexResponse.setTotalnoofworks(entry.getDocCount());
            wmIndexResponse.setTotalestimatedcostinlakhs(totalEstimatedCostInLakhsAggregation.getValue());
            wmIndexResponse.setTotalworkordervalueinlakhs(totalWorkorderValueInLakhsAggregation.getValue());
            wmIndexResponse.setTotalbillamountinlakhs(totalBillAmountInLakhsAggregation.getValue());
            wmIndexResponse.setTotalpaidamountinlakhs(totalPaidAmountInLakhsAggregation.getValue());
            worksTransactionResponses.add(wmIndexResponse);
        }
        boolQuery = this.prepareWhereClauseForMilestone(worksIndexsRequest);
        aggregation = ((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"by_aggregationField").field(orderingAggregationName)).size(1000).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"jan01to15actual").field("jan01to15actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"jan01to15target").field("jan01to15target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"jan16to31actual").field("jan16to31actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"jan16to31target").field("jan16to31target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"feb01to15actual").field("feb01to15actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"feb01to15target").field("feb01to15target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"feb16to28or29actual").field("feb16to28or29actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"feb16to28or29target").field("feb16to28or29target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"mar01to15actual").field("mar01to15actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"mar01to15target").field("mar01to15target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"mar16to31actual").field("mar16to31actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"mar16to31target").field("mar16to31target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"apr01to15actual").field("apr01to15actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"apr01to15target").field("apr01to15target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"apr16to30actual").field("apr16to30actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"apr16to30target").field("apr16to30target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"may01to15actual").field("may01to15actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"may01to15target").field("may01to15target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"may16to31actual").field("may16to31actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"may16to31target").field("may16to31target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"jun01to15actual").field("jun01to15actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"jun01to15target").field("jun01to15target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"jun16to30actual").field("jun16to30actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"jun16to30target").field("jun16to30target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"jul01to15actual").field("jul01to15actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"jul01to15target").field("jul01to15target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"jul16to31actual").field("jul16to31actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"jul16to31target").field("jul16to31target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"aug01to15actual").field("aug01to15actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"aug01to15target").field("aug01to15target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"aug16to31actual").field("aug16to31actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"aug16to31target").field("aug16to31target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"sep01to15actual").field("sep01to15actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"sep01to15target").field("sep01to15target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"sep16to30actual").field("sep16to30actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"sep16to30target").field("sep16to30target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"oct01to15actual").field("oct01to15actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"oct01to15target").field("oct01to15target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"oct16to31actual").field("oct16to31actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"oct16to31target").field("oct16to31target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"nov01to15actual").field("nov01to15actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"nov01to15target").field("nov01to15target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"nov16to30actual").field("nov16to30actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"nov16to30target").field("nov16to30target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"dec01to15actual").field("dec01to15actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"dec01to15target").field("dec01to15target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"dec16to31actual").field("dec16to31actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"dec16to31target").field("dec16to31target"));
        searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{WORKSMILESTONE_INDEX_NAME}).withQuery((QueryBuilder)boolQuery).withSort((SortBuilder)SortBuilders.fieldSort((String)orderingAggregationName).order(SortOrder.DESC)).addAggregation((AbstractAggregationBuilder)aggregation).build();
        worksAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQuery, response -> response.getAggregations());
        if (!orderingAggregationName.equals("lineestimatedetailid")) {
            saggr = (StringTerms)worksAggr.get("by_aggregationField");
            resultBuckets = saggr.getBuckets();
        } else {
            laggr = (LongTerms)worksAggr.get("by_aggregationField");
            resultBuckets = laggr.getBuckets();
        }
        for (Terms.Bucket entry : resultBuckets) {
            wmIndexResponse = new WorksMilestoneIndexResponse();
            wmIndexResponse.setReporttype(worksIndexsRequest.getReportType());
            fieldName = String.valueOf(entry.getKey());
            wmIndexResponse.setName(fieldName);
            Avg jan01to15actual = (Avg)entry.getAggregations().get("jan01to15actual");
            Avg jan01to15target = (Avg)entry.getAggregations().get("jan01to15target");
            Avg jan16to31actual = (Avg)entry.getAggregations().get("jan16to31actual");
            Avg jan16to31target = (Avg)entry.getAggregations().get("jan16to31target");
            Avg feb01to15actual = (Avg)entry.getAggregations().get("feb01to15actual");
            Avg feb01to15target = (Avg)entry.getAggregations().get("feb01to15target");
            Avg feb16to28or29actual = (Avg)entry.getAggregations().get("feb16to28or29actual");
            Avg feb16to28or29target = (Avg)entry.getAggregations().get("feb16to28or29target");
            Avg mar01to15actual = (Avg)entry.getAggregations().get("mar01to15actual");
            Avg mar01to15target = (Avg)entry.getAggregations().get("mar01to15target");
            Avg mar16to31actual = (Avg)entry.getAggregations().get("mar16to31actual");
            Avg mar16to31target = (Avg)entry.getAggregations().get("mar16to31target");
            Avg apr01to15actual = (Avg)entry.getAggregations().get("apr01to15actual");
            Avg apr01to15target = (Avg)entry.getAggregations().get("apr01to15target");
            Avg apr16to30actual = (Avg)entry.getAggregations().get("apr16to30actual");
            Avg apr16to30target = (Avg)entry.getAggregations().get("apr16to30target");
            Avg may01to15actual = (Avg)entry.getAggregations().get("may01to15actual");
            Avg may01to15target = (Avg)entry.getAggregations().get("may01to15target");
            Avg may16to31actual = (Avg)entry.getAggregations().get("may16to31actual");
            Avg may16to31target = (Avg)entry.getAggregations().get("may16to31target");
            Avg jun01to15actual = (Avg)entry.getAggregations().get("jun01to15actual");
            Avg jun01to15target = (Avg)entry.getAggregations().get("jun01to15target");
            Avg jun16to30actual = (Avg)entry.getAggregations().get("jun16to30actual");
            Avg jun16to30target = (Avg)entry.getAggregations().get("jun16to30target");
            Avg jul01to15actual = (Avg)entry.getAggregations().get("jul01to15actual");
            Avg jul01to15target = (Avg)entry.getAggregations().get("jul01to15target");
            Avg jul16to31actual = (Avg)entry.getAggregations().get("jul16to31actual");
            Avg jul16to31target = (Avg)entry.getAggregations().get("jul16to31target");
            Avg aug01to15actual = (Avg)entry.getAggregations().get("aug01to15actual");
            Avg aug01to15target = (Avg)entry.getAggregations().get("aug01to15target");
            Avg aug16to31actual = (Avg)entry.getAggregations().get("aug16to31actual");
            Avg aug16to31target = (Avg)entry.getAggregations().get("aug16to31target");
            Avg sep01to15actual = (Avg)entry.getAggregations().get("sep01to15actual");
            Avg sep01to15target = (Avg)entry.getAggregations().get("sep01to15target");
            Avg sep16to30actual = (Avg)entry.getAggregations().get("sep16to30actual");
            Avg sep16to30target = (Avg)entry.getAggregations().get("sep16to30target");
            Avg oct01to15actual = (Avg)entry.getAggregations().get("oct01to15actual");
            Avg oct01to15target = (Avg)entry.getAggregations().get("oct01to15target");
            Avg oct16to31actual = (Avg)entry.getAggregations().get("oct16to31actual");
            Avg oct16to31target = (Avg)entry.getAggregations().get("oct16to31target");
            Avg nov01to15actual = (Avg)entry.getAggregations().get("nov01to15actual");
            Avg nov01to15target = (Avg)entry.getAggregations().get("nov01to15target");
            Avg nov16to30actual = (Avg)entry.getAggregations().get("nov16to30actual");
            Avg nov16to30target = (Avg)entry.getAggregations().get("nov16to30target");
            Avg dec01to15actual = (Avg)entry.getAggregations().get("dec01to15actual");
            Avg dec01to15target = (Avg)entry.getAggregations().get("dec01to15target");
            Avg dec16to31actual = (Avg)entry.getAggregations().get("dec16to31actual");
            Avg dec16to31target = (Avg)entry.getAggregations().get("dec16to31target");
            wmIndexResponse.setTotalnoofworks(entry.getDocCount());
            wmIndexResponse.setJan01to15actual(jan01to15actual.getValue());
            wmIndexResponse.setJan01to15target(jan01to15target.getValue());
            wmIndexResponse.setJan16to31actual(jan16to31actual.getValue());
            wmIndexResponse.setJan16to31target(jan16to31target.getValue());
            wmIndexResponse.setFeb01to15actual(feb01to15actual.getValue());
            wmIndexResponse.setFeb01to15target(feb01to15target.getValue());
            wmIndexResponse.setFeb16to28or29actual(feb16to28or29actual.getValue());
            wmIndexResponse.setFeb16to28or29target(feb16to28or29target.getValue());
            wmIndexResponse.setMar01to15actual(mar01to15actual.getValue());
            wmIndexResponse.setMar01to15target(mar01to15target.getValue());
            wmIndexResponse.setMar16to31actual(mar16to31actual.getValue());
            wmIndexResponse.setMar16to31target(mar16to31target.getValue());
            wmIndexResponse.setApr01to15actual(apr01to15actual.getValue());
            wmIndexResponse.setApr01to15target(apr01to15target.getValue());
            wmIndexResponse.setApr16to30actual(apr16to30actual.getValue());
            wmIndexResponse.setApr16to30target(apr16to30target.getValue());
            wmIndexResponse.setMay01to15actual(may01to15actual.getValue());
            wmIndexResponse.setMay01to15target(may01to15target.getValue());
            wmIndexResponse.setMay16to31actual(may16to31actual.getValue());
            wmIndexResponse.setMay16to31target(may16to31target.getValue());
            wmIndexResponse.setJun01to15actual(jun01to15actual.getValue());
            wmIndexResponse.setJun01to15target(jun01to15target.getValue());
            wmIndexResponse.setJun16to30actual(jun16to30actual.getValue());
            wmIndexResponse.setJun16to30target(jun16to30target.getValue());
            wmIndexResponse.setJul01to15actual(jul01to15actual.getValue());
            wmIndexResponse.setJul01to15target(jul01to15target.getValue());
            wmIndexResponse.setJul16to31actual(jul16to31actual.getValue());
            wmIndexResponse.setJul16to31target(jul16to31target.getValue());
            wmIndexResponse.setAug01to15actual(aug01to15actual.getValue());
            wmIndexResponse.setAug01to15target(aug01to15target.getValue());
            wmIndexResponse.setAug16to31actual(aug16to31actual.getValue());
            wmIndexResponse.setAug16to31target(aug16to31target.getValue());
            wmIndexResponse.setSep01to15actual(sep01to15actual.getValue());
            wmIndexResponse.setSep01to15target(sep01to15target.getValue());
            wmIndexResponse.setSep16to30actual(sep16to30actual.getValue());
            wmIndexResponse.setSep16to30target(sep16to30target.getValue());
            wmIndexResponse.setOct01to15actual(oct01to15actual.getValue());
            wmIndexResponse.setOct01to15target(oct01to15target.getValue());
            wmIndexResponse.setOct16to31actual(oct16to31actual.getValue());
            wmIndexResponse.setOct16to31target(oct16to31target.getValue());
            wmIndexResponse.setNov01to15actual(nov01to15actual.getValue());
            wmIndexResponse.setNov01to15target(nov01to15target.getValue());
            wmIndexResponse.setNov16to30actual(nov16to30actual.getValue());
            wmIndexResponse.setNov16to30target(nov16to30target.getValue());
            wmIndexResponse.setDec01to15actual(dec01to15actual.getValue());
            wmIndexResponse.setDec01to15target(dec01to15target.getValue());
            wmIndexResponse.setDec16to31actual(dec16to31actual.getValue());
            wmIndexResponse.setDec16to31target(dec16to31target.getValue());
            worksMilestoneResponses.add(wmIndexResponse);
        }
        this.prepareResponseMap(worksIndexsRequest, worksMilestoneResponses, worksMilestoneResponseMap);
        this.prepareResultList(worksIndexsRequest, worksTransactionResponses, worksMilestoneResponseMap, finalResponses);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken for setting values in getAggregationResults() is : " + timeTaken + " (millisecs) ");
        }
        return finalResponses;
    }

    public void getAggregationResultsForUlb(WorksIndexsRequest worksIndexsRequest, WorksMilestoneIndexResponse wmIndexResponse, String orderingAggregationName) {
        List resultBuckets;
        Long startTime = System.currentTimeMillis();
        BoolQueryBuilder boolQuery = this.prepareWhereClauseForMilestone(worksIndexsRequest);
        AggregationBuilder aggregation = ((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"by_aggregationField").field(orderingAggregationName)).size(1000).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"jan01to15actual").field("jan01to15actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"jan01to15target").field("jan01to15target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"jan16to31actual").field("jan16to31actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"jan16to31target").field("jan16to31target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"feb01to15actual").field("feb01to15actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"feb01to15target").field("feb01to15target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"feb16to28or29actual").field("feb16to28or29actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"feb16to28or29target").field("feb16to28or29target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"mar01to15actual").field("mar01to15actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"mar01to15target").field("mar01to15target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"mar16to31actual").field("mar16to31actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"mar16to31target").field("mar16to31target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"apr01to15actual").field("apr01to15actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"apr01to15target").field("apr01to15target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"apr16to30actual").field("apr16to30actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"apr16to30target").field("apr16to30target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"may01to15actual").field("may01to15actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"may01to15target").field("may01to15target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"may16to31actual").field("may16to31actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"may16to31target").field("may16to31target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"jun01to15actual").field("jun01to15actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"jun01to15target").field("jun01to15target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"jun16to30actual").field("jun16to30actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"jun16to30target").field("jun16to30target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"jul01to15actual").field("jul01to15actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"jul01to15target").field("jul01to15target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"jul16to31actual").field("jul16to31actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"jul16to31target").field("jul16to31target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"aug01to15actual").field("aug01to15actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"aug01to15target").field("aug01to15target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"aug16to31actual").field("aug16to31actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"aug16to31target").field("aug16to31target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"sep01to15actual").field("sep01to15actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"sep01to15target").field("sep01to15target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"sep16to30actual").field("sep16to30actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"sep16to30target").field("sep16to30target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"oct01to15actual").field("oct01to15actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"oct01to15target").field("oct01to15target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"oct16to31actual").field("oct16to31actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"oct16to31target").field("oct16to31target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"nov01to15actual").field("nov01to15actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"nov01to15target").field("nov01to15target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"nov16to30actual").field("nov16to30actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"nov16to30target").field("nov16to30target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"dec01to15actual").field("dec01to15actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"dec01to15target").field("dec01to15target"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"dec16to31actual").field("dec16to31actual"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)"dec16to31target").field("dec16to31target"));
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{WORKSMILESTONE_INDEX_NAME}).withQuery((QueryBuilder)boolQuery).withSort((SortBuilder)SortBuilders.fieldSort((String)orderingAggregationName).order(SortOrder.DESC)).addAggregation((AbstractAggregationBuilder)aggregation).build();
        Aggregations worksAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQuery, response -> response.getAggregations());
        if (!orderingAggregationName.equals("lineestimatedetailid")) {
            StringTerms saggr = (StringTerms)worksAggr.get("by_aggregationField");
            resultBuckets = saggr.getBuckets();
        } else {
            LongTerms laggr = (LongTerms)worksAggr.get("by_aggregationField");
            resultBuckets = laggr.getBuckets();
        }
        for (Terms.Bucket entry : resultBuckets) {
            Avg jan01to15actual = (Avg)entry.getAggregations().get("jan01to15actual");
            Avg jan01to15target = (Avg)entry.getAggregations().get("jan01to15target");
            Avg jan16to31actual = (Avg)entry.getAggregations().get("jan16to31actual");
            Avg jan16to31target = (Avg)entry.getAggregations().get("jan16to31target");
            Avg feb01to15actual = (Avg)entry.getAggregations().get("feb01to15actual");
            Avg feb01to15target = (Avg)entry.getAggregations().get("feb01to15target");
            Avg feb16to28or29actual = (Avg)entry.getAggregations().get("feb16to28or29actual");
            Avg feb16to28or29target = (Avg)entry.getAggregations().get("feb16to28or29target");
            Avg mar01to15actual = (Avg)entry.getAggregations().get("mar01to15actual");
            Avg mar01to15target = (Avg)entry.getAggregations().get("mar01to15target");
            Avg mar16to31actual = (Avg)entry.getAggregations().get("mar16to31actual");
            Avg mar16to31target = (Avg)entry.getAggregations().get("mar16to31target");
            Avg apr01to15actual = (Avg)entry.getAggregations().get("apr01to15actual");
            Avg apr01to15target = (Avg)entry.getAggregations().get("apr01to15target");
            Avg apr16to30actual = (Avg)entry.getAggregations().get("apr16to30actual");
            Avg apr16to30target = (Avg)entry.getAggregations().get("apr16to30target");
            Avg may01to15actual = (Avg)entry.getAggregations().get("may01to15actual");
            Avg may01to15target = (Avg)entry.getAggregations().get("may01to15target");
            Avg may16to31actual = (Avg)entry.getAggregations().get("may16to31actual");
            Avg may16to31target = (Avg)entry.getAggregations().get("may16to31target");
            Avg jun01to15actual = (Avg)entry.getAggregations().get("jun01to15actual");
            Avg jun01to15target = (Avg)entry.getAggregations().get("jun01to15target");
            Avg jun16to30actual = (Avg)entry.getAggregations().get("jun16to30actual");
            Avg jun16to30target = (Avg)entry.getAggregations().get("jun16to30target");
            Avg jul01to15actual = (Avg)entry.getAggregations().get("jul01to15actual");
            Avg jul01to15target = (Avg)entry.getAggregations().get("jul01to15target");
            Avg jul16to31actual = (Avg)entry.getAggregations().get("jul16to31actual");
            Avg jul16to31target = (Avg)entry.getAggregations().get("jul16to31target");
            Avg aug01to15actual = (Avg)entry.getAggregations().get("aug01to15actual");
            Avg aug01to15target = (Avg)entry.getAggregations().get("aug01to15target");
            Avg aug16to31actual = (Avg)entry.getAggregations().get("aug16to31actual");
            Avg aug16to31target = (Avg)entry.getAggregations().get("aug16to31target");
            Avg sep01to15actual = (Avg)entry.getAggregations().get("sep01to15actual");
            Avg sep01to15target = (Avg)entry.getAggregations().get("sep01to15target");
            Avg sep16to30actual = (Avg)entry.getAggregations().get("sep16to30actual");
            Avg sep16to30target = (Avg)entry.getAggregations().get("sep16to30target");
            Avg oct01to15actual = (Avg)entry.getAggregations().get("oct01to15actual");
            Avg oct01to15target = (Avg)entry.getAggregations().get("oct01to15target");
            Avg oct16to31actual = (Avg)entry.getAggregations().get("oct16to31actual");
            Avg oct16to31target = (Avg)entry.getAggregations().get("oct16to31target");
            Avg nov01to15actual = (Avg)entry.getAggregations().get("nov01to15actual");
            Avg nov01to15target = (Avg)entry.getAggregations().get("nov01to15target");
            Avg nov16to30actual = (Avg)entry.getAggregations().get("nov16to30actual");
            Avg nov16to30target = (Avg)entry.getAggregations().get("nov16to30target");
            Avg dec01to15actual = (Avg)entry.getAggregations().get("dec01to15actual");
            Avg dec01to15target = (Avg)entry.getAggregations().get("dec01to15target");
            Avg dec16to31actual = (Avg)entry.getAggregations().get("dec16to31actual");
            Avg dec16to31target = (Avg)entry.getAggregations().get("dec16to31target");
            wmIndexResponse.setTotalnoofworks(entry.getDocCount());
            wmIndexResponse.setJan01to15actual(jan01to15actual.getValue());
            wmIndexResponse.setJan01to15target(jan01to15target.getValue());
            wmIndexResponse.setJan16to31actual(jan16to31actual.getValue());
            wmIndexResponse.setJan16to31target(jan16to31target.getValue());
            wmIndexResponse.setFeb01to15actual(feb01to15actual.getValue());
            wmIndexResponse.setFeb01to15target(feb01to15target.getValue());
            wmIndexResponse.setFeb16to28or29actual(feb16to28or29actual.getValue());
            wmIndexResponse.setFeb16to28or29target(feb16to28or29target.getValue());
            wmIndexResponse.setMar01to15actual(mar01to15actual.getValue());
            wmIndexResponse.setMar01to15target(mar01to15target.getValue());
            wmIndexResponse.setMar16to31actual(mar16to31actual.getValue());
            wmIndexResponse.setMar16to31target(mar16to31target.getValue());
            wmIndexResponse.setApr01to15actual(apr01to15actual.getValue());
            wmIndexResponse.setApr01to15target(apr01to15target.getValue());
            wmIndexResponse.setApr16to30actual(apr16to30actual.getValue());
            wmIndexResponse.setApr16to30target(apr16to30target.getValue());
            wmIndexResponse.setMay01to15actual(may01to15actual.getValue());
            wmIndexResponse.setMay01to15target(may01to15target.getValue());
            wmIndexResponse.setMay16to31actual(may16to31actual.getValue());
            wmIndexResponse.setMay16to31target(may16to31target.getValue());
            wmIndexResponse.setJun01to15actual(jun01to15actual.getValue());
            wmIndexResponse.setJun01to15target(jun01to15target.getValue());
            wmIndexResponse.setJun16to30actual(jun16to30actual.getValue());
            wmIndexResponse.setJun16to30target(jun16to30target.getValue());
            wmIndexResponse.setJul01to15actual(jul01to15actual.getValue());
            wmIndexResponse.setJul01to15target(jul01to15target.getValue());
            wmIndexResponse.setJul16to31actual(jul16to31actual.getValue());
            wmIndexResponse.setJul16to31target(jul16to31target.getValue());
            wmIndexResponse.setAug01to15actual(aug01to15actual.getValue());
            wmIndexResponse.setAug01to15target(aug01to15target.getValue());
            wmIndexResponse.setAug16to31actual(aug16to31actual.getValue());
            wmIndexResponse.setAug16to31target(aug16to31target.getValue());
            wmIndexResponse.setSep01to15actual(sep01to15actual.getValue());
            wmIndexResponse.setSep01to15target(sep01to15target.getValue());
            wmIndexResponse.setSep16to30actual(sep16to30actual.getValue());
            wmIndexResponse.setSep16to30target(sep16to30target.getValue());
            wmIndexResponse.setOct01to15actual(oct01to15actual.getValue());
            wmIndexResponse.setOct01to15target(oct01to15target.getValue());
            wmIndexResponse.setOct16to31actual(oct16to31actual.getValue());
            wmIndexResponse.setOct16to31target(oct16to31target.getValue());
            wmIndexResponse.setNov01to15actual(nov01to15actual.getValue());
            wmIndexResponse.setNov01to15target(nov01to15target.getValue());
            wmIndexResponse.setNov16to30actual(nov16to30actual.getValue());
            wmIndexResponse.setNov16to30target(nov16to30target.getValue());
            wmIndexResponse.setDec01to15actual(dec01to15actual.getValue());
            wmIndexResponse.setDec01to15target(dec01to15target.getValue());
            wmIndexResponse.setDec16to31actual(dec16to31actual.getValue());
            wmIndexResponse.setDec16to31target(dec16to31target.getValue());
        }
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken for setting values in getAggregationResultsForUlb() is : " + timeTaken + " (millisecs) ");
        }
    }

    private void prepareResultList(WorksIndexsRequest worksIndexsRequest, List<WorksMilestoneIndexResponse> worksTransactionResponses, Map<String, WorksMilestoneIndexResponse> worksMilestoneResponseMap, List<WorksMilestoneIndexResponse> finalResponses) {
        for (WorksMilestoneIndexResponse transactionResponse : worksTransactionResponses) {
            WorksMilestoneIndexResponse finalResponse;
            if (worksMilestoneResponseMap.get(this.prepareGroupingKey(worksIndexsRequest, transactionResponse)) != null) {
                WorksMilestoneIndexResponse milestoneResponse = worksMilestoneResponseMap.get(this.prepareGroupingKey(worksIndexsRequest, transactionResponse));
                finalResponse = new WorksMilestoneIndexResponse();
                finalResponse = milestoneResponse;
                finalResponse.setTotalbillamountinlakhs(transactionResponse.getTotalbillamountinlakhs());
                finalResponse.setTotalestimatedcostinlakhs(transactionResponse.getTotalestimatedcostinlakhs());
                finalResponse.setTotalpaidamountinlakhs(transactionResponse.getTotalpaidamountinlakhs());
                finalResponse.setTotalworkordervalueinlakhs(transactionResponse.getTotalworkordervalueinlakhs());
                finalResponse.setMilestonenotcreatedcount(transactionResponse.getTotalnoofworks() - milestoneResponse.getTotalnoofworks());
                finalResponse.setTotalnoofworks(transactionResponse.getTotalnoofworks());
            } else {
                finalResponse = new WorksMilestoneIndexResponse();
                finalResponse = transactionResponse;
                finalResponse.setMilestonenotcreatedcount(transactionResponse.getTotalnoofworks());
            }
            finalResponses.add(finalResponse);
        }
    }

    private void prepareResponseMap(WorksIndexsRequest worksIndexsRequest, List<WorksMilestoneIndexResponse> worksTransactionResponses, Map<String, WorksMilestoneIndexResponse> worksTransactionResponseMap) {
        for (WorksMilestoneIndexResponse response : worksTransactionResponses) {
            worksTransactionResponseMap.put(this.prepareGroupingKey(worksIndexsRequest, response), response);
        }
    }

    private String prepareGroupingKey(WorksIndexsRequest worksMilestoneIndexRequest, WorksMilestoneIndexResponse response) {
        String groupingKey = "";
        if (StringUtils.isNotBlank((CharSequence)worksMilestoneIndexRequest.getTypeofwork())) {
            groupingKey = groupingKey + worksMilestoneIndexRequest.getTypeofwork();
        }
        if (StringUtils.isNotBlank((CharSequence)worksMilestoneIndexRequest.getDistname())) {
            groupingKey = groupingKey + worksMilestoneIndexRequest.getDistname();
        }
        if (StringUtils.isNotBlank((CharSequence)worksMilestoneIndexRequest.getUlbname())) {
            groupingKey = groupingKey + worksMilestoneIndexRequest.getUlbname();
        }
        if (worksMilestoneIndexRequest.getUlbcodes() != null && !worksMilestoneIndexRequest.getUlbcodes().isEmpty()) {
            for (String ulbcode : worksMilestoneIndexRequest.getUlbcodes()) {
                groupingKey = groupingKey + ulbcode;
            }
        }
        groupingKey = groupingKey + response.getName();
        return groupingKey;
    }

    private BoolQueryBuilder prepareWhereClauseForMilestone(WorksIndexsRequest worksIndexsRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)worksIndexsRequest.getTypeofwork())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"lineestimatetypeofworkname", (Object)worksIndexsRequest.getTypeofwork()));
        }
        if (StringUtils.isNotBlank((CharSequence)worksIndexsRequest.getDistname())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"distname", (Object)worksIndexsRequest.getDistname()));
        }
        if (StringUtils.isNotBlank((CharSequence)worksIndexsRequest.getUlbname())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"ulbname", (Object)worksIndexsRequest.getUlbname()));
        }
        if (worksIndexsRequest.getUlbcodes() != null && !worksIndexsRequest.getUlbcodes().isEmpty()) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)"ulbcode", worksIndexsRequest.getUlbcodes()));
        }
        if (worksIndexsRequest.getLineestimatedetailid() != null) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"lineestimatedetailid", (Object)worksIndexsRequest.getLineestimatedetailid()));
        }
        boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"milestonestatus", (Object)"APPROVED"));
        return boolQuery;
    }

    private BoolQueryBuilder prepareWhereClauseForTransaction(WorksIndexsRequest worksIndexsRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)worksIndexsRequest.getTypeofwork())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"lineestimatetypeofworkname", (Object)worksIndexsRequest.getTypeofwork()));
        }
        if (StringUtils.isNotBlank((CharSequence)worksIndexsRequest.getDistname())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"distname", (Object)worksIndexsRequest.getDistname()));
        }
        if (StringUtils.isNotBlank((CharSequence)worksIndexsRequest.getUlbname())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"ulbname", (Object)worksIndexsRequest.getUlbname()));
        }
        if (worksIndexsRequest.getUlbcodes() != null && !worksIndexsRequest.getUlbcodes().isEmpty()) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)"ulbcode", worksIndexsRequest.getUlbcodes()));
        }
        if (worksIndexsRequest.getLineestimatedetailid() != null) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"lineestimatedetailid", (Object)worksIndexsRequest.getLineestimatedetailid()));
        }
        boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"loastatus", (Object)"APPROVED"));
        return boolQuery;
    }
}

