/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.abstractestimate.entity;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringEscapeUtils;
import org.egov.common.entity.UOM;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.utils.StringUtils;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="EGW_NONSOR")
@SequenceGenerator(name="SEQ_EGW_NONSOR", sequenceName="SEQ_EGW_NONSOR", allocationSize=1)
public class NonSor
extends AbstractAuditable {
    private static final long serialVersionUID = -2421682889450100305L;
    public static final String SEQ_EGW_NONSOR = "SEQ_EGW_NONSOR";
    @Id
    @GeneratedValue(generator="SEQ_EGW_NONSOR", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @SafeHtml
    private String description;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="uom")
    private UOM uom;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @NotEmpty(message="nonsor.desc.empty")
    @Length(max=4000, message="masters.description.length")
    public String getDescription() {
        return this.description;
    }

    public String getDescriptionJS() {
        return StringUtils.escapeJavaScript((String)this.description);
    }

    public void setDescription(String description) {
        this.description = StringEscapeUtils.unescapeHtml((String)description);
    }

    public UOM getUom() {
        return this.uom;
    }

    public void setUom(UOM uom) {
        this.uom = uom;
    }
}

