/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.egov.commons.CFinancialYear;
import org.egov.infra.utils.DateUtils;
import org.egov.infstr.services.PersistenceService;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.models.tender.EstimateLineItemsForWP;
import org.egov.works.models.tender.WorksPackage;
import org.egov.works.models.tender.WorksPackageDetails;
import org.egov.works.models.tender.WorksPackageNumberGenerator;
import org.egov.works.services.WorksPackageService;
import org.egov.works.services.impl.BaseServiceImpl;

public class WorksPackageServiceImpl
extends BaseServiceImpl<WorksPackage, Long>
implements WorksPackageService {
    private WorksPackageNumberGenerator workspackageGenerator;

    public WorksPackageServiceImpl(PersistenceService<WorksPackage, Long> persistenceService) {
        super(persistenceService);
    }

    @Override
    public void setWorksPackageNumber(WorksPackage entity, CFinancialYear finYear) {
        if (entity.getWpNumber() == null) {
            entity.setWpNumber(this.workspackageGenerator.getWorksPackageNumber(entity, finYear));
        }
    }

    @Override
    public List<AbstractEstimate> getAbStractEstimateListByWorksPackage(WorksPackage entity) {
        ArrayList<AbstractEstimate> abList = new ArrayList<AbstractEstimate>();
        if (entity != null && !entity.getWorksPackageDetails().isEmpty()) {
            for (WorksPackageDetails wpd : entity.getWorksPackageDetails()) {
                abList.add(wpd.getEstimate());
            }
        }
        return abList;
    }

    public void setWorkspackageGenerator(WorksPackageNumberGenerator workspackageGenerator) {
        this.workspackageGenerator = workspackageGenerator;
    }

    @Override
    public Collection<EstimateLineItemsForWP> getActivitiesForEstimate(WorksPackage wpObj) {
        HashMap<Long, EstimateLineItemsForWP> resultMap = new HashMap<Long, EstimateLineItemsForWP>();
        List<AbstractEstimate> abList = this.getAbStractEstimateListByWorksPackage(wpObj);
        for (Activity act : this.getAllActivities(abList)) {
            EstimateLineItemsForWP estlineItem = new EstimateLineItemsForWP();
            if (act.getSchedule() != null) {
                if (resultMap.containsKey(act.getSchedule().getId())) {
                    EstimateLineItemsForWP preEstlineItem = (EstimateLineItemsForWP)resultMap.get(act.getSchedule().getId());
                    preEstlineItem.setQuantity(act.getQuantity() + preEstlineItem.getQuantity());
                    if (DateUtils.compareDates((Date)act.getAbstractEstimate().getEstimateDate(), (Date)preEstlineItem.getEstimateDate())) {
                        preEstlineItem.setRate(act.getEstimateRate());
                        preEstlineItem.setAmt(preEstlineItem.getQuantity() * act.getRate());
                    }
                    resultMap.put(act.getSchedule().getId(), preEstlineItem);
                } else {
                    this.addEstLineItem(act, estlineItem);
                    resultMap.put(act.getSchedule().getId(), estlineItem);
                }
            }
            if (act.getNonSor() == null) continue;
            this.addEstLineItem(act, estlineItem);
            resultMap.put(act.getNonSor().getId(), estlineItem);
        }
        return this.getEstLineItemsWithSrlNo(resultMap.values());
    }

    private void addEstLineItem(Activity act, EstimateLineItemsForWP estlineItem) {
        if (act.getSchedule() == null) {
            estlineItem.setCode("");
            estlineItem.setDescription(act.getNonSor().getDescription());
            estlineItem.setRate(act.getRate());
        } else {
            estlineItem.setCode(act.getSchedule().getCode());
            estlineItem.setDescription(act.getSchedule().getDescription());
            estlineItem.setRate(act.getEstimateRate());
        }
        estlineItem.setAmt(act.getQuantity() * act.getRate());
        estlineItem.setEstimateDate(act.getAbstractEstimate().getEstimateDate());
        estlineItem.setQuantity(act.getQuantity());
        estlineItem.setUom(act.getUom().getUom());
    }

    private List<Activity> getAllActivities(List<AbstractEstimate> abList) {
        ArrayList<Activity> actList = new ArrayList<Activity>();
        for (AbstractEstimate ab : abList) {
            actList.addAll(ab.getActivities());
        }
        return actList;
    }

    @Override
    public double getTotalAmount(Collection<EstimateLineItemsForWP> actList) {
        double totalAmt = 0.0;
        for (EstimateLineItemsForWP act : actList) {
            totalAmt += act.getAmt();
        }
        return totalAmt;
    }

    private Collection<EstimateLineItemsForWP> getEstLineItemsWithSrlNo(Collection<EstimateLineItemsForWP> actList) {
        int i = 1;
        ArrayList<EstimateLineItemsForWP> latestEstLineItemList = new ArrayList<EstimateLineItemsForWP>();
        for (EstimateLineItemsForWP act : actList) {
            act.setSrlNo(i);
            latestEstLineItemList.add(act);
            ++i;
        }
        return latestEstLineItemList;
    }

    @Override
    public WorksPackage getWorksPackageForAbstractEstimate(AbstractEstimate estimate) {
        WorksPackage wp = (WorksPackage)((Object)this.persistenceService.find("select wpd.worksPackage from WorksPackageDetails wpd where wpd.estimate.estimateNumber = ? and wpd.worksPackage.egwStatus.code<>'CANCELLED'", new Object[]{estimate.getEstimateNumber()}));
        return wp;
    }

    @Override
    public List<Object> getWorksPackageDetails(Long estimateId) {
        List wpDetails = this.genericService.findAllBy("select wpd.worksPackage.id, wpd.worksPackage.wpNumber from WorksPackageDetails wpd  where wpd.estimate.id= ? and  wpd.worksPackage.egwStatus.code not in (?,?) ", new Object[]{estimateId, "NEW", "CANCELLED"});
        return wpDetails;
    }
}

