/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.model.budget.BudgetGroup;
import org.springframework.beans.factory.annotation.Autowired;

public class WorkProgressAbstractReportService {
    private static final Logger logger = Logger.getLogger(WorkProgressAbstractReportService.class);
    private BudgetDetailsDAO budgetDetailsDAO;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;

    public void setBudgetHeadsFromString(String budgetHeadsStr, List<String> budgetHeads, List<Long> budgetHeadIds) {
        ArrayList budgetHeadList = new ArrayList();
        ArrayList coaList = new ArrayList();
        if (StringUtils.isNotBlank((String)budgetHeadsStr)) {
            String[] budgetHeadsFromString;
            for (String element : budgetHeadsFromString = budgetHeadsStr.split(",")) {
                coaList.addAll(this.chartOfAccountsHibernateDAO.getListOfDetailCode(element.split("-")[0]));
            }
            budgetHeadList.addAll(this.budgetDetailsDAO.getBudgetHeadForGlcodeList(coaList));
            ArrayList<Long> budgetHeadIdsLong = new ArrayList<Long>();
            ArrayList<String> budgetHeadIdStr = new ArrayList<String>();
            if (budgetHeadList != null && budgetHeadList.size() > 0) {
                for (BudgetGroup bdgtGrp : budgetHeadList) {
                    budgetHeadIdStr.add(bdgtGrp.getId().toString());
                    budgetHeadIdsLong.add(bdgtGrp.getId());
                }
            }
            budgetHeads.addAll(budgetHeadIdStr);
            budgetHeadIds.addAll(budgetHeadIdsLong);
        }
    }

    public void setBudgetHeadsFromIdString(String budgetHeadsStr, List<String> budgetHeads, List<Long> budgetHeadIds) {
        if (StringUtils.isNotBlank((String)budgetHeadsStr)) {
            String[] budgetHeadIdsFromString;
            for (String element : budgetHeadIdsFromString = budgetHeadsStr.split(",")) {
                budgetHeads.add(element);
                budgetHeadIds.add(Long.parseLong(element));
            }
        }
    }

    public void setDepositCodesFromString(String depositCodesStr, List<Long> depositCodeIds) {
        ArrayList coaList = new ArrayList();
        if (StringUtils.isNotBlank((String)depositCodesStr)) {
            String[] depositCodesFromStr;
            for (String element : depositCodesFromStr = depositCodesStr.split(",")) {
                coaList.addAll(this.chartOfAccountsHibernateDAO.getListOfDetailCode(element.split("-")[0]));
            }
            ArrayList<Long> depositCodeIdsLong = new ArrayList<Long>();
            if (coaList != null && coaList.size() > 0) {
                for (CChartOfAccounts coa : coaList) {
                    depositCodeIdsLong.add(coa.getId());
                }
            }
            depositCodeIds.addAll(depositCodeIdsLong);
        }
    }

    public void setDepositCodesFromIdString(String depositCodesStr, List<Long> depositCodeIds) {
        new ArrayList();
        if (StringUtils.isNotBlank((String)depositCodesStr)) {
            String[] depositCodesFromStr;
            for (String element : depositCodesFromStr = depositCodesStr.split(",")) {
                depositCodeIds.add(Long.parseLong(element));
            }
        }
    }

    public BigDecimal getRoundedOfAmount(Object amount, int decimalPoints) {
        int dividingFactor = 10000000;
        if (amount != null) {
            BigDecimal divisor = new BigDecimal(10000000);
            BigDecimal amountBD = (BigDecimal)amount;
            BigDecimal result = amountBD.divide(divisor);
            return result.setScale(decimalPoints, RoundingMode.HALF_UP);
        }
        return null;
    }

    public void setBudgetDetailsDAO(BudgetDetailsDAO budgetDetailsDAO) {
        this.budgetDetailsDAO = budgetDetailsDAO;
    }
}

