/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.service.PersonalInformationService;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.models.tender.TenderResponse;
import org.egov.works.models.tender.TenderResponseActivity;
import org.egov.works.models.tender.TenderResponseContractors;

public class TenderResponseService
extends PersistenceService<TenderResponse, Long> {
    private static final Logger logger = Logger.getLogger(TenderResponseService.class);
    private PersonalInformationService personalInformationService;
    private PersistenceService persistenceService;

    public TenderResponseService() {
        super(TenderResponse.class);
    }

    public TenderResponseService(Class<TenderResponse> type) {
        super(type);
    }

    public List getApprovedByList(Integer deptId) {
        List approvedByList = null;
        try {
            HashMap<String, Object> criteriaParams = new HashMap<String, Object>();
            criteriaParams.put("departmentId", deptId);
            criteriaParams.put("isPrimary", "Y");
            approvedByList = this.personalInformationService.getListOfEmployeeViewBasedOnCriteria(criteriaParams, Integer.valueOf(-1), Integer.valueOf(-1));
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("user.find.error", (Throwable)e);
        }
        return approvedByList;
    }

    public List populateNegotiationPreparedByList(AbstractEstimate abstractEstimate) {
        List negotiationPreparedByList = null;
        if (abstractEstimate != null && abstractEstimate.getExecutingDepartment() != null) {
            try {
                HashMap<String, Object> criteriaParams = new HashMap<String, Object>();
                criteriaParams.put("departmentId", abstractEstimate.getExecutingDepartment().getId());
                criteriaParams.put("isPrimary", "Y");
                negotiationPreparedByList = this.personalInformationService.getListOfEmployeeViewBasedOnCriteria(criteriaParams, Integer.valueOf(-1), Integer.valueOf(-1));
            }
            catch (Exception e) {
                logger.info((Object)"-----inside tenderResponseservice---------Exception");
                negotiationPreparedByList = Collections.emptyList();
            }
        }
        if (negotiationPreparedByList == null) {
            negotiationPreparedByList = Collections.emptyList();
        }
        return negotiationPreparedByList;
    }

    public Collection<TenderResponseActivity> getTenderResponseActivityList(List<TenderResponseActivity> actionTenderResponseActivities) {
        return CollectionUtils.select(actionTenderResponseActivities, tenderReponseAct -> {
            TenderResponseActivity tra = (TenderResponseActivity)((Object)((Object)tenderReponseAct));
            if (tra == null) {
                return false;
            }
            tra.setActivity((Activity)((Object)((Object)this.persistenceService.find("from Activity where id=?", new Object[]{tra.getActivity().getId()}))));
            return true;
        });
    }

    public Collection<TenderResponseContractors> getActionTenderResponseContractorsList(List<TenderResponseContractors> actionTenderResponseContractors) {
        return CollectionUtils.select(actionTenderResponseContractors, tenderResponseContractors -> (TenderResponseContractors)((Object)((Object)tenderResponseContractors)) != null);
    }

    public void setPersonalInformationService(PersonalInformationService personalInformationService) {
        this.personalInformationService = personalInformationService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }
}

