/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.offlinestatus.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.collections.CollectionUtils;
import org.egov.works.models.tender.OfflineStatus;
import org.egov.works.offlinestatus.repository.OfflineStatusRepository;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class OfflineStatusService {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private OfflineStatusRepository offlineStatusRepository;
    @Autowired
    private WorksUtils worksUtils;

    @Transactional
    public void create(List<OfflineStatus> offlineStatuses, Long ObjectId, String ObjectType) {
        for (OfflineStatus status : offlineStatuses) {
            if (status.getId() != null) continue;
            status.setObjectId(ObjectId);
            status.setObjectType(ObjectType);
            status.setEgwStatus(this.worksUtils.getStatusById(status.getEgwStatus().getId()));
            this.offlineStatusRepository.save((Object)status);
        }
    }

    public List<OfflineStatus> getOfflineStatusByObjectIdAndType(Long objectId, String objectType) {
        return this.offlineStatusRepository.findByObjectIdAndObjectType(objectId, objectType);
    }

    public Collection<String> getStatusNameDetails(String[] statusNames) {
        return CollectionUtils.select(Arrays.asList(statusNames), statusName -> (String)statusName != null);
    }

    public OfflineStatus getOfflineStatusByObjectIdAndObjectTypeAndStatus(Long objectId, String objectType, String statusCode) {
        return this.offlineStatusRepository.findByObjectIdAndObjectTypeAndEgwStatus_code(objectId, objectType, statusCode);
    }

    public OfflineStatus getLastOfflineStatusByObjectIdAndObjectType(Long objectId, String objectType) {
        return this.offlineStatusRepository.getLastOfflineStatusByObjectIdAndObjectType(objectId, objectType);
    }
}

