/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.models.masters;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.egov.commons.CChartOfAccounts;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.works.models.masters.OverheadRate;

@Entity
@Table(name="EGW_OVERHEAD")
@Unique(id="id", tableName="EGW_OVERHEAD", columnName={"name"}, fields={"name"}, enableDfltMsg=true)
@NamedQueries(value={@NamedQuery(name="OVERHEADS_BY_DATE", query="from Overhead o inner join fetch o.overheadRates as rates where ((? between rates.validity.startDate and rates.validity.endDate ) or (rates.validity.startDate<=? and rates.validity.endDate is null))"), @NamedQuery(name="BY_DATE_AND_TYPE", query="from Overhead o inner join fetch o.overheadRates as rates where ((? between rates.validity.startDate and rates.validity.endDate ) or (rates.validity.startDate<=? and rates.validity.endDate is null))")})
@SequenceGenerator(name="SEQ_EGW_OVERHEAD", sequenceName="SEQ_EGW_OVERHEAD", allocationSize=1)
public class Overhead
extends AbstractAuditable {
    private static final long serialVersionUID = 474905206086516812L;
    public static final String SEQ_EGW_OVERHEAD = "SEQ_EGW_OVERHEAD";
    public static final String BY_DATE_AND_TYPE = "BY_DATE_AND_TYPE";
    public static final String OVERHEADS_BY_DATE = "OVERHEADS_BY_DATE";
    @Id
    @GeneratedValue(generator="SEQ_EGW_OVERHEAD", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    private String name;
    @NotNull
    private String description;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="accountcode", nullable=false)
    private CChartOfAccounts accountCode;
    @JsonIgnore
    @OrderBy(value="id")
    @OneToMany(mappedBy="overhead", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=OverheadRate.class)
    private final List<OverheadRate> overheadRates = new ArrayList<OverheadRate>(0);
    @Transient
    private List<OverheadRate> tempOverheadRateValues = new ArrayList<OverheadRate>(0);

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CChartOfAccounts getAccountCode() {
        return this.accountCode;
    }

    public void setAccountCode(CChartOfAccounts accountCode) {
        this.accountCode = accountCode;
    }

    public List<OverheadRate> getOverheadRates() {
        return this.overheadRates;
    }

    public List<OverheadRate> getTempOverheadRateValues() {
        return this.tempOverheadRateValues;
    }

    public void setTempOverheadRateValues(List<OverheadRate> tempOverheadRateValues) {
        this.tempOverheadRateValues = tempOverheadRateValues;
    }
}

