/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.models.masters;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.egov.commons.EgwTypeOfWork;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.OptionalPattern;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.works.models.masters.MilestoneTemplateActivity;

@Entity
@Table(name="EGW_MILESTONE_TEMPLATE")
@Unique(id="id", tableName="EGW_MILESTONE_TEMPLATE", columnName={"code"}, fields={"code"}, enableDfltMsg=true)
@SequenceGenerator(name="SEQ_EGW_MILESTONE_TEMPLATE", sequenceName="SEQ_EGW_MILESTONE_TEMPLATE", allocationSize=1)
public class MilestoneTemplate
extends AbstractAuditable {
    private static final long serialVersionUID = 474905206086516812L;
    public static final String SEQ_EGW_MILESTONE_TEMPLATE = "SEQ_EGW_MILESTONE_TEMPLATE";
    @Id
    @GeneratedValue(generator="SEQ_EGW_MILESTONE_TEMPLATE", strategy=GenerationType.SEQUENCE)
    private Long id;
    private String code;
    @OptionalPattern(regex="[0-9a-zA-Z_@./#&+-/!(){}\",^$%*|=;:<>?`~ ]+", message="milestonetemplate.name.alphaNumeric")
    private String name;
    @OptionalPattern(regex="[0-9a-zA-Z_@./#&+-/!(){}\",^$%*|=;:<>?`~ ]+", message="milestonetemplate.description.alphaNumeric")
    private String description;
    private Integer status;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="typeOfWork", nullable=false)
    private EgwTypeOfWork typeOfWork;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="subTypeOfWork")
    private EgwTypeOfWork subTypeOfWork;
    @OrderBy(value="id")
    @OneToMany(mappedBy="milestoneTemplate", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=MilestoneTemplateActivity.class)
    private final List<MilestoneTemplateActivity> milestoneTemplateActivities = new ArrayList<MilestoneTemplateActivity>(0);

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public EgwTypeOfWork getTypeOfWork() {
        return this.typeOfWork;
    }

    public void setTypeOfWork(EgwTypeOfWork typeOfWork) {
        this.typeOfWork = typeOfWork;
    }

    public EgwTypeOfWork getSubTypeOfWork() {
        return this.subTypeOfWork;
    }

    public void setSubTypeOfWork(EgwTypeOfWork subTypeOfWork) {
        this.subTypeOfWork = subTypeOfWork;
    }

    public List<MilestoneTemplateActivity> getMilestoneTemplateActivities() {
        return this.milestoneTemplateActivities;
    }

    public void addMilestoneTemplateActivity(MilestoneTemplateActivity milestoneTemplateactivity) {
        this.milestoneTemplateActivities.add(milestoneTemplateactivity);
    }
}

