/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.models.masters;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.egov.infra.persistence.entity.component.Money;
import org.egov.infra.persistence.entity.component.Period;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infstr.models.BaseModel;
import org.egov.works.models.masters.ScheduleOfRate;

public class MarketRate
extends BaseModel {
    private static final long serialVersionUID = -6785284745222705060L;
    private ScheduleOfRate scheduleOfRate;
    @Valid
    private Money marketRate;
    private Period validity;

    public ScheduleOfRate getScheduleOfRate() {
        return this.scheduleOfRate;
    }

    public void setScheduleOfRate(ScheduleOfRate scheduleOfRate) {
        this.scheduleOfRate = scheduleOfRate;
    }

    public Money getMarketRate() {
        return this.marketRate;
    }

    public void setMarketRate(Money marketRate) {
        this.marketRate = marketRate;
    }

    public Period getValidity() {
        return this.validity;
    }

    public void setValidity(Period validity) {
        this.validity = validity;
    }

    public MarketRate() {
    }

    public MarketRate(Money sorrate) {
        this.marketRate = sorrate;
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        if (this.marketRate == null || this.marketRate.getValue() == 0.0 || this.marketRate != null && this.marketRate.getValue() == 0.0) {
            validationErrors.add(new ValidationError("marketRate", "sor.marketrate.lessthan.0"));
        }
        if (this.validity == null || this.validity != null && this.validity.getStartDate() == null) {
            validationErrors.add(new ValidationError("validity", "sor.marketrate.startDate__empty"));
        } else if (this.validity == null || this.validity != null && !MarketRate.compareDates(this.validity.getStartDate(), this.validity.getEndDate())) {
            validationErrors.add(new ValidationError("validity", "sor.rate.invalid_date_range"));
        }
        return validationErrors.isEmpty() ? null : validationErrors;
    }

    public static boolean compareDates(Date startDate, Date endDate) {
        if (startDate == null) {
            return false;
        }
        if (endDate == null) {
            return true;
        }
        return !endDate.before(startDate);
    }
}

