/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.mb.service;

import java.util.Date;
import java.util.List;
import org.egov.works.mb.entity.MBDetails;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.mb.repository.MBDetailsRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.history.Revisions;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class MBDetailsService {
    private final MBDetailsRepository mBDetailsRepository;

    @Autowired
    public MBDetailsService(MBDetailsRepository mBDetailsRepository) {
        this.mBDetailsRepository = mBDetailsRepository;
    }

    public List<Object[]> getActivitiesByContractorBillForApprovedMB(Long contractorBillId) {
        return this.mBDetailsRepository.getActivitiesByContractorBill(contractorBillId, "APPROVED");
    }

    public List<MBDetails> getActivitiesByContractorBillTillDate(Long workOrderEstimateId, Date billCreatedDate) {
        return this.mBDetailsRepository.getActivitiesByContractorBillTillDate(workOrderEstimateId, "APPROVED", billCreatedDate);
    }

    public List<MBDetails> getMBDetailsByWorkOrderActivity(Long woaId) {
        return this.mBDetailsRepository.getMBDetailsByWorkOrderActivity(woaId, MBHeader.MeasurementBookStatus.APPROVED.toString());
    }

    public List<Object[]> getMBDetailsByWorkOrderActivity(List<Long> activityIdList) {
        return this.mBDetailsRepository.getMBActivitiesForRevisionEstimate(activityIdList);
    }

    public MBDetails getMBDetailsForREActivity(Long activityId, Long revisionEstimateId) {
        return this.mBDetailsRepository.getMBDetailsForREActivity(activityId, revisionEstimateId, "CANCELLED");
    }

    public Revisions<Integer, MBDetails> findRevisions(Long id) {
        return this.mBDetailsRepository.findRevisions(id);
    }
}

