/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.mb.entity;

import java.math.BigDecimal;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.Max;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.works.mb.entity.MBDetails;
import org.egov.works.workorder.entity.WorkOrderMeasurementSheet;
import org.hibernate.envers.AuditJoinTable;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.AuditOverrides;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGW_MB_MEASUREMENTSHEET")
@SequenceGenerator(name="SEQ_EGW_MB_MEASUREMENTSHEET", sequenceName="SEQ_EGW_MB_MEASUREMENTSHEET", allocationSize=1)
@AuditOverrides(value={@AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedBy"), @AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedDate")})
@Audited
public class MBMeasurementSheet
extends AbstractAuditable {
    private static final long serialVersionUID = -5841511908573164177L;
    public static final String SEQ = "SEQ_EGW_MB_MEASUREMENTSHEET";
    @Id
    @GeneratedValue(generator="SEQ_EGW_MB_MEASUREMENTSHEET", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Length(max=1024, message="estimate.measurementSheet.remarks.length")
    private String remarks;
    @Max(value=9999L)
    private BigDecimal no;
    private BigDecimal length;
    private BigDecimal width;
    private BigDecimal depthOrHeight;
    @Required
    private BigDecimal quantity;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="mbdetails")
    @AuditJoinTable
    private MBDetails mbDetails;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="womsheetid")
    @NotAudited
    private WorkOrderMeasurementSheet woMeasurementSheet;
    @Transient
    private BigDecimal cumulativeQuantity;
    @Transient
    private double mbMSheetTotalQuantity;

    public BigDecimal getCumulativeQuantity() {
        return this.cumulativeQuantity;
    }

    public void setCumulativeQuantity(BigDecimal cumulativeQuantity) {
        this.cumulativeQuantity = cumulativeQuantity;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BigDecimal getNo() {
        return this.no;
    }

    public void setNo(BigDecimal no) {
        this.no = no;
    }

    public void setLength(BigDecimal length) {
        this.length = length;
    }

    public BigDecimal getWidth() {
        return this.width;
    }

    public void setWidth(BigDecimal width) {
        this.width = width;
    }

    public BigDecimal getDepthOrHeight() {
        return this.depthOrHeight;
    }

    public void setDepthOrHeight(BigDecimal depthOrHeight) {
        this.depthOrHeight = depthOrHeight;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public MBDetails getMbDetails() {
        return this.mbDetails;
    }

    public void setMbDetails(MBDetails mbDetails) {
        this.mbDetails = mbDetails;
    }

    public WorkOrderMeasurementSheet getWoMeasurementSheet() {
        return this.woMeasurementSheet;
    }

    public void setWoMeasurementSheet(WorkOrderMeasurementSheet woMeasurementSheet) {
        this.woMeasurementSheet = woMeasurementSheet;
    }

    public double getMbMSheetTotalQuantity() {
        return this.mbMSheetTotalQuantity;
    }

    public void setMbMSheetTotalQuantity(double mbMSheetTotalQuantity) {
        this.mbMSheetTotalQuantity = mbMSheetTotalQuantity;
    }

    public BigDecimal getLength() {
        return this.length;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
}

