/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.mb.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.apache.commons.collections.CollectionUtils;
import org.egov.commons.EgwStatus;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.DateFormat;
import org.egov.infra.persistence.validator.annotation.GreaterThan;
import org.egov.infra.persistence.validator.annotation.OptionalPattern;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.persistence.validator.annotation.ValidateDate;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.lineestimate.entity.DocumentDetails;
import org.egov.works.mb.entity.MBDetails;
import org.egov.works.revisionestimate.entity.enums.RevisionType;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.hibernate.envers.AuditJoinTable;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.AuditOverrides;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGW_MB_HEADER")
@NamedQueries(value={@NamedQuery(name="getApprovedMBList", query=" select distinct mbh from MBHeader mbh where mbh.egwStatus.code = ? and trunc(mbh.state.createdDate) <= ? and mbh.isLegacyMB!=1 and mbh.workOrder.id = ? and mbh.workOrderEstimate.id = ? "), @NamedQuery(name="getPartBillList", query=" select distinct mbh from MBHeader mbh left join mbh.egBillregister as reg where mbh.egwStatus.code = ? and mbh.workOrder.id = ? and (reg is not null or reg.status.code != ?) and reg.billtype=? "), @NamedQuery(name="getAllBilledMBs", query=" select eb1.billdate from EgBillregister eb1 where exists(select mbh.egBillregister.id from MBHeader mbh left join mbh.egBillregister as reg where mbh.egwStatus.code = ? and mbh.workOrder.id = ? and reg is not null  and  upper(reg.status.code)!='CANCELLED' and eb1.id=mbh.egBillregister.id order by reg.billdate desc) and rownum=1 "), @NamedQuery(name="getAllBilledMBsForWOEstimate", query=" select eb1.billdate from EgBillregister eb1 where exists(select mbh.egBillregister.id from MBHeader mbh left join mbh.egBillregister as reg where mbh.egwStatus.code = ? and mbh.workOrderEstimate.id = ? and reg is not null and  upper(reg.status.code)!='CANCELLED' and eb1.id=mbh.egBillregister.id order by reg.billdate desc) and rownum=1 "), @NamedQuery(name="getAllMBsForBillId", query=" from MBHeader mbh where mbh.egwStatus.code = ? and mbh.egBillregister is not null and mbh.egBillregister.id = ? "), @NamedQuery(name="getMBbyWorkOrderEstID", query=" from MBHeader mbh where mbh.workOrderEstimate.id=? and mbh.egwStatus.code!=? and mbh.workOrderEstimate.id not in (select mb.workOrderEstimate.id from MBHeader mb where mb.egBillregister.billtype=? and mb.egBillregister.status.code!=? ) "), @NamedQuery(name="getMBWithoutLegacyByWOEstID", query=" from MBHeader mbh where mbh.workOrderEstimate.id=? and mbh.egwStatus.code!=? and mbh.isLegacyMB!=1 and mbh.workOrderEstimate.id not in (select mb.workOrderEstimate.id from MBHeader mb where mb.egBillregister.billtype=? and mb.egBillregister.status.code!=?)  "), @NamedQuery(name="getAllMBHeadersbyBillId", query=" Select distinct mbHeader from MBHeader mbHeader where mbHeader.egBillregister.id=?  "), @NamedQuery(name="getAllMBNosbyWorkEstimate", query=" Select distinct mbHeader.mbRefNo from MBHeader mbHeader where mbHeader.egwStatus.code = ? and mbHeader.workOrderEstimate.id=? "), @NamedQuery(name="totalMBAmountOfMBs", query=" select sum(mbAmount) from MBHeader where egwStatus.code != 'CANCELLED' and  workOrderEstimate.workOrder.id=? and  workOrderEstimate.estimate.id= ? "), @NamedQuery(name="totalMBAmountOfMBsForRevisionWO", query=" select sum(mbAmount) from MBHeader where egwStatus.code != 'CANCELLED' and  workOrderEstimate.workOrder.parent.id=? and  workOrderEstimate.estimate.parent.id= ?  "), @NamedQuery(name="getAmountForApprovedRevisionWO", query=" select sum(wo.workOrderAmount) from WorkOrder wo where wo.parent is not null and wo.egwStatus.code='APPROVED' and wo.parent.id=? "), @NamedQuery(name="getAllApprovedMBHeaders", query=" select distinct mbh from MBHeader mbh where mbh.egwStatus.code = ? and mbh.workOrder.id = ? and mbh.workOrderEstimate.estimate.id = ? ")})
@SequenceGenerator(name="SEQ_EGW_MB_HEADER", sequenceName="SEQ_EGW_MB_HEADER", allocationSize=1)
@AuditOverrides(value={@AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedBy"), @AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedDate")})
@Audited
public class MBHeader
extends StateAware {
    private static final long serialVersionUID = 121631467636260459L;
    public static final String SEQ_EGW_MB_HEADER = "SEQ_EGW_MB_HEADER";
    public static final String GETAPPROVEDMBLIST = "getApprovedMBList";
    public static final String GETPARTBILLLIST = "getPartBillList";
    public static final String GETALLBILLEDMBS = "getAllBilledMBs";
    public static final String GETALLBILLEDMBSFORWOESTIMATE = "getAllBilledMBsForWOEstimate";
    public static final String GETALLMBSFORBILLID = "getAllMBsForBillId";
    public static final String GETMBBYWORKORDERESTID = "getMBbyWorkOrderEstID";
    public static final String GETMBWITHOUTLEGACYBYWOESTID = "getMBWithoutLegacyByWOEstID";
    public static final String GETALLMBHEADERSBYBILLID = "getAllMBHeadersbyBillId";
    public static final String GETALLMBNOSBYWORKESTIMATE = "getAllMBNosbyWorkEstimate";
    public static final String TOTALMBAMOUNTOFMBS = "totalMBAmountOfMBs";
    public static final String TOTALMBAMOUNTOFMBSFORREVISIONWO = "totalMBAmountOfMBsForRevisionWO";
    public static final String GETAMOUNTFORAPPROVEDREVISIONWO = "getAmountForApprovedRevisionWO";
    public static final String GETALLAPPROVEDMBHEADERS = "getAllApprovedMBHeaders";
    @Id
    @GeneratedValue(generator="SEQ_EGW_MB_HEADER", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="WORKORDER_ID")
    @Required(message="mbheader.workorder.null")
    @NotAudited
    private WorkOrder workOrder;
    @Required(message="mbheader.mbrefno.null")
    @Length(max=50, message="mbheader.mbrefno.length")
    @Column(name="MB_REFNO")
    private String mbRefNo;
    @Length(max=400, message="mbheader.contractorComments.length")
    @OptionalPattern(regex="[0-9a-zA-Z_@./#&+-/!(){}\",^$%*|=;:<>?`~ ]+", message="mb.contractorComments.alphaNumeric")
    @Column(name="CONTRACTOR_COMMENTS")
    private String contractorComments;
    @Required(message="mbheader.mbdate.null")
    @ValidateDate(allowPast=true, dateFormat="dd/MM/yyyy", message="mbheader.mbDate.futuredate")
    @DateFormat(message="invalid.fieldvalue.mbDate")
    @Temporal(value=TemporalType.DATE)
    @Column(name="MB_DATE")
    private Date mbDate;
    @Column(name="MB_ISSUED_DATE")
    @Temporal(value=TemporalType.DATE)
    private Date mbIssuedDate;
    @Length(max=400, message="mbheader.mbabstract.length")
    @OptionalPattern(regex="[0-9a-zA-Z_@./#&+-/!(){}\",^$%*|=;:<>?`~ ]+", message="mb.mbabstract.alphaNumeric")
    @Column(name="ABSTRACT")
    private String mbAbstract;
    @Required(message="mbheader.fromPageNo.null")
    @GreaterThan(value=0L, message="mbheader.fromPageNo.non.negative")
    @Column(name="FROM_PAGE_NO")
    private Integer fromPageNo;
    @Min(value=0L, message="mbheader.toPageNo.non.negative")
    @Column(name="TO_PAGE_NO")
    private Integer toPageNo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="WORKORDER_ESTIMATE_ID")
    @NotAudited
    private WorkOrderEstimate workOrderEstimate;
    @Transient
    private Integer approverUserId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="BILLREGISTER_ID")
    @NotAudited
    private ContractorBillRegister egBillregister;
    @Valid
    @JsonIgnore
    @OrderBy(value="id")
    @OneToMany(mappedBy="mbHeader", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=MBDetails.class)
    @AuditJoinTable
    private final List<MBDetails> mbDetails = new ArrayList<MBDetails>(0);
    private transient List<MBDetails> sorMbDetails = new ArrayList<MBDetails>(0);
    private transient List<MBDetails> nonSorMbDetails = new ArrayList<MBDetails>(0);
    private transient List<MBDetails> nonTenderedMbDetails = new ArrayList<MBDetails>(0);
    private transient List<MBDetails> lumpSumMbDetails = new ArrayList<MBDetails>(0);
    private final transient List<DocumentDetails> documentDetails = new ArrayList<DocumentDetails>(0);
    @Transient
    private String owner;
    @Transient
    private List<String> mbActions = new ArrayList<String>();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="STATUS_ID")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    private EgwStatus egwStatus;
    @Column(name="IS_LEGACY_MB")
    private boolean isLegacyMB;
    @Column(name="MB_AMOUNT")
    private BigDecimal mbAmount;
    @Column(name="APPROVED_DATE")
    @Temporal(value=TemporalType.DATE)
    private Date approvedDate;
    @Transient
    private Long approvalDepartment;
    @Transient
    private String approvalComent;
    private String cancellationReason;
    private String cancellationRemarks;

    public List<ValidationError> validate() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        if (this.workOrder != null && (this.workOrder.getId() == null || this.workOrder.getId() == 0L || this.workOrder.getId() == -1L)) {
            validationErrors.add(new ValidationError("workOrder", "mbheader.workorder.null"));
        }
        if (this.fromPageNo != null && this.toPageNo != null && this.fromPageNo > this.toPageNo) {
            validationErrors.add(new ValidationError("toPageNo", "mbheader.toPageNo.invalid"));
        }
        if (this.mbDate != null && this.workOrder != null && this.workOrder.getWorkOrderDate() != null && this.mbDate.before(this.workOrder.getWorkOrderDate())) {
            validationErrors.add(new ValidationError("mbDate", "mbheader.mbDate.invalid"));
        }
        return validationErrors;
    }

    public void setWorkOrder(WorkOrder workOrder) {
        this.workOrder = workOrder;
    }

    public WorkOrder getWorkOrder() {
        return this.workOrder;
    }

    public void setMbRefNo(String mbRefNo) {
        this.mbRefNo = mbRefNo;
    }

    public String getMbRefNo() {
        return this.mbRefNo;
    }

    public void setMbDate(Date mbDate) {
        this.mbDate = mbDate;
    }

    public Date getMbDate() {
        return this.mbDate;
    }

    public void setMbAbstract(String mbAbstract) {
        this.mbAbstract = mbAbstract;
    }

    public String getMbAbstract() {
        return this.mbAbstract;
    }

    public Integer getFromPageNo() {
        return this.fromPageNo;
    }

    public void setFromPageNo(Integer fromPageNo) {
        this.fromPageNo = fromPageNo;
    }

    public Integer getToPageNo() {
        return this.toPageNo;
    }

    public void setToPageNo(Integer toPageNo) {
        this.toPageNo = toPageNo;
    }

    public String getContractorComments() {
        return this.contractorComments;
    }

    public void setContractorComments(String contractorComments) {
        this.contractorComments = contractorComments;
    }

    public List<MBDetails> getMbDetails() {
        return this.mbDetails;
    }

    public void setMbDetails(List<MBDetails> mbDetails) {
        this.mbDetails.clear();
        if (mbDetails != null) {
            this.mbDetails.addAll(mbDetails);
        }
    }

    public void addMbDetails(MBDetails mbDetails) {
        this.mbDetails.add(mbDetails);
    }

    public String getStateDetails() {
        return "MB Ref Number : " + this.getMbRefNo();
    }

    public ContractorBillRegister getEgBillregister() {
        return this.egBillregister;
    }

    public void setEgBillregister(ContractorBillRegister egBillregister) {
        this.egBillregister = egBillregister;
    }

    public Integer getApproverUserId() {
        return this.approverUserId;
    }

    public void setApproverUserId(Integer approverUserId) {
        this.approverUserId = approverUserId;
    }

    public WorkOrderEstimate getWorkOrderEstimate() {
        return this.workOrderEstimate;
    }

    public void setWorkOrderEstimate(WorkOrderEstimate workOrderEstimate) {
        this.workOrderEstimate = workOrderEstimate;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public List<String> getMbActions() {
        return this.mbActions;
    }

    public void setMbActions(List<String> mbActions) {
        this.mbActions = mbActions;
    }

    public EgwStatus getEgwStatus() {
        return this.egwStatus;
    }

    public void setEgwStatus(EgwStatus egwStatus) {
        this.egwStatus = egwStatus;
    }

    public boolean getIsLegacyMB() {
        return this.isLegacyMB;
    }

    public void setIsLegacyMB(boolean isLegacyMB) {
        this.isLegacyMB = isLegacyMB;
    }

    public BigDecimal getMbAmount() {
        return this.mbAmount;
    }

    public void setMbAmount(BigDecimal mbAmount) {
        this.mbAmount = mbAmount;
    }

    public String toString() {
        return "MBHeader ( Id : " + this.getId() + "MB Ref No: " + this.mbRefNo + ")";
    }

    public BigDecimal getTotalMBAmount() {
        double amount = 0.0;
        BigDecimal resultAmount = BigDecimal.ZERO;
        for (MBDetails mbd : this.mbDetails) {
            amount = mbd.getWorkOrderActivity().getActivity().getNonSor() == null ? mbd.getWorkOrderActivity().getApprovedRate() * mbd.getQuantity() * mbd.getWorkOrderActivity().getConversionFactor() : mbd.getWorkOrderActivity().getApprovedRate() * mbd.getQuantity();
            resultAmount = resultAmount.add(BigDecimal.valueOf(amount));
        }
        return resultAmount;
    }

    public Date getApprovedDate() {
        return this.approvedDate;
    }

    public void setApprovedDate(Date approvedDate) {
        this.approvedDate = approvedDate;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<MBDetails> getSorMbDetails() {
        return this.sorMbDetails;
    }

    public void setSorMbDetails(List<MBDetails> sorMbDetails) {
        this.sorMbDetails = sorMbDetails;
    }

    public List<MBDetails> getNonSorMbDetails() {
        return this.nonSorMbDetails;
    }

    public void setNonSorMbDetails(List<MBDetails> nonSorMbDetails) {
        this.nonSorMbDetails = nonSorMbDetails;
    }

    public Collection<MBDetails> getSORMBDetails() {
        return CollectionUtils.select(this.mbDetails, mbDetail -> ((MBDetails)((Object)((Object)mbDetail))).getWorkOrderActivity().getActivity().getSchedule() != null && (((MBDetails)((Object)((Object)mbDetail))).getWorkOrderActivity().getActivity().getRevisionType() == null || ((MBDetails)((Object)((Object)mbDetail))).getWorkOrderActivity().getActivity().getRevisionType().compareTo(RevisionType.ADDITIONAL_QUANTITY) == 0 || ((MBDetails)((Object)((Object)mbDetail))).getWorkOrderActivity().getActivity().getRevisionType().compareTo(RevisionType.REDUCED_QUANTITY) == 0));
    }

    public Collection<MBDetails> getNonSORMBDetails() {
        return CollectionUtils.select(this.mbDetails, mbDetail -> ((MBDetails)((Object)((Object)mbDetail))).getWorkOrderActivity().getActivity().getNonSor() != null && (((MBDetails)((Object)((Object)mbDetail))).getWorkOrderActivity().getActivity().getRevisionType() == null || ((MBDetails)((Object)((Object)mbDetail))).getWorkOrderActivity().getActivity().getRevisionType().compareTo(RevisionType.ADDITIONAL_QUANTITY) == 0 || ((MBDetails)((Object)((Object)mbDetail))).getWorkOrderActivity().getActivity().getRevisionType().compareTo(RevisionType.REDUCED_QUANTITY) == 0));
    }

    public Collection<MBDetails> getNonTenderedMBDetails() {
        return CollectionUtils.select(this.mbDetails, mbDetail -> ((MBDetails)((Object)((Object)mbDetail))).getWorkOrderActivity().getActivity().getRevisionType() != null && ((MBDetails)((Object)((Object)mbDetail))).getWorkOrderActivity().getActivity().getRevisionType().compareTo(RevisionType.NON_TENDERED_ITEM) == 0);
    }

    public Collection<MBDetails> getLumpSumMBDetails() {
        return CollectionUtils.select(this.mbDetails, mbDetail -> ((MBDetails)((Object)((Object)mbDetail))).getWorkOrderActivity().getActivity().getRevisionType() != null && ((MBDetails)((Object)((Object)mbDetail))).getWorkOrderActivity().getActivity().getRevisionType().compareTo(RevisionType.LUMP_SUM_ITEM) == 0);
    }

    public Long getApprovalDepartment() {
        return this.approvalDepartment;
    }

    public void setApprovalDepartment(Long approvalDepartment) {
        this.approvalDepartment = approvalDepartment;
    }

    public String getApprovalComent() {
        return this.approvalComent;
    }

    public void setApprovalComent(String approvalComent) {
        this.approvalComent = approvalComent;
    }

    public Date getMbIssuedDate() {
        return this.mbIssuedDate;
    }

    public void setMbIssuedDate(Date mbIssuedDate) {
        this.mbIssuedDate = mbIssuedDate;
    }

    public List<DocumentDetails> getDocumentDetails() {
        return this.documentDetails;
    }

    public void setDocumentDetails(List<DocumentDetails> documentDetails) {
        this.documentDetails.clear();
        if (documentDetails != null) {
            this.documentDetails.addAll(documentDetails);
        }
    }

    public String getCancellationReason() {
        return this.cancellationReason;
    }

    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public String getCancellationRemarks() {
        return this.cancellationRemarks;
    }

    public void setCancellationRemarks(String cancellationRemarks) {
        this.cancellationRemarks = cancellationRemarks;
    }

    public List<MBDetails> getNonTenderedMbDetails() {
        return this.nonTenderedMbDetails;
    }

    public void setNonTenderedMbDetails(List<MBDetails> nonTenderedMbDetails) {
        this.nonTenderedMbDetails = nonTenderedMbDetails;
    }

    public List<MBDetails> getLumpSumMbDetails() {
        return this.lumpSumMbDetails;
    }

    public void setLumpSumMbDetails(List<MBDetails> lumpSumMbDetails) {
        this.lumpSumMbDetails = lumpSumMbDetails;
    }

    public static enum Actions {
        SAVE,
        SUBMIT_FOR_APPROVAL,
        REJECT,
        CANCEL,
        APPROVAL;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum MeasurementBookStatus {
        NEW,
        CREATED,
        CHECKED,
        REJECTED,
        RESUBMITTED,
        CANCELLED,
        APPROVED,
        WORK_COMMENCED;

    }
}

