/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.letterofacceptance.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.infra.utils.DateUtils;
import org.egov.works.letterofacceptance.repository.WorkOrderActivityRepository;
import org.egov.works.revisionestimate.entity.RevisionAbstractEstimate;
import org.egov.works.revisionestimate.entity.enums.RevisionType;
import org.egov.works.workorder.entity.WorkOrderActivity;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.egov.works.workorder.service.WorkOrderEstimateService;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class WorkOrderActivityService {
    @PersistenceContext
    private EntityManager entityManager;
    private final WorkOrderActivityRepository workOrderActivityRepository;
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Autowired
    public WorkOrderActivityService(WorkOrderActivityRepository workOrderActivityRepository) {
        this.workOrderActivityRepository = workOrderActivityRepository;
    }

    public WorkOrderActivity getWorkOrderActivityById(Long id) {
        return (WorkOrderActivity)((Object)this.workOrderActivityRepository.findOne(id));
    }

    @Transactional
    public WorkOrderActivity create(WorkOrderActivity workOrderActivity) {
        return (WorkOrderActivity)((Object)this.workOrderActivityRepository.save((Object)workOrderActivity));
    }

    public List<WorkOrderActivity> searchActivities(Long workOrderEstimateId, String description, String itemCode, String sorType) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(WorkOrderActivity.class, "woa").createAlias("woa.workOrderEstimate", "woe").createAlias("activity", "act");
        if (workOrderEstimateId != null) {
            criteria.add((Criterion)Restrictions.eq((String)"woe.id", (Object)workOrderEstimateId));
        }
        if (sorType != null && sorType.equalsIgnoreCase("SOR")) {
            criteria.add(Restrictions.isNotNull((String)"act.schedule"));
        }
        if (sorType != null && sorType.equalsIgnoreCase("Non Sor")) {
            criteria.add(Restrictions.isNull((String)"act.schedule"));
        }
        return criteria.list();
    }

    public List<WorkOrderActivity> searchREActivities(Long workOrderEstimateId, String description, String itemCode, String nonTenderedType, String mbDate) {
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateById(workOrderEstimateId);
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(WorkOrderActivity.class, "woa").createAlias("woa.workOrderEstimate", "woe").createAlias("woe.workOrder", "workOrder").createAlias("activity", "act").createAlias("act.abstractEstimate", "estimate").createAlias("woa.activity.schedule", "schedule", CriteriaSpecification.LEFT_JOIN).createAlias("woa.activity.nonSor", "nonSor", CriteriaSpecification.LEFT_JOIN);
        if (workOrderEstimateId != null) {
            criteria.add((Criterion)Restrictions.le((String)"estimate.estimateDate", (Object)DateUtils.getDate((String)mbDate, (String)"dd/MM/yyyy")));
        }
        if (mbDate != null) {
            criteria.add((Criterion)Restrictions.eq((String)"workOrder.parent.id", (Object)workOrderEstimate.getWorkOrder().getId()));
        }
        if (nonTenderedType != null && "NONTENDERED".equalsIgnoreCase(nonTenderedType)) {
            criteria.add((Criterion)Restrictions.eq((String)"act.revisionType", (Object)((Object)RevisionType.NON_TENDERED_ITEM)));
        } else if (nonTenderedType != null && "LUMPSUM".equalsIgnoreCase(nonTenderedType)) {
            criteria.add((Criterion)Restrictions.eq((String)"act.revisionType", (Object)((Object)RevisionType.LUMP_SUM_ITEM)));
        } else {
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"act.revisionType", (Object)((Object)RevisionType.NON_TENDERED_ITEM)), (Criterion)Restrictions.eq((String)"act.revisionType", (Object)((Object)RevisionType.LUMP_SUM_ITEM))));
        }
        if (itemCode != null && !itemCode.isEmpty()) {
            criteria.add(Restrictions.ilike((String)"schedule.code", (String)itemCode, (MatchMode)MatchMode.ANYWHERE));
        }
        if (description != null && !description.isEmpty()) {
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)"schedule.description", (String)description, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.ilike((String)"nonSor.description", (String)description, (MatchMode)MatchMode.ANYWHERE)));
        }
        return criteria.list();
    }

    public WorkOrderActivity getWorkOrderActivityByActivity(Long activityId) {
        return this.workOrderActivityRepository.findByActivity_IdAndWorkOrderEstimate_WorkOrder_EgwStatus_Code(activityId, "APPROVED");
    }

    public List<WorkOrderActivity> getChangedQuantityActivities(RevisionAbstractEstimate revisionEstimate, WorkOrderEstimate revisionWorkOrderEstimate) {
        return this.workOrderActivityRepository.findChangedQuantityActivitiesForEstimate(revisionEstimate.getId(), revisionWorkOrderEstimate.getId(), RevisionType.ADDITIONAL_QUANTITY);
    }

    public Object getQuantityForActivity(Long activityId) {
        return this.workOrderActivityRepository.getActivityQuantity(activityId, "APPROVED");
    }

    public Object getREActivityQuantity(Long reId, Long parentId) {
        return this.workOrderActivityRepository.getREActivityQuantity(reId, parentId);
    }

    public List<WorkOrderActivity> getWorkOrderActivitiesForContractorPortal(Long workOrderId) {
        return this.workOrderActivityRepository.getWorkOrderActivitiesForContractorPortal(workOrderId);
    }
}

