/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.letterofacceptance.repository;

import java.util.List;
import org.egov.works.revisionestimate.entity.enums.RevisionType;
import org.egov.works.workorder.entity.WorkOrderActivity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface WorkOrderActivityRepository
extends JpaRepository<WorkOrderActivity, Long> {
    public WorkOrderActivity findByActivity_IdAndWorkOrderEstimate_WorkOrder_EgwStatus_Code(Long var1, String var2);

    @Query(value="select woa from WorkOrderActivity woa where woa.workOrderEstimate.estimate.id =:revisionEstimateId and woa.workOrderEstimate.id=:revisionWorkOrderId and woa.activity.revisionType=:changedQuantityRevisionType")
    public List<WorkOrderActivity> findChangedQuantityActivitiesForEstimate(@Param(value="revisionEstimateId") Long var1, @Param(value="revisionWorkOrderId") Long var2, @Param(value="changedQuantityRevisionType") RevisionType var3);

    @Query(value="select sum(woa.approvedQuantity) from WorkOrderActivity woa where workOrderEstimate.workOrder.egwStatus.code =:workOrderStatus group by woa,woa.activity having activity.id =:activityId")
    public Object getActivityQuantity(@Param(value="activityId") Long var1, @Param(value="workOrderStatus") String var2);

    @Query(value="select sum(woa.approvedQuantity*coalesce((CASE WHEN woa.activity.revisionType = 'REDUCED_QUANTITY' THEN -1 WHEN woa.activity.revisionType = 'ADDITIONAL_QUANTITY' THEN 1 WHEN woa.activity.revisionType = 'NON_TENDERED_ITEM' THEN 1 WHEN woa.activity.revisionType = 'LUMP_SUM_ITEM' THEN 1 END),1)) from WorkOrderActivity woa where woa.activity.abstractEstimate.egwStatus.code = 'APPROVED' and woa.activity.abstractEstimate.id !=:revisionEstimateId group by woa.activity.parent having (woa.activity.parent is not null and woa.activity.parent.id =:parentId)")
    public Object getREActivityQuantity(@Param(value="revisionEstimateId") Long var1, @Param(value="parentId") Long var2);

    @Query(value="select woa from WorkOrderActivity woa where woa.workOrderEstimate.workOrder.id = :workOrderId or woa.workOrderEstimate.workOrder.parent.id= :workOrderId")
    public List<WorkOrderActivity> getWorkOrderActivitiesForContractorPortal(@Param(value="workOrderId") Long var1);
}

