/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.contractorportal.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.Valid;
import org.egov.commons.EgwStatus;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.DateFormat;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.persistence.validator.annotation.ValidateDate;
import org.egov.works.contractorportal.entity.ContractorMBDetails;
import org.egov.works.lineestimate.entity.DocumentDetails;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGW_CONTRACTOR_MB_HEADER")
@SequenceGenerator(name="SEQ_EGW_CONTRACTOR_MB_HEADER", sequenceName="SEQ_EGW_CONTRACTOR_MB_HEADER", allocationSize=1)
public class ContractorMBHeader
extends AbstractAuditable {
    private static final long serialVersionUID = 121631467636260459L;
    public static final String SEQ_EGW_CONTRACTOR_MB_HEADER = "SEQ_EGW_CONTRACTOR_MB_HEADER";
    @Id
    @GeneratedValue(generator="SEQ_EGW_CONTRACTOR_MB_HEADER", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Required(message="mbheader.mbrefno.null")
    @Length(max=50, message="mbheader.mbrefno.length")
    @Column(name="MB_REFNO")
    private String mbRefNo;
    @Required(message="mbheader.mbdate.null")
    @ValidateDate(allowPast=true, dateFormat="dd/MM/yyyy", message="mbheader.mbDate.futuredate")
    @DateFormat(message="invalid.fieldvalue.mbDate")
    @Temporal(value=TemporalType.DATE)
    @Column(name="MB_DATE")
    private Date mbDate;
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="WORKORDER_ESTIMATE_ID")
    private WorkOrderEstimate workOrderEstimate;
    @Valid
    @JsonIgnore
    @OrderBy(value="id")
    @OneToMany(mappedBy="contractorMBHeader", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=ContractorMBDetails.class)
    private final List<ContractorMBDetails> contractorMBDetails = new ArrayList<ContractorMBDetails>(0);
    private transient List<DocumentDetails> documentDetails = new ArrayList<DocumentDetails>(0);
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="STATUS_ID")
    private EgwStatus egwStatus;
    @Column(name="MB_AMOUNT")
    private BigDecimal mbAmount;
    @Length(max=400, message="mbdetails.remark.length")
    private String remarks;

    public void setMbDate(Date mbDate) {
        this.mbDate = mbDate;
    }

    public Date getMbDate() {
        return this.mbDate;
    }

    public WorkOrderEstimate getWorkOrderEstimate() {
        return this.workOrderEstimate;
    }

    public void setWorkOrderEstimate(WorkOrderEstimate workOrderEstimate) {
        this.workOrderEstimate = workOrderEstimate;
    }

    public EgwStatus getEgwStatus() {
        return this.egwStatus;
    }

    public void setEgwStatus(EgwStatus egwStatus) {
        this.egwStatus = egwStatus;
    }

    public BigDecimal getMbAmount() {
        return this.mbAmount;
    }

    public void setMbAmount(BigDecimal mbAmount) {
        this.mbAmount = mbAmount;
    }

    public BigDecimal getTotalMBAmount() {
        double amount = 0.0;
        BigDecimal resultAmount = BigDecimal.ZERO;
        for (ContractorMBDetails mbd : this.contractorMBDetails) {
            amount = mbd.getWorkOrderActivity().getActivity().getNonSor() == null ? mbd.getWorkOrderActivity().getApprovedRate() * mbd.getQuantity() * mbd.getWorkOrderActivity().getConversionFactor() : mbd.getWorkOrderActivity().getApprovedRate() * mbd.getQuantity();
            resultAmount = resultAmount.add(BigDecimal.valueOf(amount));
        }
        return resultAmount;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<DocumentDetails> getDocumentDetails() {
        return this.documentDetails;
    }

    public void setDocumentDetails(List<DocumentDetails> documentDetails) {
        this.documentDetails.clear();
        if (documentDetails != null) {
            this.documentDetails.addAll(documentDetails);
        }
    }

    public List<ContractorMBDetails> getContractorMBDetails() {
        return this.contractorMBDetails;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void setContractorMBDetails(List<ContractorMBDetails> contractorMBDetails) {
        this.contractorMBDetails.clear();
        if (contractorMBDetails != null) {
            this.contractorMBDetails.addAll(contractorMBDetails);
        }
    }

    public String getMbRefNo() {
        return this.mbRefNo;
    }

    public void setMbRefNo(String mbRefNo) {
        this.mbRefNo = mbRefNo;
    }
}

