/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.autonumber.impl;

import java.io.Serializable;
import org.egov.commons.CFinancialYear;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.works.autonumber.ContractorMBNumberGenerator;
import org.egov.works.contractorportal.entity.ContractorMBHeader;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContractorMBNumberGeneratorImpl
implements ContractorMBNumberGenerator {
    private static final String CONTRACTOR_MB_NUMBER_SEQ_PREFIX = "SEQ_CONTRACTOR_MB_NUMBER";
    @Autowired
    private ApplicationSequenceNumberGenerator applicationSequenceNumberGenerator;

    @Override
    public String getNextNumber(ContractorMBHeader contractorMBHeader, CFinancialYear financialYear) {
        String financialYearRange = financialYear.getFinYearRange();
        String[] finYearRange = financialYearRange.split("-");
        String sequenceName = "SEQ_CONTRACTOR_MB_NUMBER_" + finYearRange[0] + "_" + finYearRange[1];
        DateTime dateTime = new DateTime();
        Serializable sequenceNumber = this.applicationSequenceNumberGenerator.getNextSequence(sequenceName);
        return String.format("CR/MB/%05d/%02d/%s", sequenceNumber, Integer.parseInt(dateTime.toString("MM")), financialYearRange);
    }
}

