/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.abstractestimate.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.abstractestimate.repository.ActivityRepository;
import org.egov.works.revisionestimate.entity.RevisionAbstractEstimate;
import org.egov.works.revisionestimate.entity.enums.RevisionType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ActivityService {
    private final ActivityRepository activityRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public ActivityService(ActivityRepository activityRepository) {
        this.activityRepository = activityRepository;
    }

    public Activity findOne(Long id) {
        return (Activity)((Object)this.activityRepository.findOne(id));
    }

    public List<Activity> findByParentId(Long parentId) {
        return this.activityRepository.findByParent_Id(parentId);
    }

    public List<Activity> findApprovedActivitiesByParentId(Long parentId) {
        return this.activityRepository.findByParent_IdAndAbstractEstimate_EgwStatus_Code(parentId, RevisionAbstractEstimate.RevisionEstimateStatus.APPROVED.toString());
    }

    public List<Activity> findByRevisionType(Long estimateId, RevisionType nonTenderderRevisionType, RevisionType lumpSumRevisionType) {
        return this.activityRepository.findByAbstractEstimate_IdAndRevisionType(estimateId, nonTenderderRevisionType, lumpSumRevisionType);
    }
}

