/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.abstractestimate.repository;

import java.util.Date;
import java.util.List;
import org.egov.infra.admin.master.entity.User;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface AbstractEstimateRepository
extends JpaRepository<AbstractEstimate, Long> {
    @Query(value="select distinct(ae.estimateNumber) from AbstractEstimate as ae where ae.parent.id is null and upper(ae.estimateNumber) like upper(:estimateNumber)")
    public List<String> findDistinctEstimateNumberContainingIgnoreCase(@Param(value="estimateNumber") String var1);

    public List<AbstractEstimate> findByEstimateNumberAndEgwStatus_codeEquals(String var1, String var2);

    public List<AbstractEstimate> findByParent_idAndEgwStatus_codeEquals(Long var1, String var2);

    public AbstractEstimate findByEstimateNumberAndEgwStatus_codeNotLike(String var1, String var2);

    public AbstractEstimate findByLineEstimateDetails_EstimateNumberAndEgwStatus_codeEquals(String var1, String var2);

    public AbstractEstimate findByLineEstimateDetails_IdAndEgwStatus_codeEquals(Long var1, String var2);

    @Query(value="select distinct(ae.createdBy) from AbstractEstimate as ae")
    public List<User> findAbstractEstimateCreatedByUsers();

    @Query(value="select distinct(ae.createdBy) from AbstractEstimate as ae where ae.executingDepartment.id in (:departmentIds)")
    public List<User> findAbstractEstimateCreatedByUsers(@Param(value="departmentIds") List<Long> var1);

    public AbstractEstimate findByEstimateTechnicalSanctionsIgnoreCase_TechnicalSanctionNumberAndEgwStatus_CodeNot(String var1, String var2);

    @Query(value="select distinct(ae.estimateNumber) from AbstractEstimate as ae where ae.egwStatus.code != :status and exists(select distinct(activity.abstractEstimate.estimateNumber) from Activity as activity where activity.abstractEstimate = ae) and ae.lineEstimateDetails.lineEstimate.id = :lineEstimateId")
    public List<String> findAbstractEstimateNumbersToCancelLineEstimate(@Param(value="lineEstimateId") Long var1, @Param(value="status") String var2);

    @Query(value="select distinct(ae.estimateNumber) from AbstractEstimate as ae where upper(ae.estimateNumber) like upper(:code) and ae.egwStatus.code = :aeStatus and exists (select distinct(activity.id) from Activity activity where activity.abstractEstimate.id = ae.id) and not exists (select distinct(woe) from WorkOrderEstimate as woe where woe.estimate.id = ae.id and woe.workOrder.egwStatus.code != :status) and ae.parent.id is null")
    public List<String> findAbstractEstimateNumbersToCancelEstimate(@Param(value="code") String var1, @Param(value="status") String var2, @Param(value="aeStatus") String var3);

    @Query(value="select distinct(ae.estimateNumber) from AbstractEstimate as ae where ae.parent.id is null and upper(ae.estimateNumber) like upper(:code) and ae.egwStatus.code = :abstractEstimateStatus and not exists (select distinct(woe.estimate) from WorkOrderEstimate as woe where ae.id = woe.workOrder.id and woe.workOrder.egwStatus.code != upper(:workOrderStatus))")
    public List<String> findAbstractEstimateNumbersToSetOfflineStatus(@Param(value="code") String var1, @Param(value="abstractEstimateStatus") String var2, @Param(value="workOrderStatus") String var3);

    @Query(value="select distinct(estimate.estimateNumber) from AbstractEstimate estimate where estimate.parent.id is null and estimate.egwStatus.code = :abstractEstimateStatus and upper(estimate.estimateNumber) like upper(:estimateNumber) and not exists (select distinct(woe.estimate) from WorkOrderEstimate as woe where estimate.id = woe.estimate.id and upper(woe.workOrder.egwStatus.code) != upper(:workOrderStatus) and upper(estimate.egwStatus.code) = upper(:abstractEstimateStatus)) and exists (select act.abstractEstimate from Activity as act where estimate.id = act.abstractEstimate.id ) and exists (select off.id from OfflineStatus as off where off.objectId = estimate.id and off.objectType = :objectType and upper(off.egwStatus.code) = upper(:offlineStatus) )")
    public List<String> findEstimateNumbersToCreateLOA(@Param(value="estimateNumber") String var1, @Param(value="abstractEstimateStatus") String var2, @Param(value="workOrderStatus") String var3, @Param(value="objectType") String var4, @Param(value="offlineStatus") String var5);

    @Query(value="select distinct(estimate.projectCode.code) from AbstractEstimate estimate where estimate.egwStatus.code = :abstractEstimateStatus and upper(estimate.projectCode.code) like upper(:workIdentificationNumber) and not exists (select distinct(woe.estimate) from WorkOrderEstimate as woe where estimate.id = woe.estimate.id and upper(woe.workOrder.egwStatus.code) != upper(:workOrderStatus) and upper(estimate.egwStatus.code) = upper(:abstractEstimateStatus)) and exists (select act.abstractEstimate from Activity as act where estimate.id = act.abstractEstimate.id ) and exists (select off.id from OfflineStatus as off where off.objectId = estimate.id and off.objectType = :objectType and upper(off.egwStatus.code) = upper(:offlineStatus) )")
    public List<String> findWorkIdentificationNumbersToCreateLOA(@Param(value="workIdentificationNumber") String var1, @Param(value="abstractEstimateStatus") String var2, @Param(value="workOrderStatus") String var3, @Param(value="objectType") String var4, @Param(value="offlineStatus") String var5);

    @Query(value="select distinct(estimate.lineEstimateDetails.lineEstimate.adminSanctionNumber) from AbstractEstimate estimate where estimate.egwStatus.code = :abstractEstimateStatus and upper(estimate.lineEstimateDetails.lineEstimate.adminSanctionNumber) like upper(:adminSanctionNumber) and not exists (select distinct(woe.estimate) from WorkOrderEstimate as woe where estimate.id = woe.estimate.id and upper(woe.workOrder.egwStatus.code) != upper(:workOrderStatus) and upper(estimate.egwStatus.code) = upper(:abstractEstimateStatus)) and exists (select act.abstractEstimate from Activity as act where estimate.id = act.abstractEstimate.id ) and exists (select off.id from OfflineStatus as off where off.objectId = estimate.id and off.objectType = :objectType and upper(off.egwStatus.code) = upper(:offlineStatus) )")
    public List<String> findAdminSanctionNumbersToCreateLOA(@Param(value="adminSanctionNumber") String var1, @Param(value="abstractEstimateStatus") String var2, @Param(value="workOrderStatus") String var3, @Param(value="objectType") String var4, @Param(value="offlineStatus") String var5);

    @Query(value="select estimate from AbstractEstimate estimate where exists (select a.abstractEstimate from Activity a where a.abstractEstimate.id = estimate.id and a.schedule.id=:sorId) and estimate.estimateDate>=:estimateDate and estimate.egwStatus.code !=:abstractEstimateStatus ")
    public List<AbstractEstimate> findBySorIdAndEstimateDate(@Param(value="sorId") Long var1, @Param(value="estimateDate") Date var2, @Param(value="abstractEstimateStatus") String var3);

    @Query(value="select act from Activity act where act.parent.id =:activityId and act.abstractEstimate.egwStatus.code =:abstractEstimateStatus ")
    public List<Activity> findActivitiesByParent(@Param(value="activityId") Long var1, @Param(value="abstractEstimateStatus") String var2);

    @Query(value="select woe from WorkOrderEstimate woe where exists (select a.abstractEstimate from Activity a where a.abstractEstimate.id = woe.estimate.id and a.schedule.id=:sorId) and woe.workOrder.workOrderDate>=:workOrderDate and woe.estimate.egwStatus.code !=:abstractEstimateStatus ")
    public List<WorkOrderEstimate> findBySorIdAndWorkOrderDate(@Param(value="sorId") Long var1, @Param(value="workOrderDate") Date var2, @Param(value="abstractEstimateStatus") String var3);

    @Query(value="select distinct(ae.createdBy) from AbstractEstimate as ae where ae.egwStatus.code = :abstractEstimateStatus ")
    public List<User> findCreatedByForEstimatePhotograph(@Param(value="abstractEstimateStatus") String var1);
}

