/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.utils;

import com.lowagie.text.Document;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.io.OutputStream;
import java.text.DecimalFormat;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.component.Money;

public class AbstractPDFGenerator {
    public static final int LARGE_FONT = 14;
    protected Document document;
    protected final OutputStream out;

    public AbstractPDFGenerator(OutputStream out, String type) {
        this.out = out;
        try {
            this.document = type != null && "landscape".equalsIgnoreCase(type) ? new Document(PageSize.A4.rotate()) : new Document();
            PdfWriter.getInstance((Document)this.document, (OutputStream)out);
            this.document.open();
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("estimate.pdf.error", (Throwable)e);
        }
    }

    protected void addRow(PdfPTable table, boolean needsBorder, Paragraph ... elements) {
        for (Paragraph element : elements) {
            PdfPCell cell = new PdfPCell((Phrase)element);
            cell.setVerticalAlignment(4);
            if (!needsBorder) {
                cell.setBorderWidth(0.0f);
            }
            table.addCell(cell);
        }
    }

    protected Paragraph spacer() {
        return new Paragraph(" ");
    }

    protected Paragraph makePara(Object value, int alignment) {
        Paragraph header = new Paragraph(value == null ? "" : value.toString());
        header.setAlignment(alignment);
        return header;
    }

    protected Paragraph makeParaWithFont(float fontSize, Object value, int alignment) {
        Font font = new Font();
        font.setSize(fontSize);
        Paragraph header = new Paragraph(value == null ? "" : value.toString(), font);
        header.setAlignment(alignment);
        return header;
    }

    protected Paragraph makePara(Object value) {
        return new Paragraph(value == null ? "" : value.toString());
    }

    protected Paragraph makeParaWithFont(float fontSize, Object value) {
        Font font = new Font();
        font.setSize(fontSize);
        return new Paragraph(value == null ? "" : value.toString(), font);
    }

    protected Paragraph makePara(float size, Object value) {
        Font font = new Font();
        font.setSize(size);
        return new Paragraph(value == null ? "" : value.toString(), font);
    }

    protected Paragraph centerPara(Object value) {
        return this.makePara(value, 1);
    }

    protected Paragraph centerPara(float fontSize, Object value) {
        return this.makeParaWithFont(fontSize, value, 1);
    }

    protected Paragraph rightPara(Object value) {
        return this.makePara(value, 2);
    }

    protected Paragraph rightPara(float size, Object value) {
        Font font = new Font();
        font.setSize(size);
        Paragraph header = new Paragraph(value == null ? "" : value.toString(), font);
        header.setAlignment(2);
        return header;
    }

    protected Font getUnderlinedFont() {
        return new Font(-1, -1.0f, 4, null);
    }

    public String toCurrency(Money money) {
        return this.toCurrency(money.getValue());
    }

    public String toCurrency(double money) {
        double rounded = (double)Math.round(money * 100.0) / 100.0;
        DecimalFormat formatter = new DecimalFormat("0.00");
        formatter.setDecimalSeparatorAlwaysShown(true);
        return formatter.format(rounded);
    }
}

