/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.contractoradvance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.EgwStatus;
import org.egov.commons.Functionary;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.eis.entity.DrawingOfficer;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.service.WorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.advance.EgAdvanceReqPayeeDetails;
import org.egov.model.advance.EgAdvanceRequisition;
import org.egov.model.advance.EgAdvanceRequisitionDetails;
import org.egov.model.advance.EgAdvanceRequisitionMis;
import org.egov.model.masters.AccountCodePurpose;
import org.egov.pims.commons.Designation;
import org.egov.pims.service.EisUtilService;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.models.contractoradvance.ContractorAdvanceRequisition;
import org.egov.works.models.contractoradvance.ContractorAdvanceRequisitionNumberGenerator;
import org.egov.works.revisionestimate.entity.RevisionAbstractEstimate;
import org.egov.works.services.WorksService;
import org.egov.works.services.contractoradvance.ContractorAdvanceService;
import org.springframework.beans.factory.annotation.Autowired;

public class ContractorAdvanceServiceImpl
extends PersistenceService<ContractorAdvanceRequisition, Long>
implements ContractorAdvanceService {
    protected PersistenceService persistenceService;
    private WorksService worksService;
    private EisUtilService eisService;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    @Autowired
    private FinancialYearHibernateDAO financialYearHibernateDAO;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    private ContractorAdvanceRequisitionNumberGenerator contractorAdvanceRequisitionNumberGenerator;
    private static final String CONTRACTOR_ADVANCE_ACCOUNTCODE_PURPOSE = "CONTRACTOR_ADVANCE_ACCOUNTCODE";
    private static final String CONTRACTOR_ADVANCE_REQUISITION = "ContractorAdvanceRequisition";
    private static final String ACCOUNTDETAIL_TYPE_CONTRACTOR = "contractor";
    private final String PENDING_FOR_VERIFICATION = "Pending for Verification";
    private final String PENDING_FOR_VALIDATION = "Pending for Validation";
    private final String PENDING_FOR_APPROVAL = "Pending for Approval";
    private final String PENDING_FOR_RECTIFICATION = "Pending for Rectification";
    private final String PENDING_FOR_CHECK = "Pending for Check";
    private PersistenceService<RevisionAbstractEstimate, Long> revisionAbstractEstimateService;
    private WorkflowService<ContractorAdvanceRequisition> workflowService;
    private static final String ARF_TYPE = "Contractor";
    private static final Logger LOGGER = Logger.getLogger(ContractorAdvanceServiceImpl.class);

    @Override
    public BigDecimal getAdvancePaidByWOEstimateId(Long workOrderEstimateId) throws ValidationException {
        BigDecimal advanceAlreadyPaid = BigDecimal.ZERO;
        try {
            advanceAlreadyPaid = (BigDecimal)this.persistenceService.find("select sum(advanceRequisitionAmount) from ContractorAdvanceRequisition where status.code<>'CANCELLED' and workOrderEstimate.id = ?", new Object[]{workOrderEstimateId});
        }
        catch (ValidationException validationException) {
            throw new ValidationException(validationException.getErrors());
        }
        return advanceAlreadyPaid;
    }

    @Override
    public BigDecimal getAdvancePaidByWOEstIdForView(Long workOrderEstimateId, Long contractorAdvanceRequisitionId) throws ValidationException {
        BigDecimal advanceAlreadyPaid = BigDecimal.ZERO;
        try {
            advanceAlreadyPaid = (BigDecimal)this.persistenceService.find("select sum(advanceRequisitionAmount) from ContractorAdvanceRequisition where status.code<>'CANCELLED' and workOrderEstimate.id = ? and id < ?", new Object[]{workOrderEstimateId, contractorAdvanceRequisitionId});
        }
        catch (ValidationException validationException) {
            throw new ValidationException(validationException.getErrors());
        }
        return advanceAlreadyPaid;
    }

    @Override
    public ContractorAdvanceRequisition save(ContractorAdvanceRequisition contractorAdvanceRequisition, String actionName, Long advanceAccountCode) throws ValidationException {
        boolean shouldAddAdvanceDetails = false;
        try {
            if (contractorAdvanceRequisition.getStatus() == null || ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.REJECTED.toString().equalsIgnoreCase(contractorAdvanceRequisition.getStatus().getCode()) && StringUtils.isBlank((String)contractorAdvanceRequisition.getState().getNextAction()) || ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.NEW.toString().equalsIgnoreCase(contractorAdvanceRequisition.getStatus().getCode())) {
                shouldAddAdvanceDetails = true;
            }
            if (contractorAdvanceRequisition.getStatus() == null) {
                contractorAdvanceRequisition.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode(CONTRACTOR_ADVANCE_REQUISITION, "NEW"));
            }
            this.setARFNumber(contractorAdvanceRequisition);
            contractorAdvanceRequisition = this.setContractorAdvanceRequisitionMis(contractorAdvanceRequisition);
            if (shouldAddAdvanceDetails) {
                contractorAdvanceRequisition = this.setContractorAdvanceDetails(contractorAdvanceRequisition, advanceAccountCode);
            }
            contractorAdvanceRequisition = (ContractorAdvanceRequisition)((Object)this.persist((Object)contractorAdvanceRequisition));
            contractorAdvanceRequisition = (ContractorAdvanceRequisition)this.workflowService.transition(actionName, (StateAware)contractorAdvanceRequisition, contractorAdvanceRequisition.getWorkflowapproverComments());
            contractorAdvanceRequisition.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode(CONTRACTOR_ADVANCE_REQUISITION, contractorAdvanceRequisition.getCurrentState().getValue()));
            contractorAdvanceRequisition = (ContractorAdvanceRequisition)((Object)this.persist((Object)contractorAdvanceRequisition));
        }
        catch (ValidationException validationException) {
            throw new ValidationException(validationException.getErrors());
        }
        return contractorAdvanceRequisition;
    }

    public void setARFNumber(ContractorAdvanceRequisition contractorAdvanceRequisition) {
        try {
            CFinancialYear financialYear = this.financialYearHibernateDAO.getFinancialYearByDate(contractorAdvanceRequisition.getAdvanceRequisitionDate());
            if (financialYear == null) {
                throw new ValidationException(Arrays.asList(new ValidationError("advancerequisition.arfdate.financialyear.invalid", "advancerequisition.arfdate.financialyear.invalid")));
            }
            if (contractorAdvanceRequisition.getAdvanceRequisitionNumber() == null || contractorAdvanceRequisition.getAdvanceRequisitionNumber() != null && this.arfNumberChangeRequired(contractorAdvanceRequisition, financialYear)) {
                contractorAdvanceRequisition.setAdvanceRequisitionNumber(this.contractorAdvanceRequisitionNumberGenerator.getARFNumber(contractorAdvanceRequisition, financialYear, this.persistenceService));
            }
        }
        catch (ValidationException exception) {
            throw exception;
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError("advancerequisition.arfdate.financialyear.invalid", "advancerequisition.arfdate.financialyear.invalid")));
        }
    }

    private boolean arfNumberChangeRequired(ContractorAdvanceRequisition entity, CFinancialYear financialYear) {
        String[] arfNum = entity.getAdvanceRequisitionNumber().split("/");
        return !arfNum[3].equals(financialYear.getFinYearRange());
    }

    private ContractorAdvanceRequisition setContractorAdvanceRequisitionMis(ContractorAdvanceRequisition contractorAdvanceRequisition) {
        try {
            EgAdvanceRequisitionMis advanceRequisitionMis = null;
            advanceRequisitionMis = contractorAdvanceRequisition.getId() == null ? new EgAdvanceRequisitionMis() : contractorAdvanceRequisition.getEgAdvanceReqMises();
            if (contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getUserDepartment() != null) {
                advanceRequisitionMis.setEgDepartment(contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getUserDepartment());
            }
            if (contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getFinancialDetails().get(0).getFunction() != null) {
                advanceRequisitionMis.setFunction(contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getFinancialDetails().get(0).getFunction());
            }
            if (contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getWard() != null) {
                advanceRequisitionMis.setFieldId(contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getWard());
            }
            if (contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getFinancialDetails().get(0).getFunctionary() != null) {
                advanceRequisitionMis.setFunctionaryId(contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getFinancialDetails().get(0).getFunctionary());
            }
            if (contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getFinancialDetails().get(0).getFund() != null) {
                advanceRequisitionMis.setFund(contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getFinancialDetails().get(0).getFund());
            }
            if (contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getFinancialDetails().get(0).getScheme() != null) {
                advanceRequisitionMis.setScheme(contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getFinancialDetails().get(0).getScheme());
            }
            if (contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getFinancialDetails().get(0).getSubScheme() != null) {
                advanceRequisitionMis.setSubScheme(contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getFinancialDetails().get(0).getSubScheme());
            }
            if (contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getFundSource() != null) {
                advanceRequisitionMis.setFundsource(contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getFundSource());
            }
            advanceRequisitionMis.setReferencenumber(contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getEstimateNumber());
            if (contractorAdvanceRequisition.getWorkOrderEstimate().getWorkOrder().getContractor().getName() != null) {
                advanceRequisitionMis.setPayto(contractorAdvanceRequisition.getWorkOrderEstimate().getWorkOrder().getContractor().getName());
            }
            advanceRequisitionMis.setLastupdatedtime(new Date());
            advanceRequisitionMis.setEgAdvanceRequisition((EgAdvanceRequisition)contractorAdvanceRequisition);
            contractorAdvanceRequisition.setEgAdvanceReqMises(advanceRequisitionMis);
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError("error", e.getMessage())));
        }
        return contractorAdvanceRequisition;
    }

    private ContractorAdvanceRequisition setContractorAdvanceDetails(ContractorAdvanceRequisition contractorAdvanceRequisition, Long advanceAccountCode) {
        try {
            List detailCode;
            EgAdvanceRequisitionDetails egAdvanceRequisitionDetails = new EgAdvanceRequisitionDetails();
            Iterator iterator = contractorAdvanceRequisition.getEgAdvanceReqDetailses().iterator();
            while (iterator.hasNext()) {
                EgAdvanceRequisitionDetails advanceRequisitionDetails;
                egAdvanceRequisitionDetails = advanceRequisitionDetails = (EgAdvanceRequisitionDetails)iterator.next();
            }
            egAdvanceRequisitionDetails.setChartofaccounts((CChartOfAccounts)this.persistenceService.find("from  CChartOfAccounts where id=?", new Object[]{advanceAccountCode}));
            egAdvanceRequisitionDetails.setFunction(contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getFinancialDetails().get(0).getFunction());
            egAdvanceRequisitionDetails.setDebitamount(contractorAdvanceRequisition.getAdvanceRequisitionAmount());
            egAdvanceRequisitionDetails.setNarration(contractorAdvanceRequisition.getNarration());
            egAdvanceRequisitionDetails.setEgAdvanceRequisition((EgAdvanceRequisition)contractorAdvanceRequisition);
            if (egAdvanceRequisitionDetails.getChartofaccounts() != null && egAdvanceRequisitionDetails.getChartofaccounts().getGlcode() != null && (detailCode = this.chartOfAccountsHibernateDAO.getAccountdetailtypeListByGLCode(egAdvanceRequisitionDetails.getChartofaccounts().getGlcode())) != null && !detailCode.isEmpty()) {
                Accountdetailtype adt = this.chartOfAccountsHibernateDAO.getAccountDetailTypeIdByName(egAdvanceRequisitionDetails.getChartofaccounts().getGlcode(), ACCOUNTDETAIL_TYPE_CONTRACTOR);
                if (adt != null) {
                    egAdvanceRequisitionDetails.getEgAdvanceReqpayeeDetailses().add(this.setRequisitionPayeeDetail(contractorAdvanceRequisition, egAdvanceRequisitionDetails, adt));
                }
                if (adt == null) {
                    ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                    errors.add(new ValidationError("advancerequisition.validate_glcode_for_subledger", "advancerequisition.validate_glcode_for_subledger"));
                    throw new ValidationException(errors);
                }
            }
            contractorAdvanceRequisition.getEgAdvanceReqDetailses().clear();
            contractorAdvanceRequisition.addEgAdvanceReqDetails(egAdvanceRequisitionDetails);
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError("error", e.getMessage())));
        }
        return contractorAdvanceRequisition;
    }

    private EgAdvanceReqPayeeDetails setRequisitionPayeeDetail(ContractorAdvanceRequisition contractorAdvanceRequisition, EgAdvanceRequisitionDetails advanceRequisitionDetails, Accountdetailtype accountdetailtype) {
        EgAdvanceReqPayeeDetails egAdvanceReqPaydetail = new EgAdvanceReqPayeeDetails();
        Iterator iterator = advanceRequisitionDetails.getEgAdvanceReqpayeeDetailses().iterator();
        while (iterator.hasNext()) {
            EgAdvanceReqPayeeDetails advanceReqPaydetail;
            egAdvanceReqPaydetail = advanceReqPaydetail = (EgAdvanceReqPayeeDetails)iterator.next();
        }
        egAdvanceReqPaydetail.setAccountdetailKeyId(Integer.valueOf(contractorAdvanceRequisition.getWorkOrderEstimate().getWorkOrder().getContractor().getId().toString()));
        egAdvanceReqPaydetail.setNarration(advanceRequisitionDetails.getNarration());
        egAdvanceReqPaydetail.setAccountDetailType(accountdetailtype);
        egAdvanceReqPaydetail.setDebitAmount(advanceRequisitionDetails.getDebitamount());
        egAdvanceReqPaydetail.setEgAdvanceRequisitionDetails(advanceRequisitionDetails);
        return egAdvanceReqPaydetail;
    }

    @Override
    public ContractorAdvanceRequisition getContractorAdvanceRequisitionById(Long Id2) throws ValidationException {
        ContractorAdvanceRequisition contractorAdvanceRequisition = null;
        try {
            contractorAdvanceRequisition = (ContractorAdvanceRequisition)((Object)this.findById(Id2, false));
        }
        catch (ValidationException validationException) {
            throw new ValidationException(validationException.getErrors());
        }
        return contractorAdvanceRequisition;
    }

    @Override
    public List<HashMap> getDrawingOfficerListForARF(String query, Date advanceRequisitionDate) {
        ArrayList<HashMap> drawingOfficers = new ArrayList<HashMap>();
        try {
            LinkedList designationsList = new LinkedList();
            LinkedList<Long> designationsIdList = new LinkedList<Long>();
            String drawingOfficerDesignations = this.worksService.getWorksConfigValue("CONTRACTORADVANCE_DRAWINGOFFICER_DESIGNATIONS");
            if (drawingOfficerDesignations != null) {
                String[] designationNames = drawingOfficerDesignations.toUpperCase().split(",");
                ArrayList<String> desgListUpper = new ArrayList<String>(Arrays.asList(designationNames));
                designationsList.addAll(this.persistenceService.findAllByNamedQuery("getDesignationForListOfDesgNames", new Object[]{desgListUpper}));
            }
            for (Designation desigMaster : designationsList) {
                designationsIdList.add(desigMaster.getId());
            }
            drawingOfficers.addAll(this.eisService.getListOfDrawingOfficers(designationsIdList, advanceRequisitionDate, query));
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error in method getDrawingOfficerListForARF" + e.getMessage()));
        }
        return drawingOfficers;
    }

    @Override
    public List<CChartOfAccounts> getContractorAdvanceAccountcodes() throws ValidationException {
        List coaList = Collections.EMPTY_LIST;
        AccountCodePurpose accountCodePurpose = (AccountCodePurpose)this.persistenceService.find("from AccountCodePurpose where name = ?", new Object[]{CONTRACTOR_ADVANCE_ACCOUNTCODE_PURPOSE});
        if (accountCodePurpose != null) {
            coaList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurpose(Integer.valueOf(accountCodePurpose.getId().toString()));
        }
        return coaList;
    }

    @Override
    public BigDecimal getTotalEstimateValueIncludingRE(AbstractEstimate abstractEstimate) throws ValidationException {
        BigDecimal totalEstimateValue = new BigDecimal(abstractEstimate.getTotalAmount().getValue());
        try {
            List revisionEstimateList = this.revisionAbstractEstimateService.findAllByNamedQuery("REVISION_ESTIMATES_BY_ESTID", new Object[]{abstractEstimate.getId()});
            for (RevisionAbstractEstimate revisionAbstractEstimate : revisionEstimateList) {
                totalEstimateValue = totalEstimateValue.add(new BigDecimal(revisionAbstractEstimate.getTotalAmount().getValue()));
            }
        }
        catch (ValidationException validationException) {
            throw new ValidationException(validationException.getErrors());
        }
        return totalEstimateValue;
    }

    @Override
    public Integer getFunctionaryForWorkflow(ContractorAdvanceRequisition contractorAdvanceRequisition) {
        Functionary func;
        Integer workflowFunctionaryId = null;
        if (contractorAdvanceRequisition != null && contractorAdvanceRequisition.getId() != null && contractorAdvanceRequisition.getCurrentState() != null && contractorAdvanceRequisition.getCurrentState().getNextAction() != null && (contractorAdvanceRequisition.getCurrentState().getNextAction().equalsIgnoreCase("Pending for Verification") || contractorAdvanceRequisition.getCurrentState().getNextAction().equalsIgnoreCase("Pending for Validation") || contractorAdvanceRequisition.getCurrentState().getNextAction().equalsIgnoreCase("Pending for Approval") || contractorAdvanceRequisition.getCurrentState().getNextAction().equalsIgnoreCase("Pending for Rectification") || contractorAdvanceRequisition.getCurrentState().getNextAction().equalsIgnoreCase("Pending for Check") && contractorAdvanceRequisition.getCurrentState().getValue().equalsIgnoreCase("REJECTED")) && (func = (Functionary)this.persistenceService.find(" from  Functionary where upper(name) = ?", new Object[]{"UAC"})) != null) {
            workflowFunctionaryId = func.getId();
        }
        return workflowFunctionaryId;
    }

    @Override
    public void cancelContractorAdvanceRequisition(ContractorAdvanceRequisition contractorAdvanceRequisition, String actionName) throws ValidationException {
        if (contractorAdvanceRequisition.getId() != null) {
            contractorAdvanceRequisition = (ContractorAdvanceRequisition)this.workflowService.transition(actionName, (StateAware)contractorAdvanceRequisition, contractorAdvanceRequisition.getWorkflowapproverComments());
            contractorAdvanceRequisition.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode(CONTRACTOR_ADVANCE_REQUISITION, "CANCELLED"));
            this.persist((Object)contractorAdvanceRequisition);
        }
    }

    @Override
    public List<EgwStatus> getAllContractorAdvanceRequisitionStatus() {
        return this.persistenceService.findAllBy("from EgwStatus s where s.moduletype=? and s.code <>'NEW' order by orderId", new Object[]{ContractorAdvanceRequisition.class.getSimpleName()});
    }

    @Override
    public List<DrawingOfficer> getAllDrawingOfficerFromARF() {
        List drawingOfficerList = this.persistenceService.findAllByNamedQuery("getAllDrawingOfficerFromARF", new Object[0]);
        return drawingOfficerList;
    }

    @Override
    public CChartOfAccounts getContractorAdvanceAccountcodeForWOE(Long workOrderEstimateId) {
        CChartOfAccounts advanceCOA = null;
        List arfList = this.persistenceService.findAllBy("select distinct arf from ContractorAdvanceRequisition arf where arf.workOrderEstimate.id = ? and arf.status.code = ? and arf.arftype = ?", new Object[]{workOrderEstimateId, ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.APPROVED.toString(), ARF_TYPE});
        if (arfList != null && !arfList.isEmpty()) {
            for (EgAdvanceRequisitionDetails advanceRequisitionDetails : ((ContractorAdvanceRequisition)((Object)arfList.get(0))).getEgAdvanceReqDetailses()) {
                advanceCOA = advanceRequisitionDetails.getChartofaccounts();
            }
        }
        return advanceCOA;
    }

    @Override
    public BigDecimal getTotalAdvancePaymentMadeByWOEstimateId(Long workOrderEstimateId, Date asOnDate) {
        BigDecimal advanceAlreadyPaid = BigDecimal.ZERO;
        advanceAlreadyPaid = (BigDecimal)this.persistenceService.find("select sum(advanceRequisitionAmount) from ContractorAdvanceRequisition where status.code = ? and workOrderEstimate.id = ?  and egAdvanceReqMises.voucherheader.status = 0 and egAdvanceReqMises.voucherheader.voucherDate <= ?", new Object[]{ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.APPROVED.toString(), workOrderEstimateId, asOnDate});
        return advanceAlreadyPaid;
    }

    @Override
    public ContractorAdvanceRequisition getContractorARFInWorkflowByWOEId(Long workOrderEstimateId) {
        ContractorAdvanceRequisition arf = (ContractorAdvanceRequisition)((Object)this.find("from ContractorAdvanceRequisition arf where arf.workOrderEstimate.id = ? and arf.status.code not in(?,?) and arf.arftype = ?", new Object[]{workOrderEstimateId, ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.APPROVED.toString(), ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.CANCELLED.toString(), ARF_TYPE}));
        return arf;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public void setEisService(EisUtilService eisService) {
        this.eisService = eisService;
    }

    public void setContractorAdvanceRequisitionNumberGenerator(ContractorAdvanceRequisitionNumberGenerator contractorAdvanceRequisitionNumberGenerator) {
        this.contractorAdvanceRequisitionNumberGenerator = contractorAdvanceRequisitionNumberGenerator;
    }

    public void setRevisionAbstractEstimateService(PersistenceService<RevisionAbstractEstimate, Long> revisionAbstractEstimateService) {
        this.revisionAbstractEstimateService = revisionAbstractEstimateService;
    }

    public void setContractorAdvanceWorkflowService(WorkflowService<ContractorAdvanceRequisition> workflow) {
        this.workflowService = workflow;
    }
}

