/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.models.measurementbook;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.egov.commons.EgwStatus;
import org.egov.infra.persistence.validator.annotation.DateFormat;
import org.egov.infra.persistence.validator.annotation.GreaterThan;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.persistence.validator.annotation.ValidateDate;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.models.measurementbook.MBDetails;
import org.egov.works.models.workorder.WorkOrder;
import org.egov.works.models.workorder.WorkOrderEstimate;
import org.hibernate.validator.constraints.Length;

public class MBHeader
extends StateAware {
    private static final long serialVersionUID = 121631467636260459L;
    private Long id;
    @Required(message="mbheader.workorder.null")
    private WorkOrder workOrder;
    @Required(message="mbheader.mbrefno.null")
    @Length(max=50, message="mbheader.mbrefno.length")
    private String mbRefNo;
    @Length(max=400, message="mbheader.contractorComments.length")
    private String contractorComments;
    @Required(message="mbheader.mbdate.null")
    @ValidateDate(allowPast=true, dateFormat="dd/MM/yyyy", message="mbheader.mbDate.futuredate")
    @DateFormat(message="invalid.fieldvalue.mbDate")
    private Date mbDate;
    @Length(max=400, message="mbheader.mbabstract.length")
    private String mbAbstract;
    @Required(message="mbheader.fromPageNo.null")
    @GreaterThan(value=0L, message="mbheader.fromPageNo.non.negative")
    private Integer fromPageNo;
    @Min(value=0L, message="mbheader.toPageNo.non.negative")
    private Integer toPageNo;
    private WorkOrderEstimate workOrderEstimate;
    private Integer approverUserId;
    private ContractorBillRegister egBillregister;
    @Valid
    private List<MBDetails> mbDetails = new LinkedList<MBDetails>();
    private String owner;
    private List<String> mbActions = new ArrayList<String>();
    private EgwStatus egwStatus;
    private boolean isLegacyMB;
    private BigDecimal mbAmount;
    private Date approvedDate;

    public List<ValidationError> validate() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        if (this.workOrder != null && (this.workOrder.getId() == null || this.workOrder.getId() == 0L || this.workOrder.getId() == -1L)) {
            validationErrors.add(new ValidationError("workOrder", "mbheader.workorder.null"));
        }
        if (this.fromPageNo != null && this.toPageNo != null && this.fromPageNo > this.toPageNo) {
            validationErrors.add(new ValidationError("toPageNo", "mbheader.toPageNo.invalid"));
        }
        if (this.mbDate != null && this.workOrder != null && this.workOrder.getWorkOrderDate() != null && this.mbDate.before(this.workOrder.getWorkOrderDate())) {
            validationErrors.add(new ValidationError("mbDate", "mbheader.mbDate.invalid"));
        }
        return validationErrors;
    }

    public void setWorkOrder(WorkOrder workOrder) {
        this.workOrder = workOrder;
    }

    public WorkOrder getWorkOrder() {
        return this.workOrder;
    }

    public void setMbRefNo(String mbRefNo) {
        this.mbRefNo = mbRefNo;
    }

    public String getMbRefNo() {
        return this.mbRefNo;
    }

    public void setMbDate(Date mbDate) {
        this.mbDate = mbDate;
    }

    public Date getMbDate() {
        return this.mbDate;
    }

    public void setMbAbstract(String mbAbstract) {
        this.mbAbstract = mbAbstract;
    }

    public String getMbAbstract() {
        return this.mbAbstract;
    }

    public Integer getFromPageNo() {
        return this.fromPageNo;
    }

    public void setFromPageNo(Integer fromPageNo) {
        this.fromPageNo = fromPageNo;
    }

    public Integer getToPageNo() {
        return this.toPageNo;
    }

    public void setToPageNo(Integer toPageNo) {
        this.toPageNo = toPageNo;
    }

    public String getContractorComments() {
        return this.contractorComments;
    }

    public void setContractorComments(String contractorComments) {
        this.contractorComments = contractorComments;
    }

    public List<MBDetails> getMbDetails() {
        return this.mbDetails;
    }

    public void setMbDetails(List<MBDetails> mbDetails) {
        this.mbDetails = mbDetails;
    }

    public void addMbDetails(MBDetails mbDetails) {
        this.mbDetails.add(mbDetails);
    }

    public String getStateDetails() {
        return "MbHeader : " + this.getMbRefNo();
    }

    public ContractorBillRegister getEgBillregister() {
        return this.egBillregister;
    }

    public void setEgBillregister(ContractorBillRegister egBillregister) {
        this.egBillregister = egBillregister;
    }

    public Integer getApproverUserId() {
        return this.approverUserId;
    }

    public void setApproverUserId(Integer approverUserId) {
        this.approverUserId = approverUserId;
    }

    public WorkOrderEstimate getWorkOrderEstimate() {
        return this.workOrderEstimate;
    }

    public void setWorkOrderEstimate(WorkOrderEstimate workOrderEstimate) {
        this.workOrderEstimate = workOrderEstimate;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public List<String> getMbActions() {
        return this.mbActions;
    }

    public void setMbActions(List<String> mbActions) {
        this.mbActions = mbActions;
    }

    public EgwStatus getEgwStatus() {
        return this.egwStatus;
    }

    public void setEgwStatus(EgwStatus egwStatus) {
        this.egwStatus = egwStatus;
    }

    public boolean getIsLegacyMB() {
        return this.isLegacyMB;
    }

    public void setIsLegacyMB(boolean isLegacyMB) {
        this.isLegacyMB = isLegacyMB;
    }

    public BigDecimal getMbAmount() {
        return this.mbAmount;
    }

    public void setMbAmount(BigDecimal mbAmount) {
        this.mbAmount = mbAmount;
    }

    public String toString() {
        return "MBHeader ( Id : " + this.getId() + "MB Ref No: " + this.mbRefNo + ")";
    }

    public BigDecimal getTotalMBAmount() {
        double amount = 0.0;
        BigDecimal resultAmount = BigDecimal.ZERO;
        for (MBDetails mbd : this.mbDetails) {
            amount = mbd.getWorkOrderActivity().getActivity().getNonSor() == null ? mbd.getWorkOrderActivity().getApprovedRate() * mbd.getQuantity() * mbd.getWorkOrderActivity().getConversionFactor() : mbd.getWorkOrderActivity().getApprovedRate() * mbd.getQuantity();
            resultAmount = resultAmount.add(BigDecimal.valueOf(amount));
        }
        return resultAmount;
    }

    public Date getApprovedDate() {
        return this.approvedDate;
    }

    public void setApprovedDate(Date approvedDate) {
        this.approvedDate = approvedDate;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public static enum Actions {
        SAVE,
        SUBMIT_FOR_APPROVAL,
        REJECT,
        CANCEL,
        APPROVAL;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum MeasurementBookStatus {
        NEW,
        CREATED,
        CHECKED,
        REJECTED,
        RESUBMITTED,
        CANCELLED,
        APPROVED;

    }
}

