/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.models.masters;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.egov.infra.persistence.entity.component.Money;
import org.egov.infra.persistence.entity.component.Period;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infstr.models.BaseModel;
import org.egov.works.models.masters.ScheduleOfRate;

public class SORRate
extends BaseModel {
    private static final long serialVersionUID = 4057715980589711248L;
    private ScheduleOfRate scheduleOfRate;
    @Valid
    private Money rate;
    private Period validity;

    public ScheduleOfRate getScheduleOfRate() {
        return this.scheduleOfRate;
    }

    public void setScheduleOfRate(ScheduleOfRate scheduleOfRate) {
        this.scheduleOfRate = scheduleOfRate;
    }

    public Money getRate() {
        return this.rate;
    }

    public void setRate(Money rate) {
        this.rate = rate;
    }

    public Period getValidity() {
        return this.validity;
    }

    public void setValidity(Period validity) {
        this.validity = validity;
    }

    public SORRate() {
    }

    public SORRate(Money sorrate) {
        this.rate = sorrate;
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        if (this.rate == null || this.rate.getValue() == 0.0 || this.rate != null && this.rate.getValue() == 0.0) {
            validationErrors.add(new ValidationError("rate", "sor.rate.lessthan.0"));
        }
        if (this.validity == null || this.validity != null && this.validity.getStartDate() == null) {
            validationErrors.add(new ValidationError("validity", "sor.rate.startDate__empty"));
        } else if (this.validity == null || this.validity != null && !SORRate.compareDates(this.validity.getStartDate(), this.validity.getEndDate())) {
            validationErrors.add(new ValidationError("validity", "sor.rate.invalid_date_range"));
        }
        if (validationErrors.isEmpty()) {
            return null;
        }
        return validationErrors;
    }

    public static boolean compareDates(Date startDate, Date endDate) {
        if (startDate == null) {
            return false;
        }
        if (endDate == null) {
            return true;
        }
        return !endDate.before(startDate);
    }
}

