/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.master.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.transaction.Transactional;
import org.egov.commons.Accountdetailkey;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.dao.AccountdetailkeyHibernateDAO;
import org.egov.infstr.services.PersistenceService;
import org.egov.works.models.masters.DepositCode;
import org.egov.works.services.WorksService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="depositCodeService")
@Transactional
public class DepositCodeService
extends PersistenceService<DepositCode, Long> {
    @Autowired
    private WorksService worksService;
    @Autowired
    private AccountdetailkeyHibernateDAO accountdetailkeyHibernateDAO;
    @PersistenceContext
    private EntityManager entityManager;

    public DepositCode getDepositCodeById(Long DepositCodeId) {
        DepositCode depositCode = (DepositCode)((Object)this.entityManager.find(DepositCode.class, (Object)DepositCodeId));
        return depositCode;
    }

    public List<DepositCode> getAllDepositCodes() {
        Query query = this.entityManager.createQuery("from DepositCode");
        List depositCodeList = query.getResultList();
        return depositCodeList;
    }

    public void createAccountDetailKey(DepositCode dc) {
        Accountdetailtype accountdetailtype = this.worksService.getAccountdetailtypeByName("DEPOSITCODE");
        Accountdetailkey adk = new Accountdetailkey();
        adk.setGroupid(Integer.valueOf(1));
        adk.setDetailkey(Integer.valueOf(dc.getId().intValue()));
        adk.setDetailname(accountdetailtype.getAttributename());
        adk.setAccountdetailtype(accountdetailtype);
        this.accountdetailkeyHibernateDAO.create(adk);
    }
}

