/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.lineestimate.service;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import javax.transaction.Transactional;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.utils.DBSequenceGenerator;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.entity.enums.WorkCategory;
import org.hibernate.exception.SQLGrammarException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkOrderIdentificationNumberGenerator {
    private static final String PROJECTCODE_SEQ_PREFIX = "SEQ_PROJECTCODE";
    @Autowired
    private SequenceNumberGenerator sequenceNumberGenerator;
    @Autowired
    private DBSequenceGenerator dbSequenceGenerator;
    @Autowired
    private FinancialYearHibernateDAO financialYearHibernateDAO;

    @Transactional
    public String generateWorkOrderIdentificationNumber(LineEstimateDetails lineEstimateDetails) {
        try {
            Serializable sequenceNumber;
            CFinancialYear financialYear = this.financialYearHibernateDAO.getFinancialYearByDate(lineEstimateDetails.getLineEstimate().getLineEstimateDate());
            String[] finYearRange = financialYear.getFinYearRange().split("-");
            String sequenceName = "SEQ_PROJECTCODE_" + finYearRange[0] + "_" + finYearRange[1];
            String typeOfWork = lineEstimateDetails.getLineEstimate().getWorkCategory().toString().equals(WorkCategory.SLUM_WORK.toString()) ? "SL" : "NS";
            try {
                sequenceNumber = this.sequenceNumberGenerator.getNextSequence(sequenceName);
            }
            catch (SQLGrammarException e) {
                sequenceNumber = this.dbSequenceGenerator.createAndGetNextSequence(sequenceName);
            }
            return String.format("%s/%s/%05d/%02d/%s", lineEstimateDetails.getLineEstimate().getExecutingDepartment().getCode(), typeOfWork, sequenceNumber, this.getMonthOfTransaction(lineEstimateDetails.getLineEstimate().getLineEstimateDate()), financialYear.getFinYearRange());
        }
        catch (SQLException e) {
            throw new ApplicationRuntimeException("Error occurred while generating WIN", (Throwable)e);
        }
    }

    private int getMonthOfTransaction(Date lineEstimateDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(lineEstimateDate);
        return cal.get(2) + 1;
    }
}

