/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.lineestimate.repository;

import java.util.List;
import org.egov.infra.admin.master.entity.User;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface LineEstimateDetailsRepository
extends JpaRepository<LineEstimateDetails, Long> {
    public List<LineEstimateDetails> findByEstimateNumberContainingIgnoreCase(String var1);

    public LineEstimateDetails findByEstimateNumberAndLineEstimate_Status_CodeEquals(String var1, String var2);

    public LineEstimateDetails findByEstimateNumberAndLineEstimate_Status_CodeNot(String var1, String var2);

    @Query(value="select distinct(led.estimateNumber) from LineEstimateDetails as led where led.estimateNumber like :estimateNumber and led.lineEstimate.status.code = :egwStatus and not exists (select distinct(wo.estimateNumber) from WorkOrder as wo where wo.estimateNumber = led.estimateNumber and upper(wo.egwStatus.code) != :status)")
    public List<String> findEstimateNumbersForLoa(@Param(value="estimateNumber") String var1, @Param(value="egwStatus") String var2, @Param(value="status") String var3);

    @Query(value="select distinct(led.estimateNumber) from LineEstimateDetails as led where not exists (select distinct(wo.estimateNumber) from WorkOrder as wo where led.estimateNumber = wo.estimateNumber and upper(wo.egwStatus.code) != :status)")
    public List<String> findEstimateNumbersToSearchLineEstimatesForLoa(@Param(value="status") String var1);

    @Query(value="select distinct(led.lineEstimate.adminSanctionNumber) from LineEstimateDetails as led  where led.lineEstimate.adminSanctionNumber like :adminSanctionNumber and led.lineEstimate.status.code = :egwStatus and not exists (select distinct(wo.estimateNumber) from WorkOrder as wo where led.estimateNumber = wo.estimateNumber and upper(wo.egwStatus.code) != :status)")
    public List<String> findAdminSanctionNumbersForLoa(@Param(value="adminSanctionNumber") String var1, @Param(value="egwStatus") String var2, @Param(value="status") String var3);

    @Query(value="select distinct(estimateNumber) from LineEstimateDetails as led where led.lineEstimate.executingDepartment.id = :departmentId")
    public List<String> findEstimateNumbersForDepartment(@Param(value="departmentId") Long var1);

    @Query(value="select distinct(led.projectCode.code) from LineEstimateDetails as led  where led.projectCode.code like :code and not exists (select distinct(wo.estimateNumber) from WorkOrder as wo where led.estimateNumber = wo.estimateNumber and upper(wo.egwStatus.code) != :status)")
    public List<String> findWorkIdentificationNumbersToSearchLineEstimatesForLoa(@Param(value="code") String var1, @Param(value="status") String var2);

    @Query(value="select distinct(estimateNumber) from LineEstimateDetails as led where upper(led.projectCode.code) = upper(:workIdentificationNumber)")
    public List<String> findEstimateNumbersForWorkIdentificationNumber(@Param(value="workIdentificationNumber") String var1);

    @Query(value="select distinct(estimateNumber) from LineEstimateDetails as led where led.lineEstimate.spillOverFlag = :spillOverFlag")
    public List<String> findEstimateNumbersForSpillOverFlag(@Param(value="spillOverFlag") boolean var1);

    @Query(value="select distinct(led.projectCode.code) from LineEstimateDetails as led  where upper(led.projectCode.code) like upper(:code) and led.lineEstimate.status.code in (:adminSanctionstatus, :technicalSanctionstatus)")
    public List<String> findWorkIdentificationNumbersToSearchWorkProgressRegister(@Param(value="code") String var1, @Param(value="adminSanctionstatus") String var2, @Param(value="technicalSanctionstatus") String var3);

    @Query(value="select distinct(led.lineEstimate.createdBy) from LineEstimateDetails as led where led.lineEstimate.executingDepartment.id = :department and led.lineEstimate.status.code = :lineEstimateStatus and not exists (select distinct(wo.estimateNumber) from WorkOrder as wo where led.estimateNumber = wo.estimateNumber and upper(wo.egwStatus.code) = :workOrderStatus)")
    public List<User> findCreatedByForCancelLineEstimateByDepartment(@Param(value="department") Long var1, @Param(value="lineEstimateStatus") String var2, @Param(value="workOrderStatus") String var3);

    public LineEstimateDetails findByProjectCode_codeAndLineEstimate_Status_CodeNotLike(String var1, String var2);
}

