/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.transactions.payment;

import java.util.Collection;
import org.egov.infra.utils.JsonUtils;
import org.egov.tl.entity.License;
import org.egov.tl.entity.contracts.DCBReportSearchRequest;
import org.egov.tl.entity.view.DCBReportResult;
import org.egov.tl.service.DCBReportService;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.web.response.adaptor.OnlineDCBReportResponseAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/dcb/view"})
public class ViewDCBController {
    @Autowired
    private TradeLicenseService tradeLicenseService;
    @Autowired
    private DCBReportService dCBReportService;

    @GetMapping(value={"{id}"})
    public String search(@PathVariable Long id, Model model, DCBReportSearchRequest searchRequest) {
        License licenseObj = this.tradeLicenseService.getLicenseById(id);
        searchRequest.setLicenseid(licenseObj.getId());
        model.addAttribute("license", (Object)licenseObj);
        model.addAttribute("dcbreport", (Object)JsonUtils.toJSON((Collection)this.dCBReportService.getDCBRecords(searchRequest), DCBReportResult.class, OnlineDCBReportResponseAdaptor.class));
        model.addAttribute("receipts", (Object)this.tradeLicenseService.getReceipts(licenseObj));
        return "view-license-dcb";
    }
}

